time: float = 0.0
k1: float = 0.100000000000000
k2: float = 0.150000000000000
p1: float = 2.50000000000000
C: float = 2.50000000000000
S1: float = 1.00000000000000
S2: float = 0.0
S3: float = 0.0

# Initial assignments
S4 = S3 / (p1 + 1)
S5 = S4 * p1
S1_conc = S1 / C
S2_conc = S2 / C
S3_conc = S3 / C
S4_conc = S4 / C
S5_conc = S5 / C
reaction1 = S1_conc * k1
reaction2 = S5_conc * k2
y0 = [S1, S2, S3]
variable_names = ["S1", "S2", "S3"]


def model(time: float, variables: tuple[float, ...]) -> tuple[float, ...]:
    S1, S2, S3 = variables
    S4: float = S3 / (p1 + 1)
    S5: float = S4 * p1
    S1_conc: float = S1 / C
    S5_conc: float = S5 / C
    reaction1: float = S1_conc * k1
    reaction2: float = S5_conc * k2
    dS1dt: float = -C * reaction1
    dS3dt: float = C * reaction1 - C * reaction2
    dS2dt: float = C * reaction2
    return dS1dt, dS2dt, dS3dt


def derived(time: float, variables: tuple[float, ...]) -> dict[str, float]:
    S1, S2, S3 = variables
    S4: float = S3 / (p1 + 1)
    S5: float = S4 * p1
    S1_conc: float = S1 / C
    S2_conc: float = S2 / C
    S3_conc: float = S3 / C
    S4_conc: float = S4 / C
    S5_conc: float = S5 / C
    reaction1: float = S1_conc * k1
    reaction2: float = S5_conc * k2
    return {
        "S4": S4,
        "S5": S5,
        "S1_conc": S1_conc,
        "S2_conc": S2_conc,
        "S3_conc": S3_conc,
        "S4_conc": S4_conc,
        "S5_conc": S5_conc,
        "reaction1": reaction1,
        "reaction2": reaction2,
    }
