time: float = 0.0
k1: float = 1.75000000000000
k2: float = 0.0150000000000000
compartment: float = 1.00000000000000

# Initial assignments
dS3 = k1 * k2
S1_amount = 0.15 * compartment
S2_amount = 0.1 * compartment
S3_amount = 0.1 * compartment
S1 = S1_amount / compartment
S2 = S2_amount / compartment
S3 = S3_amount / compartment
reaction1 = S1 * k1
y0 = [S1_amount, S2_amount, S3_amount]
variable_names = ["S1_amount", "S2_amount", "S3_amount"]


def model(time: float, variables: tuple[float, ...]) -> tuple[float, ...]:
    S1_amount, S2_amount, S3_amount = variables
    S1: float = S1_amount / compartment
    dS3: float = k1 * k2
    reaction1: float = S1 * k1
    dS3_amountdt: float = compartment * dS3
    dS1_amountdt: float = -compartment * reaction1
    dS2_amountdt: float = compartment * reaction1
    return dS1_amountdt, dS2_amountdt, dS3_amountdt


def derived(time: float, variables: tuple[float, ...]) -> dict[str, float]:
    S1_amount, S2_amount, S3_amount = variables
    S1: float = S1_amount / compartment
    S2: float = S2_amount / compartment
    S3: float = S3_amount / compartment
    dS3: float = k1 * k2
    reaction1: float = S1 * k1
    return {
        "S1": S1,
        "S2": S2,
        "S3": S3,
        "dS3": dS3,
        "reaction1": reaction1,
    }
