All contributions, bug reports, bug fixes, documentation improvements, enhancements and ideas are welcome.
In order to contribute:

1. [Fork the project](https://github.com/Computational-Biology-Aachen/pysbml)
2. Improve or extend the project
3. Create unit tests for your added / improved features in the respective [test directory](https://github.com/Computational-Biology-Aachen/pysbml/tree/main/tests). The old test suite mostly uses the standard [unittest](https://docs.python.org/3/library/unittest.html) library, however new tests are written with [pytest](https://docs.pytest.org/en/latest/). If you are not familiar with pytest you can still use the unittest interface, as pytest supports both test styles.
4. Create a [pull request](https://docs.github.com/de/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request)

Your work will then be reviewed as soon as possible (suggestions about some changes, improvements or alternatives may be given).

## Coding standards

In order for your improvements to be accepted, please make sure that you added tests in the respective subfolder of the [test directory](https://github.com/Computational-Biology-Aachen/mxlpy/tree/main/tests).
We also ask you to write proper documentation in the [NumPy / SciPy style](https://docs.scipy.org/doc/numpy/docs/howto_document.html) and
that you name your functions according to [pep8](http://pep8.org/). Further, please use the supplied [pre-commit](https://pre-commit.com/) hook, to make sure that your code passes our guidelines.

Thank you for participating!
