// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
// SPDX-FileCopyrightInfo: Copyright © DUNE Project contributors, see file LICENSE.md in module root
// SPDX-License-Identifier: LicenseRef-GPL-2.0-only-with-DUNE-exception
//
// WARNING
// This file is automatically generated by jacobian.mac! Don't edit by hand!
#ifndef DUNE_GEOMETRY_QUADRATURE_Jacobi1_HH
#define DUNE_GEOMETRY_QUADRATURE_Jacobi1_HH

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif

namespace Dune {

  /************************************************
   * Quadraturerule for 1d line
   *************************************************/

  template<typename ct, int dim>
  class Jacobi1QuadratureRule;

  template<typename ct>
  using Jacobi1QuadratureRule1D = Jacobi1QuadratureRule<ct,1>;

  template<typename ct>
  class Jacobi1QuadratureRule<ct,1> : public QuadratureRule<ct,1>
  {
  public:
    /** brief The highest quadrature order available */
    constexpr static int highest_order = 61;

  private:
    friend class QuadratureRuleFactory<ct,1>;
    Jacobi1QuadratureRule (int p);
    ~Jacobi1QuadratureRule(){}
  };

  //! internal Helper template for the initialization of the quadrature rules
  template<typename ct,
      bool fundamental = std::is_floating_point<ct>::value>
  struct Jacobi1QuadratureInitHelper;

  template<typename ct>
  struct Jacobi1QuadratureInitHelper<ct, true> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  template<typename ct>
  struct Jacobi1QuadratureInitHelper<ct, false> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  // for fundamental types
  template<typename ct>
  void Jacobi1QuadratureInitHelper<ct,true>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = 0.3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _weight[0] = 1.0;
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = 0.6449489742783178098197284074705891391965947480656670128432692567250960377457315026539859433104640235;
      _weight[0] = 0.3639172365120456612112619958496727004463362510746294373092948573749466456968158318588966981608533203;
      _points[1] = 0.1550510257216821901802715925294108608034052519343329871567307432749039622542684973460140566895359765;
      _weight[1] = 0.6360827634879543387887380041503272995536637489253705626907051426250533543031841681411033018391466797;
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = 0.7876594617608470560252418898759996233480800585109738408854524491392307168918253691359860554930833447;
      _weight[0] = 0.1396539598029082450677625443581538098252225758276251979994248447935389105334084604080564612661091634;
      _points[1] = 0.08858795951270394739554614376945619688572933192274956543116369516997648742681009672521930761610157858;
      _weight[1] = 0.4018638274779192615443962665291996972772826161899046690923842878330733109101018240536312300474029069;
      _points[2] = 0.4094668644407347108649262520688298940519048952805623079690981414050785099670788198530803511765293624;
      _weight[2] = 0.4584822127191724933878411891126464928974948079824701329081908673733877785564897155383123086864879298;
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = 0.8602401356562194478479129188751197667383780225872255049242335941839742579301655644134901549264276107;
      _weight[0] = 0.0623619419000161643477502941931506212697875166839309830761809569911317040022539361293684065166161988;
      _points[1] = 0.5835904323689168200566976686629172486934326398967716401762938418317475019618310120056322774674562994;
      _weight[1] = 0.2596950952164648816529124057792580292271059432720818009310478738715197515684797549856501468079414159;
      _points[2] = 0.05710419611451768219312119255411562123507794559875016432780829293093467820207316458611381681984273682;
      _weight[2] = 0.2710138268629762324165283481558817992920669850614066882947002084270279998974049555934063155149987714;
      _points[3] = 0.2768430136381238276800459976856251411108891696950304683494420488311213396837080367725415285640511309;
      _weight[3] = 0.4069291360205427215828089518717095502110395549825805276980709607103205445318613532915751311604436132;
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = 0.9014649142011735738765011021122473096194864304517102005637358130565651259599860618861752355046079332;
      _weight[0] = 0.03149582904338455237058463313697596258298062393862741207778897431029291618946468034442481885294203153;
      _points[1] = 0.6954642733536360945146148237211671613940015549986483590851972611325288138368238668739250465460035525;
      _weight[1] = 0.147817740145233340701266438683407157647088123302568081608965017046687166399586788131013562994436696;
      _points[2] = 0.03980985705146874234080669009333316770426265422838516194640774820496474562617430685450225908318456724;
      _weight[2] = 0.1935631804533033585487219432723014706300773723042959314554533779929073487933655762166538198748335154;
      _points[3] = 0.4379748102473861440050125200052288525167902742147401264690572735060053301210965344528972647247758255;
      _weight[3] = 0.2927739741693396173960757387119177719719819871066279796088146708892391099142328799058439924278608752;
      _points[4] = 0.1980134178736081725357921367952962360381863588337888792083291768272087117286465026597729214141553943;
      _weight[4] = 0.3343492761887391309833512461953976371678718933478805952489779597608734587033500754020638058499268799;
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = 0.9269456713197411148518739658196820110561724195422832527244670796566452024525282438143394800135873916;
      _weight[0] = 0.01747660362721906351203460662479774148929411516337233806318102016698451025225396235129028371682599565;
      _points[1] = 0.7692338620300545009168833601156454518371421433222954161669481696365481305739532856852002115427743676;
      _weight[1] = 0.08791033110101795101635324861086019025599267125557955276461742797557562193809890394074140334644478675;
      _points[2] = 0.02931642715978489197205027691316491037373039256371492778691068394493603824166577874863094836518436948;
      _weight[2] = 0.1446206614510173673109086522496639352868157617754660467953566358954592311021538274525319681276946567;
      _points[3] = 0.5586715187715501320813933418055219400743682889654078255557472261173501228974210783238200520122825819;
      _weight[3] = 0.1973223017813105282411690210967195758979330860171400109013608542168691368036765872249948825320820935;
      _points[4] = 0.1480785996684842918499768524959792122302487748085944614125946418015983860908783218063693976617475761;
      _weight[4] = 0.2710849944630372336813807932761008554153744603412901289757132736303442652218840953547976196174453532;
      _points[5] = 0.3369846902811542990970529720807757051975687500284733471225629680736913505127840608524091411736544825;
      _weight[5] = 0.2815851075763978562381536781418577016545899054471519224997707881147672346819326236756438426595071102;
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = 0.9437374394630778535343478089676888242202344852553769164275572083026057856516616966519018212670469614;
      _weight[0] = 0.01042872440561480817938274860756603627285202470301292757712310575208095879452089021202956789850911329;
      _points[1] = 0.819759308263107635012420057190818215457939379194529844677374444720182011832042478974289957052318717;
      _weight[1] = 0.05481671344374695088866209671645257295417296286400596170705830992550156540265177605400520195059885001;
      _points[2] = 0.02247938643871249810882549957084505992217390723560038985928427605875857575812188014380655937699869036;
      _weight[2] = 0.1119347268469821023031242268598512673581543443021245729793031713310010121026578504175518039330847103;
      _points[3] = 0.6473752828868303626260922298287587971919781169427252176007906613661670650910811632587999055012469012;
      _weight[3] = 0.1327693929309829399672959775272798268160367658936009632652402776516685774949256903432965593140492997;
      _points[4] = 0.4528463736694446169985514423476511453596140721008524586919906545143298698851397040631574340782308227;
      _weight[4] = 0.2142501313917473399818245059997114645430845154022713345106969229642921740907764451829036761934830747;
      _points[5] = 0.1146790531609042319096402370675146270777298245319719453889897349515683398313771981082383887487264664;
      _weight[5] = 0.221018516381749204842241472739215549356686584462224309432389243557215340531236858632022007842467717;
      _points[6] = 0.2657898227845894684767893916933899974369968814056098940206796867530550186172425454664726006420981076;
      _weight[6] = 0.2547817945991766538374689715499232826990128023727599305281889688182403715832304891581911828678072318;
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = 0.9553660447100301492668789781416922384764228669900323904483832488568928548867910582521230305572279597;
      _weight[0] = 0.006590382884497597709484632022178140232917756360727536905728685105949423544222450202661257721956446443;
      _points[1] = 0.8556337429578544285147814797717850302864781605395751604095670933496281754845563783672978210969088188;
      _weight[1] = 0.03568580531197241678710559440208448516980542367921554701695861934230527222794506401464323963977834126;
      _points[2] = 0.01777991514736345181320510103767906126648839823850043366560783167875924757578300659726427675032243899;
      _weight[2] = 0.08910160872311186265243123906792652143579327591629599162893070650953490775807421614093597558657522439;
      _points[3] = 0.7131752428555694810513137602509073414468837909454265589730704929652137959347225387189767846054023754;
      _weight[3] = 0.09087863900939779616611084219138819921280234422368229723283559301918617746520672846935872214646562912;
      _points[4] = 0.5451866848034266490322722299532130551329800560537052249374829413005927647507051249095965493813529666;
      _weight[4] = 0.1583991989846383202408163787197844534389880146907948116529832318421622220548405973903502249576825338;
      _points[5] = 0.09132360789979395600374145807454135310704047574456766876687017263479530047915987523538037892138190674;
      _weight[5] = 0.1822380472727472526914449235657595207038316830973420932240504518535206139038892838023314283723494268;
      _points[6] = 0.3719321645832723024308539604826292446681000633774806778676385412497303508594868127751294857726545931;
      _weight[6] = 0.2120947188718600214090621928223164323473301836600784587558404501112348205250685256991863152516914685;
      _points[7] = 0.2143084793956307583575412675816703226744297175224765908137326191408580982640893227912904964441607055;
      _weight[7] = 0.2250115989417747323435441972085622474585313183718632635826722622161065625207531342805328363235010072;
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = 0.9637421871167905390588356992319185479241288771581362138479503914355973155457527404910756919669630462;
      _weight[0] = 0.004361694171546261745098102240033931989346658172745913415730741761530425250798256232225741196300546876;
      _points[1] = 0.8819210212100012998077148880052647763071205854487038619129766513283089105657085985563097864503385465;
      _weight[1] = 0.02412000856957075810345430457380053454860935724228865674231168030985443217573930570828234243797814129;
      _points[2] = 0.7628230151850396146826933071467255329235111827037380779911005908346167214808478679770430364298828452;
      _weight[2] = 0.06360964298210800252338021387173996796508686851938261644837130415206699494945930902374759895630440021;
      _points[3] = 0.01441240964887654863282674081081323941174473105657808607075067912813887583460044894395069303727210119;
      _weight[3] = 0.0725560070465597429192991958823192775999960953346010980361779016438558511176469019496579491905235033;
      _points[4] = 0.6181172346952940246392297516035044802806674046397913475060393055585778777428482116865746364861237204;
      _weight[4] = 0.1168023905903302211314630458032802960303593103025793617178533568693960614302271220161688241514649212;
      _points[5] = 0.07438738970919604463591818595599858508097691328473519842679960274501992379023428096791242945498303357;
      _weight[5] = 0.1521485102186163251601586075079285812132106027704451841051048669451110654017776300437392883754255205;
      _points[6] = 0.4619704010810109348831431086805643081072330679787275209992998979929435248645151935609445375900637938;
      _weight[6] = 0.1687166436898406987885000399171749817104627172846977348696669835038285248020424407597603571357401275;
      _points[7] = 0.1761166561629952818631757460725685864113860479693058739346483371718478923148052033071589166216033504;
      _weight[7] = 0.1970674843446914103203460407385488509023560656011704825855076061845847487566519614460658661365497313;
      _points[8] = 0.3096675799276378170596204672294840488163890844971259245735924385417910631238453492458723772259274575;
      _weight[8] = 0.2006176183867365793083004494651735780405723247720889520792755586297718961156570728203520324197133498;
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = 0.9699709678385135029569356423655920593053451564625792084689040051698797214284804451045965026202723376;
      _weight[0] = 0.002998281204812788056496272008212784833084388876744268112203022420650156860159853329068353288083480999;
      _points[1] = 0.9017109877901467703487989784097679814681176760729360475326567373055975858521386207932416878958506861;
      _weight[1] = 0.01683863956596637483503273103740214403152870043903156313634792885260503739501482295430271106515098109;
      _points[2] = 0.8009789210368988451379463016172425246730022622599153383117418553952368566445573598703594633591531736;
      _weight[2] = 0.04554918290652606517297529885212039260089893374717979072674077076892597133564094826507860794028660136;
      _points[3] = 0.01191761343241559690974558695898597603002784725837485802027599304441351971793953552093495537698887493;
      _weight[3] = 0.06019901604807404660130951104775872423481025847493586386892954004541908963029659975623116469369904037;
      _points[4] = 0.6759444616766651073571505089347614715039952762295357455139412301626256578790308622295455518800017058;
      _weight[4] = 0.08680381281430125184491223517276793341846841416734091479841192293605468475240771493378858474227150558;
      _points[5] = 0.06173207187714812552262936719425014145287208036190213218470079750300542267782554988602355308971116556;
      _weight[5] = 0.1285743090181651457496530772577303833702586985336065153964167070111045190343947831187521473702406254;
      _points[6] = 0.5367387657156606328730951777118890227811982315666478711601841465166401511417696449330275943910494234;
      _weight[6] = 0.1321061511267007583321490050097555927283068703402401952281986304716746942938517327591629187622353407;
      _points[7] = 0.3946398468857868429619521050776075022149391536489841976946611563878829320916183985232456263028812026;
      _weight[7] = 0.1691142193816546648612911643310017367123791483004682190032143948519815060462764343108107374876334037;
      _points[8] = 0.1471114496430702404275994355798195021337713619059297805712867093259790600660861446700545255054338431;
      _weight[8] = 0.1724226005783520728566667214238285835326209744871433508891823477804675766487885763704506821303024848;
      _points[9] = 0.2611596760084562402660516580548457231986357161379567253035521310935009972624582003737324443405623491;
      _weight[9] = 0.185393787355446831689513983859421724537643612633309318840354734861116764003168534202354092520096944;
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = 0.9747263796024796502466688135383708980845368176554858005326201789921787651358684645855413515511531779;
      _weight[0] = 0.002127334586489082815067761922450647971339436325800608036378943516449777205231547251874812699984002648;
      _points[1] = 0.9169583865525948532931346270180274177520051095629925713521035439862432832098136415299370694612456098;
      _weight[1] = 0.01208784192095955158546592435315376798873973678286821945884976723777153926935372997535984241012638151;
      _points[2] = 0.8308248996228185740305665439056567039439893043182143500186679333872078183180614211671796544755957774;
      _weight[2] = 0.03332724690336138483149424914765120772804900513036485126183239293221332762553574610457746434628575068;
      _points[3] = 0.01001828046168040584302472986780478481479194051621623866216912370277685746144514894811474690557217854;
      _weight[3] = 0.05073468137628285236988931703476675133207796896933092717229277653106864390791321026906916586123809916;
      _points[4] = 0.7222032848909679255633213078046109071372364455125913944559779818780897684066745302575181714890353345;
      _weight[4] = 0.0652830934276666920359077307795285077879127343290875547799110545738322739215666227754732791506949874;
      _points[5] = 0.5984972797671391832277207136730435902749187521976111511339511314695356530954712310305911412553938959;
      _weight[5] = 0.1031827213445951603861732834892155856521211990658746337177474052730046190656697225942280520050772121;
      _points[6] = 0.0520354511271805525835426957729643224471859250583818355555288193433032785128089556252838329676615465;
      _weight[6] = 0.1098761822657429965174933633313011358561393819756883634817227365336995079659568003680704346417901073;
      _points[7] = 0.4681376130895840420831103807577535932852717675509161657042498476028053990410676565350775613890232895;
      _weight[7] = 0.139063750316366099598101779267868198861848947191484699597473899124092437083773623133953772504386519;
      _points[8] = 0.1246192251444430737352995872639092292474441300880058562471871920162296059349519090766521215975420844;
      _weight[8] = 0.1512400961143739966427541096833209231046779325373189337898872562690835045663875992951588992175330985;
      _points[9] = 0.3400081579146651882336052338970175277313293398208505803470934737382842096120712309333935896431331419;
      _weight[9] = 0.163758205976126940779173703886922409929998051411988406020634300444537236239007794642416009985288504;
      _points[10] = 0.2228406070438378555078314534573627644117252503274297081643638173616062308369832016150585853516004854;
      _weight[10] = 0.1693188457680352424384787771038208637870956062801928026832694675642471331496036035898182671775944239;
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = 0.9784379368341496390919069169169960383680691296676253661798930654904321350621424594217105164689234999;
      _weight[0] = 0.001550364441876056714491629023748274324615848140402517231572360221265942541320023063415527150625599336;
      _points[1] = 0.9289421012644110178488101551343152998504932414769823471037599293899243740926428914029706095801991064;
      _weight[1] = 0.008889615591336924645592291731656523264334512786299205998267553396394713293187392679750568752472830688;
      _points[2] = 0.8545525437649358807902119164056171284859595037395583869615217146999851616473022152580139867380827058;
      _weight[2] = 0.02487201833284453121496658611334714530755126260542143269983812777030176667500918269938718422593047246;
      _points[3] = 0.008539054988427419368664460877839802806090414566577746496257927301230364575762166797509842961307629987;
      _weight[3] = 0.04332972177374353464916694415595120758543212996143774483351792036632706037307065931531595605216654504;
      _points[4] = 0.7595988895252270537426025740434203419422064350885379264310222786423119973912528922496277727549814325;
      _weight[4] = 0.04975356081853086402501634458003176107706292549054632675888919684570712369316153894595850288044856231;
      _points[5] = 0.64960065027725499276629172334298057222565311827730373485571958964856442485986620008885607294565333;
      _weight[5] = 0.0809033074138272335212928485012913254284908033388081504474420876958459531768419460967739126481291571;
      _points[6] = 0.04444646315540772302546679878555276624130930378899710999139642043436028639661647795803987919635307312;
      _weight[6] = 0.09485570396075494026861836439417384912441834405354373442454022749260726809250625956872612646956304494;
      _points[7] = 0.5309508493128176706289302428968181393245082635016252048349547896722090314354827164359000778197833608;
      _weight[7] = 0.1132276874273352638874022103122425258241607825709588607721683748382582855487003673371838524124059047;
      _points[8] = 0.1068544908834766576341067704324992625897998143695000275580631125622836143405186814627639697793505886;
      _weight[8] = 0.1332135012533463962616689707039492301237993045862266872004033332675451141542576651800487628901600931;
      _points[9] = 0.4105450812014576824890343505593324118433186951909181754985565958109519682767226149737373217217664215;
      _weight[9] = 0.1402186799952601889918436100593420114476858105470553510722523423091126135591673604029597265238160539;
      _points[10] = 0.1921510545298540409910572562286133303827013670215218660373964882963368867384002033277468512639620344;
      _weight[10] = 0.1537932053600820125624089382247452165048916722672790101081421598961789423490551582621434158001226839;
      _points[11] = 0.2953808842625802216229168343760149059398907133108521080514580880514097551832904806231230987696368169;
      _weight[11] = 0.1553926336310620532575312621995209299875566036520209784529663159004552165437224464483364641941562454;
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = 0.9813896349890121485602806221597123115526801027908002379955097186555535838880620308147789489545503322;
      _weight[0] = 0.001156113409872385703193022385189204618455050656599975054649145246648958439626729696480355938729999156;
      _points[1] = 0.9385244591007310123976333867652993517339853062062887126354508873721247374248021832126814047065480957;
      _weight[1] = 0.006676718501547543613220841284083742579141287031654765750719644999750581810915764860757199651559573378;
      _points[2] = 0.873694821306689419367714567131743891173381534920334759444696161547514405472868541853111673402239862;
      _weight[2] = 0.0188978489591855007323601730984825277398072170071017667796222649055973489956725747846467746142906843;
      _points[3] = 0.007364651026089321650691498413822343611205715616446000420689416452269750033894550997416319128445293114;
      _weight[3] = 0.037429463171230350386748817329987677463195653326885579415509956584359065159563626022275791014111276;
      _points[4] = 0.7901570282734374855528633324993759322704266136136999317134349971780526905331558640579365443870029772;
      _weight[4] = 0.0384279143294396412917909957274853493954585050845213350300056554246318753846340556589445192487208949;
      _points[5] = 0.6921010017196016568970419516876697301808911008718652877381506074556730863418738419796277914411356902;
      _weight[5] = 0.06387357432440629768476274231692273392726396567637467815805792742291004917213504197268100373444847643;
      _points[6] = 0.03839813873967835037683252486414168591782983413635468761241601179824278069140258974034999134662094291;
      _weight[6] = 0.08264057883967859695322341390524823284515157447829234410387722644326630504728309789009709658118130558;
      _points[7] = 0.5844439640213404555042208478109107062952661618107888083023659837678484044838564429563713070829009516;
      _weight[7] = 0.09199156135210478662651956906042682442879113791215881297685885117558806298728604690294432003559148446;
      _points[8] = 0.09259522469900263528289137543861635588927985865429292632366593235281921073136849542406090039759718093;
      _weight[8] = 0.117907875913294165072323006523922488540725339188477464752066853333436329261003962309016356899786218;
      _points[9] = 0.472584386004117725175094642678597272871548735684737639137060650545639928993354340136687675801761997;
      _weight[9] = 0.1182409626281846548385803119060635216477645343671270767817530063264325986532512918418359540320018567;
      _points[10] = 0.3621313972822388004086812982273215588635004488227823666951627890767765685364866146107646481156613177;
      _weight[10] = 0.1376310589751308344356757788733870175764464444515615290689142927534206737481584776849026461687874131;
      _points[11] = 0.1672510113915577314955224787593571163747337087390977895834969262324481399932617359780977489832830797;
      _weight[11] = 0.1394269365642887965028332599008539689313215803996770757259514170749411407585930292996487794819507198;
      _points[12] = 0.2586235407057625165897907328226910025245301373917701116571591768242959721348720274973743055115115389;
      _weight[12] = 0.1456993930316364461587680676879467103064777104195675964020137583090170105818763010757692025989815253;
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = 0.9837752340986002382812280091410008568029060918346814026541382401229231239358663224051124039381821732;
      _weight[0] = 0.0008794274174943185095245122078521822019754611306820543635221058449937077708215836466191607368411296988;
      _points[1] = 0.9463027000602753835334059434247240449122575138455164975479188348405641933767500076215855613747667627;
      _weight[1] = 0.005108202635375307895958999219885338023800341194130592644971481918873169565255964058559811747742715242;
      _points[2] = 0.8893428088195155396908716609464895647037628629053267599145054482375380565684526275834413083786664654;
      _weight[2] = 0.01459296826642524288681984453495518538081081230683288195407175989264044277989459235431320050562344511;
      _points[3] = 0.8153897394434746419730742186120575147090134055115116514499564217599632405912766985454621567772925713;
      _weight[3] = 0.03006460748785728700681742950262958234619962060282172680123539669179027622963256575707868303499798465;
      _points[4] = 0.006416760792818456810820464094507178865719839912244884307238769932733545613705239155655121904187687092;
      _weight[4] = 0.03265350864519367963889885870153317340972173478361002456864218835784085024442850788249598470811557747;
      _points[5] = 0.7276764528892646854360267279903316966165601685246486600874809495965456531104679399309294019000621421;
      _weight[5] = 0.05084693081429752423013979751491821787681438824769049239677309253558218964169264456977882426851555228;
      _points[6] = 0.03350140453201314003596392857057248161039076925284236707232192332100661384915949406912586179668633199;
      _weight[6] = 0.07259215611088738637530423764370492657108112269853959863122175065021865096017202301997584723508772513;
      _points[7] = 0.6300366883704039578844805941314332791605030321087179470245277359365694220786253960307680873297618343;
      _weight[7] = 0.07488619291797165331187660365377253958575162997750359965853311053036376136149071602224720460759622726;
      _points[8] = 0.5267378613398730320537269448128829953760927123999441876600624391842836631760001928071840738368501546;
      _weight[8] = 0.09903890904640600916187235867150676110280042407247668375164802867487908835414687742741451294178579331;
      _points[9] = 0.08098549968195518439245130773998218722766514758665499507829939127797017196531825081787486655370778227;
      _weight[9] = 0.104891907003833491182163612325355902630923882710021642880128189982150297028945256249301997973770032;
      _points[10] = 0.4222946573075702578404089875181026958217938762273438789639540713852576268236287646690911714244228904;
      _weight[10] = 0.1195711180450631684452281183371739455866965354227942932369779043707771685058862101141744024798095759;
      _points[11] = 0.1468048676812137299236601652607991515599694654279756227180485513313137055587256285457460550167373603;
      _weight[11] = 0.1264260511486584068850582307158644869441896337243628225912745291094341360195650397288853205184837878;
      _points[12] = 0.3212717439889361744023403974130354496573046310098509725155244153528428571119004042632189220394104758;
      _weight[12] = 0.1327847012521708502656427173025549628480833128549141521111606655971088192656782192878509397656416219;
      _points[13] = 0.2280842706492579915346440986199429719415777248320505178336090146170398503780540680375636284189205411;
      _weight[13] = 0.1356633192083656742046946796682927954911511002736194344098397958433474422723897998813041094757195334;
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = 0.9857305452631742252659006330591292421044806623979681396367496904534811104340037194340828859918697385;
      _weight[0] = 0.0006806847682757921219050495213766638432680058407302207119346460095765860960776864024700562258866547623;
      _points[1] = 0.9527004099058333143380442075242620935055589938201492599119746533434704857023258451913238950513425218;
      _weight[1] = 0.003972469386290076082067610229152060080164258093234183168970372439783118787506178115381153751505928668;
      _points[2] = 0.9022867006793780266312385046620090802654876855849468717160511280017608939616471254566098257665163856;
      _weight[2] = 0.01143444478944235234324930059485362276155780539908978755489501360681769092103144487510479479673066532;
      _points[3] = 0.836430960605610123975559085654183196614405051627992133778977423021298990485129486291590400663182545;
      _weight[3] = 0.02380838071019515768606037392049978041111467814177297555284892510317273317213807457840075998316796784;
      _points[4] = 0.00564068897251170975750646657944420096608410698813114796797833513821814157573636404891569720358967909;
      _weight[4] = 0.02873413924342504603822660041253805338312894456953019000237612541859506016961128946212643705469219694;
      _points[5] = 0.7576647390313427119970742777402853179406886187590936481745381257951925531912300645820920629808513943;
      _weight[5] = 0.04083261854523967138238199054130899238084842965133790112559698218356527355006904832983602017392245969;
      _points[6] = 0.6690151950299598765386956390531395651245327979857527236420750144055549199665133052913040313820535802;
      _weight[6] = 0.06121953917293708160858361757949451057101860352459654126809960020356064378300880593208989800744638434;
      _points[7] = 0.02948229864794248663164098471800370918700961303166077760161299352098320969659464315137326588996548668;
      _weight[7] = 0.06423808974993183175709533215289588884744112148800311203074357885220757249757941129839863550239944708;
      _points[8] = 0.5738891609066858806714538552375264393339926267874317142496528265661645824810184689905478175189410147;
      _weight[8] = 0.08280147036884515645762630104986933848692863219976179565650568989405659185694148889272203873424612482;
      _points[9] = 0.07141295311515884005478390174673491912187290234227435678431701381106489005946195046185073236066259622;
      _weight[9] = 0.09378327988811985135869114109359384457615020825902727102745231221097976938006047088803797585845547739;
      _points[10] = 0.4759423084632348605725889920158496815427420479142534143461931573336140130566014455167924185629638753;
      _weight[10] = 0.1028247246237729370608003387427179543718483332403108120303957336121729678371306599559686414960307901;
      _points[11] = 0.1298310255535910559712545380942899123177230784713915452688927991403297243171614954096840860975794594;
      _weight[11] = 0.1147976510138825787492378322328278794932624818571617498887067215859317142102959221744686929404717464;
      _points[12] = 0.3789386886469780381065290091427738514254527443330112900124820663975192124536679674713512968590311795;
      _weight[12] = 0.118348384119425863130042337329175114508728339622021249334756378356496508819680628536993165372220157;
      _points[13] = 0.2024927550501040475682199883202304426029145838857816183098197713593869872838287905637745131407654636;
      _weight[13] = 0.1258362132971938191853306984611028086637728409087228064297723636579546705764893008808467616699069615;
      _points[14] = 0.2866060862575270599840260454843964124631835183282258747277172597764764143673373926548361027887495962;
      _weight[14] = 0.1266879103230227850387014761385934876207673172046994042169455568651290983423795896771549684315259543;
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = 0.9873530206260416180311559031679007912251798676684086442026613475062814838402808784348941153083800942;
      _weight[0] = 0.0005349873301110723536352523245214688183617068853187298053447754895460255914769305758271994969541214465;
      _points[1] = 0.9580244176904754545449593445542902781690561530886972767565858987751500797120765811025149504454439451;
      _weight[1] = 0.003134376947191639406144801392810125165152211379977657619913840594889257190569195251860266967518853567;
      _points[2] = 0.9131083765371412746295855467032689982673591902958463102880070958924077633184989381448279078074159235;
      _weight[2] = 0.009078464772277270136442222357225691316200205613577463083584857434992460933218018083501741086092773742;
      _points[3] = 0.8541381477752106336651136838193234409326728494243068253734695081123194081450149725457651384431831747;
      _weight[3] = 0.01906833576933187330993392764154659000664170074848288047274653307098419606424675728205551148860085042;
      _points[4] = 0.004997299663771921042651149601520690335334381543416344377970522255874964157558701037502647102439618306;
      _weight[4] = 0.0254786213146683694950996917591554882950068833129658279912640220737138513709595935845618250570916986;
      _points[5] = 0.7831225539648680838521817825620535305797128397296362805179828091518110236513200121261822163769397743;
      _weight[5] = 0.03307916871127158700245048416620955670443497800101336034230747234827543543117463085957742175622968897;
      _points[6] = 0.7024801379250410444548069755376171424391608550242998874533600580057788358037540611975107319064165735;
      _weight[6] = 0.05031846621294008117130791499383570158153393032155337021668257703869079487755627644770701989152686714;
      _points[7] = 0.02614351368139405197854932338054296839544549585254593258969286943447829808354691926416178281901416681;
      _weight[7] = 0.05722490518028629871511613797483697079230632259783211879752488731784247248602820192649149147829524039;
      _points[8] = 0.6149571518764895174896408338190829300761737909570376040266234164320457869812106383069644402943986533;
      _weight[8] = 0.06929563315857159820616975574746178675946381337997363992181349355292028244090523248488698582693559141;
      _points[9] = 0.06343094558383674549252822277070085989944232720053606329921286336606196501991941696906214544072557158;
      _weight[9] = 0.08425886231485656951503148108375679459878568927192553127356020255912965879211860283525552208869890524;
      _points[10] = 0.5235341160251683205174701650756566635860722410235498499954471423511414451699874777100902273256248828;
      _weight[10] = 0.08799476437848784634696283460898074168566203452803298141048012151277732409770913018617800056991931691;
      _points[11] = 0.4313243435956253750835922695827402886099831559358862798400496976431495143682652974446555198615522437;
      _weight[11] = 0.1041282756876131675099467043785466919999001988893057566387403573176304031195728572957688903687759438;
      _points[12] = 0.1155984375798159401789236282473972563726614701242300531764409420939787630288591298296722238684111472;
      _weight[12] = 0.1044571888079182947270193577860579511982476687312989947927842773279309587346572216043331398329162766;
      _points[13] = 0.3414679275478230686258992979386936719113738330035523847360437885913802004557323404561019734950136269;
      _weight[13] = 0.1154377592185356472353639909359373445130799205578497513133111318249085177414985560302496131357962334;
      _points[14] = 0.1808705596578836662475733912556982106123115303246260325696821028817277573264066422281984062600090246;
      _weight[14] = 0.1165084804197116707586035588447860117666087389169987223931858385521171238120053660291409688664210766;
      _points[15] = 0.2570248078451708599229442395592698543456357763791818065543456950821702866951437507776531490026073371;
      _weight[15] = 0.1200017097762270141107718840043310847986139968638932139267556119836512373163034295226044021116885655;
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = 0.9887140406322437514171214022529600950271304358332938882155721604826076932154206388238562326534443377;
      _weight[0] = 0.0004262325784138671616503014825668479867743121463983310760858304095888980890581472393557710822246507172;
      _points[1] = 0.9625011978233500412504607753885055612059058670805919300838487295359170197761774966465922450143861371;
      _weight[1] = 0.002505366878782441497821305040213450564573948855367154150978343268848357634079495184968727608399159802;
      _points[2] = 0.9222430345922984084871073282303817691602583776161059845144196175091317355129889510768256352598660848;
      _weight[2] = 0.007294460966842812890068913047567504341965175593956839929686155659396138028717360227340619459117792835;
      _points[3] = 0.869166059567413619204446498011157536480619533973801747094055147008674628966944082007489138202985139;
      _weight[3] = 0.01543284442961187739177684553210850040977377913889605049895702539591618751800244624737646088996791658;
      _points[4] = 0.004457993567787391754506229111546399964633760100259970537810725491458494250043598437019664865493643768;
      _weight[4] = 0.02274540622639378829776020880683720609452057522373976015749508324031731694387040746972125365570310004;
      _points[5] = 0.8048835785249664919991777013970255022373475851134620892027287774778381435285669046560052364431526214;
      _weight[5] = 0.02702739490460156181927791662098239956927108947038280148990998102655235785834616122857118941751450445;
      _points[6] = 0.731348952734051382133021495562975876964288241933596559645743754150107521905228731408698776571450455;
      _weight[6] = 0.0416065560205907241200257327515462961439659897769936343927590006521666545011746825379533316882700652;
      _points[7] = 0.02334009412377427396702152820768312299586060057599419863449974659248238243339757550585495829405487255;
      _weight[7] = 0.05128485584041035837150041049462227236569515810109611130226859683533715551484088425680168656439029542;
      _points[8] = 0.6507965584533822647314874073231465774368335045672017460161248195939594014514835415159009295305527969;
      _weight[8] = 0.05814904817541010112637471093584722632635723649505078175048544545500447542788986279551396785911403471;
      _points[9] = 0.5656739668866343319033069760096456365875201180074841733261734685045356633266844286988014211643520509;
      _weight[9] = 0.07518465097422447606286399704863748886393605930789172672958010315085190595784826875016684063030466313;
      _points[10] = 0.0567079687690782395327133315565206422583954294330082911813093706572985010525054793316865221556378879;
      _weight[10] = 0.07605145765148480040294983401333088847853799893124803854611256634704675720143211718355596447759322621;
      _points[11] = 0.478567596853079588783710462859367863464895919649049929129470687367069564027548762072173649770694993;
      _weight[11] = 0.09095558079828455499487784832842234327421076718008184235832962158876271346851796676218008225388408436;
      _points[12] = 0.1035554329351970634134912269613124043655029097199118685108784305899757515572621444529640256077589927;
      _weight[12] = 0.09528373874923688384115041853141755745633038829194399052580502788189156712111849867133924841409385054;
      _points[13] = 0.3921241347220956580336194633319030935711764025114615789973484145740342676368815150194126405593319517;
      _weight[13] = 0.1036194838585926665104294095256400693128383841028677293915780879742991691522033818310328703299843335;
      _points[14] = 0.1624600034281365499816295439141031838558059790103253735306759523919908694781359490868358657162134059;
      _weight[14] = 0.1078158633350549603832320404930530506583776814863800678782279266510495293543282695089808637986145332;
      _points[15] = 0.3089701177521959033175242612862631293729470242289113159247135612658365232010381202115837653514093201;
      _weight[15] = 0.1114698358471210991542580389815065276072464356895427892969110466585885649118705952943517744483555478;
      _points[16] = 0.2316321257771721829467972257383587479080211677883964983117694939499389815368349381911564356963581668;
      _weight[16] = 0.1131472227649430259739820683657003705456250202081623505248301578043822513167014548107893476058445038;
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = 0.9898668482025971344167630227759617852272654029332944782218012796457954641639004909483002293295752187;
      _weight[0] = 0.0003437381681963917846247430221834229151499287042287230354055143379188235978579521132163657479768314514;
      _points[1] = 0.9663007519456325424115067464906798893423212721801663890681129055831478702436903498571145506943067162;
      _weight[1] = 0.002026050358602094250494341820341870894120024561864795036338823580354925264367517227275244576909932423;
      _points[2] = 0.9300208896996932164819585047276942532417932534056115051608547073927014042784861756734769306165351191;
      _weight[2] = 0.0059248861288656750073070124596837593021079220492247058775169782719872717029736487292831561213573021;
      _points[3] = 0.882019825362079146731241208862299348005417555808720267548968016151212864669297713515695332184984095;
      _weight[3] = 0.01261207776476106746655648532508006599729513787362061969061111331011139156523293135970609947084018862;
      _points[4] = 0.004001479383867386797042719910270824223541185248785833363554578344319893757114842618058463407348803735;
      _weight[4] = 0.02042867887008126774453513345708525680111295405537645831789221858363235004907653637524376483250420953;
      _points[5] = 0.8236074297748695658739488546206220397694931892518864127892186510351045655222244744576037075797895574;
      _weight[5] = 0.02226374019481872490578598695715605901312264527880759493159497248783660222780139439098845774611394999;
      _points[6] = 0.7563771934061506267981673359097779706473518228163447251511697288815637982124887651626427336664155865;
      _weight[6] = 0.03461660096179857963094037301158265977500547563449518843396957076139936244796763506359293284799136368;
      _points[7] = 0.02096364839376647799513560098656109675689180176538502182710065123636384918467384831554500962763531465;
      _weight[7] = 0.04621270032675413386257866238629064300957438277868616878558323293289918331132386077257775663020718931;
      _points[8] = 0.6821630391136515650188220799815272984812129529984549136808308873845014736266989488992730818190698119;
      _weight[8] = 0.04897518000258343319573971841628213770242132719001940867089608917054120707937976989292545511549928993;
      _points[9] = 0.6029893605598320721374807041874726334761957597253021332090631742614856848258536813319527445372951366;
      _weight[9] = 0.06426961225525709848147580633301085880443436756721415851562729065246516504496265169885498286161075816;
      _points[10] = 0.05099404158789055396677492129985342752684335179502102250490757627054764167157590973686635778722014573;
      _weight[10] = 0.06894223784384404993007739031698519886588775153771160210566885018965190752564322224893633392985120252;
      _points[11] = 0.5210158208707761473198147915854717855660664902319620429318729520457293008516289285224828683060695134;
      _weight[11] = 0.07915832457721575745284593825289506100924953969440499641376678369347764830926340546224343749330271028;
      _points[12] = 0.09328039592854495077760905882606572909110423169403601965545516113954878960271296675572769974433514713;
      _weight[12] = 0.08714781414928617652436330187061168404379158056036702876225120391972824949607113158995664181206534451;
      _points[13] = 0.4384784492241381176518542603874069642668262016685327878789060389076575892412083497577428502906842642;
      _weight[13] = 0.09216480198048256152417399078564414852612846466652256992046258396446590593706414236053909750896569121;
      _points[14] = 0.1466701036776179571516088297346119926828719790587607976177450052287675453102203350213112764829923106;
      _weight[14] = 0.09980445383540542778220444771221204607299051846682882828893450936727624068650930424980230859564698864;
      _points[15] = 0.357628649976634629398327142983900163551554823411966631545931014342118455385001575208686365462093356;
      _weight[15] = 0.1018338577127481863631259923308642099185514417373884497748896700704506385950017111137663314704100197;
      _points[16] = 0.2097070395888429667218817114520340564344572337129713950314960570502750540556726532998975043202670298;
      _weight[16] = 0.1063846692636713200524475540357298948042757460509025466150822041706738793410034729395308181691385946;
      _points[17] = 0.2806717900601716991068192620345454984655482490495543795697683718559155121543067476743790509001396303;
      _weight[17] = 0.1068905756056280540407231215063610225447807915923361568235083905351292478184997124115608137022023352;
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = 0.9908518052709556853530948352201172311414908971100306236116888056786547010228099804847460306449291637;
      _weight[0] = 0.0002802551883567726748812555744779639105600352061968937989749794735813128057127028672314734203440280795;
      _points[1] = 0.9695526370802208854719287862322660049706018326703098706378843584104484087310020229969934667704093052;
      _weight[1] = 0.001655761521847964386692006035428965858679000056357516012475017722076239956761833907883794506161951596;
      _points[2] = 0.9366958480743650805439055020819450266811818650579229027664901891451477928206324529848022077423518401;
      _weight[2] = 0.004860183424086561415136332087732184813912903332909763493482554844577771785083994880850628451944158735;
      _points[3] = 0.8930931349818449707509811545649148473623623153254222496159769165216758357705561673044346695221435769;
      _weight[3] = 0.0103995626565567593736110930883662168930384206107188660197640952475440944449729962894776242764085632;
      _points[4] = 0.00361164281855689303445321012625198346733275355003682919557113405867408349929295207867441611737690897;
      _weight[4] = 0.01844807545006615338353364973844063664514747348633002796850199039649780838921192974783628927072788796;
      _points[5] = 0.8398186157087110778386362944292882560999767507786887653784723935849407017581430396000219565181239941;
      _weight[5] = 0.01848218385863319552539537554057223036019964756805820620573212876783093453134742074611622587750882251;
      _points[6] = 0.7781842229767616142092996470420758791283656925578678775853071098643813559091198697527204996713931532;
      _weight[6] = 0.02897969422421944931400246601007177204686871789749054254495145220324571113131572128329170246403961399;
      _points[7] = 0.7097076516539023988437467831116355144608909392408906399894113065110659853244124588493665962726797404;
      _weight[7] = 0.04142334512551560975967431967755079490752620840476902467442180073660343747997340115254631834842068448;
      _points[8] = 0.01893183703158821725026452431694923674614045524658723100881095660938384328017838051860341840597562064;
      _weight[8] = 0.04184930350395978096289045666597507923015930768805746257353242039038709944828752655956749265005342344;
      _points[9] = 0.6360750448792708946910910570981647668668019198973285696987761671558681881849944225414546581423684885;
      _weight[9] = 0.05503611628869595628296228495903234773834971955306329246189976450730557322385402735173501701009562429;
      _points[10] = 0.04609793304843108357392477083545909375906241693422215752403930389795061196209317861717874813163785794;
      _weight[10] = 0.06275255057146579770871362891521873929256827500121891666402911779624971524361366764385547386229422249;
      _points[11] = 0.5590994926490319878469279758790814850485694130830958106631220505575721013709915928328659605930323349;
      _weight[11] = 0.06879791590381478285911941087185040133275238686516501251070694318774386308432389393107853548035543575;
      _points[12] = 0.08444722278420982059984790045116954757568547567342996475773948377116464751353011539561005675988539905;
      _weight[12] = 0.0799247400979834838805861528846334314674922993978160391753764141223543035502626214065807498002876862;
      _points[13] = 0.4806763935785519026332213524827062607958913951805210382735109679392374943149106385409942481778506352;
      _weight[13] = 0.08153774174367337114460345968332885877015622313913313374058373868512964935174277352830164497093084712;
      _points[14] = 0.4027367861650770951230470111048776348626646611402175602798726241469139422734752813325599363666955167;
      _weight[14] = 0.09204397143227682581672576212135660932951865767707678899669727185145202547081949806407328350372842929;
      _points[15] = 0.1330361885580987754240874239752163178462101569942577515312839921107421010353389269684892715246493502;
      _weight[15] = 0.09246985633715682353076157026438268785806641992726473058335517773221312455376698448719205979985072617;
      _points[16] = 0.327199800763811715728429965275660215695471902297825977016122346800179335288035110115459307288784813;
      _weight[16] = 0.09918209293741316028263210506706355271369499867043289653925746745730565272014624896429591950124037465;
      _points[17] = 0.1906685949047633510874746648871937910511869102030339299609855946583176259568932278761873481665619608;
      _weight[17] = 0.09986827648083875910656821167754631038635897016436543739205281535304647362910941203114996053856106275;
      _points[18] = 0.2559254034821029602520473972952833166965225034685666607613445549879376542400004376190936134395605969;
      _weight[18] = 0.1020083732534387925915104591369712164449503353535754486442048495248552091996933451569357987499299783;
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = 0.9916999557929327307665436596947020094146922407257829898363762060484693209882124325386440915297526987;
      _weight[0] = 0.0002307638143513705802967255226568830728813167721599840524365336414500605445638183205419184402827059144;
      _points[1] = 0.9723569466474369111847018716646485313955816199047026627731927463182820924001386973341816730256379103;
      _weight[1] = 0.001366124552171843969035439751076010937012975665488565633903154123928917136910100459323476024770590956;
      _points[2] = 0.9424655423631863386908918774276637741176541559385663981945954132521152784422837129268702079654087369;
      _weight[2] = 0.004022915227928156013814278936824336762072286332632338071325792455668677727129064099489345807286851259;
      _points[3] = 0.9026958717934536922763469416996700772864999425096913605427629927201564197787843225600147491273022283;
      _weight[3] = 0.008646438225380306267478104148579112377200533623295159410282371065482011056328697434527181907858069684;
      _points[4] = 0.8539367530358904570890043916180165250991367585634254004379927018011944789694603521437745068010803997;
      _weight[4] = 0.01545533586010292574715613428317953854964217039480755935175135440483625462586097291289321958626061925;
      _points[5] = 0.003276106669050098975264676112871143292010168497029644767295470063831412161584194743610327964052659495;
      _weight[5] = 0.0167416883525451139484695594692113303959200115840109757199624734967735024433026011320234271381241498;
      _points[6] = 0.7972775083365946877021888513752729067366395533700328215630061593076170870677993680779536516217368242;
      _weight[6] = 0.02440809225336020855759740649158179130555848135630839155224086550001630535743462622984150349854465053;
      _points[7] = 0.7339838582356594497320271932958407316824886943041261173702937687882678060193520684331489222685668062;
      _weight[7] = 0.03519413375841203253537225731014733812107557483384302032295579824046286874151937628916098565550834621;
      _points[8] = 0.01718121814525571373824770463158205217142310650921932699389301827173010299694629239806929714009353387;
      _weight[8] = 0.03806993892740333390463550463872740520842342009670349282847748189119210800461319599436674582927199561;
      _points[9] = 0.6654696989055136479537295881338505673772460184966543033851700597919629976818155341141170411631585467;
      _weight[9] = 0.04725059234709778562613272088316633264786049061137085249821716995453687692356004132430763173471373923;
      _points[10] = 0.04187143111776519524423463414370851114954902307898488691386863470682049070344137006251506996053615728;
      _weight[10] = 0.05733647475826119260703896626884620663676526982142598197751665152278167937952506465377762486070349003;
      _points[11] = 0.5932655334835064879673930865443734208473977411399654892597462260744716869678127565393306479732092832;
      _weight[11] = 0.05980348368525802609816497837917858372547486798828513804350498569402473230677222080215249105521630064;
      _points[12] = 0.5189842887035737296184117608302417580161348370994725645140664538072682185064509019793474604143752166;
      _weight[12] = 0.07192983830772549570812637571959705220454253379516249592845826823872807811447074214345608253045060851;
      _points[13] = 0.07680083708962197048187052301994736761573663220191864690793950376336940712642192742790120232186627601;
      _weight[13] = 0.07350047967329571176034002983707970547786941802561395491718754226714603265744811012378159064912127635;
      _points[14] = 0.444285286963011162128823917835975050036359774906195940140501796031417737745668160330444167600005532;
      _weight[14] = 0.08263541363333147565166589034452447111897790526008740772996796592380070257693533775950888460291073922;
      _points[15] = 0.1211898673236760656176861522945444470235806268943235898707887850377131524410713389898296198872403467;
      _weight[15] = 0.08578059167595640842829204758039989126835431719768784417396580841619485004243385901000626956881311921;
      _points[16] = 0.3708371805843968964453220795377124336991024955666204869798357877359442742262916746260159928230296167;
      _weight[16] = 0.09094117788270695025052175053988521021573682596634589761784828202602528063874365566272648430490295018;
      _points[17] = 0.1740471126355421652241579341996569921877681033069868901852878459116461179764358286536618532558350224;
      _weight[17] = 0.09368338372511565569498576493650134822004762846570875646531322483816870359335260839464910457532484731;
      _points[18] = 0.3002806768359501643662584187171734631746719686192409655675227716570747312020196669966322653788992448;
      _weight[18] = 0.09597092321988782503051231642150166590478722336093452405759351080479348502148876405591865563178148165;
      _points[19] = 0.2341918863135921908944557128323043352373021481231570747714734150082081622077654966849128615343105212;
      _weight[19] = 0.09703221011970818162036374853733578584979674884812765964709076549398887310760714319754736126669081831;
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = 0.9924354907256214774937902793889982068789303884718009223638209927180066784787668474833283570905445554;
      _weight[0] = 0.000191723737059443657959199685730487354781103587725215652416642420063697623658594870138319440832039897;
      _points[1] = 0.9747919756603656530791520912867540805522533015938938496488658734735577229804897977756749790184306923;
      _weight[1] = 0.001136997053399528357223582471399066105620591183233813017156494435682540599458716110693253354979571245;
      _points[2] = 0.9474855444063973466860989716611313948903221194844454580667087781352119091878179384063695290882740173;
      _weight[2] = 0.003357512043133831072552673187562964503288479122657296229103793587294405115801504672333876098665852311;
      _points[3] = 0.9110742658026157747796664327661934805098614945934874284421480344586480510586007787502760981037640813;
      _weight[3] = 0.007244105739489879730472547559442240697420720259915659077551736989091842220673176735262750458582496436;
      _points[4] = 0.8662997589709565970763633043579206958620698193352277530749704236585637715961211057848505289659337019;
      _weight[4] = 0.01301319484729121067081350259836615564509889406165673029724426861833434880054116162097542564135199251;
      _points[5] = 0.002985237283213062741888784075749833348045897190182021426647111448051836745590953162187136553707655404;
      _weight[5] = 0.01526121181304637819034183537343181870586287942279387814026920795825460055220015001230074094371099912;
      _points[6] = 0.8140736165126974167889441095793418834761159091940745540915800538406752152475818572669301867705564224;
      _weight[6] = 0.02067841951594062532766545282048113895201409713863530682554154662668730367463374091492579251825178598;
      _points[7] = 0.7554590544496869862658499728148629393663862148485365820478410117499734428055421838878873979671459391;
      _weight[7] = 0.03003974522638556952704078489267777259843073958271775542411847529124306280115798397937637514899445391;
      _points[8] = 0.01566228055757354733289561065567830149720101282930379057740690982898809746455700724957349161137445402;
      _weight[8] = 0.0347758521523900250906201851623707590927008222558555613311917759618246838587949059386947611441063847;
      _points[9] = 0.6916493150129622572194466789692474731114378954421946863393862533447191774980898542170077714513614257;
      _weight[9] = 0.04069109877964301658407017730425226266443064057334065145095136833448379998485753079799217710254713125;
      _points[10] = 0.6239433897212819474963058147440920154900191318154389436290443886013853942344250394844038511295753291;
      _weight[10] = 0.05204609359179111023564632579998986927183950203292324804344689812665144316827079944423657995726457014;
      _points[11] = 0.03819828824507355334483281939565778780322081882037253284478137692301839452272816351601955509121448931;
      _weight[11] = 0.05257452016640661293744751166188692897194515113241003199215036965601069114006596457477516802652630106;
      _points[12] = 0.5537195807282935914003656124348565130222723633112639658363114623393879406517479598116624690714085946;
      _weight[12] = 0.06337990610025468075352666693255656013349124651231552374816444219192430946831498393294160099075286409;
      _points[13] = 0.07013961906232579813984265676375811407081827897927155972627053849656310064145605407077470856671992207;
      _weight[13] = 0.06777358068880635103031781043749696727813442757543512272919269504359828524130368130679642947198108584;
      _points[14] = 0.4824074446124388805353185218595824144467997109997394967544461672573758804548396608944152015562769533;
      _weight[14] = 0.07388402529699877110380641152857474527467150780108552765426171096663124369742378311614318387497559488;
      _points[15] = 0.1108366733203635022376253075861617420191222518457438320529257958835099421591933038201169995724621575;
      _weight[15] = 0.07969195514279793288914190000566235267906711260491304675619638962584196774176642443198237391267458687;
      _points[16] = 0.4114586915619051989269753361265125049694148578387329380612416947570578330099506998594987587756143859;
      _weight[16] = 0.08272952079399523470880740580838362330379464284872694528732063439370860031512300475525677462603061616;
      _points[17] = 0.1594611294440652502638138083655501810579538766130618360388682958278037659580503571599755802371923706;
      _weight[17] = 0.08787114127030075492971967145810458697850436666177532008944289193939981177542132493146261828025422332;
      _points[18] = 0.342317632958730793723481323712457505166343984781374969599613768908520216861182272658072990449954171;
      _weight[18] = 0.08913374937230921373396964638398331645759341581488079946582408064396578278281966817037315653266913572;
      _points[19] = 0.2150231853580202850809121676459173588900222007857657740357006632538302506890640907152055964899157391;
      _weight[19] = 0.09210054144651500414815597125252491515932996742881640264899141571621140700823572973382363663710533364;
      _points[20] = 0.2763917790937831724096862097630639456644117270400405937135134283509653312425761670490246263920613148;
      _weight[20] = 0.09242510522204482532070073767512146817197969239818616413946316147309617242947716994951510527304012945;
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = 0.9930774850443482149030021066415407683406700298179706308215188462467044126812424398542732069635953363;
      _weight[0] = 0.0001605964338749016320576856292150734027974336746659489676629679245638257528017707162633356339579309951;
      _points[1] = 0.9769196632371288671781665711370362045685576491004758259075059336129642443913384619385342626927521243;
      _weight[1] = 0.0009538558113180135180967949786628451294240092743928687244237285896188821328575349981455723556774242151;
      _points[2] = 0.9518795932297199145233254132304692539088438686423388255790172833977314296065333707540227994344743905;
      _weight[2] = 0.002823533706278848565916530037911878629982887095586678771104423447725510221470260596622430583204829748;
      _points[3] = 0.9184257249898492632792699442543246960817983206223100233229591659202425806838473116664400173192555422;
      _weight[3] = 0.006112428226300807468928605022472388819840529336780360990858784903836597627090362080718578428772948567;
      _points[4] = 0.8771815974654200209935832382780264667216854819433063264149961682215358967027150316006842063229545824;
      _weight[4] = 0.01102775020425528202183274932690576622802929805904276532381154234944322175706675534281853900355524607;
      _points[5] = 0.002731446008884229684008970450320001444920091810195930525180269991442470544358606232863648791137992902;
      _weight[5] = 0.01396851222739562730764330994005642798820870305226851204432919119548361416787182679620322866610583444;
      _points[6] = 0.8289156136217265123540054985427691593398783968413130229560818673737749864709777074205767676513685463;
      _weight[6] = 0.01761734488022181417634750650161074169827888941368967387824436676905266460390992162845846544979252123;
      _points[7] = 0.7745269160648226353202027384109920682527303908818411141565719030087724957529183987986099954836780992;
      _weight[7] = 0.0257584605627306793926964100933613725492722872259953914150712254770612504454578414722046723976962161;
      _points[8] = 0.01433593348369970618530803928505257182212734984171995141756688554596877547440774718470825927907210741;
      _weight[8] = 0.03188810690955699372913185825261865705830584729624107779763818757645318375465544204740947987843934266;
      _points[9] = 0.7150286804747624026121578393379999446389645236341253188769096134374679986116977432704020454213976699;
      _weight[9] = 0.03516003512030458548547005431414484593424269996086323158449180253002667739460805295412856717443142857;
      _points[10] = 0.6515292548958144740358068223118511349859101369629558312595962074831187114090178549434212259989474758;
      _weight[10] = 0.04537845719632199076042572155228547303759643411880068270661964657070462859342870351180007030550233198;
      _points[11] = 0.03498632835121644938721881407108470789540507513413332008873819031943272701440377309817494943055717373;
      _weight[11] = 0.04836847334378099951774078646756125991897967480632796321673948363274069201822403812450461165062074718;
      _points[12] = 0.5852115179512991297552453346740838766873451701532765634475564569305673634168154853640549882370619951;
      _weight[12] = 0.05584574164688526249815932491291670258280004563995038841006871240856953599982233845476300338102841803;
      _points[13] = 0.06430264113215888253127507139568606483527396467455008276394607606723427123735449200295989192425551556;
      _weight[13] = 0.06265519399875045578481791711936416627645561286020844389093385854076882602968762518293824437104395458;
      _points[14] = 0.5173108459509911200513628668417419502531014399509647860341897330139076887981516467821142472826215626;
      _weight[14] = 0.06590811757077106807977571305735299366400317729192485529773531632140783267376844390929590547508218283;
      _points[15] = 0.1017393434521639240125822659379428899539853633989816895418881106050308024257778517338354719506687597;
      _weight[15] = 0.07415410818640572896643467181854132802159376843867967796198737741804690263271070220679766274082477725;
      _points[16] = 0.4490921009868173325138719504239347417475929920954648897808863573672971601962552955877951121911249076;
      _weight[16] = 0.07487223293386003847932596237778164765909771195087018622881954379418589205789644518583498915989155589;
      _points[17] = 0.3818260692567502030509512762811186856943928877507787697256756013761460030692112995057041549779558298;
      _weight[17] = 0.08205559156388180327653087723778992847221561856887365139092586395278825727586388000965819474762431428;
      _points[18] = 0.1465992001576654169265658426695235179279442290125604632515204687033228653332772641236747155787629019;
      _weight[18] = 0.0824448098128229051541582393875662137076647115837413320869169037065961050583960349723017507169251583;
      _points[19] = 0.316765788710447271834211176023788565585917218829176864381597468997832396169947236122444167801337943;
      _weight[19] = 0.08683750029083565581666905153333353034148761155627255043342898156741359986662248660638659974313726394;
      _points[20] = 0.1980466041181826148466050402800147983667787135049020201401014006434161174885707857036810715432879233;
      _weight[20] = 0.08730240757260692599058627618965695877333537373682736038372387813522711622922491115184985621378186379;
      _points[21] = 0.2551232069716869695768287350762534865017322609522133051615515472916441580767357518665803492792871761;
      _weight[21] = 0.08870674180083961237725395424888980010638767505799639849446421318828518370656462205089634953201953275;
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = 0.9936411423413659674234674659492144344825859906238375139346624942288118730536279398452978995101742923;
      _weight[0] = 0.000135534085630299773212074130897584210836555854564225333161803433610929170770419163441050799228018816;
      _points[1] = 0.9787895175170725588787939186958919174534641597824532080283251852183454120155341188680323899069674147;
      _weight[1] = 0.0008060783183419481302475769328811150712121287430918492847770345087224901752876520422652114035579145278;
      _points[2] = 0.955747055076380126306280934995655993508546571972578475189971588106363915440947204061462001894897211;
      _weight[2] = 0.002391164993413535831600994583419511700235568916766570267257880249998309203933376284348101463868195296;
      _points[3] = 0.9249098542075925823337164109969201318994696513183952026689198527018630611553347105313285453711814395;
      _weight[3] = 0.005191620446910720770096011274932118364042720186345085236614939007955783549782982195562743151370410214;
      _points[4] = 0.8868058750607934334740477882285871206071403541849894413037182530711360933825476533262438961100102982;
      _weight[4] = 0.009401868666227652995952585963231501422382957680697780965957245463094744102323209704629371613850600187;
      _points[5] = 0.002508689638982744438582834305084970754465513041215795244037291698106602509090989047144538885452310289;
      _weight[5] = 0.0128331652253125979400788588633991492037855612500533267579485452992396263751800578389440168905250927;
      _points[6] = 0.8420871815760147938272551090762841119895322905806887532216879812775912541917310769974367310218997339;
      _weight[6] = 0.01509008390394755517476464908179904728950585618281600061596910970327096104697896113737910324026950532;
      _points[7] = 0.791518958392199164999544811561899563969866530494357902752851291892239872938757884419906943099590211;
      _weight[7] = 0.02218746826207120887276263590638552621253197931251564408631796147019043169238537869081644237786204674;
      _points[8] = 0.01317098500036888781833393883008497304237693656498066106398450987552457101458753605359608128168743719;
      _weight[8] = 0.02934304620092188218926113600741607806739210817537199870266151443933950832690670503975771066297699378;
      _points[9] = 0.7359664575449968693948098166623482992411491974356738064983977465191447748707008794380155771341181069;
      _weight[9] = 0.03048748451352573060772721176350031611003474117711489554566270549461388710349331159902545415320505057;
      _points[10] = 0.6763802055359521297445541267501844773125729751061369156714561779908754921014857822086096522112308808;
      _weight[10] = 0.0396551893481249125925521086126432747002257718640553587940071945094773848424573489581704970305004816;
      _points[11] = 0.03216172768263549326403367565653550535205766565201664531712686624400665820371098603813869334727816456;
      _weight[11] = 0.04463725220786037308362066413240402086136904820699921434316677932141270933111474705923954412447090065;
      _points[12] = 0.6137797438222284322478251318001054000017788712275714851022029844218004813706509166663266125837282715;
      _weight[12] = 0.04924611206265319667827944363701807174968086942310183494453035969494685072370452468029153544157500021;
      _points[13] = 0.05916028461389076523322206577362019497788250568779307045784761685757471784484460194699384188422236678;
      _weight[13] = 0.05806819763322011970374782113924425761404511862778324479824299752720919807911566279375387723149769095;
      _points[14] = 0.5492361859337143986849444709434036999595634258787999588444642290913115681454981608358155754321058537;
      _weight[14] = 0.05873345966894180966241572944644661616634652469095377698346786561882559594662330923115818784810304391;
      _points[15] = 0.4838538912019967973430622916413376995836676173698294055646030869616179182331776207634155618518804048;
      _weight[15] = 0.06754184722435728497520002182184314434614082127218346806093570515182043965457234703866461587667979884;
      _points[16] = 0.09370523422563984366939026810701599431294843355379981255080596536633429882747373537128397881326481735;
      _weight[16] = 0.06911669325016075584493212610566610721140551761560671679530417625630597260007129822813775191577520333;
      _points[17] = 0.4187515692045311374092315829147009424821192511291422675616536437335683699790579610322750663361326695;
      _weight[17] = 0.07508529186083901414100526577407837545431900256520270901278341770173066637555355144434418735382997458;
      _points[18] = 0.1352056309863808460458454746251433160911708193841602999666708950632019186174750867966318879969589279;
      _weight[18] = 0.07740045437700328926473449453186946979485005699189929147909285069627000897494280716076551491212405294;
      _points[19] = 0.3550431384266732981536948763163021427209776085086219647490204456653280019775176349750919633016300716;
      _weight[19] = 0.08080690215257658597452762845490596703525596328546181279008243628500936409123153800589940372707628206;
      _points[20] = 0.182951434776206737817241219053163283147422248322105739279654822172669012612264918073669777008318145;
      _weight[20] = 0.08269256057546193715477130820235096515571599625521525349385431798507764427936998623641731548676776034;
      _points[21] = 0.2938186667005872290547424363576361134204043156282958233734911798438694506857100888924860114111920557;
      _weight[21] = 0.08421756232457493979943437980297802638058106035661088138746759718641313900343550501435144093388206736;
      _points[22] = 0.2361257194699659752033367975673903519867094069780877665480629132753104255091235776405840076486321074;
      _weight[22] = 0.08493096269792264883907527383068975587810407136558906032073556299546435535076532045263371654972207912;
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = 0.9941387002099847972174529494354186447065590111257385945879012558028220919933208547206036697068695813;
      _weight[0] = 0.0001151730150479458384071635595253101782832122745104808509747143553195202907771103803048664630273115494;
      _points[1] = 0.9804414867720773047861990092929623254654564518007672132576640373798768725183629974386659808406771145;
      _weight[1] = 0.0006857923806901939716180130215329527076359172887024981713091355795707735117444618081210364335144106147;
      _points[2] = 0.9591684333956145359195940133146757910921505457443845505930704566821066595074815881415270673833622153;
      _weight[2] = 0.00203815713912692007459646347769836203946352713265341526734571099668110605270544423185729335343259772;
      _points[3] = 0.9306567200768073264940897342948113540892147989736239490329954181172965522690414938590459685654063852;
      _weight[3] = 0.004436613641500169169439699970626442930590561207013584324589174385384877629658784768911216861600074852;
      _points[4] = 0.8953562946217610669903735651020598427994962565161247360082353603807290907387866393285046179471673542;
      _weight[4] = 0.008061266812448580930088891626091521017798326749095430281313277537958062872952727474091695627913290944;
      _points[5] = 0.002312107617798491569705276671091089554939384003636010189709388318905051457029892184514494087344005534;
      _weight[5] = 0.01183066055113336862806942240007326328245558099447927275162523552741007390766368641044486302691611349;
      _points[6] = 0.8538239525472523950102126950475975286633013398103204851603925633645574373545504247981078805449901342;
      _weight[6] = 0.01299144166781244007855380199287793161149080700512316783535285734348566786945346584013675240596698465;
      _points[7] = 0.8067147162308662079759883230462271215511214289418775696507626148867661530416063674514532295042286124;
      _weight[7] = 0.01919585570453531090274182547445749150555233627807191180519025749427489117067745137550248266139141968;
      _points[8] = 0.7547715409190971048511486978937648589061186652744929259781655167672301711625351688732468834021431278;
      _weight[8] = 0.02653019230140020249207268704743023175850973695203784071226564499171372408835572203998397885347122954;
      _points[9] = 0.01214230377107489705391618941072912260522755162446019471499380137216042202948348504762488631035567119;
      _weight[9] = 0.02708890824143026572037962662152288020969476966472863417825282202056481771333289850444085338833423305;
      _points[10] = 0.6988136087122555462016606377145350834461598850036410982928344624206350632284010299704447755398053868;
      _weight[10] = 0.03474229649484084003930890647846262727505108642173711331754141432035930539668108322663152396872809195;
      _points[11] = 0.02966481421406884694296518092415020517648541895905737943054284836662555853198029459708727505457923553;
      _weight[11] = 0.04131359852028912070813348612469458121266906681977047751086422223751155286109440455542530956212070502;
      _points[12] = 0.6397234134973043576554117727135736996646600113714081000045059910790721633790546552645982027501322789;
      _weight[12] = 0.04348472766572340728540928114789743818624545599387243885741710511492122452733704265550252406972611373;
      _points[13] = 0.5784328451129381173040996319869945856313733674576909278189693731645225384582334961614709864014439181;
      _weight[13] = 0.05233393229745876141906451197180871793300976215540282985419030015323189126408906128503865664752988069;
      _points[14] = 0.05460726328354278129885634528658109995675907857338212819561910072319464261893667297651857381196832126;
      _weight[14] = 0.05394596868921663524498068262844092364170052310862208007218011372940229373250922674094381645827344836;
      _points[15] = 0.5159084936202979568506211844229575689363706436725780992080644753405181129907634992160172026059024785;
      _weight[15] = 0.06081487403303229439557250461246857543106709458728555540542244478846987123597889141506562545922541255;
      _points[16] = 0.08657678275502653153027885149201366204915309675322937558650613592608210237006631190380162408379504711;
      _weight[16] = 0.06453135870842410635528940758432413674737559106054908567625814834380452190132723118159432526647738541;
      _points[17] = 0.4531364059378609233872602564908296475944846220926500743387614702917419726601357431551427286510223685;
      _weight[17] = 0.06842960472039024618212495432963431108894080844633652827051493472714512862008051584998227091418043717;
      _points[18] = 0.1250693120998313816827247034321147372716372812643793892831974422340660561775264779754430133711757073;
      _weight[18] = 0.07272392358209171859073020012272423331634752635725114961740036064699127019826765310647657118990659075;
      _points[19] = 0.3911065354271857628058029229759407587117961441488460253702401794353555304627992294123975242415039216;
      _weight[19] = 0.07468800138191237704937459456995169435294967932534591746282115187766476994517745985562126268100280594;
      _points[20] = 0.1694778408374137992122551210880916091724440900194513583551692099521297695569503211773284187174570824;
      _weight[20] = 0.07830217864471200784132989838038854530001015874197726701210669511616739254100083028981782478774985955;
      _points[21] = 0.3307971297342992989465449797634122839351353239458986043016484038687065359502901031392280699179553766;
      _weight[21] = 0.07913874651520938929265736761457077631574365663020054012563532141424833258155611098929166716363521104;
      _points[22] = 0.2191020363269966008052502214870027886228146700884203403626969975224363594600835115547810175625647987;
      _weight[22] = 0.08117812499761111793897603388086616924056250529426903044903261905158249863418553775020821290326759497;
      _points[23] = 0.2731593030949704981198326346716482638665286879359816866038841088473610512662532110402010110389662036;
      _weight[23] = 0.08139860229396257985108057536193088271685230951096375019039633824613643145339319826460674182521286602;
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = 0.994580098039975381755943258134921196515439243907115241892613222040274966787806323038254950411999966;
      _weight[0] = 0.00009849406172470012342729183797120306729289956825438560707512493759046505877196757172281017650086300047;
      _points[1] = 0.9819080873346961325077074435259613225499801670479781693750962994666519993115924159471265473976297682;
      _weight[1] = 0.0005870930138403858080781133946229403539078885793604901154230653455535909040354642990632189297837364007;
      _points[2] = 0.962209486590731189772863397747711003487131531065813181451688745525844129958953618722182068233988584;
      _weight[2] = 0.001747720324216249475087491502293789694397139287420886663505338741268344649234561021604669851838969137;
      _points[3] = 0.9357731085313031293882544650031356312195798060607631882567272915711012342389978233465384997918124043;
      _weight[3] = 0.003813096281420520842348298710895950881889701039955631763288577889908654722745077399684986333284637478;
      _points[4] = 0.9029847330954237846160108102144816242809611079263960417211087101890827959775348038191523331937712815;
      _weight[4] = 0.00694869076994824250564297958061441939352289609681812839617731614595753371500276899856024923923484653;
      _points[5] = 0.002137754840779325097003996068484341170531133944451123784608428716465128312889554565077424114622343405;
      _weight[5] = 0.01094107579169813189091237608942257612915731472352215860492901940875784817684822085977668710227725507;
      _points[6] = 0.8643225686575712512890930964464128884912645871039346858755335774412004904375538141581885649622616211;
      _weight[6] = 0.01123893942176472911521814402227084965277093149641017025250777628933241674291632070615824939422379614;
      _points[7] = 0.8203504266385679362480414025046644799692216902498877451708436721193771528836986810945627036059209933;
      _weight[7] = 0.01667844746417703482858827412105202654768663139416267562768610651187442182435611008344612749151113714;
      _points[8] = 0.7717095332090876532772702662299137017534216024796653237460220724084526447410338907367806228629369144;
      _weight[8] = 0.02316874597448142681430272573677028827491415078621799535354766932626957753146747980664577809025445712;
      _points[9] = 0.01122946060565248953765964495295842160878607386165047422524781380016346040248689425049555083510760924;
      _weight[9] = 0.02508327722702107727564330652194328699205195700415177187291626937632732713366479790668583552899807848;
      _points[10] = 0.7191091887702756756924733312759952703610235950003264675599094080939261671384587307200102973531914237;
      _weight[10] = 0.03052084060846490888777912318780060035451395536472057323180285253178882915878800370061906778391131643;
      _points[11] = 0.0274469434643197743434582952393301677966795058332544771415907730879432148015830814776531097816784999;
      _weight[11] = 0.03834144667483376494444168127629636943855168654307775524429254616965643468194663566289872000674802254;
      _points[12] = 0.6633164283801916080438663597093166623213491788613272167696983082588163829549425343365271477378754117;
      _weight[12] = 0.03846345091061473349290245539794099303708019282297091901740137152519600363961583008523285646670019196;
      _points[13] = 0.6051448381551349081424173890238120465852778156899718864521872811406263759015006314129890759192133067;
      _weight[13] = 0.04665650137559238100136333265315206043659187299633210330041980122434126791481360689974380076448028748;
      _points[14] = 0.05055738036921262563480593409648928639639291900566926165094194152128925730424342105114094576969514026;
      _weight[14] = 0.05023107977579624293082489939776848612795440206268521504827201101988163471721421863245982233173798446;
      _points[15] = 0.5454426920332588243126070891910049145712573150611219268116870762412938483414356567846858208870956794;
      _weight[15] = 0.05470911337993017133325658954591537464613243821693582754945733906555848787274909343811964787857264477;
      _points[16] = 0.0802242209123347788711806562294006865192884691392240487497176541792428819362495039574470334376226373;
      _weight[16] = 0.06035303547197594011536946214697428562244105735504644592761780204490024094524008923007047324841406013;
      _points[17] = 0.4850805823554158825739775389860063675732738097640718535822201240883097297180151158721545179097262209;
      _weight[17] = 0.06220107820158806088435333669253889377963299096493770394973335210519773180746305069290850138698745457;
      _points[18] = 0.1160149645874870172347350473465606669489106230158662308693922678144886136045272672526553037082963898;
      _weight[18] = 0.06839537544316108834152713171531975770585381497544037444937248176128482598116938100169841603692543401;
      _points[19] = 0.4249387248171481696883001024393147385589320252409908017977547745824610905505913984042249884129209462;
      _weight[19] = 0.06870658133314383697685351362085691413583117735597939494713400804125932270303523200365795429917671417;
      _points[20] = 0.3658941229846370226364064314991338752818897598016621885592227542838233793054347295626319302125106143;
      _weight[20] = 0.07381880949267258745570611132264679808177411201634040263123836073740074140392720781241131139297762215;
      _points[21] = 0.1574077383886659652193159384891105328541375646502171946705997212341715684439550613338558276683796734;
      _weight[21] = 0.07414640177550565019867457680187590050097479701658588964064176822972214718382922048913127448484917208;
      _points[22] = 0.3088077795622951038979119439836161009663783922166299606375840033527997031278586274863047483670254866;
      _weight[22] = 0.07717401233298538239701017926660146653703606970898668982214027556915412179838143641951278835213681971;
      _points[23] = 0.2037989575831378225336879722401727700751661453631751449300676446592974173952675347684620523747703873;
      _weight[23] = 0.07750307846489530106069001626917005366648185167101180936037628557609221967072401671463450488288759469;
      _points[24] = 0.2545121408770102731752042678534638511633337808460910662787207479083865625018202584499175428930839519;
      _weight[24] = 0.07847361442854745129999858918728471494155807095267460162304348042572581006206020856357340736457611768;
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = 0.9949734758572125109018548468457757451414034454994678437134746777377314759592836642394933873290978458;
      _weight[0] = 0.0000847266482218448156947327605447326126419659617844272871156905786136235122516774210387065414626002125;
      _points[1] = 0.9832159998661838487495423597867820380401895721015838753714698965929400840517768491779043505066538759;
      _weight[1] = 0.0005055010659316268156697904469713558505999011355121561471933639284915004498018912965831367132020459454;
      _points[2] = 0.9649243392355685769676789331181850486069916808216714189009346206348469238729501303425886192745964061;
      _weight[2] = 0.001507051270060215245738339727124017471225049056873612094515045979327154650350622172691802201761831085;
      _points[3] = 0.9403473057218671707575661924897942312565963618065724508702617539552909102894060455499272532250298864;
      _weight[3] = 0.003294701834427150802711378133094103566373633324556116068118172306506898075038472954763116221312803249;
      _points[4] = 0.9098175190772664572577288936685780032938885885639025695186218563884849263622085581336329392731539935;
      _weight[4] = 0.006019673135257074110480920880712994889898064197316878936261920311358339469987576574531217903905751702;
      _points[5] = 0.8737479163770055563444293398713444395647730795686451952308337238766361425385557764556171897935901199;
      _weight[5] = 0.009767577246988349844368959326074245339906130164224783443389859320911296477027153023249454065509989329;
      _points[6] = 0.001982402312500991974764508701509203188187092356310070549948036260509797246427442856641364318118786936;
      _weight[6] = 0.01014808420232600024203421407891864326967813611225317519604953710526452069416772253977839448461609008;
      _points[7] = 0.8326263048793096592840319901487043552909483798146004051450267827213551566378150192788626666368150197;
      _weight[7] = 0.01455065777740560048945432725678785020079291621240239065081833184010255621019635602390937881818659981;
      _points[8] = 0.787008796159314796328080238209286307636016143142496025622674079035016921733834146837825179233227587;
      _weight[8] = 0.02030423177222357942405312178653612755525415648826535986135120681968192455152752689740341633477985469;
      _points[9] = 0.01041571203509252666821917702931014674935479485106816524423187191810390241276843270721704469819313156;
      _weight[9] = 0.02329114401400434107623960101019748682844868035669047120616072012257778273808340621085543544339633781;
      _points[10] = 0.7375122949172582536693195662187433097563287951254783157564549381318449761373581277895857265168695533;
      _weight[10] = 0.02688756442258594394198564943536074963802617244572964250768720667333181166040705692347132345670597557;
      _points[11] = 0.6848061597563768691573930360166283266837702181638087861103877824608012560472566171090269983928681477;
      _weight[11] = 0.03408916470242993251882218894046125122731292371714041110875776292446406522925454370012819778710050886;
      _points[12] = 0.02546814775045601344292075058542701375019841643628081237335239638580493646438840089869787286535769335;
      _weight[12] = 0.03567383035949472508322253846200779250258506124560617922629226954076677145218050153633101412079701784;
      _points[13] = 0.629603152646366832440005835186433246405811585188146038276837837280437272150104697014026598810722124;
      _weight[13] = 0.04163624742448221054690511799845617999254992276850739950519913819788930854925306643839091326449477419;
      _points[14] = 0.04693954797272390029719352115915356373546076220882119542989174060489332587033482373906263198125120149;
      _weight[14] = 0.04687405429551426087558989633323650022463453467699547900364888632785840215419132950168073015892539337;
      _points[15] = 0.5726498006750368846698153034557769759301843942142236134513678722424631571284058108657451973547353036;
      _weight[15] = 0.04920787783957516399463353490332616402964507354307016190860555769829433495204703242645409835846820773;
      _points[16] = 0.514716300858142001351707261638654109705083087690772118910357707639424905325977021819699527601195918;
      _weight[16] = 0.0564511112660067597072396547032695132870542650221711623908710568510712801252163799195090529486065156;
      _points[17] = 0.07453996747497746177748212306933832256427367540970293847144712393640101788929532457190961305371464226;
      _weight[17] = 0.05654047670425408731673641746840444106706145938580495870768149053927784423957084294480749076126356119;
      _points[18] = 0.4565861046963797540479864485503725667356963030172069689574101221860311846558745203443032208709777164;
      _weight[18] = 0.06299927337564799294914832905905277124462503427963309452997012853782168724233937070149924372893476695;
      _points[19] = 0.1078962587148670518369933864179128680363862543318018393308158240698289232868109968676399249029215776;
      _weight[19] = 0.06439218521754601961609217515415748254965335209980546776078885523102830281793937574743462706467966926;
      _points[20] = 0.3990453234002412501528182579168397671593845939181776667219899610514800606114315767563476820928747503;
      _weight[20] = 0.06849140575169568012668800722262161522613334377457403128300937582927520679256050458344419628226694089;
      _points[21] = 0.1465573689781110622454405645211420385843833471460570019307330150135958433471094540487915029769819494;
      _weight[21] = 0.07022960671117586974426525058832575750953055446936506488322864597988955028307342935889618929244731548;
      _points[22] = 0.3428720970842849252151378642974238623794694294290994447908012269211766838901167147393952220069469325;
      _weight[22] = 0.0725918327712018624120357190515451543007959976782386099644323142584005972169684717387584764973049203;
      _points[23] = 0.1900004870599828336341439787909794085126181077453390929451879495109536533280805490705145871629269747;
      _weight[23] = 0.07394209946166916222101129200752939221868094362783113220849632853398411916937608256518092603124973877;
      _points[24] = 0.2888260716927312263060031147583258288008503288275055379968170057607358670390531602234574905707601279;
      _weight[24] = 0.07500879353237672763699801406961978229108936240432004642829627625630132640321505130936349085986904773;
      _points[25] = 0.2376381259328170562198557150947490838125062796023926838503683108907578655346968932790673406258904327;
      _weight[25] = 0.07551112719749781844218082919566389510580336585132778769206085830750979488397455548961364118188574334;
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = 0.9953255513271093328270351894495473119057794466212460828361309213612753533892573799919314231415102235;
      _weight[0] = 0.00007328186742973457248973346335268348308990106749721830402804514884874852544364092321383075279342271722;
      _points[1] = 0.9843872802327865221402703305050865376477358992329912305682706127051502754664076249624229033974971323;
      _weight[1] = 0.0004375835695954694319402968526394878093805906978934431788809678901563370832892874754776959120609792781;
      _points[2] = 0.967357856993813442888042181474701065240585349524088001841956352807017098269912180578703569993125112;
      _weight[2] = 0.001306291162482041307513273595746611017270220411081977254624897447679861162403842854671409547310733369;
      _points[3] = 0.9444527826987507331425260090411746078705975423460296253295198573755605731026031630850456677387944581;
      _weight[3] = 0.002860989938171968740611001933779543816374542989923606744174802748622344893560754537563466895557173069;
      _points[4] = 0.9159603411903557702727824364325821830316077077386156250540469597358886472259235994667255020111350392;
      _weight[4] = 0.005239419741905222510689162974228147278566274534968597513495834319549298869840982032689155040662882629;
      _points[5] = 0.8822389102341396454689826313057027389226267678942236210056160455752391145785184091546650419162996677;
      _weight[5] = 0.008525852555960638572219657461707102521891573539394917046403114188820346919404426896027012171696186572;
      _points[6] = 0.001843386661593831967726735667295828873915982082832672961302707423046245066116804281541879869808804072;
      _weight[6] = 0.009438203890880110866596413809031958726344004381082942643778752283009119164009190109057284600952362998;
      _points[7] = 0.8437125821466905369938778855425381743397595579708781792466494145717162173438121723567149172814722983;
      _weight[7] = 0.0127443068031079317715688761451132541542067222744958632051824594229015519066742950552553740091615511;
      _points[8] = 0.8008658592874873234732464957552331150349938591747462274480585030882443351844636275401613601250526774;
      _weight[8] = 0.01785496844943601640277750879058008805396662109216816766106464135700233982039264716056288080389367592;
      _points[9] = 0.009687231019540805273828081504282131116359659467549445267187225423223113523010002437844497609237991749;
      _weight[9] = 0.02168341697171634922387206163071664777223232067278973251502576675723184728219216643152310340730796864;
      _points[10] = 0.7542375697640191565673740509855886563757234218511268984625872592197338373290508090761113687668744005;
      _weight[10] = 0.02375402799044424959072051962268325181356197297482915729116896189554605021009758096115809530581689383;
      _points[11] = 0.7044140944718857265433052486560377972151930169197974524635302295609988027848098312397552342521119597;
      _weight[11] = 0.03027696861193742610784335894757796436342078243942527942081998530055037186894711078030414144043462203;
      _points[12] = 0.02369534823915010708382497244256481068013762237691314340450484701623746518298477536252903465995659874;
      _weight[12] = 0.03327121392996553082051253960656141674676698664874091138577924743699340286248666375068308662950781324;
      _points[13] = 0.6520219943065595128144520218202029835324140443758028088226666444218422243992797923412452670120753289;
      _weight[13] = 0.03720516474612843252115408793185275353855779065005451754273434428797531460701296701493334494925037368;
      _points[14] = 0.04369473580455800013769324464294019749014271105473332584282951242378903272580157799981535573499100973;
      _weight[14] = 0.04383223890274716207783270394301581492732858579499438231354191010417070821260416813703099811250239746;
      _points[15] = 0.5977201313878155000196942168596513335913650222028782052701089676472197217513431621531390052097054438;
      _weight[15] = 0.0442754809043745166049102553444756242629834754947539739688308925406328335470728344353699778944724549;
      _points[16] = 0.5421913837761862949497505196736063188110717433003851565440307389535776130912578939384032088911835582;
      _weight[16] = 0.05119240661403538109314247413068615838127744479416697841527953461192940260522878214085058664786929483;
      _points[17] = 0.0694342787989322199730161870599743899193417310335786837684089594535236674250451492247500562398937346;
      _weight[17] = 0.05305637157700611567035240177857449090592886836998970530450787053641364840432593332954674885802999604;
      _points[18] = 0.486134058031581842105811479741619256441348442651950033915572669570835846369697411190512406608564496;
      _weight[18] = 0.05764213229207180802657160281800379487874937184851651202260951686951263830209716610394437458473375141;
      _points[19] = 0.1005903811326853915190140549903467621805094580706385252308216095694597532629310010567882974571874852;
      _weight[19] = 0.06069078747570479786231324288739386744739844478687997246810594496612261624138048834339131455140341535;
      _points[20] = 0.4302531076729567979697915582545114448017590910700067673138678746580049425247712359442692580026425598;
      _weight[20] = 0.06330786957011047808854565517611624075329395117374875437813393453496000829664673633228191742678929595;
      _points[21] = 0.136771268210552437602568374864889972745034266593335441275391608114954920387727316437892629650041949;
      _weight[21] = 0.06654908535523464685397561098642480640115961409995553567285259367625967934405564418116203664782725719;
      _points[22] = 0.3752512679997629534933730456435740542694401655843067372579497841123207581560234471930509217275150035;
      _weight[22] = 0.06788565307649292039687283320238157402058107784817118583358955398507924022035164383119891786003106666;
      _points[23] = 0.1775219573659193028130614393988634183199427689032530418019253526001223410476168743574185750257449093;
      _weight[23] = 0.07051803275142590627456213690666551450110300183953213724808652522368240015081698904312404196825072647;
      _points[24] = 0.3218202187671672377769064975778236252489272904134530562088575656239167866863330675121375687111015968;
      _weight[24] = 0.07109983236886887427029839467974307139978913310686388388211605126488499602691446213807129528454306465;
      _points[25] = 0.2223299911830712808191360033542121533705911233623428600494451493718258335612207931646668848912206942;
      _weight[25] = 0.07256094481011321558801623950042687835571243590410499523542589298533471692607778934127785986264937661;
      _points[26] = 0.2706318858403828388174545619009036764776417627277516962633080821607300256186263524972127095298013223;
      _weight[26] = 0.07271747407265305475209795588052125266906429056397565154975795821613017654667180666213671766173563337;
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = 0.9956419077642228317186491333620060237601315295415473070854638905269220407116028222638890083449209743;
      _weight[0] = 0.00006370515996210101725745472702265633711758913990764554459024871592454748893659112280483407229406835385;
      _points[1] = 0.9854402875829232562843797204417416195238244745167805643345209779564325262374245842623134551401451341;
      _weight[1] = 0.0003806839593599654687052937172487546861406951983143054441628893654176073429097708717496854771009674265;
      _points[2] = 0.9695474769380218769795841255378286564895236407683444524251818691481329207472659134792764782657673718;
      _weight[2] = 0.0011377791456507986924889327557193353897988937145668760114411400073408539511318751097684318098934036;
      _points[3] = 0.9481510589669756248379883268157639950428963847697689099425419930439997189239613345109477892587155246;
      _weight[3] = 0.002495982237871979415829687616319526354929321484971594260093162240535500992872031481890968421521032581;
      _points[4] = 0.9215021099473594085155151704718151363517054432469130506984103322769692925488804599027244231343314117;
      _weight[4] = 0.004580509469313366317241966253684956837737283433524900914903528095852603465920170011166099239052318532;
      _points[5] = 0.8899131284723934956831712532221734523372783412412214239234061344184586027297876948955008948655299972;
      _weight[5] = 0.007472731568327629262425404229139219420008809551561161327362666088823157856139752051538235243301389832;
      _points[6] = 0.001718495293402246663028020771266791644996181934602356641243498668963609900790262554124227544054489556;
      _weight[6] = 0.008800223579860048483254710294217191577207739024953436339979561240637942739941017301399737983542058875;
      _points[7] = 0.8537544904322088788247775513811542988294457872776482108393252112089107868125245581262654586120792931;
      _weight[7] = 0.01120427189543885884005076223431923448359865792254287286501113213756952844083798362642400838278667982;
      _points[8] = 0.8134501334282394697267215578375188617234481770369277012202582476084865180325716182203592738059608096;
      _weight[8] = 0.01575357142381088974813226281442771906887412741280410221144539737971025231278995461878959887619881906;
      _points[9] = 0.009032518495310017290182668008309766335460710175829955817301796886950012957313421273553999923511387801;
      _weight[9] = 0.02023576838137988786034698670252521582177125525959502980263720470161220865339795485231134855413136611;
      _points[10] = 0.7694725945042181706805050432690356903413932244153720708644567415131536687406382160956998961745973101;
      _weight[10] = 0.02104510391067328185606724574426733926381029950552618742473734044634105412953922386528522423178877086;
      _points[11] = 0.7223374729826939086395173882436445520337460324133837205062443405405843577730351703929806948350872225;
      _weight[11] = 0.02695129894362714574317820278902739133656214753061143720194269756412480787235284583042023250023369184;
      _points[12] = 0.02210098135778681137268521021888062944151160946598760331796165999691174140377074554738617759820391624;
      _weight[12] = 0.03110015822865166067702923886015083025462579664580579398440848573178798449726498246324159018595777494;
      _points[13] = 0.6725973867373374963190421178579525574571588976574083160637357387177511124421386108602402867292366295;
      _weight[13] = 0.03329710179283746617377097231688107447881161015071885848544979051240828473437080881621446821160749512;
      _points[14] = 0.6208354938051186180751604988886875212206555915139963242977997641728491315993006032194731774639848879;
      _weight[14] = 0.0398669733284307313096721339861435149472677529777038992004750528535172531348461975711478042333117905;
      _points[15] = 0.04077361101977503091299474371167607706934898162520204845715575724018978323744190358853092513413754222;
      _weight[15] = 0.04106881180888533341596419244898047338318591795943706620487407038350580428826353390074697779662723614;
      _points[16] = 0.567658655663528963950549089025851521052663287662634927318125089113081431332606079713178298077963132;
      _weight[16] = 0.04641401659297863618279998467239187373005512892102633459543014117149358423998773507108652281038679931;
      _points[17] = 0.06483185036310752409761920639076661009926122221841610874216905587622670223518452033164935524580956556;
      _weight[17] = 0.04986722172799528536062300428357175719538303706187497370739264376729336818031041386760448700580612527;
      _points[18] = 0.5136903224747328748359169275644776550261521565143655052175059751887984135439312756239786212853367327;
      _weight[18] = 0.05267081444046336301346320191574594298873507545356939242387535251298683116224294172328249432628441329;
      _points[19] = 0.09399372568531336584140604037988657514003928824741309138398524913091673982081934491751314695582119002;
      _weight[19] = 0.05726781728496770116342685381854171257294862281728752208595617722281137028532049290933995766813740385;
      _points[20] = 0.4595632237739050247007580803181932916401376476628329857646448103515031096132724631061051072771519328;
      _weight[20] = 0.05836147977632291693862247694575220416360419006726144133894084241127940580809791871084881643492680216;
      _points[21] = 0.1279173699497222880332522902374298487321410081872785108652567404644903241925006868210433634637075585;
      _weight[21] = 0.06309759998920903832871619063187736427798328292865043490361484313506251495597716084182017491112556288;
      _points[22] = 0.4059119503245874996847819872096119528855570149194244408537244840158077666547928989884755351269759843;
      _weight[22] = 0.06321436026746541740578527862238867356580627473567945958614016390860714467272442769773655632274855485;
      _points[23] = 0.3533655141226461443509711091964390610724843762952359906320931037906887192044490676408869047345885822;
      _weight[23] = 0.06697480576198529947544249860329464644901197190434949442692233737598107738389930962131631795027128428;
      _points[24] = 0.1662050715215077754955928759549225525500957899853919033389963748850263839788521736378389887243452743;
      _weight[24] = 0.06724408184431729629610348227194436576417121590563488018244433962007116416697608344776265973965821892;
      _points[25] = 0.302539973775495358074098333008187919125959354053583216851150863022968872658500709858348412122672375;
      _weight[25] = 0.0694174006753446002943627136391517107293962502719934382621097138969527028293570715409689190762229163;
      _points[26] = 0.2084079478245644898876042894881013130324364643445421872994684928640539779603323923616045542186026246;
      _weight[26] = 0.06965864122232914783245525515766061197702074092320849650604718467156459693423628053637574476087616474;
      _points[27] = 0.2540312117051822502779332060989567717949333472202278170522577722830524357606964327183922476911471108;
      _weight[27] = 0.07035708558254015342678361194760470294443631209691896475761189284078684747935547051565534476561309205;
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = 0.9959272163607104691288374259807873291852593765446743146044815163863520054377631604148207633157846463;
      _weight[0] = 0.00005564241358714027532095053065803486490740943017680132607960936195006065033342071382225621345431696057;
      _points[1] = 0.9863904025392899117534861248015055941531051693629358191149649118720756782810516399238781644834428962;
      _weight[1] = 0.0003327279866112555094128006597084461188640953367772790824749440720953263498256535625988508076668608904;
      _points[2] = 0.9715246308559920866035488013575234119830975119551380701750238183981258606107602886980920135470270639;
      _weight[2] = 0.0009955114404107457036282987011420741036488422258616618973463593330141214449773470206395792824078634067;
      _points[3] = 0.9514939456164770559729801920265220261323300561844336714391207835992703432662113799732175447073914194;
      _weight[3] = 0.002187090029371519934764961921673762746149951990276364790288993358680005697151259428847928785250727178;
      _points[4] = 0.9265180152719407691275609266113728355764496137049103876779217996365555765482396657211416405901523585;
      _weight[4] = 0.004021182485231803386534230962943425794757388828963288314425169192269667107680391493129668817354327049;
      _points[5] = 0.8968705411002962316766114182292236819780119355812354874912319856093777036147736123027412055456563799;
      _weight[5] = 0.006575340169921764095135252527351854065836319905993192237496403188926387421135809555119496073796546306;
      _points[6] = 0.001605877852540094476677460267393333375715283616860331804506374382205905858795931071993942459642501275;
      _weight[6] = 0.008224759073026150013337165044732122149231177684820350074016830574690805752082382549994400699945455583;
      _points[7] = 0.86287636938624473396555917869022505651157506413871461457383706913436171402038290528480498534189686;
      _weight[7] = 0.009885829532976952297502565856123033463512360899385135623303387224673325024682566847647387741612482973;
      _points[8] = 0.8249079573005494156007944812292208906787416791393452824336661869940549234669086353363655173900752772;
      _weight[8] = 0.01394442666818688026059107376377405494209665104256295061957681177283639436450565135033828582964307838;
      _points[9] = 0.7833812996605872372611127878355374096893314804833155528966749287801062427902846865455568229607412141;
      _weight[9] = 0.01869728163635560116792048307870749321429571415331115426277003745924714046260312547581256186227275358;
      _points[10] = 0.008441948804031172691750305154270751359254642677660426647805634104208696641578312638825578741506269733;
      _weight[10] = 0.01892773329343349779572660522959708923603067512949384638213060568878587305185604042369878972842506566;
      _points[11] = 0.7387513739119412937894744959680884811212751986011720468957062635753622921833823658529018354675299005;
      _weight[11] = 0.02404591853972230935791201088077912861061979588079558439714543772093319758864057087945139003336009097;
      _points[12] = 0.02066193363615915476014353455675614888152234322370671862925378861418209355011390825531581969983189155;
      _weight[12] = 0.02913224977147369630435371509591788516497127738021211468364733144940634553044053378111820566832924059;
      _points[13] = 0.6915071564230854286671345510916194350973455194579840038960101517935299316600829866562060441590159543;
      _weight[13] = 0.02985034246189268703045850444863408825831084746850206015839821802101854257623979915267724844383865647;
      _points[14] = 0.6421662656731861238287974627913649707773183543080836828973314488493767488926898483696649824941938186;
      _weight[14] = 0.03593413059728592678232574595449670370924216522382692396538501302643477845479560527760392817593825342;
      _points[15] = 0.0381346969971121293156671304127122061908427724432955368922775580973517627701451337438444969457350822;
      _weight[15] = 0.03855192568110300992731787948569749686052539437629187659190769761585088614005755908990193666493402233;
      _points[16] = 0.5912692913707834829478765566234395995724095853348927353348565847908533092030035780849500293024165982;
      _weight[16] = 0.04209129631860883510580700101232906094913172520881469088463222892379855573154919991407642591976469689;
      _points[17] = 0.06066914207658226981904661707387973061339655888382338512792452002820457736488673316674820829450741823;
      _weight[17] = 0.04694309426636408371953486849927191064071717332656199572683966811401250472932076965764591751878827569;
      _points[18] = 0.5393738717727236992403103247034391839852566119036684134142180869297304990124736025268732863129619822;
      _weight[18] = 0.04809463546398829869371533562782688895220513580178416037071732542065284736437622845049166880340602575;
      _points[19] = 0.4870485841530376732703106931946815813887093165769280917756070969164567729544177022621628404883829681;
      _weight[19] = 0.05370519726261224517441839350484898995722099633288349579493820971087947368967875312163865815120067472;
      _points[20] = 0.08801845813988722465113256457750709714087466744915465606791769806360585010539787194938103623801238897;
      _weight[20] = 0.05410079186859844844367088474395607795687457881564928149255949744070610415755416273667872356483112521;
      _points[21] = 0.4348667153860257491398700432703089870432644535249158432053836873358514943003487504468549993874690005;
      _weight[21] = 0.05868247100441087283841989450493688012026853494073014267958587339102668812083850425895915857506469626;
      _points[22] = 0.1198830276848970432901164194721133615437473706091056747138979253876140849072260495061209040067929833;
      _weight[22] = 0.05986514983088954149802257556131410370145028546473926100037200780395276628373010490620581743371751677;
      _points[23] = 0.3833999809061070668784747580919607726984317643808177613142919854072677369249366817102831666846690371;
      _weight[23] = 0.06279484606213871827922785530254060818304508070323358845405923153953552222330567398669030144966779909;
      _points[24] = 0.1559137470843829473370606131417264220555557747384501978986829188400691312404561996585751299552473492;
      _weight[24] = 0.06412659178073493294015772905883242677694949119956667273898712010326479351329538109259913677016902762;
      _points[25] = 0.3332122608640143309721523536351177737981679593513508685203846408997852637001956485169227428186550926;
      _weight[25] = 0.0658298886821547883177566702200576302814581710102619073023532507225593633367576164581285422538752774;
      _points[26] = 0.1957158615701235346271845355727618654403065491060100053893129052945034633900434287495630167925552728;
      _weight[26] = 0.06682903797752355680708798131643143756002374157820628443355072911779172499539671165753842492171865239;
      _points[27] = 0.2848534221035185149516172379240780825714158061355885118736472933422323566101288260175500745175553813;
      _weight[27] = 0.06760398471965420388414470001461319453931749237342308586790232501846019357132809543458076331263868046;
      _points[28] = 0.2388532936333663745936940565623196065759316483784380767855858606661415400153543649197279531138628582;
      _weight[28] = 0.06797092298173053445579386649110409707833752628689484884710968363254660466586108170267586036152601854;
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = 0.9961854092532896146028221753356389314404324408686493792874214932610240703762534389970414536663528984;
      _weight[0] = 0.00004881538648506998360388173728839473046687594331829239051542362498444876128405787257610641121435982496;
      _points[1] = 0.987250587966732915704867341539757607126329624210631340190097603536590860456898711558078237762728568;
      _weight[1] = 0.0002920824818819113533365390766918036968638135004181526130531057784590465269274888973274707688805240154;
      _points[2] = 0.9733158613935448794453820105491724343356720246202466373654937709136522090881131218997332838292498842;
      _weight[2] = 0.0008747452449452054528434345545792328394990878028984125283749635749400441660481138993949777526144453479;
      _points[3] = 0.954525315743250196891212405909841651664193121330522964818769451712885974883692851607198562628294405;
      _weight[3] = 0.00192432146563680853039780262267058084934464281296702761384700340884737221497115728721168215653477519;
      _points[4] = 0.9310719621711364212548285011966173256931864130262399049310424572383352311872885421014229760611693296;
      _weight[4] = 0.003544057111846242578449714083482700968747522670541078730791206739367707904169668505907464731859013099;
      _points[5] = 0.9031965197235615179874486945867351160142948387890865854781167311755796735993819800971467684400464672;
      _weight[5] = 0.005807197046687551242251792528986641465603517512649975600107358331114246119583995371657609253148391519;
      _points[6] = 0.001503977326638774096538941045439819204897050842323639110517193282528933882651248791240534017615526382;
      _weight[6] = 0.007703907526677142332781611057875534544819793506537816162172648136598926396897833220321164234763843774;
      _points[7] = 0.8711850490619494505257748373786477444812674413535150966051762168128661783132891618825618402191055982;
      _weight[7] = 0.008752554092761193897920666189535675116315443555815723285447313014922448847745255648780050131576355236;
      _points[8] = 0.8353660404570975782088039706260406779943814651902810216421804120682862030815465101588411782330872668;
      _weight[8] = 0.01238157096505112882609671713082506468468716145623744445894400365087184337768244738355009213416501403;
      _points[9] = 0.7961070500327450999963466408130769909254065823786988072990704501299103077656532538035315934328438486;
      _weight[9] = 0.01665700904270025006653225825818748132054069181447553844487836536226341303293367295386176749150289439;
      _points[10] = 0.007907415319962090553874910548706797889640929395624179523081760110455578957554042677725283477454649201;
      _weight[10] = 0.01774200002910266224241589398107510122653617419432137008802265042177278051968609016670453221518424845;
      _points[11] = 0.7538109306754931985292676380937912950273016582300685379467850951928081223373494944028470408186327805;
      _weight[11] = 0.02150333048441228769833753851508196766124541500331822808509520438345824079506333418293329410470080059;
      _points[12] = 0.7089116992693157344021296505007320277178336913754735555904081981587657489227382458808600070143245976;
      _weight[12] = 0.02680876976084624127714802836523064146869361267096646765712817819486360367453807577343673561893162335;
      _points[13] = 0.01935870848902583784855403050288221797598668568969896998662158485432325673456693050224134370338878558;
      _weight[13] = 0.02734323769023239623194332571355552815906192296906783687662345184113901926590361524395191648538035178;
      _points[14] = 0.6618700835772073917491354419849632203892530088735732812563719385176190205613534846026225511037711621;
      _weight[14] = 0.03242902027054050043405269502953432501755780381155927730280438058383449132894536615575943817616581525;
      _points[15] = 0.03574292537490614361442355505910787775634862347975856384163644336736875759787627385072751815153740946;
      _weight[15] = 0.03625397463788723790524483974173847020917492065787212600840108277078063463761026436450175975946083963;
      _points[16] = 0.6131687947901146656740818993889533163504756553625524311289854346046812852781127326882590856590079547;
      _weight[16] = 0.03819239423170725851575184801695770825061515968304590598855971096584248504449023211886317255778801667;
      _points[17] = 0.5633075743824562981501263532733843048016241869169987473593829812419401409863189611028075333329458588;
      _weight[17] = 0.04390625227933978568080902602950186417843079234280225955367345367601986305141065089129071180428246366;
      _points[18] = 0.05689225853525516679821004110599804301611377083656079546200661056446482284527669656096891945940680971;
      _weight[18] = 0.04425731927748618287257948334671876202437120287511051701022472597796561585699259418942874447794983731;
      _points[19] = 0.5127980661561916817746887451598282918401125275994180446481874937657033611674660693401318099368063618;
      _weight[19] = 0.04936444568948249182271354202432237836841853506199668047436650095508669478549848818479903009284566956;
      _points[20] = 0.08258976331894715037611720235316913189397065646611817204648742992390166397107742163078245234741296826;
      _weight[20] = 0.05116849259793773961536020333387403840090728696787416722400025316316297583997339266789880587685716188;
      _points[21] = 0.4621585661189246886540277907231243106393062489018270745431532167413125006992428964361637064261870771;
      _weight[21] = 0.05435547110670841272312359308648180196145265254699122138675635302555438086361230585239049569790033029;
      _points[22] = 0.112571774110936611053694579518741087338027646767961081329743508651370777248795257348659213291718789;
      _weight[22] = 0.0568401843945930875022309199510318410662194983414264632830750229803768435128288250456115058327183983;
      _points[23] = 0.4119087040813242226237090428292506153631763321335100527625422039405211351297361868627226093733969804;
      _weight[23] = 0.05867100684562144938879531538437321203226400947228654914597314289823584855733418457124886247351885538;
      _points[24] = 0.1465306454397049070797253669507133675863970812842654082165416081846888928125469797956253712673911181;
      _weight[24] = 0.06116708587574294585708384600511210723249655869946088776193334346188726348364913454224787676895355881;
      _points[25] = 0.3625641115525919243603237735395555249376544784701360196082102632275515462910475713276721125086440228;
      _weight[25] = 0.06211448255080993935299302013223286515895217681731822651599307938155060303705561438986736826779035532;
      _points[26] = 0.1841179183174382295159362040481778712255751073163280436744486781128841767238309332184203445772649971;
      _weight[26] = 0.06408887558478726966987172952929198476290145444949765876320874448844505401660613395137922016487293419;
      _points[27] = 0.3146311306484368093477133152707186848865010512147554712673141128875662531347957837834036041944222118;
      _weight[27] = 0.06450933095755145680015534470844576452895509725364825086687152102043276408899255479082363409045853491;
      _points[28] = 0.2249478990674261230239659038071794671177427343701348684130225163163224666208835088859070269965705134;
      _weight[28] = 0.06559148352964400742074101780590288922762063110608826979290732662425384779750749352007854814383952964;
      _points[29] = 0.2686016183001323810743018232453001490062411850001232918802978956024515050823666262374429233151227997;
      _weight[29] = 0.06570658184089414272443437205941363884723654449948817438625048156296749249405795825047760374282482709;
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = 0.9964198154713465863814005035441978010799044283122436703650320561453919687873406872890135672702316458;
      _weight[0] = 0.00004300369105210562692826370639121461833320652605667711416578738547360188460016161941716611831833587364;
      _points[1] = 0.9880318304951722914880530368106836749146235982824393858168425335568924461010604907917735038470862901;
      _weight[1] = 0.0002574514681284442266230751751507317607746199866536766321397160733033418132062271462470548959235436023;
      _points[2] = 0.9749437042544240163360031479159922744282696526039622177198702095339328818125350799450505594531097618;
      _weight[2] = 0.0007717057396996697641517258768670426827188915944192573597223229681262995542318343942265362056001387414;
      _points[3] = 0.9572825118149126493832813913549764982221829460675596349535989927608206332156385580989282616880613246;
      _weight[3] = 0.00169969018272393218254041765280551133219705363301035677082391746333472054338783832375495304115262724;
      _points[4] = 0.9352185227478344903005635619837840093875008866261301248284230002913241844856789158446614001940347283;
      _weight[4] = 0.003135161039546822021790675745981601732773492778297033598408165845484191268636204404626888163907635763;
      _points[5] = 0.9089642777365259832428053473898178551206481174446911746120405937208542772309144429777671577360346158;
      _weight[5] = 0.005146855981905776970511696158170320994675246401119572219172360040145011608975207596344947769210658964;
      _points[6] = 0.001411475965443800134825651358139039341956298466719277973633838444099651944102671436345461185232959835;
      _weight[6] = 0.007230975650216755624745604235452245279656002216723509408307916172060648702594299051622707208973025844;
      _points[7] = 0.8787726390975521425669806413071461215080266752415391212208380529932518479277636784487635052985135871;
      _weight[7] = 0.0077746591068403809703585541633919208182299537947198423202384641651753902336505509239560671215301708;
      _points[8] = 0.8449343774921062514064287344919565431900271420193003901458878575147974746179949038330386644409125033;
      _weight[8] = 0.0110269395456367302862777382302981553927566333560509275458448854279203254075501907732773782637812124;
      _points[9] = 0.8077753782079414862781562853347802220882808558955060482906917367586304344645833319010154104094802443;
      _weight[9] = 0.01487917669239610535935110809974107459177779203087820996598630854524461789174475235354270098848842731;
      _points[10] = 0.007422051826455695999029982273149380199843648470952244242156277596152147491323816744840604628235024314;
      _weight[10] = 0.01666384739763897032812241273494349301940479298727467776618499701123988004490992571717846310005239696;
      _points[11] = 0.7676535050807021900513946022822988218884222022947288784940173065942976001602180565188762480511487887;
      _weight[11] = 0.01927393500347561210274414657736369528739716154850885294306403397770541527835430503292412077877843752;
      _points[12] = 0.724955155054066052909185099237878881084330552561552842546850981707460790693381057457479986132086864;
      _weight[12] = 0.024122198648856929845540272680044765145707133412858515109112454837530783184804667781896838708612533;
      _points[13] = 0.01817476909526580384371084818030880219026844158254025954136291598091552233243165652620126345900753569;
      _weight[13] = 0.02571233502559233962916487514592441336832695124269937897406163393750519114984932164320084145245725209;
      _points[14] = 0.680091537418071236704477829714537714512091984669183389020551342806291946956036957137269710642400284;
      _weight[14] = 0.02930602312747382029070259723856409204900613580780841178372978455996881359391922812877220700604353425;
      _points[15] = 0.03356848869388057760203511836733933006131679408286549627645855414122872018381444995169640476649594173;
      _weight[15] = 0.0341509712866015141155229335940271146524226007444312712197754887548547987319766790888766616421082058;
      _points[16] = 0.6334947138634949003275653909484439122889862153213787389931455390854347121392448677482017219298371185;
      _weight[16] = 0.03468240935401616737828159765451323084923611155594248045105379003407352239380156383657820936225743249;
      _points[17] = 0.5856134376099925987278912540897165142616026682924333001806921183223956634540653543769719960785603365;
      _weight[17] = 0.04008825767952754596264770738045083066907786976512135760856103031172796742597777430196433932228157271;
      _points[18] = 0.05345525785126260801052035243425137799376937217185000461579500643018915955451401268677204289733892771;
      _weight[18] = 0.04178617160801825992915658801875977837905592813985782271826046732639763824111240551941946659502975067;
      _points[19] = 0.5369088317321095914497342490074296657907384825367613041415625936691425061246625821704741521455568662;
      _weight[19] = 0.04534621667933985881749779656727066820681662775058860556728564399850914215218638600268285241138664089;
      _points[20] = 0.07764362749241415095123711981229508670423849074450172141610710630224628092431498413286873936044139503;
      _weight[20] = 0.04845115329628569641400235641488049317751856187046068419552911791551587187988711064185529431040869095;
      _points[21] = 0.4878499483276243221234259221844367644251247402658100645076118919224730288083968168335729128892347285;
      _weight[21] = 0.05027120597876520794900410958133807051720717588961402097129758603339362629583444196959462479095184526;
      _points[22] = 0.1059006743507898902323150186915157844736889361974601035488644790649877832087183842561556969859190848;
      _weight[22] = 0.05401042910942297169606643634238107289080557340412569681213873962182967211009544484175484319162796908;
      _points[23] = 0.4389092513075168270421572355375920326554093292760278491838960877415263051727169311927625190648144359;
      _weight[23] = 0.05467736526761173539523204053682411291515305478198601616271701663699064504367567004571196515961782481;
      _points[24] = 0.1379542774855552447128780719326255863550668361596339433657214819259907437335908860511917486878175547;
      _weight[24] = 0.05836375229138350624160086990362615338239160080471286336192335984386192265975526908968401649778295166;
      _points[25] = 0.3905580663160595481669443532255889640119739535291665391197508692095761083793683382818158071394605711;
      _weight[25] = 0.05838516403304980397938236524245392855998127762199298477601893806562625801132740459692252467239128363;
      _points[26] = 0.3432620416022793630998090225239495403051757556793224800045295652949384229369749325747176898568972359;
      _weight[26] = 0.06122839910606623016083516397607929712359889718041574971984734730807128531033074166688103903283101319;
      _points[27] = 0.1734957478467754419324204886538899820795596100969803016910279626820120007603979994054583834071865742;
      _weight[27] = 0.06144885509138399963208906732313442111944660705453147856358092910024558128442404871634707719902707542;
      _points[28] = 0.2974766635554075645053147462633574325365810656072451302443779042064099713369581234883434685332375287;
      _weight[28] = 0.06306081016811023815063366225055830973064193329943389248977312015799791678018878924264416822426470029;
      _points[29] = 0.2121828040888040191351780039348599803712580510768313825900253541385619933886307214449555348905033587;
      _weight[29] = 0.06324282395146252460962228399357097064629451333929175881113071479705576514084592429465797579309071398;
      _points[30] = 0.2536428700864666432082452431813143747831005223909369486026040434260267599265945644212698451850904382;
      _weight[30] = 0.06376205679777034433887185779904126910661659948041441706014396168363015437816563331764831665085087739;
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

  // for non-fundamental types: assign numbers as strings
  template<typename ct>
  void Jacobi1QuadratureInitHelper<ct,false>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = ct("0.3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333");
      _weight[0] = ct("1.0");
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = ct("0.6449489742783178098197284074705891391965947480656670128432692567250960377457315026539859433104640235");
      _weight[0] = ct("0.3639172365120456612112619958496727004463362510746294373092948573749466456968158318588966981608533203");
      _points[1] = ct("0.1550510257216821901802715925294108608034052519343329871567307432749039622542684973460140566895359765");
      _weight[1] = ct("0.6360827634879543387887380041503272995536637489253705626907051426250533543031841681411033018391466797");
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = ct("0.7876594617608470560252418898759996233480800585109738408854524491392307168918253691359860554930833447");
      _weight[0] = ct("0.1396539598029082450677625443581538098252225758276251979994248447935389105334084604080564612661091634");
      _points[1] = ct("0.08858795951270394739554614376945619688572933192274956543116369516997648742681009672521930761610157858");
      _weight[1] = ct("0.4018638274779192615443962665291996972772826161899046690923842878330733109101018240536312300474029069");
      _points[2] = ct("0.4094668644407347108649262520688298940519048952805623079690981414050785099670788198530803511765293624");
      _weight[2] = ct("0.4584822127191724933878411891126464928974948079824701329081908673733877785564897155383123086864879298");
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = ct("0.8602401356562194478479129188751197667383780225872255049242335941839742579301655644134901549264276107");
      _weight[0] = ct("0.0623619419000161643477502941931506212697875166839309830761809569911317040022539361293684065166161988");
      _points[1] = ct("0.5835904323689168200566976686629172486934326398967716401762938418317475019618310120056322774674562994");
      _weight[1] = ct("0.2596950952164648816529124057792580292271059432720818009310478738715197515684797549856501468079414159");
      _points[2] = ct("0.05710419611451768219312119255411562123507794559875016432780829293093467820207316458611381681984273682");
      _weight[2] = ct("0.2710138268629762324165283481558817992920669850614066882947002084270279998974049555934063155149987714");
      _points[3] = ct("0.2768430136381238276800459976856251411108891696950304683494420488311213396837080367725415285640511309");
      _weight[3] = ct("0.4069291360205427215828089518717095502110395549825805276980709607103205445318613532915751311604436132");
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = ct("0.9014649142011735738765011021122473096194864304517102005637358130565651259599860618861752355046079332");
      _weight[0] = ct("0.03149582904338455237058463313697596258298062393862741207778897431029291618946468034442481885294203153");
      _points[1] = ct("0.6954642733536360945146148237211671613940015549986483590851972611325288138368238668739250465460035525");
      _weight[1] = ct("0.147817740145233340701266438683407157647088123302568081608965017046687166399586788131013562994436696");
      _points[2] = ct("0.03980985705146874234080669009333316770426265422838516194640774820496474562617430685450225908318456724");
      _weight[2] = ct("0.1935631804533033585487219432723014706300773723042959314554533779929073487933655762166538198748335154");
      _points[3] = ct("0.4379748102473861440050125200052288525167902742147401264690572735060053301210965344528972647247758255");
      _weight[3] = ct("0.2927739741693396173960757387119177719719819871066279796088146708892391099142328799058439924278608752");
      _points[4] = ct("0.1980134178736081725357921367952962360381863588337888792083291768272087117286465026597729214141553943");
      _weight[4] = ct("0.3343492761887391309833512461953976371678718933478805952489779597608734587033500754020638058499268799");
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = ct("0.9269456713197411148518739658196820110561724195422832527244670796566452024525282438143394800135873916");
      _weight[0] = ct("0.01747660362721906351203460662479774148929411516337233806318102016698451025225396235129028371682599565");
      _points[1] = ct("0.7692338620300545009168833601156454518371421433222954161669481696365481305739532856852002115427743676");
      _weight[1] = ct("0.08791033110101795101635324861086019025599267125557955276461742797557562193809890394074140334644478675");
      _points[2] = ct("0.02931642715978489197205027691316491037373039256371492778691068394493603824166577874863094836518436948");
      _weight[2] = ct("0.1446206614510173673109086522496639352868157617754660467953566358954592311021538274525319681276946567");
      _points[3] = ct("0.5586715187715501320813933418055219400743682889654078255557472261173501228974210783238200520122825819");
      _weight[3] = ct("0.1973223017813105282411690210967195758979330860171400109013608542168691368036765872249948825320820935");
      _points[4] = ct("0.1480785996684842918499768524959792122302487748085944614125946418015983860908783218063693976617475761");
      _weight[4] = ct("0.2710849944630372336813807932761008554153744603412901289757132736303442652218840953547976196174453532");
      _points[5] = ct("0.3369846902811542990970529720807757051975687500284733471225629680736913505127840608524091411736544825");
      _weight[5] = ct("0.2815851075763978562381536781418577016545899054471519224997707881147672346819326236756438426595071102");
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = ct("0.9437374394630778535343478089676888242202344852553769164275572083026057856516616966519018212670469614");
      _weight[0] = ct("0.01042872440561480817938274860756603627285202470301292757712310575208095879452089021202956789850911329");
      _points[1] = ct("0.819759308263107635012420057190818215457939379194529844677374444720182011832042478974289957052318717");
      _weight[1] = ct("0.05481671344374695088866209671645257295417296286400596170705830992550156540265177605400520195059885001");
      _points[2] = ct("0.02247938643871249810882549957084505992217390723560038985928427605875857575812188014380655937699869036");
      _weight[2] = ct("0.1119347268469821023031242268598512673581543443021245729793031713310010121026578504175518039330847103");
      _points[3] = ct("0.6473752828868303626260922298287587971919781169427252176007906613661670650910811632587999055012469012");
      _weight[3] = ct("0.1327693929309829399672959775272798268160367658936009632652402776516685774949256903432965593140492997");
      _points[4] = ct("0.4528463736694446169985514423476511453596140721008524586919906545143298698851397040631574340782308227");
      _weight[4] = ct("0.2142501313917473399818245059997114645430845154022713345106969229642921740907764451829036761934830747");
      _points[5] = ct("0.1146790531609042319096402370675146270777298245319719453889897349515683398313771981082383887487264664");
      _weight[5] = ct("0.221018516381749204842241472739215549356686584462224309432389243557215340531236858632022007842467717");
      _points[6] = ct("0.2657898227845894684767893916933899974369968814056098940206796867530550186172425454664726006420981076");
      _weight[6] = ct("0.2547817945991766538374689715499232826990128023727599305281889688182403715832304891581911828678072318");
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = ct("0.9553660447100301492668789781416922384764228669900323904483832488568928548867910582521230305572279597");
      _weight[0] = ct("0.006590382884497597709484632022178140232917756360727536905728685105949423544222450202661257721956446443");
      _points[1] = ct("0.8556337429578544285147814797717850302864781605395751604095670933496281754845563783672978210969088188");
      _weight[1] = ct("0.03568580531197241678710559440208448516980542367921554701695861934230527222794506401464323963977834126");
      _points[2] = ct("0.01777991514736345181320510103767906126648839823850043366560783167875924757578300659726427675032243899");
      _weight[2] = ct("0.08910160872311186265243123906792652143579327591629599162893070650953490775807421614093597558657522439");
      _points[3] = ct("0.7131752428555694810513137602509073414468837909454265589730704929652137959347225387189767846054023754");
      _weight[3] = ct("0.09087863900939779616611084219138819921280234422368229723283559301918617746520672846935872214646562912");
      _points[4] = ct("0.5451866848034266490322722299532130551329800560537052249374829413005927647507051249095965493813529666");
      _weight[4] = ct("0.1583991989846383202408163787197844534389880146907948116529832318421622220548405973903502249576825338");
      _points[5] = ct("0.09132360789979395600374145807454135310704047574456766876687017263479530047915987523538037892138190674");
      _weight[5] = ct("0.1822380472727472526914449235657595207038316830973420932240504518535206139038892838023314283723494268");
      _points[6] = ct("0.3719321645832723024308539604826292446681000633774806778676385412497303508594868127751294857726545931");
      _weight[6] = ct("0.2120947188718600214090621928223164323473301836600784587558404501112348205250685256991863152516914685");
      _points[7] = ct("0.2143084793956307583575412675816703226744297175224765908137326191408580982640893227912904964441607055");
      _weight[7] = ct("0.2250115989417747323435441972085622474585313183718632635826722622161065625207531342805328363235010072");
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = ct("0.9637421871167905390588356992319185479241288771581362138479503914355973155457527404910756919669630462");
      _weight[0] = ct("0.004361694171546261745098102240033931989346658172745913415730741761530425250798256232225741196300546876");
      _points[1] = ct("0.8819210212100012998077148880052647763071205854487038619129766513283089105657085985563097864503385465");
      _weight[1] = ct("0.02412000856957075810345430457380053454860935724228865674231168030985443217573930570828234243797814129");
      _points[2] = ct("0.7628230151850396146826933071467255329235111827037380779911005908346167214808478679770430364298828452");
      _weight[2] = ct("0.06360964298210800252338021387173996796508686851938261644837130415206699494945930902374759895630440021");
      _points[3] = ct("0.01441240964887654863282674081081323941174473105657808607075067912813887583460044894395069303727210119");
      _weight[3] = ct("0.0725560070465597429192991958823192775999960953346010980361779016438558511176469019496579491905235033");
      _points[4] = ct("0.6181172346952940246392297516035044802806674046397913475060393055585778777428482116865746364861237204");
      _weight[4] = ct("0.1168023905903302211314630458032802960303593103025793617178533568693960614302271220161688241514649212");
      _points[5] = ct("0.07438738970919604463591818595599858508097691328473519842679960274501992379023428096791242945498303357");
      _weight[5] = ct("0.1521485102186163251601586075079285812132106027704451841051048669451110654017776300437392883754255205");
      _points[6] = ct("0.4619704010810109348831431086805643081072330679787275209992998979929435248645151935609445375900637938");
      _weight[6] = ct("0.1687166436898406987885000399171749817104627172846977348696669835038285248020424407597603571357401275");
      _points[7] = ct("0.1761166561629952818631757460725685864113860479693058739346483371718478923148052033071589166216033504");
      _weight[7] = ct("0.1970674843446914103203460407385488509023560656011704825855076061845847487566519614460658661365497313");
      _points[8] = ct("0.3096675799276378170596204672294840488163890844971259245735924385417910631238453492458723772259274575");
      _weight[8] = ct("0.2006176183867365793083004494651735780405723247720889520792755586297718961156570728203520324197133498");
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = ct("0.9699709678385135029569356423655920593053451564625792084689040051698797214284804451045965026202723376");
      _weight[0] = ct("0.002998281204812788056496272008212784833084388876744268112203022420650156860159853329068353288083480999");
      _points[1] = ct("0.9017109877901467703487989784097679814681176760729360475326567373055975858521386207932416878958506861");
      _weight[1] = ct("0.01683863956596637483503273103740214403152870043903156313634792885260503739501482295430271106515098109");
      _points[2] = ct("0.8009789210368988451379463016172425246730022622599153383117418553952368566445573598703594633591531736");
      _weight[2] = ct("0.04554918290652606517297529885212039260089893374717979072674077076892597133564094826507860794028660136");
      _points[3] = ct("0.01191761343241559690974558695898597603002784725837485802027599304441351971793953552093495537698887493");
      _weight[3] = ct("0.06019901604807404660130951104775872423481025847493586386892954004541908963029659975623116469369904037");
      _points[4] = ct("0.6759444616766651073571505089347614715039952762295357455139412301626256578790308622295455518800017058");
      _weight[4] = ct("0.08680381281430125184491223517276793341846841416734091479841192293605468475240771493378858474227150558");
      _points[5] = ct("0.06173207187714812552262936719425014145287208036190213218470079750300542267782554988602355308971116556");
      _weight[5] = ct("0.1285743090181651457496530772577303833702586985336065153964167070111045190343947831187521473702406254");
      _points[6] = ct("0.5367387657156606328730951777118890227811982315666478711601841465166401511417696449330275943910494234");
      _weight[6] = ct("0.1321061511267007583321490050097555927283068703402401952281986304716746942938517327591629187622353407");
      _points[7] = ct("0.3946398468857868429619521050776075022149391536489841976946611563878829320916183985232456263028812026");
      _weight[7] = ct("0.1691142193816546648612911643310017367123791483004682190032143948519815060462764343108107374876334037");
      _points[8] = ct("0.1471114496430702404275994355798195021337713619059297805712867093259790600660861446700545255054338431");
      _weight[8] = ct("0.1724226005783520728566667214238285835326209744871433508891823477804675766487885763704506821303024848");
      _points[9] = ct("0.2611596760084562402660516580548457231986357161379567253035521310935009972624582003737324443405623491");
      _weight[9] = ct("0.185393787355446831689513983859421724537643612633309318840354734861116764003168534202354092520096944");
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = ct("0.9747263796024796502466688135383708980845368176554858005326201789921787651358684645855413515511531779");
      _weight[0] = ct("0.002127334586489082815067761922450647971339436325800608036378943516449777205231547251874812699984002648");
      _points[1] = ct("0.9169583865525948532931346270180274177520051095629925713521035439862432832098136415299370694612456098");
      _weight[1] = ct("0.01208784192095955158546592435315376798873973678286821945884976723777153926935372997535984241012638151");
      _points[2] = ct("0.8308248996228185740305665439056567039439893043182143500186679333872078183180614211671796544755957774");
      _weight[2] = ct("0.03332724690336138483149424914765120772804900513036485126183239293221332762553574610457746434628575068");
      _points[3] = ct("0.01001828046168040584302472986780478481479194051621623866216912370277685746144514894811474690557217854");
      _weight[3] = ct("0.05073468137628285236988931703476675133207796896933092717229277653106864390791321026906916586123809916");
      _points[4] = ct("0.7222032848909679255633213078046109071372364455125913944559779818780897684066745302575181714890353345");
      _weight[4] = ct("0.0652830934276666920359077307795285077879127343290875547799110545738322739215666227754732791506949874");
      _points[5] = ct("0.5984972797671391832277207136730435902749187521976111511339511314695356530954712310305911412553938959");
      _weight[5] = ct("0.1031827213445951603861732834892155856521211990658746337177474052730046190656697225942280520050772121");
      _points[6] = ct("0.0520354511271805525835426957729643224471859250583818355555288193433032785128089556252838329676615465");
      _weight[6] = ct("0.1098761822657429965174933633313011358561393819756883634817227365336995079659568003680704346417901073");
      _points[7] = ct("0.4681376130895840420831103807577535932852717675509161657042498476028053990410676565350775613890232895");
      _weight[7] = ct("0.139063750316366099598101779267868198861848947191484699597473899124092437083773623133953772504386519");
      _points[8] = ct("0.1246192251444430737352995872639092292474441300880058562471871920162296059349519090766521215975420844");
      _weight[8] = ct("0.1512400961143739966427541096833209231046779325373189337898872562690835045663875992951588992175330985");
      _points[9] = ct("0.3400081579146651882336052338970175277313293398208505803470934737382842096120712309333935896431331419");
      _weight[9] = ct("0.163758205976126940779173703886922409929998051411988406020634300444537236239007794642416009985288504");
      _points[10] = ct("0.2228406070438378555078314534573627644117252503274297081643638173616062308369832016150585853516004854");
      _weight[10] = ct("0.1693188457680352424384787771038208637870956062801928026832694675642471331496036035898182671775944239");
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = ct("0.9784379368341496390919069169169960383680691296676253661798930654904321350621424594217105164689234999");
      _weight[0] = ct("0.001550364441876056714491629023748274324615848140402517231572360221265942541320023063415527150625599336");
      _points[1] = ct("0.9289421012644110178488101551343152998504932414769823471037599293899243740926428914029706095801991064");
      _weight[1] = ct("0.008889615591336924645592291731656523264334512786299205998267553396394713293187392679750568752472830688");
      _points[2] = ct("0.8545525437649358807902119164056171284859595037395583869615217146999851616473022152580139867380827058");
      _weight[2] = ct("0.02487201833284453121496658611334714530755126260542143269983812777030176667500918269938718422593047246");
      _points[3] = ct("0.008539054988427419368664460877839802806090414566577746496257927301230364575762166797509842961307629987");
      _weight[3] = ct("0.04332972177374353464916694415595120758543212996143774483351792036632706037307065931531595605216654504");
      _points[4] = ct("0.7595988895252270537426025740434203419422064350885379264310222786423119973912528922496277727549814325");
      _weight[4] = ct("0.04975356081853086402501634458003176107706292549054632675888919684570712369316153894595850288044856231");
      _points[5] = ct("0.64960065027725499276629172334298057222565311827730373485571958964856442485986620008885607294565333");
      _weight[5] = ct("0.0809033074138272335212928485012913254284908033388081504474420876958459531768419460967739126481291571");
      _points[6] = ct("0.04444646315540772302546679878555276624130930378899710999139642043436028639661647795803987919635307312");
      _weight[6] = ct("0.09485570396075494026861836439417384912441834405354373442454022749260726809250625956872612646956304494");
      _points[7] = ct("0.5309508493128176706289302428968181393245082635016252048349547896722090314354827164359000778197833608");
      _weight[7] = ct("0.1132276874273352638874022103122425258241607825709588607721683748382582855487003673371838524124059047");
      _points[8] = ct("0.1068544908834766576341067704324992625897998143695000275580631125622836143405186814627639697793505886");
      _weight[8] = ct("0.1332135012533463962616689707039492301237993045862266872004033332675451141542576651800487628901600931");
      _points[9] = ct("0.4105450812014576824890343505593324118433186951909181754985565958109519682767226149737373217217664215");
      _weight[9] = ct("0.1402186799952601889918436100593420114476858105470553510722523423091126135591673604029597265238160539");
      _points[10] = ct("0.1921510545298540409910572562286133303827013670215218660373964882963368867384002033277468512639620344");
      _weight[10] = ct("0.1537932053600820125624089382247452165048916722672790101081421598961789423490551582621434158001226839");
      _points[11] = ct("0.2953808842625802216229168343760149059398907133108521080514580880514097551832904806231230987696368169");
      _weight[11] = ct("0.1553926336310620532575312621995209299875566036520209784529663159004552165437224464483364641941562454");
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = ct("0.9813896349890121485602806221597123115526801027908002379955097186555535838880620308147789489545503322");
      _weight[0] = ct("0.001156113409872385703193022385189204618455050656599975054649145246648958439626729696480355938729999156");
      _points[1] = ct("0.9385244591007310123976333867652993517339853062062887126354508873721247374248021832126814047065480957");
      _weight[1] = ct("0.006676718501547543613220841284083742579141287031654765750719644999750581810915764860757199651559573378");
      _points[2] = ct("0.873694821306689419367714567131743891173381534920334759444696161547514405472868541853111673402239862");
      _weight[2] = ct("0.0188978489591855007323601730984825277398072170071017667796222649055973489956725747846467746142906843");
      _points[3] = ct("0.007364651026089321650691498413822343611205715616446000420689416452269750033894550997416319128445293114");
      _weight[3] = ct("0.037429463171230350386748817329987677463195653326885579415509956584359065159563626022275791014111276");
      _points[4] = ct("0.7901570282734374855528633324993759322704266136136999317134349971780526905331558640579365443870029772");
      _weight[4] = ct("0.0384279143294396412917909957274853493954585050845213350300056554246318753846340556589445192487208949");
      _points[5] = ct("0.6921010017196016568970419516876697301808911008718652877381506074556730863418738419796277914411356902");
      _weight[5] = ct("0.06387357432440629768476274231692273392726396567637467815805792742291004917213504197268100373444847643");
      _points[6] = ct("0.03839813873967835037683252486414168591782983413635468761241601179824278069140258974034999134662094291");
      _weight[6] = ct("0.08264057883967859695322341390524823284515157447829234410387722644326630504728309789009709658118130558");
      _points[7] = ct("0.5844439640213404555042208478109107062952661618107888083023659837678484044838564429563713070829009516");
      _weight[7] = ct("0.09199156135210478662651956906042682442879113791215881297685885117558806298728604690294432003559148446");
      _points[8] = ct("0.09259522469900263528289137543861635588927985865429292632366593235281921073136849542406090039759718093");
      _weight[8] = ct("0.117907875913294165072323006523922488540725339188477464752066853333436329261003962309016356899786218");
      _points[9] = ct("0.472584386004117725175094642678597272871548735684737639137060650545639928993354340136687675801761997");
      _weight[9] = ct("0.1182409626281846548385803119060635216477645343671270767817530063264325986532512918418359540320018567");
      _points[10] = ct("0.3621313972822388004086812982273215588635004488227823666951627890767765685364866146107646481156613177");
      _weight[10] = ct("0.1376310589751308344356757788733870175764464444515615290689142927534206737481584776849026461687874131");
      _points[11] = ct("0.1672510113915577314955224787593571163747337087390977895834969262324481399932617359780977489832830797");
      _weight[11] = ct("0.1394269365642887965028332599008539689313215803996770757259514170749411407585930292996487794819507198");
      _points[12] = ct("0.2586235407057625165897907328226910025245301373917701116571591768242959721348720274973743055115115389");
      _weight[12] = ct("0.1456993930316364461587680676879467103064777104195675964020137583090170105818763010757692025989815253");
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = ct("0.9837752340986002382812280091410008568029060918346814026541382401229231239358663224051124039381821732");
      _weight[0] = ct("0.0008794274174943185095245122078521822019754611306820543635221058449937077708215836466191607368411296988");
      _points[1] = ct("0.9463027000602753835334059434247240449122575138455164975479188348405641933767500076215855613747667627");
      _weight[1] = ct("0.005108202635375307895958999219885338023800341194130592644971481918873169565255964058559811747742715242");
      _points[2] = ct("0.8893428088195155396908716609464895647037628629053267599145054482375380565684526275834413083786664654");
      _weight[2] = ct("0.01459296826642524288681984453495518538081081230683288195407175989264044277989459235431320050562344511");
      _points[3] = ct("0.8153897394434746419730742186120575147090134055115116514499564217599632405912766985454621567772925713");
      _weight[3] = ct("0.03006460748785728700681742950262958234619962060282172680123539669179027622963256575707868303499798465");
      _points[4] = ct("0.006416760792818456810820464094507178865719839912244884307238769932733545613705239155655121904187687092");
      _weight[4] = ct("0.03265350864519367963889885870153317340972173478361002456864218835784085024442850788249598470811557747");
      _points[5] = ct("0.7276764528892646854360267279903316966165601685246486600874809495965456531104679399309294019000621421");
      _weight[5] = ct("0.05084693081429752423013979751491821787681438824769049239677309253558218964169264456977882426851555228");
      _points[6] = ct("0.03350140453201314003596392857057248161039076925284236707232192332100661384915949406912586179668633199");
      _weight[6] = ct("0.07259215611088738637530423764370492657108112269853959863122175065021865096017202301997584723508772513");
      _points[7] = ct("0.6300366883704039578844805941314332791605030321087179470245277359365694220786253960307680873297618343");
      _weight[7] = ct("0.07488619291797165331187660365377253958575162997750359965853311053036376136149071602224720460759622726");
      _points[8] = ct("0.5267378613398730320537269448128829953760927123999441876600624391842836631760001928071840738368501546");
      _weight[8] = ct("0.09903890904640600916187235867150676110280042407247668375164802867487908835414687742741451294178579331");
      _points[9] = ct("0.08098549968195518439245130773998218722766514758665499507829939127797017196531825081787486655370778227");
      _weight[9] = ct("0.104891907003833491182163612325355902630923882710021642880128189982150297028945256249301997973770032");
      _points[10] = ct("0.4222946573075702578404089875181026958217938762273438789639540713852576268236287646690911714244228904");
      _weight[10] = ct("0.1195711180450631684452281183371739455866965354227942932369779043707771685058862101141744024798095759");
      _points[11] = ct("0.1468048676812137299236601652607991515599694654279756227180485513313137055587256285457460550167373603");
      _weight[11] = ct("0.1264260511486584068850582307158644869441896337243628225912745291094341360195650397288853205184837878");
      _points[12] = ct("0.3212717439889361744023403974130354496573046310098509725155244153528428571119004042632189220394104758");
      _weight[12] = ct("0.1327847012521708502656427173025549628480833128549141521111606655971088192656782192878509397656416219");
      _points[13] = ct("0.2280842706492579915346440986199429719415777248320505178336090146170398503780540680375636284189205411");
      _weight[13] = ct("0.1356633192083656742046946796682927954911511002736194344098397958433474422723897998813041094757195334");
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = ct("0.9857305452631742252659006330591292421044806623979681396367496904534811104340037194340828859918697385");
      _weight[0] = ct("0.0006806847682757921219050495213766638432680058407302207119346460095765860960776864024700562258866547623");
      _points[1] = ct("0.9527004099058333143380442075242620935055589938201492599119746533434704857023258451913238950513425218");
      _weight[1] = ct("0.003972469386290076082067610229152060080164258093234183168970372439783118787506178115381153751505928668");
      _points[2] = ct("0.9022867006793780266312385046620090802654876855849468717160511280017608939616471254566098257665163856");
      _weight[2] = ct("0.01143444478944235234324930059485362276155780539908978755489501360681769092103144487510479479673066532");
      _points[3] = ct("0.836430960605610123975559085654183196614405051627992133778977423021298990485129486291590400663182545");
      _weight[3] = ct("0.02380838071019515768606037392049978041111467814177297555284892510317273317213807457840075998316796784");
      _points[4] = ct("0.00564068897251170975750646657944420096608410698813114796797833513821814157573636404891569720358967909");
      _weight[4] = ct("0.02873413924342504603822660041253805338312894456953019000237612541859506016961128946212643705469219694");
      _points[5] = ct("0.7576647390313427119970742777402853179406886187590936481745381257951925531912300645820920629808513943");
      _weight[5] = ct("0.04083261854523967138238199054130899238084842965133790112559698218356527355006904832983602017392245969");
      _points[6] = ct("0.6690151950299598765386956390531395651245327979857527236420750144055549199665133052913040313820535802");
      _weight[6] = ct("0.06121953917293708160858361757949451057101860352459654126809960020356064378300880593208989800744638434");
      _points[7] = ct("0.02948229864794248663164098471800370918700961303166077760161299352098320969659464315137326588996548668");
      _weight[7] = ct("0.06423808974993183175709533215289588884744112148800311203074357885220757249757941129839863550239944708");
      _points[8] = ct("0.5738891609066858806714538552375264393339926267874317142496528265661645824810184689905478175189410147");
      _weight[8] = ct("0.08280147036884515645762630104986933848692863219976179565650568989405659185694148889272203873424612482");
      _points[9] = ct("0.07141295311515884005478390174673491912187290234227435678431701381106489005946195046185073236066259622");
      _weight[9] = ct("0.09378327988811985135869114109359384457615020825902727102745231221097976938006047088803797585845547739");
      _points[10] = ct("0.4759423084632348605725889920158496815427420479142534143461931573336140130566014455167924185629638753");
      _weight[10] = ct("0.1028247246237729370608003387427179543718483332403108120303957336121729678371306599559686414960307901");
      _points[11] = ct("0.1298310255535910559712545380942899123177230784713915452688927991403297243171614954096840860975794594");
      _weight[11] = ct("0.1147976510138825787492378322328278794932624818571617498887067215859317142102959221744686929404717464");
      _points[12] = ct("0.3789386886469780381065290091427738514254527443330112900124820663975192124536679674713512968590311795");
      _weight[12] = ct("0.118348384119425863130042337329175114508728339622021249334756378356496508819680628536993165372220157");
      _points[13] = ct("0.2024927550501040475682199883202304426029145838857816183098197713593869872838287905637745131407654636");
      _weight[13] = ct("0.1258362132971938191853306984611028086637728409087228064297723636579546705764893008808467616699069615");
      _points[14] = ct("0.2866060862575270599840260454843964124631835183282258747277172597764764143673373926548361027887495962");
      _weight[14] = ct("0.1266879103230227850387014761385934876207673172046994042169455568651290983423795896771549684315259543");
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = ct("0.9873530206260416180311559031679007912251798676684086442026613475062814838402808784348941153083800942");
      _weight[0] = ct("0.0005349873301110723536352523245214688183617068853187298053447754895460255914769305758271994969541214465");
      _points[1] = ct("0.9580244176904754545449593445542902781690561530886972767565858987751500797120765811025149504454439451");
      _weight[1] = ct("0.003134376947191639406144801392810125165152211379977657619913840594889257190569195251860266967518853567");
      _points[2] = ct("0.9131083765371412746295855467032689982673591902958463102880070958924077633184989381448279078074159235");
      _weight[2] = ct("0.009078464772277270136442222357225691316200205613577463083584857434992460933218018083501741086092773742");
      _points[3] = ct("0.8541381477752106336651136838193234409326728494243068253734695081123194081450149725457651384431831747");
      _weight[3] = ct("0.01906833576933187330993392764154659000664170074848288047274653307098419606424675728205551148860085042");
      _points[4] = ct("0.004997299663771921042651149601520690335334381543416344377970522255874964157558701037502647102439618306");
      _weight[4] = ct("0.0254786213146683694950996917591554882950068833129658279912640220737138513709595935845618250570916986");
      _points[5] = ct("0.7831225539648680838521817825620535305797128397296362805179828091518110236513200121261822163769397743");
      _weight[5] = ct("0.03307916871127158700245048416620955670443497800101336034230747234827543543117463085957742175622968897");
      _points[6] = ct("0.7024801379250410444548069755376171424391608550242998874533600580057788358037540611975107319064165735");
      _weight[6] = ct("0.05031846621294008117130791499383570158153393032155337021668257703869079487755627644770701989152686714");
      _points[7] = ct("0.02614351368139405197854932338054296839544549585254593258969286943447829808354691926416178281901416681");
      _weight[7] = ct("0.05722490518028629871511613797483697079230632259783211879752488731784247248602820192649149147829524039");
      _points[8] = ct("0.6149571518764895174896408338190829300761737909570376040266234164320457869812106383069644402943986533");
      _weight[8] = ct("0.06929563315857159820616975574746178675946381337997363992181349355292028244090523248488698582693559141");
      _points[9] = ct("0.06343094558383674549252822277070085989944232720053606329921286336606196501991941696906214544072557158");
      _weight[9] = ct("0.08425886231485656951503148108375679459878568927192553127356020255912965879211860283525552208869890524");
      _points[10] = ct("0.5235341160251683205174701650756566635860722410235498499954471423511414451699874777100902273256248828");
      _weight[10] = ct("0.08799476437848784634696283460898074168566203452803298141048012151277732409770913018617800056991931691");
      _points[11] = ct("0.4313243435956253750835922695827402886099831559358862798400496976431495143682652974446555198615522437");
      _weight[11] = ct("0.1041282756876131675099467043785466919999001988893057566387403573176304031195728572957688903687759438");
      _points[12] = ct("0.1155984375798159401789236282473972563726614701242300531764409420939787630288591298296722238684111472");
      _weight[12] = ct("0.1044571888079182947270193577860579511982476687312989947927842773279309587346572216043331398329162766");
      _points[13] = ct("0.3414679275478230686258992979386936719113738330035523847360437885913802004557323404561019734950136269");
      _weight[13] = ct("0.1154377592185356472353639909359373445130799205578497513133111318249085177414985560302496131357962334");
      _points[14] = ct("0.1808705596578836662475733912556982106123115303246260325696821028817277573264066422281984062600090246");
      _weight[14] = ct("0.1165084804197116707586035588447860117666087389169987223931858385521171238120053660291409688664210766");
      _points[15] = ct("0.2570248078451708599229442395592698543456357763791818065543456950821702866951437507776531490026073371");
      _weight[15] = ct("0.1200017097762270141107718840043310847986139968638932139267556119836512373163034295226044021116885655");
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = ct("0.9887140406322437514171214022529600950271304358332938882155721604826076932154206388238562326534443377");
      _weight[0] = ct("0.0004262325784138671616503014825668479867743121463983310760858304095888980890581472393557710822246507172");
      _points[1] = ct("0.9625011978233500412504607753885055612059058670805919300838487295359170197761774966465922450143861371");
      _weight[1] = ct("0.002505366878782441497821305040213450564573948855367154150978343268848357634079495184968727608399159802");
      _points[2] = ct("0.9222430345922984084871073282303817691602583776161059845144196175091317355129889510768256352598660848");
      _weight[2] = ct("0.007294460966842812890068913047567504341965175593956839929686155659396138028717360227340619459117792835");
      _points[3] = ct("0.869166059567413619204446498011157536480619533973801747094055147008674628966944082007489138202985139");
      _weight[3] = ct("0.01543284442961187739177684553210850040977377913889605049895702539591618751800244624737646088996791658");
      _points[4] = ct("0.004457993567787391754506229111546399964633760100259970537810725491458494250043598437019664865493643768");
      _weight[4] = ct("0.02274540622639378829776020880683720609452057522373976015749508324031731694387040746972125365570310004");
      _points[5] = ct("0.8048835785249664919991777013970255022373475851134620892027287774778381435285669046560052364431526214");
      _weight[5] = ct("0.02702739490460156181927791662098239956927108947038280148990998102655235785834616122857118941751450445");
      _points[6] = ct("0.731348952734051382133021495562975876964288241933596559645743754150107521905228731408698776571450455");
      _weight[6] = ct("0.0416065560205907241200257327515462961439659897769936343927590006521666545011746825379533316882700652");
      _points[7] = ct("0.02334009412377427396702152820768312299586060057599419863449974659248238243339757550585495829405487255");
      _weight[7] = ct("0.05128485584041035837150041049462227236569515810109611130226859683533715551484088425680168656439029542");
      _points[8] = ct("0.6507965584533822647314874073231465774368335045672017460161248195939594014514835415159009295305527969");
      _weight[8] = ct("0.05814904817541010112637471093584722632635723649505078175048544545500447542788986279551396785911403471");
      _points[9] = ct("0.5656739668866343319033069760096456365875201180074841733261734685045356633266844286988014211643520509");
      _weight[9] = ct("0.07518465097422447606286399704863748886393605930789172672958010315085190595784826875016684063030466313");
      _points[10] = ct("0.0567079687690782395327133315565206422583954294330082911813093706572985010525054793316865221556378879");
      _weight[10] = ct("0.07605145765148480040294983401333088847853799893124803854611256634704675720143211718355596447759322621");
      _points[11] = ct("0.478567596853079588783710462859367863464895919649049929129470687367069564027548762072173649770694993");
      _weight[11] = ct("0.09095558079828455499487784832842234327421076718008184235832962158876271346851796676218008225388408436");
      _points[12] = ct("0.1035554329351970634134912269613124043655029097199118685108784305899757515572621444529640256077589927");
      _weight[12] = ct("0.09528373874923688384115041853141755745633038829194399052580502788189156712111849867133924841409385054");
      _points[13] = ct("0.3921241347220956580336194633319030935711764025114615789973484145740342676368815150194126405593319517");
      _weight[13] = ct("0.1036194838585926665104294095256400693128383841028677293915780879742991691522033818310328703299843335");
      _points[14] = ct("0.1624600034281365499816295439141031838558059790103253735306759523919908694781359490868358657162134059");
      _weight[14] = ct("0.1078158633350549603832320404930530506583776814863800678782279266510495293543282695089808637986145332");
      _points[15] = ct("0.3089701177521959033175242612862631293729470242289113159247135612658365232010381202115837653514093201");
      _weight[15] = ct("0.1114698358471210991542580389815065276072464356895427892969110466585885649118705952943517744483555478");
      _points[16] = ct("0.2316321257771721829467972257383587479080211677883964983117694939499389815368349381911564356963581668");
      _weight[16] = ct("0.1131472227649430259739820683657003705456250202081623505248301578043822513167014548107893476058445038");
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = ct("0.9898668482025971344167630227759617852272654029332944782218012796457954641639004909483002293295752187");
      _weight[0] = ct("0.0003437381681963917846247430221834229151499287042287230354055143379188235978579521132163657479768314514");
      _points[1] = ct("0.9663007519456325424115067464906798893423212721801663890681129055831478702436903498571145506943067162");
      _weight[1] = ct("0.002026050358602094250494341820341870894120024561864795036338823580354925264367517227275244576909932423");
      _points[2] = ct("0.9300208896996932164819585047276942532417932534056115051608547073927014042784861756734769306165351191");
      _weight[2] = ct("0.0059248861288656750073070124596837593021079220492247058775169782719872717029736487292831561213573021");
      _points[3] = ct("0.882019825362079146731241208862299348005417555808720267548968016151212864669297713515695332184984095");
      _weight[3] = ct("0.01261207776476106746655648532508006599729513787362061969061111331011139156523293135970609947084018862");
      _points[4] = ct("0.004001479383867386797042719910270824223541185248785833363554578344319893757114842618058463407348803735");
      _weight[4] = ct("0.02042867887008126774453513345708525680111295405537645831789221858363235004907653637524376483250420953");
      _points[5] = ct("0.8236074297748695658739488546206220397694931892518864127892186510351045655222244744576037075797895574");
      _weight[5] = ct("0.02226374019481872490578598695715605901312264527880759493159497248783660222780139439098845774611394999");
      _points[6] = ct("0.7563771934061506267981673359097779706473518228163447251511697288815637982124887651626427336664155865");
      _weight[6] = ct("0.03461660096179857963094037301158265977500547563449518843396957076139936244796763506359293284799136368");
      _points[7] = ct("0.02096364839376647799513560098656109675689180176538502182710065123636384918467384831554500962763531465");
      _weight[7] = ct("0.04621270032675413386257866238629064300957438277868616878558323293289918331132386077257775663020718931");
      _points[8] = ct("0.6821630391136515650188220799815272984812129529984549136808308873845014736266989488992730818190698119");
      _weight[8] = ct("0.04897518000258343319573971841628213770242132719001940867089608917054120707937976989292545511549928993");
      _points[9] = ct("0.6029893605598320721374807041874726334761957597253021332090631742614856848258536813319527445372951366");
      _weight[9] = ct("0.06426961225525709848147580633301085880443436756721415851562729065246516504496265169885498286161075816");
      _points[10] = ct("0.05099404158789055396677492129985342752684335179502102250490757627054764167157590973686635778722014573");
      _weight[10] = ct("0.06894223784384404993007739031698519886588775153771160210566885018965190752564322224893633392985120252");
      _points[11] = ct("0.5210158208707761473198147915854717855660664902319620429318729520457293008516289285224828683060695134");
      _weight[11] = ct("0.07915832457721575745284593825289506100924953969440499641376678369347764830926340546224343749330271028");
      _points[12] = ct("0.09328039592854495077760905882606572909110423169403601965545516113954878960271296675572769974433514713");
      _weight[12] = ct("0.08714781414928617652436330187061168404379158056036702876225120391972824949607113158995664181206534451");
      _points[13] = ct("0.4384784492241381176518542603874069642668262016685327878789060389076575892412083497577428502906842642");
      _weight[13] = ct("0.09216480198048256152417399078564414852612846466652256992046258396446590593706414236053909750896569121");
      _points[14] = ct("0.1466701036776179571516088297346119926828719790587607976177450052287675453102203350213112764829923106");
      _weight[14] = ct("0.09980445383540542778220444771221204607299051846682882828893450936727624068650930424980230859564698864");
      _points[15] = ct("0.357628649976634629398327142983900163551554823411966631545931014342118455385001575208686365462093356");
      _weight[15] = ct("0.1018338577127481863631259923308642099185514417373884497748896700704506385950017111137663314704100197");
      _points[16] = ct("0.2097070395888429667218817114520340564344572337129713950314960570502750540556726532998975043202670298");
      _weight[16] = ct("0.1063846692636713200524475540357298948042757460509025466150822041706738793410034729395308181691385946");
      _points[17] = ct("0.2806717900601716991068192620345454984655482490495543795697683718559155121543067476743790509001396303");
      _weight[17] = ct("0.1068905756056280540407231215063610225447807915923361568235083905351292478184997124115608137022023352");
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = ct("0.9908518052709556853530948352201172311414908971100306236116888056786547010228099804847460306449291637");
      _weight[0] = ct("0.0002802551883567726748812555744779639105600352061968937989749794735813128057127028672314734203440280795");
      _points[1] = ct("0.9695526370802208854719287862322660049706018326703098706378843584104484087310020229969934667704093052");
      _weight[1] = ct("0.001655761521847964386692006035428965858679000056357516012475017722076239956761833907883794506161951596");
      _points[2] = ct("0.9366958480743650805439055020819450266811818650579229027664901891451477928206324529848022077423518401");
      _weight[2] = ct("0.004860183424086561415136332087732184813912903332909763493482554844577771785083994880850628451944158735");
      _points[3] = ct("0.8930931349818449707509811545649148473623623153254222496159769165216758357705561673044346695221435769");
      _weight[3] = ct("0.0103995626565567593736110930883662168930384206107188660197640952475440944449729962894776242764085632");
      _points[4] = ct("0.00361164281855689303445321012625198346733275355003682919557113405867408349929295207867441611737690897");
      _weight[4] = ct("0.01844807545006615338353364973844063664514747348633002796850199039649780838921192974783628927072788796");
      _points[5] = ct("0.8398186157087110778386362944292882560999767507786887653784723935849407017581430396000219565181239941");
      _weight[5] = ct("0.01848218385863319552539537554057223036019964756805820620573212876783093453134742074611622587750882251");
      _points[6] = ct("0.7781842229767616142092996470420758791283656925578678775853071098643813559091198697527204996713931532");
      _weight[6] = ct("0.02897969422421944931400246601007177204686871789749054254495145220324571113131572128329170246403961399");
      _points[7] = ct("0.7097076516539023988437467831116355144608909392408906399894113065110659853244124588493665962726797404");
      _weight[7] = ct("0.04142334512551560975967431967755079490752620840476902467442180073660343747997340115254631834842068448");
      _points[8] = ct("0.01893183703158821725026452431694923674614045524658723100881095660938384328017838051860341840597562064");
      _weight[8] = ct("0.04184930350395978096289045666597507923015930768805746257353242039038709944828752655956749265005342344");
      _points[9] = ct("0.6360750448792708946910910570981647668668019198973285696987761671558681881849944225414546581423684885");
      _weight[9] = ct("0.05503611628869595628296228495903234773834971955306329246189976450730557322385402735173501701009562429");
      _points[10] = ct("0.04609793304843108357392477083545909375906241693422215752403930389795061196209317861717874813163785794");
      _weight[10] = ct("0.06275255057146579770871362891521873929256827500121891666402911779624971524361366764385547386229422249");
      _points[11] = ct("0.5590994926490319878469279758790814850485694130830958106631220505575721013709915928328659605930323349");
      _weight[11] = ct("0.06879791590381478285911941087185040133275238686516501251070694318774386308432389393107853548035543575");
      _points[12] = ct("0.08444722278420982059984790045116954757568547567342996475773948377116464751353011539561005675988539905");
      _weight[12] = ct("0.0799247400979834838805861528846334314674922993978160391753764141223543035502626214065807498002876862");
      _points[13] = ct("0.4806763935785519026332213524827062607958913951805210382735109679392374943149106385409942481778506352");
      _weight[13] = ct("0.08153774174367337114460345968332885877015622313913313374058373868512964935174277352830164497093084712");
      _points[14] = ct("0.4027367861650770951230470111048776348626646611402175602798726241469139422734752813325599363666955167");
      _weight[14] = ct("0.09204397143227682581672576212135660932951865767707678899669727185145202547081949806407328350372842929");
      _points[15] = ct("0.1330361885580987754240874239752163178462101569942577515312839921107421010353389269684892715246493502");
      _weight[15] = ct("0.09246985633715682353076157026438268785806641992726473058335517773221312455376698448719205979985072617");
      _points[16] = ct("0.327199800763811715728429965275660215695471902297825977016122346800179335288035110115459307288784813");
      _weight[16] = ct("0.09918209293741316028263210506706355271369499867043289653925746745730565272014624896429591950124037465");
      _points[17] = ct("0.1906685949047633510874746648871937910511869102030339299609855946583176259568932278761873481665619608");
      _weight[17] = ct("0.09986827648083875910656821167754631038635897016436543739205281535304647362910941203114996053856106275");
      _points[18] = ct("0.2559254034821029602520473972952833166965225034685666607613445549879376542400004376190936134395605969");
      _weight[18] = ct("0.1020083732534387925915104591369712164449503353535754486442048495248552091996933451569357987499299783");
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = ct("0.9916999557929327307665436596947020094146922407257829898363762060484693209882124325386440915297526987");
      _weight[0] = ct("0.0002307638143513705802967255226568830728813167721599840524365336414500605445638183205419184402827059144");
      _points[1] = ct("0.9723569466474369111847018716646485313955816199047026627731927463182820924001386973341816730256379103");
      _weight[1] = ct("0.001366124552171843969035439751076010937012975665488565633903154123928917136910100459323476024770590956");
      _points[2] = ct("0.9424655423631863386908918774276637741176541559385663981945954132521152784422837129268702079654087369");
      _weight[2] = ct("0.004022915227928156013814278936824336762072286332632338071325792455668677727129064099489345807286851259");
      _points[3] = ct("0.9026958717934536922763469416996700772864999425096913605427629927201564197787843225600147491273022283");
      _weight[3] = ct("0.008646438225380306267478104148579112377200533623295159410282371065482011056328697434527181907858069684");
      _points[4] = ct("0.8539367530358904570890043916180165250991367585634254004379927018011944789694603521437745068010803997");
      _weight[4] = ct("0.01545533586010292574715613428317953854964217039480755935175135440483625462586097291289321958626061925");
      _points[5] = ct("0.003276106669050098975264676112871143292010168497029644767295470063831412161584194743610327964052659495");
      _weight[5] = ct("0.0167416883525451139484695594692113303959200115840109757199624734967735024433026011320234271381241498");
      _points[6] = ct("0.7972775083365946877021888513752729067366395533700328215630061593076170870677993680779536516217368242");
      _weight[6] = ct("0.02440809225336020855759740649158179130555848135630839155224086550001630535743462622984150349854465053");
      _points[7] = ct("0.7339838582356594497320271932958407316824886943041261173702937687882678060193520684331489222685668062");
      _weight[7] = ct("0.03519413375841203253537225731014733812107557483384302032295579824046286874151937628916098565550834621");
      _points[8] = ct("0.01718121814525571373824770463158205217142310650921932699389301827173010299694629239806929714009353387");
      _weight[8] = ct("0.03806993892740333390463550463872740520842342009670349282847748189119210800461319599436674582927199561");
      _points[9] = ct("0.6654696989055136479537295881338505673772460184966543033851700597919629976818155341141170411631585467");
      _weight[9] = ct("0.04725059234709778562613272088316633264786049061137085249821716995453687692356004132430763173471373923");
      _points[10] = ct("0.04187143111776519524423463414370851114954902307898488691386863470682049070344137006251506996053615728");
      _weight[10] = ct("0.05733647475826119260703896626884620663676526982142598197751665152278167937952506465377762486070349003");
      _points[11] = ct("0.5932655334835064879673930865443734208473977411399654892597462260744716869678127565393306479732092832");
      _weight[11] = ct("0.05980348368525802609816497837917858372547486798828513804350498569402473230677222080215249105521630064");
      _points[12] = ct("0.5189842887035737296184117608302417580161348370994725645140664538072682185064509019793474604143752166");
      _weight[12] = ct("0.07192983830772549570812637571959705220454253379516249592845826823872807811447074214345608253045060851");
      _points[13] = ct("0.07680083708962197048187052301994736761573663220191864690793950376336940712642192742790120232186627601");
      _weight[13] = ct("0.07350047967329571176034002983707970547786941802561395491718754226714603265744811012378159064912127635");
      _points[14] = ct("0.444285286963011162128823917835975050036359774906195940140501796031417737745668160330444167600005532");
      _weight[14] = ct("0.08263541363333147565166589034452447111897790526008740772996796592380070257693533775950888460291073922");
      _points[15] = ct("0.1211898673236760656176861522945444470235806268943235898707887850377131524410713389898296198872403467");
      _weight[15] = ct("0.08578059167595640842829204758039989126835431719768784417396580841619485004243385901000626956881311921");
      _points[16] = ct("0.3708371805843968964453220795377124336991024955666204869798357877359442742262916746260159928230296167");
      _weight[16] = ct("0.09094117788270695025052175053988521021573682596634589761784828202602528063874365566272648430490295018");
      _points[17] = ct("0.1740471126355421652241579341996569921877681033069868901852878459116461179764358286536618532558350224");
      _weight[17] = ct("0.09368338372511565569498576493650134822004762846570875646531322483816870359335260839464910457532484731");
      _points[18] = ct("0.3002806768359501643662584187171734631746719686192409655675227716570747312020196669966322653788992448");
      _weight[18] = ct("0.09597092321988782503051231642150166590478722336093452405759351080479348502148876405591865563178148165");
      _points[19] = ct("0.2341918863135921908944557128323043352373021481231570747714734150082081622077654966849128615343105212");
      _weight[19] = ct("0.09703221011970818162036374853733578584979674884812765964709076549398887310760714319754736126669081831");
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = ct("0.9924354907256214774937902793889982068789303884718009223638209927180066784787668474833283570905445554");
      _weight[0] = ct("0.000191723737059443657959199685730487354781103587725215652416642420063697623658594870138319440832039897");
      _points[1] = ct("0.9747919756603656530791520912867540805522533015938938496488658734735577229804897977756749790184306923");
      _weight[1] = ct("0.001136997053399528357223582471399066105620591183233813017156494435682540599458716110693253354979571245");
      _points[2] = ct("0.9474855444063973466860989716611313948903221194844454580667087781352119091878179384063695290882740173");
      _weight[2] = ct("0.003357512043133831072552673187562964503288479122657296229103793587294405115801504672333876098665852311");
      _points[3] = ct("0.9110742658026157747796664327661934805098614945934874284421480344586480510586007787502760981037640813");
      _weight[3] = ct("0.007244105739489879730472547559442240697420720259915659077551736989091842220673176735262750458582496436");
      _points[4] = ct("0.8662997589709565970763633043579206958620698193352277530749704236585637715961211057848505289659337019");
      _weight[4] = ct("0.01301319484729121067081350259836615564509889406165673029724426861833434880054116162097542564135199251");
      _points[5] = ct("0.002985237283213062741888784075749833348045897190182021426647111448051836745590953162187136553707655404");
      _weight[5] = ct("0.01526121181304637819034183537343181870586287942279387814026920795825460055220015001230074094371099912");
      _points[6] = ct("0.8140736165126974167889441095793418834761159091940745540915800538406752152475818572669301867705564224");
      _weight[6] = ct("0.02067841951594062532766545282048113895201409713863530682554154662668730367463374091492579251825178598");
      _points[7] = ct("0.7554590544496869862658499728148629393663862148485365820478410117499734428055421838878873979671459391");
      _weight[7] = ct("0.03003974522638556952704078489267777259843073958271775542411847529124306280115798397937637514899445391");
      _points[8] = ct("0.01566228055757354733289561065567830149720101282930379057740690982898809746455700724957349161137445402");
      _weight[8] = ct("0.0347758521523900250906201851623707590927008222558555613311917759618246838587949059386947611441063847");
      _points[9] = ct("0.6916493150129622572194466789692474731114378954421946863393862533447191774980898542170077714513614257");
      _weight[9] = ct("0.04069109877964301658407017730425226266443064057334065145095136833448379998485753079799217710254713125");
      _points[10] = ct("0.6239433897212819474963058147440920154900191318154389436290443886013853942344250394844038511295753291");
      _weight[10] = ct("0.05204609359179111023564632579998986927183950203292324804344689812665144316827079944423657995726457014");
      _points[11] = ct("0.03819828824507355334483281939565778780322081882037253284478137692301839452272816351601955509121448931");
      _weight[11] = ct("0.05257452016640661293744751166188692897194515113241003199215036965601069114006596457477516802652630106");
      _points[12] = ct("0.5537195807282935914003656124348565130222723633112639658363114623393879406517479598116624690714085946");
      _weight[12] = ct("0.06337990610025468075352666693255656013349124651231552374816444219192430946831498393294160099075286409");
      _points[13] = ct("0.07013961906232579813984265676375811407081827897927155972627053849656310064145605407077470856671992207");
      _weight[13] = ct("0.06777358068880635103031781043749696727813442757543512272919269504359828524130368130679642947198108584");
      _points[14] = ct("0.4824074446124388805353185218595824144467997109997394967544461672573758804548396608944152015562769533");
      _weight[14] = ct("0.07388402529699877110380641152857474527467150780108552765426171096663124369742378311614318387497559488");
      _points[15] = ct("0.1108366733203635022376253075861617420191222518457438320529257958835099421591933038201169995724621575");
      _weight[15] = ct("0.07969195514279793288914190000566235267906711260491304675619638962584196774176642443198237391267458687");
      _points[16] = ct("0.4114586915619051989269753361265125049694148578387329380612416947570578330099506998594987587756143859");
      _weight[16] = ct("0.08272952079399523470880740580838362330379464284872694528732063439370860031512300475525677462603061616");
      _points[17] = ct("0.1594611294440652502638138083655501810579538766130618360388682958278037659580503571599755802371923706");
      _weight[17] = ct("0.08787114127030075492971967145810458697850436666177532008944289193939981177542132493146261828025422332");
      _points[18] = ct("0.342317632958730793723481323712457505166343984781374969599613768908520216861182272658072990449954171");
      _weight[18] = ct("0.08913374937230921373396964638398331645759341581488079946582408064396578278281966817037315653266913572");
      _points[19] = ct("0.2150231853580202850809121676459173588900222007857657740357006632538302506890640907152055964899157391");
      _weight[19] = ct("0.09210054144651500414815597125252491515932996742881640264899141571621140700823572973382363663710533364");
      _points[20] = ct("0.2763917790937831724096862097630639456644117270400405937135134283509653312425761670490246263920613148");
      _weight[20] = ct("0.09242510522204482532070073767512146817197969239818616413946316147309617242947716994951510527304012945");
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = ct("0.9930774850443482149030021066415407683406700298179706308215188462467044126812424398542732069635953363");
      _weight[0] = ct("0.0001605964338749016320576856292150734027974336746659489676629679245638257528017707162633356339579309951");
      _points[1] = ct("0.9769196632371288671781665711370362045685576491004758259075059336129642443913384619385342626927521243");
      _weight[1] = ct("0.0009538558113180135180967949786628451294240092743928687244237285896188821328575349981455723556774242151");
      _points[2] = ct("0.9518795932297199145233254132304692539088438686423388255790172833977314296065333707540227994344743905");
      _weight[2] = ct("0.002823533706278848565916530037911878629982887095586678771104423447725510221470260596622430583204829748");
      _points[3] = ct("0.9184257249898492632792699442543246960817983206223100233229591659202425806838473116664400173192555422");
      _weight[3] = ct("0.006112428226300807468928605022472388819840529336780360990858784903836597627090362080718578428772948567");
      _points[4] = ct("0.8771815974654200209935832382780264667216854819433063264149961682215358967027150316006842063229545824");
      _weight[4] = ct("0.01102775020425528202183274932690576622802929805904276532381154234944322175706675534281853900355524607");
      _points[5] = ct("0.002731446008884229684008970450320001444920091810195930525180269991442470544358606232863648791137992902");
      _weight[5] = ct("0.01396851222739562730764330994005642798820870305226851204432919119548361416787182679620322866610583444");
      _points[6] = ct("0.8289156136217265123540054985427691593398783968413130229560818673737749864709777074205767676513685463");
      _weight[6] = ct("0.01761734488022181417634750650161074169827888941368967387824436676905266460390992162845846544979252123");
      _points[7] = ct("0.7745269160648226353202027384109920682527303908818411141565719030087724957529183987986099954836780992");
      _weight[7] = ct("0.0257584605627306793926964100933613725492722872259953914150712254770612504454578414722046723976962161");
      _points[8] = ct("0.01433593348369970618530803928505257182212734984171995141756688554596877547440774718470825927907210741");
      _weight[8] = ct("0.03188810690955699372913185825261865705830584729624107779763818757645318375465544204740947987843934266");
      _points[9] = ct("0.7150286804747624026121578393379999446389645236341253188769096134374679986116977432704020454213976699");
      _weight[9] = ct("0.03516003512030458548547005431414484593424269996086323158449180253002667739460805295412856717443142857");
      _points[10] = ct("0.6515292548958144740358068223118511349859101369629558312595962074831187114090178549434212259989474758");
      _weight[10] = ct("0.04537845719632199076042572155228547303759643411880068270661964657070462859342870351180007030550233198");
      _points[11] = ct("0.03498632835121644938721881407108470789540507513413332008873819031943272701440377309817494943055717373");
      _weight[11] = ct("0.04836847334378099951774078646756125991897967480632796321673948363274069201822403812450461165062074718");
      _points[12] = ct("0.5852115179512991297552453346740838766873451701532765634475564569305673634168154853640549882370619951");
      _weight[12] = ct("0.05584574164688526249815932491291670258280004563995038841006871240856953599982233845476300338102841803");
      _points[13] = ct("0.06430264113215888253127507139568606483527396467455008276394607606723427123735449200295989192425551556");
      _weight[13] = ct("0.06265519399875045578481791711936416627645561286020844389093385854076882602968762518293824437104395458");
      _points[14] = ct("0.5173108459509911200513628668417419502531014399509647860341897330139076887981516467821142472826215626");
      _weight[14] = ct("0.06590811757077106807977571305735299366400317729192485529773531632140783267376844390929590547508218283");
      _points[15] = ct("0.1017393434521639240125822659379428899539853633989816895418881106050308024257778517338354719506687597");
      _weight[15] = ct("0.07415410818640572896643467181854132802159376843867967796198737741804690263271070220679766274082477725");
      _points[16] = ct("0.4490921009868173325138719504239347417475929920954648897808863573672971601962552955877951121911249076");
      _weight[16] = ct("0.07487223293386003847932596237778164765909771195087018622881954379418589205789644518583498915989155589");
      _points[17] = ct("0.3818260692567502030509512762811186856943928877507787697256756013761460030692112995057041549779558298");
      _weight[17] = ct("0.08205559156388180327653087723778992847221561856887365139092586395278825727586388000965819474762431428");
      _points[18] = ct("0.1465992001576654169265658426695235179279442290125604632515204687033228653332772641236747155787629019");
      _weight[18] = ct("0.0824448098128229051541582393875662137076647115837413320869169037065961050583960349723017507169251583");
      _points[19] = ct("0.316765788710447271834211176023788565585917218829176864381597468997832396169947236122444167801337943");
      _weight[19] = ct("0.08683750029083565581666905153333353034148761155627255043342898156741359986662248660638659974313726394");
      _points[20] = ct("0.1980466041181826148466050402800147983667787135049020201401014006434161174885707857036810715432879233");
      _weight[20] = ct("0.08730240757260692599058627618965695877333537373682736038372387813522711622922491115184985621378186379");
      _points[21] = ct("0.2551232069716869695768287350762534865017322609522133051615515472916441580767357518665803492792871761");
      _weight[21] = ct("0.08870674180083961237725395424888980010638767505799639849446421318828518370656462205089634953201953275");
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = ct("0.9936411423413659674234674659492144344825859906238375139346624942288118730536279398452978995101742923");
      _weight[0] = ct("0.000135534085630299773212074130897584210836555854564225333161803433610929170770419163441050799228018816");
      _points[1] = ct("0.9787895175170725588787939186958919174534641597824532080283251852183454120155341188680323899069674147");
      _weight[1] = ct("0.0008060783183419481302475769328811150712121287430918492847770345087224901752876520422652114035579145278");
      _points[2] = ct("0.955747055076380126306280934995655993508546571972578475189971588106363915440947204061462001894897211");
      _weight[2] = ct("0.002391164993413535831600994583419511700235568916766570267257880249998309203933376284348101463868195296");
      _points[3] = ct("0.9249098542075925823337164109969201318994696513183952026689198527018630611553347105313285453711814395");
      _weight[3] = ct("0.005191620446910720770096011274932118364042720186345085236614939007955783549782982195562743151370410214");
      _points[4] = ct("0.8868058750607934334740477882285871206071403541849894413037182530711360933825476533262438961100102982");
      _weight[4] = ct("0.009401868666227652995952585963231501422382957680697780965957245463094744102323209704629371613850600187");
      _points[5] = ct("0.002508689638982744438582834305084970754465513041215795244037291698106602509090989047144538885452310289");
      _weight[5] = ct("0.0128331652253125979400788588633991492037855612500533267579485452992396263751800578389440168905250927");
      _points[6] = ct("0.8420871815760147938272551090762841119895322905806887532216879812775912541917310769974367310218997339");
      _weight[6] = ct("0.01509008390394755517476464908179904728950585618281600061596910970327096104697896113737910324026950532");
      _points[7] = ct("0.791518958392199164999544811561899563969866530494357902752851291892239872938757884419906943099590211");
      _weight[7] = ct("0.02218746826207120887276263590638552621253197931251564408631796147019043169238537869081644237786204674");
      _points[8] = ct("0.01317098500036888781833393883008497304237693656498066106398450987552457101458753605359608128168743719");
      _weight[8] = ct("0.02934304620092188218926113600741607806739210817537199870266151443933950832690670503975771066297699378");
      _points[9] = ct("0.7359664575449968693948098166623482992411491974356738064983977465191447748707008794380155771341181069");
      _weight[9] = ct("0.03048748451352573060772721176350031611003474117711489554566270549461388710349331159902545415320505057");
      _points[10] = ct("0.6763802055359521297445541267501844773125729751061369156714561779908754921014857822086096522112308808");
      _weight[10] = ct("0.0396551893481249125925521086126432747002257718640553587940071945094773848424573489581704970305004816");
      _points[11] = ct("0.03216172768263549326403367565653550535205766565201664531712686624400665820371098603813869334727816456");
      _weight[11] = ct("0.04463725220786037308362066413240402086136904820699921434316677932141270933111474705923954412447090065");
      _points[12] = ct("0.6137797438222284322478251318001054000017788712275714851022029844218004813706509166663266125837282715");
      _weight[12] = ct("0.04924611206265319667827944363701807174968086942310183494453035969494685072370452468029153544157500021");
      _points[13] = ct("0.05916028461389076523322206577362019497788250568779307045784761685757471784484460194699384188422236678");
      _weight[13] = ct("0.05806819763322011970374782113924425761404511862778324479824299752720919807911566279375387723149769095");
      _points[14] = ct("0.5492361859337143986849444709434036999595634258787999588444642290913115681454981608358155754321058537");
      _weight[14] = ct("0.05873345966894180966241572944644661616634652469095377698346786561882559594662330923115818784810304391");
      _points[15] = ct("0.4838538912019967973430622916413376995836676173698294055646030869616179182331776207634155618518804048");
      _weight[15] = ct("0.06754184722435728497520002182184314434614082127218346806093570515182043965457234703866461587667979884");
      _points[16] = ct("0.09370523422563984366939026810701599431294843355379981255080596536633429882747373537128397881326481735");
      _weight[16] = ct("0.06911669325016075584493212610566610721140551761560671679530417625630597260007129822813775191577520333");
      _points[17] = ct("0.4187515692045311374092315829147009424821192511291422675616536437335683699790579610322750663361326695");
      _weight[17] = ct("0.07508529186083901414100526577407837545431900256520270901278341770173066637555355144434418735382997458");
      _points[18] = ct("0.1352056309863808460458454746251433160911708193841602999666708950632019186174750867966318879969589279");
      _weight[18] = ct("0.07740045437700328926473449453186946979485005699189929147909285069627000897494280716076551491212405294");
      _points[19] = ct("0.3550431384266732981536948763163021427209776085086219647490204456653280019775176349750919633016300716");
      _weight[19] = ct("0.08080690215257658597452762845490596703525596328546181279008243628500936409123153800589940372707628206");
      _points[20] = ct("0.182951434776206737817241219053163283147422248322105739279654822172669012612264918073669777008318145");
      _weight[20] = ct("0.08269256057546193715477130820235096515571599625521525349385431798507764427936998623641731548676776034");
      _points[21] = ct("0.2938186667005872290547424363576361134204043156282958233734911798438694506857100888924860114111920557");
      _weight[21] = ct("0.08421756232457493979943437980297802638058106035661088138746759718641313900343550501435144093388206736");
      _points[22] = ct("0.2361257194699659752033367975673903519867094069780877665480629132753104255091235776405840076486321074");
      _weight[22] = ct("0.08493096269792264883907527383068975587810407136558906032073556299546435535076532045263371654972207912");
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = ct("0.9941387002099847972174529494354186447065590111257385945879012558028220919933208547206036697068695813");
      _weight[0] = ct("0.0001151730150479458384071635595253101782832122745104808509747143553195202907771103803048664630273115494");
      _points[1] = ct("0.9804414867720773047861990092929623254654564518007672132576640373798768725183629974386659808406771145");
      _weight[1] = ct("0.0006857923806901939716180130215329527076359172887024981713091355795707735117444618081210364335144106147");
      _points[2] = ct("0.9591684333956145359195940133146757910921505457443845505930704566821066595074815881415270673833622153");
      _weight[2] = ct("0.00203815713912692007459646347769836203946352713265341526734571099668110605270544423185729335343259772");
      _points[3] = ct("0.9306567200768073264940897342948113540892147989736239490329954181172965522690414938590459685654063852");
      _weight[3] = ct("0.004436613641500169169439699970626442930590561207013584324589174385384877629658784768911216861600074852");
      _points[4] = ct("0.8953562946217610669903735651020598427994962565161247360082353603807290907387866393285046179471673542");
      _weight[4] = ct("0.008061266812448580930088891626091521017798326749095430281313277537958062872952727474091695627913290944");
      _points[5] = ct("0.002312107617798491569705276671091089554939384003636010189709388318905051457029892184514494087344005534");
      _weight[5] = ct("0.01183066055113336862806942240007326328245558099447927275162523552741007390766368641044486302691611349");
      _points[6] = ct("0.8538239525472523950102126950475975286633013398103204851603925633645574373545504247981078805449901342");
      _weight[6] = ct("0.01299144166781244007855380199287793161149080700512316783535285734348566786945346584013675240596698465");
      _points[7] = ct("0.8067147162308662079759883230462271215511214289418775696507626148867661530416063674514532295042286124");
      _weight[7] = ct("0.01919585570453531090274182547445749150555233627807191180519025749427489117067745137550248266139141968");
      _points[8] = ct("0.7547715409190971048511486978937648589061186652744929259781655167672301711625351688732468834021431278");
      _weight[8] = ct("0.02653019230140020249207268704743023175850973695203784071226564499171372408835572203998397885347122954");
      _points[9] = ct("0.01214230377107489705391618941072912260522755162446019471499380137216042202948348504762488631035567119");
      _weight[9] = ct("0.02708890824143026572037962662152288020969476966472863417825282202056481771333289850444085338833423305");
      _points[10] = ct("0.6988136087122555462016606377145350834461598850036410982928344624206350632284010299704447755398053868");
      _weight[10] = ct("0.03474229649484084003930890647846262727505108642173711331754141432035930539668108322663152396872809195");
      _points[11] = ct("0.02966481421406884694296518092415020517648541895905737943054284836662555853198029459708727505457923553");
      _weight[11] = ct("0.04131359852028912070813348612469458121266906681977047751086422223751155286109440455542530956212070502");
      _points[12] = ct("0.6397234134973043576554117727135736996646600113714081000045059910790721633790546552645982027501322789");
      _weight[12] = ct("0.04348472766572340728540928114789743818624545599387243885741710511492122452733704265550252406972611373");
      _points[13] = ct("0.5784328451129381173040996319869945856313733674576909278189693731645225384582334961614709864014439181");
      _weight[13] = ct("0.05233393229745876141906451197180871793300976215540282985419030015323189126408906128503865664752988069");
      _points[14] = ct("0.05460726328354278129885634528658109995675907857338212819561910072319464261893667297651857381196832126");
      _weight[14] = ct("0.05394596868921663524498068262844092364170052310862208007218011372940229373250922674094381645827344836");
      _points[15] = ct("0.5159084936202979568506211844229575689363706436725780992080644753405181129907634992160172026059024785");
      _weight[15] = ct("0.06081487403303229439557250461246857543106709458728555540542244478846987123597889141506562545922541255");
      _points[16] = ct("0.08657678275502653153027885149201366204915309675322937558650613592608210237006631190380162408379504711");
      _weight[16] = ct("0.06453135870842410635528940758432413674737559106054908567625814834380452190132723118159432526647738541");
      _points[17] = ct("0.4531364059378609233872602564908296475944846220926500743387614702917419726601357431551427286510223685");
      _weight[17] = ct("0.06842960472039024618212495432963431108894080844633652827051493472714512862008051584998227091418043717");
      _points[18] = ct("0.1250693120998313816827247034321147372716372812643793892831974422340660561775264779754430133711757073");
      _weight[18] = ct("0.07272392358209171859073020012272423331634752635725114961740036064699127019826765310647657118990659075");
      _points[19] = ct("0.3911065354271857628058029229759407587117961441488460253702401794353555304627992294123975242415039216");
      _weight[19] = ct("0.07468800138191237704937459456995169435294967932534591746282115187766476994517745985562126268100280594");
      _points[20] = ct("0.1694778408374137992122551210880916091724440900194513583551692099521297695569503211773284187174570824");
      _weight[20] = ct("0.07830217864471200784132989838038854530001015874197726701210669511616739254100083028981782478774985955");
      _points[21] = ct("0.3307971297342992989465449797634122839351353239458986043016484038687065359502901031392280699179553766");
      _weight[21] = ct("0.07913874651520938929265736761457077631574365663020054012563532141424833258155611098929166716363521104");
      _points[22] = ct("0.2191020363269966008052502214870027886228146700884203403626969975224363594600835115547810175625647987");
      _weight[22] = ct("0.08117812499761111793897603388086616924056250529426903044903261905158249863418553775020821290326759497");
      _points[23] = ct("0.2731593030949704981198326346716482638665286879359816866038841088473610512662532110402010110389662036");
      _weight[23] = ct("0.08139860229396257985108057536193088271685230951096375019039633824613643145339319826460674182521286602");
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = ct("0.994580098039975381755943258134921196515439243907115241892613222040274966787806323038254950411999966");
      _weight[0] = ct("0.00009849406172470012342729183797120306729289956825438560707512493759046505877196757172281017650086300047");
      _points[1] = ct("0.9819080873346961325077074435259613225499801670479781693750962994666519993115924159471265473976297682");
      _weight[1] = ct("0.0005870930138403858080781133946229403539078885793604901154230653455535909040354642990632189297837364007");
      _points[2] = ct("0.962209486590731189772863397747711003487131531065813181451688745525844129958953618722182068233988584");
      _weight[2] = ct("0.001747720324216249475087491502293789694397139287420886663505338741268344649234561021604669851838969137");
      _points[3] = ct("0.9357731085313031293882544650031356312195798060607631882567272915711012342389978233465384997918124043");
      _weight[3] = ct("0.003813096281420520842348298710895950881889701039955631763288577889908654722745077399684986333284637478");
      _points[4] = ct("0.9029847330954237846160108102144816242809611079263960417211087101890827959775348038191523331937712815");
      _weight[4] = ct("0.00694869076994824250564297958061441939352289609681812839617731614595753371500276899856024923923484653");
      _points[5] = ct("0.002137754840779325097003996068484341170531133944451123784608428716465128312889554565077424114622343405");
      _weight[5] = ct("0.01094107579169813189091237608942257612915731472352215860492901940875784817684822085977668710227725507");
      _points[6] = ct("0.8643225686575712512890930964464128884912645871039346858755335774412004904375538141581885649622616211");
      _weight[6] = ct("0.01123893942176472911521814402227084965277093149641017025250777628933241674291632070615824939422379614");
      _points[7] = ct("0.8203504266385679362480414025046644799692216902498877451708436721193771528836986810945627036059209933");
      _weight[7] = ct("0.01667844746417703482858827412105202654768663139416267562768610651187442182435611008344612749151113714");
      _points[8] = ct("0.7717095332090876532772702662299137017534216024796653237460220724084526447410338907367806228629369144");
      _weight[8] = ct("0.02316874597448142681430272573677028827491415078621799535354766932626957753146747980664577809025445712");
      _points[9] = ct("0.01122946060565248953765964495295842160878607386165047422524781380016346040248689425049555083510760924");
      _weight[9] = ct("0.02508327722702107727564330652194328699205195700415177187291626937632732713366479790668583552899807848");
      _points[10] = ct("0.7191091887702756756924733312759952703610235950003264675599094080939261671384587307200102973531914237");
      _weight[10] = ct("0.03052084060846490888777912318780060035451395536472057323180285253178882915878800370061906778391131643");
      _points[11] = ct("0.0274469434643197743434582952393301677966795058332544771415907730879432148015830814776531097816784999");
      _weight[11] = ct("0.03834144667483376494444168127629636943855168654307775524429254616965643468194663566289872000674802254");
      _points[12] = ct("0.6633164283801916080438663597093166623213491788613272167696983082588163829549425343365271477378754117");
      _weight[12] = ct("0.03846345091061473349290245539794099303708019282297091901740137152519600363961583008523285646670019196");
      _points[13] = ct("0.6051448381551349081424173890238120465852778156899718864521872811406263759015006314129890759192133067");
      _weight[13] = ct("0.04665650137559238100136333265315206043659187299633210330041980122434126791481360689974380076448028748");
      _points[14] = ct("0.05055738036921262563480593409648928639639291900566926165094194152128925730424342105114094576969514026");
      _weight[14] = ct("0.05023107977579624293082489939776848612795440206268521504827201101988163471721421863245982233173798446");
      _points[15] = ct("0.5454426920332588243126070891910049145712573150611219268116870762412938483414356567846858208870956794");
      _weight[15] = ct("0.05470911337993017133325658954591537464613243821693582754945733906555848787274909343811964787857264477");
      _points[16] = ct("0.0802242209123347788711806562294006865192884691392240487497176541792428819362495039574470334376226373");
      _weight[16] = ct("0.06035303547197594011536946214697428562244105735504644592761780204490024094524008923007047324841406013");
      _points[17] = ct("0.4850805823554158825739775389860063675732738097640718535822201240883097297180151158721545179097262209");
      _weight[17] = ct("0.06220107820158806088435333669253889377963299096493770394973335210519773180746305069290850138698745457");
      _points[18] = ct("0.1160149645874870172347350473465606669489106230158662308693922678144886136045272672526553037082963898");
      _weight[18] = ct("0.06839537544316108834152713171531975770585381497544037444937248176128482598116938100169841603692543401");
      _points[19] = ct("0.4249387248171481696883001024393147385589320252409908017977547745824610905505913984042249884129209462");
      _weight[19] = ct("0.06870658133314383697685351362085691413583117735597939494713400804125932270303523200365795429917671417");
      _points[20] = ct("0.3658941229846370226364064314991338752818897598016621885592227542838233793054347295626319302125106143");
      _weight[20] = ct("0.07381880949267258745570611132264679808177411201634040263123836073740074140392720781241131139297762215");
      _points[21] = ct("0.1574077383886659652193159384891105328541375646502171946705997212341715684439550613338558276683796734");
      _weight[21] = ct("0.07414640177550565019867457680187590050097479701658588964064176822972214718382922048913127448484917208");
      _points[22] = ct("0.3088077795622951038979119439836161009663783922166299606375840033527997031278586274863047483670254866");
      _weight[22] = ct("0.07717401233298538239701017926660146653703606970898668982214027556915412179838143641951278835213681971");
      _points[23] = ct("0.2037989575831378225336879722401727700751661453631751449300676446592974173952675347684620523747703873");
      _weight[23] = ct("0.07750307846489530106069001626917005366648185167101180936037628557609221967072401671463450488288759469");
      _points[24] = ct("0.2545121408770102731752042678534638511633337808460910662787207479083865625018202584499175428930839519");
      _weight[24] = ct("0.07847361442854745129999858918728471494155807095267460162304348042572581006206020856357340736457611768");
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = ct("0.9949734758572125109018548468457757451414034454994678437134746777377314759592836642394933873290978458");
      _weight[0] = ct("0.0000847266482218448156947327605447326126419659617844272871156905786136235122516774210387065414626002125");
      _points[1] = ct("0.9832159998661838487495423597867820380401895721015838753714698965929400840517768491779043505066538759");
      _weight[1] = ct("0.0005055010659316268156697904469713558505999011355121561471933639284915004498018912965831367132020459454");
      _points[2] = ct("0.9649243392355685769676789331181850486069916808216714189009346206348469238729501303425886192745964061");
      _weight[2] = ct("0.001507051270060215245738339727124017471225049056873612094515045979327154650350622172691802201761831085");
      _points[3] = ct("0.9403473057218671707575661924897942312565963618065724508702617539552909102894060455499272532250298864");
      _weight[3] = ct("0.003294701834427150802711378133094103566373633324556116068118172306506898075038472954763116221312803249");
      _points[4] = ct("0.9098175190772664572577288936685780032938885885639025695186218563884849263622085581336329392731539935");
      _weight[4] = ct("0.006019673135257074110480920880712994889898064197316878936261920311358339469987576574531217903905751702");
      _points[5] = ct("0.8737479163770055563444293398713444395647730795686451952308337238766361425385557764556171897935901199");
      _weight[5] = ct("0.009767577246988349844368959326074245339906130164224783443389859320911296477027153023249454065509989329");
      _points[6] = ct("0.001982402312500991974764508701509203188187092356310070549948036260509797246427442856641364318118786936");
      _weight[6] = ct("0.01014808420232600024203421407891864326967813611225317519604953710526452069416772253977839448461609008");
      _points[7] = ct("0.8326263048793096592840319901487043552909483798146004051450267827213551566378150192788626666368150197");
      _weight[7] = ct("0.01455065777740560048945432725678785020079291621240239065081833184010255621019635602390937881818659981");
      _points[8] = ct("0.787008796159314796328080238209286307636016143142496025622674079035016921733834146837825179233227587");
      _weight[8] = ct("0.02030423177222357942405312178653612755525415648826535986135120681968192455152752689740341633477985469");
      _points[9] = ct("0.01041571203509252666821917702931014674935479485106816524423187191810390241276843270721704469819313156");
      _weight[9] = ct("0.02329114401400434107623960101019748682844868035669047120616072012257778273808340621085543544339633781");
      _points[10] = ct("0.7375122949172582536693195662187433097563287951254783157564549381318449761373581277895857265168695533");
      _weight[10] = ct("0.02688756442258594394198564943536074963802617244572964250768720667333181166040705692347132345670597557");
      _points[11] = ct("0.6848061597563768691573930360166283266837702181638087861103877824608012560472566171090269983928681477");
      _weight[11] = ct("0.03408916470242993251882218894046125122731292371714041110875776292446406522925454370012819778710050886");
      _points[12] = ct("0.02546814775045601344292075058542701375019841643628081237335239638580493646438840089869787286535769335");
      _weight[12] = ct("0.03567383035949472508322253846200779250258506124560617922629226954076677145218050153633101412079701784");
      _points[13] = ct("0.629603152646366832440005835186433246405811585188146038276837837280437272150104697014026598810722124");
      _weight[13] = ct("0.04163624742448221054690511799845617999254992276850739950519913819788930854925306643839091326449477419");
      _points[14] = ct("0.04693954797272390029719352115915356373546076220882119542989174060489332587033482373906263198125120149");
      _weight[14] = ct("0.04687405429551426087558989633323650022463453467699547900364888632785840215419132950168073015892539337");
      _points[15] = ct("0.5726498006750368846698153034557769759301843942142236134513678722424631571284058108657451973547353036");
      _weight[15] = ct("0.04920787783957516399463353490332616402964507354307016190860555769829433495204703242645409835846820773");
      _points[16] = ct("0.514716300858142001351707261638654109705083087690772118910357707639424905325977021819699527601195918");
      _weight[16] = ct("0.0564511112660067597072396547032695132870542650221711623908710568510712801252163799195090529486065156");
      _points[17] = ct("0.07453996747497746177748212306933832256427367540970293847144712393640101788929532457190961305371464226");
      _weight[17] = ct("0.05654047670425408731673641746840444106706145938580495870768149053927784423957084294480749076126356119");
      _points[18] = ct("0.4565861046963797540479864485503725667356963030172069689574101221860311846558745203443032208709777164");
      _weight[18] = ct("0.06299927337564799294914832905905277124462503427963309452997012853782168724233937070149924372893476695");
      _points[19] = ct("0.1078962587148670518369933864179128680363862543318018393308158240698289232868109968676399249029215776");
      _weight[19] = ct("0.06439218521754601961609217515415748254965335209980546776078885523102830281793937574743462706467966926");
      _points[20] = ct("0.3990453234002412501528182579168397671593845939181776667219899610514800606114315767563476820928747503");
      _weight[20] = ct("0.06849140575169568012668800722262161522613334377457403128300937582927520679256050458344419628226694089");
      _points[21] = ct("0.1465573689781110622454405645211420385843833471460570019307330150135958433471094540487915029769819494");
      _weight[21] = ct("0.07022960671117586974426525058832575750953055446936506488322864597988955028307342935889618929244731548");
      _points[22] = ct("0.3428720970842849252151378642974238623794694294290994447908012269211766838901167147393952220069469325");
      _weight[22] = ct("0.0725918327712018624120357190515451543007959976782386099644323142584005972169684717387584764973049203");
      _points[23] = ct("0.1900004870599828336341439787909794085126181077453390929451879495109536533280805490705145871629269747");
      _weight[23] = ct("0.07394209946166916222101129200752939221868094362783113220849632853398411916937608256518092603124973877");
      _points[24] = ct("0.2888260716927312263060031147583258288008503288275055379968170057607358670390531602234574905707601279");
      _weight[24] = ct("0.07500879353237672763699801406961978229108936240432004642829627625630132640321505130936349085986904773");
      _points[25] = ct("0.2376381259328170562198557150947490838125062796023926838503683108907578655346968932790673406258904327");
      _weight[25] = ct("0.07551112719749781844218082919566389510580336585132778769206085830750979488397455548961364118188574334");
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = ct("0.9953255513271093328270351894495473119057794466212460828361309213612753533892573799919314231415102235");
      _weight[0] = ct("0.00007328186742973457248973346335268348308990106749721830402804514884874852544364092321383075279342271722");
      _points[1] = ct("0.9843872802327865221402703305050865376477358992329912305682706127051502754664076249624229033974971323");
      _weight[1] = ct("0.0004375835695954694319402968526394878093805906978934431788809678901563370832892874754776959120609792781");
      _points[2] = ct("0.967357856993813442888042181474701065240585349524088001841956352807017098269912180578703569993125112");
      _weight[2] = ct("0.001306291162482041307513273595746611017270220411081977254624897447679861162403842854671409547310733369");
      _points[3] = ct("0.9444527826987507331425260090411746078705975423460296253295198573755605731026031630850456677387944581");
      _weight[3] = ct("0.002860989938171968740611001933779543816374542989923606744174802748622344893560754537563466895557173069");
      _points[4] = ct("0.9159603411903557702727824364325821830316077077386156250540469597358886472259235994667255020111350392");
      _weight[4] = ct("0.005239419741905222510689162974228147278566274534968597513495834319549298869840982032689155040662882629");
      _points[5] = ct("0.8822389102341396454689826313057027389226267678942236210056160455752391145785184091546650419162996677");
      _weight[5] = ct("0.008525852555960638572219657461707102521891573539394917046403114188820346919404426896027012171696186572");
      _points[6] = ct("0.001843386661593831967726735667295828873915982082832672961302707423046245066116804281541879869808804072");
      _weight[6] = ct("0.009438203890880110866596413809031958726344004381082942643778752283009119164009190109057284600952362998");
      _points[7] = ct("0.8437125821466905369938778855425381743397595579708781792466494145717162173438121723567149172814722983");
      _weight[7] = ct("0.0127443068031079317715688761451132541542067222744958632051824594229015519066742950552553740091615511");
      _points[8] = ct("0.8008658592874873234732464957552331150349938591747462274480585030882443351844636275401613601250526774");
      _weight[8] = ct("0.01785496844943601640277750879058008805396662109216816766106464135700233982039264716056288080389367592");
      _points[9] = ct("0.009687231019540805273828081504282131116359659467549445267187225423223113523010002437844497609237991749");
      _weight[9] = ct("0.02168341697171634922387206163071664777223232067278973251502576675723184728219216643152310340730796864");
      _points[10] = ct("0.7542375697640191565673740509855886563757234218511268984625872592197338373290508090761113687668744005");
      _weight[10] = ct("0.02375402799044424959072051962268325181356197297482915729116896189554605021009758096115809530581689383");
      _points[11] = ct("0.7044140944718857265433052486560377972151930169197974524635302295609988027848098312397552342521119597");
      _weight[11] = ct("0.03027696861193742610784335894757796436342078243942527942081998530055037186894711078030414144043462203");
      _points[12] = ct("0.02369534823915010708382497244256481068013762237691314340450484701623746518298477536252903465995659874");
      _weight[12] = ct("0.03327121392996553082051253960656141674676698664874091138577924743699340286248666375068308662950781324");
      _points[13] = ct("0.6520219943065595128144520218202029835324140443758028088226666444218422243992797923412452670120753289");
      _weight[13] = ct("0.03720516474612843252115408793185275353855779065005451754273434428797531460701296701493334494925037368");
      _points[14] = ct("0.04369473580455800013769324464294019749014271105473332584282951242378903272580157799981535573499100973");
      _weight[14] = ct("0.04383223890274716207783270394301581492732858579499438231354191010417070821260416813703099811250239746");
      _points[15] = ct("0.5977201313878155000196942168596513335913650222028782052701089676472197217513431621531390052097054438");
      _weight[15] = ct("0.0442754809043745166049102553444756242629834754947539739688308925406328335470728344353699778944724549");
      _points[16] = ct("0.5421913837761862949497505196736063188110717433003851565440307389535776130912578939384032088911835582");
      _weight[16] = ct("0.05119240661403538109314247413068615838127744479416697841527953461192940260522878214085058664786929483");
      _points[17] = ct("0.0694342787989322199730161870599743899193417310335786837684089594535236674250451492247500562398937346");
      _weight[17] = ct("0.05305637157700611567035240177857449090592886836998970530450787053641364840432593332954674885802999604");
      _points[18] = ct("0.486134058031581842105811479741619256441348442651950033915572669570835846369697411190512406608564496");
      _weight[18] = ct("0.05764213229207180802657160281800379487874937184851651202260951686951263830209716610394437458473375141");
      _points[19] = ct("0.1005903811326853915190140549903467621805094580706385252308216095694597532629310010567882974571874852");
      _weight[19] = ct("0.06069078747570479786231324288739386744739844478687997246810594496612261624138048834339131455140341535");
      _points[20] = ct("0.4302531076729567979697915582545114448017590910700067673138678746580049425247712359442692580026425598");
      _weight[20] = ct("0.06330786957011047808854565517611624075329395117374875437813393453496000829664673633228191742678929595");
      _points[21] = ct("0.136771268210552437602568374864889972745034266593335441275391608114954920387727316437892629650041949");
      _weight[21] = ct("0.06654908535523464685397561098642480640115961409995553567285259367625967934405564418116203664782725719");
      _points[22] = ct("0.3752512679997629534933730456435740542694401655843067372579497841123207581560234471930509217275150035");
      _weight[22] = ct("0.06788565307649292039687283320238157402058107784817118583358955398507924022035164383119891786003106666");
      _points[23] = ct("0.1775219573659193028130614393988634183199427689032530418019253526001223410476168743574185750257449093");
      _weight[23] = ct("0.07051803275142590627456213690666551450110300183953213724808652522368240015081698904312404196825072647");
      _points[24] = ct("0.3218202187671672377769064975778236252489272904134530562088575656239167866863330675121375687111015968");
      _weight[24] = ct("0.07109983236886887427029839467974307139978913310686388388211605126488499602691446213807129528454306465");
      _points[25] = ct("0.2223299911830712808191360033542121533705911233623428600494451493718258335612207931646668848912206942");
      _weight[25] = ct("0.07256094481011321558801623950042687835571243590410499523542589298533471692607778934127785986264937661");
      _points[26] = ct("0.2706318858403828388174545619009036764776417627277516962633080821607300256186263524972127095298013223");
      _weight[26] = ct("0.07271747407265305475209795588052125266906429056397565154975795821613017654667180666213671766173563337");
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = ct("0.9956419077642228317186491333620060237601315295415473070854638905269220407116028222638890083449209743");
      _weight[0] = ct("0.00006370515996210101725745472702265633711758913990764554459024871592454748893659112280483407229406835385");
      _points[1] = ct("0.9854402875829232562843797204417416195238244745167805643345209779564325262374245842623134551401451341");
      _weight[1] = ct("0.0003806839593599654687052937172487546861406951983143054441628893654176073429097708717496854771009674265");
      _points[2] = ct("0.9695474769380218769795841255378286564895236407683444524251818691481329207472659134792764782657673718");
      _weight[2] = ct("0.0011377791456507986924889327557193353897988937145668760114411400073408539511318751097684318098934036");
      _points[3] = ct("0.9481510589669756248379883268157639950428963847697689099425419930439997189239613345109477892587155246");
      _weight[3] = ct("0.002495982237871979415829687616319526354929321484971594260093162240535500992872031481890968421521032581");
      _points[4] = ct("0.9215021099473594085155151704718151363517054432469130506984103322769692925488804599027244231343314117");
      _weight[4] = ct("0.004580509469313366317241966253684956837737283433524900914903528095852603465920170011166099239052318532");
      _points[5] = ct("0.8899131284723934956831712532221734523372783412412214239234061344184586027297876948955008948655299972");
      _weight[5] = ct("0.007472731568327629262425404229139219420008809551561161327362666088823157856139752051538235243301389832");
      _points[6] = ct("0.001718495293402246663028020771266791644996181934602356641243498668963609900790262554124227544054489556");
      _weight[6] = ct("0.008800223579860048483254710294217191577207739024953436339979561240637942739941017301399737983542058875");
      _points[7] = ct("0.8537544904322088788247775513811542988294457872776482108393252112089107868125245581262654586120792931");
      _weight[7] = ct("0.01120427189543885884005076223431923448359865792254287286501113213756952844083798362642400838278667982");
      _points[8] = ct("0.8134501334282394697267215578375188617234481770369277012202582476084865180325716182203592738059608096");
      _weight[8] = ct("0.01575357142381088974813226281442771906887412741280410221144539737971025231278995461878959887619881906");
      _points[9] = ct("0.009032518495310017290182668008309766335460710175829955817301796886950012957313421273553999923511387801");
      _weight[9] = ct("0.02023576838137988786034698670252521582177125525959502980263720470161220865339795485231134855413136611");
      _points[10] = ct("0.7694725945042181706805050432690356903413932244153720708644567415131536687406382160956998961745973101");
      _weight[10] = ct("0.02104510391067328185606724574426733926381029950552618742473734044634105412953922386528522423178877086");
      _points[11] = ct("0.7223374729826939086395173882436445520337460324133837205062443405405843577730351703929806948350872225");
      _weight[11] = ct("0.02695129894362714574317820278902739133656214753061143720194269756412480787235284583042023250023369184");
      _points[12] = ct("0.02210098135778681137268521021888062944151160946598760331796165999691174140377074554738617759820391624");
      _weight[12] = ct("0.03110015822865166067702923886015083025462579664580579398440848573178798449726498246324159018595777494");
      _points[13] = ct("0.6725973867373374963190421178579525574571588976574083160637357387177511124421386108602402867292366295");
      _weight[13] = ct("0.03329710179283746617377097231688107447881161015071885848544979051240828473437080881621446821160749512");
      _points[14] = ct("0.6208354938051186180751604988886875212206555915139963242977997641728491315993006032194731774639848879");
      _weight[14] = ct("0.0398669733284307313096721339861435149472677529777038992004750528535172531348461975711478042333117905");
      _points[15] = ct("0.04077361101977503091299474371167607706934898162520204845715575724018978323744190358853092513413754222");
      _weight[15] = ct("0.04106881180888533341596419244898047338318591795943706620487407038350580428826353390074697779662723614");
      _points[16] = ct("0.567658655663528963950549089025851521052663287662634927318125089113081431332606079713178298077963132");
      _weight[16] = ct("0.04641401659297863618279998467239187373005512892102633459543014117149358423998773507108652281038679931");
      _points[17] = ct("0.06483185036310752409761920639076661009926122221841610874216905587622670223518452033164935524580956556");
      _weight[17] = ct("0.04986722172799528536062300428357175719538303706187497370739264376729336818031041386760448700580612527");
      _points[18] = ct("0.5136903224747328748359169275644776550261521565143655052175059751887984135439312756239786212853367327");
      _weight[18] = ct("0.05267081444046336301346320191574594298873507545356939242387535251298683116224294172328249432628441329");
      _points[19] = ct("0.09399372568531336584140604037988657514003928824741309138398524913091673982081934491751314695582119002");
      _weight[19] = ct("0.05726781728496770116342685381854171257294862281728752208595617722281137028532049290933995766813740385");
      _points[20] = ct("0.4595632237739050247007580803181932916401376476628329857646448103515031096132724631061051072771519328");
      _weight[20] = ct("0.05836147977632291693862247694575220416360419006726144133894084241127940580809791871084881643492680216");
      _points[21] = ct("0.1279173699497222880332522902374298487321410081872785108652567404644903241925006868210433634637075585");
      _weight[21] = ct("0.06309759998920903832871619063187736427798328292865043490361484313506251495597716084182017491112556288");
      _points[22] = ct("0.4059119503245874996847819872096119528855570149194244408537244840158077666547928989884755351269759843");
      _weight[22] = ct("0.06321436026746541740578527862238867356580627473567945958614016390860714467272442769773655632274855485");
      _points[23] = ct("0.3533655141226461443509711091964390610724843762952359906320931037906887192044490676408869047345885822");
      _weight[23] = ct("0.06697480576198529947544249860329464644901197190434949442692233737598107738389930962131631795027128428");
      _points[24] = ct("0.1662050715215077754955928759549225525500957899853919033389963748850263839788521736378389887243452743");
      _weight[24] = ct("0.06724408184431729629610348227194436576417121590563488018244433962007116416697608344776265973965821892");
      _points[25] = ct("0.302539973775495358074098333008187919125959354053583216851150863022968872658500709858348412122672375");
      _weight[25] = ct("0.0694174006753446002943627136391517107293962502719934382621097138969527028293570715409689190762229163");
      _points[26] = ct("0.2084079478245644898876042894881013130324364643445421872994684928640539779603323923616045542186026246");
      _weight[26] = ct("0.06965864122232914783245525515766061197702074092320849650604718467156459693423628053637574476087616474");
      _points[27] = ct("0.2540312117051822502779332060989567717949333472202278170522577722830524357606964327183922476911471108");
      _weight[27] = ct("0.07035708558254015342678361194760470294443631209691896475761189284078684747935547051565534476561309205");
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = ct("0.9959272163607104691288374259807873291852593765446743146044815163863520054377631604148207633157846463");
      _weight[0] = ct("0.00005564241358714027532095053065803486490740943017680132607960936195006065033342071382225621345431696057");
      _points[1] = ct("0.9863904025392899117534861248015055941531051693629358191149649118720756782810516399238781644834428962");
      _weight[1] = ct("0.0003327279866112555094128006597084461188640953367772790824749440720953263498256535625988508076668608904");
      _points[2] = ct("0.9715246308559920866035488013575234119830975119551380701750238183981258606107602886980920135470270639");
      _weight[2] = ct("0.0009955114404107457036282987011420741036488422258616618973463593330141214449773470206395792824078634067");
      _points[3] = ct("0.9514939456164770559729801920265220261323300561844336714391207835992703432662113799732175447073914194");
      _weight[3] = ct("0.002187090029371519934764961921673762746149951990276364790288993358680005697151259428847928785250727178");
      _points[4] = ct("0.9265180152719407691275609266113728355764496137049103876779217996365555765482396657211416405901523585");
      _weight[4] = ct("0.004021182485231803386534230962943425794757388828963288314425169192269667107680391493129668817354327049");
      _points[5] = ct("0.8968705411002962316766114182292236819780119355812354874912319856093777036147736123027412055456563799");
      _weight[5] = ct("0.006575340169921764095135252527351854065836319905993192237496403188926387421135809555119496073796546306");
      _points[6] = ct("0.001605877852540094476677460267393333375715283616860331804506374382205905858795931071993942459642501275");
      _weight[6] = ct("0.008224759073026150013337165044732122149231177684820350074016830574690805752082382549994400699945455583");
      _points[7] = ct("0.86287636938624473396555917869022505651157506413871461457383706913436171402038290528480498534189686");
      _weight[7] = ct("0.009885829532976952297502565856123033463512360899385135623303387224673325024682566847647387741612482973");
      _points[8] = ct("0.8249079573005494156007944812292208906787416791393452824336661869940549234669086353363655173900752772");
      _weight[8] = ct("0.01394442666818688026059107376377405494209665104256295061957681177283639436450565135033828582964307838");
      _points[9] = ct("0.7833812996605872372611127878355374096893314804833155528966749287801062427902846865455568229607412141");
      _weight[9] = ct("0.01869728163635560116792048307870749321429571415331115426277003745924714046260312547581256186227275358");
      _points[10] = ct("0.008441948804031172691750305154270751359254642677660426647805634104208696641578312638825578741506269733");
      _weight[10] = ct("0.01892773329343349779572660522959708923603067512949384638213060568878587305185604042369878972842506566");
      _points[11] = ct("0.7387513739119412937894744959680884811212751986011720468957062635753622921833823658529018354675299005");
      _weight[11] = ct("0.02404591853972230935791201088077912861061979588079558439714543772093319758864057087945139003336009097");
      _points[12] = ct("0.02066193363615915476014353455675614888152234322370671862925378861418209355011390825531581969983189155");
      _weight[12] = ct("0.02913224977147369630435371509591788516497127738021211468364733144940634553044053378111820566832924059");
      _points[13] = ct("0.6915071564230854286671345510916194350973455194579840038960101517935299316600829866562060441590159543");
      _weight[13] = ct("0.02985034246189268703045850444863408825831084746850206015839821802101854257623979915267724844383865647");
      _points[14] = ct("0.6421662656731861238287974627913649707773183543080836828973314488493767488926898483696649824941938186");
      _weight[14] = ct("0.03593413059728592678232574595449670370924216522382692396538501302643477845479560527760392817593825342");
      _points[15] = ct("0.0381346969971121293156671304127122061908427724432955368922775580973517627701451337438444969457350822");
      _weight[15] = ct("0.03855192568110300992731787948569749686052539437629187659190769761585088614005755908990193666493402233");
      _points[16] = ct("0.5912692913707834829478765566234395995724095853348927353348565847908533092030035780849500293024165982");
      _weight[16] = ct("0.04209129631860883510580700101232906094913172520881469088463222892379855573154919991407642591976469689");
      _points[17] = ct("0.06066914207658226981904661707387973061339655888382338512792452002820457736488673316674820829450741823");
      _weight[17] = ct("0.04694309426636408371953486849927191064071717332656199572683966811401250472932076965764591751878827569");
      _points[18] = ct("0.5393738717727236992403103247034391839852566119036684134142180869297304990124736025268732863129619822");
      _weight[18] = ct("0.04809463546398829869371533562782688895220513580178416037071732542065284736437622845049166880340602575");
      _points[19] = ct("0.4870485841530376732703106931946815813887093165769280917756070969164567729544177022621628404883829681");
      _weight[19] = ct("0.05370519726261224517441839350484898995722099633288349579493820971087947368967875312163865815120067472");
      _points[20] = ct("0.08801845813988722465113256457750709714087466744915465606791769806360585010539787194938103623801238897");
      _weight[20] = ct("0.05410079186859844844367088474395607795687457881564928149255949744070610415755416273667872356483112521");
      _points[21] = ct("0.4348667153860257491398700432703089870432644535249158432053836873358514943003487504468549993874690005");
      _weight[21] = ct("0.05868247100441087283841989450493688012026853494073014267958587339102668812083850425895915857506469626");
      _points[22] = ct("0.1198830276848970432901164194721133615437473706091056747138979253876140849072260495061209040067929833");
      _weight[22] = ct("0.05986514983088954149802257556131410370145028546473926100037200780395276628373010490620581743371751677");
      _points[23] = ct("0.3833999809061070668784747580919607726984317643808177613142919854072677369249366817102831666846690371");
      _weight[23] = ct("0.06279484606213871827922785530254060818304508070323358845405923153953552222330567398669030144966779909");
      _points[24] = ct("0.1559137470843829473370606131417264220555557747384501978986829188400691312404561996585751299552473492");
      _weight[24] = ct("0.06412659178073493294015772905883242677694949119956667273898712010326479351329538109259913677016902762");
      _points[25] = ct("0.3332122608640143309721523536351177737981679593513508685203846408997852637001956485169227428186550926");
      _weight[25] = ct("0.0658298886821547883177566702200576302814581710102619073023532507225593633367576164581285422538752774");
      _points[26] = ct("0.1957158615701235346271845355727618654403065491060100053893129052945034633900434287495630167925552728");
      _weight[26] = ct("0.06682903797752355680708798131643143756002374157820628443355072911779172499539671165753842492171865239");
      _points[27] = ct("0.2848534221035185149516172379240780825714158061355885118736472933422323566101288260175500745175553813");
      _weight[27] = ct("0.06760398471965420388414470001461319453931749237342308586790232501846019357132809543458076331263868046");
      _points[28] = ct("0.2388532936333663745936940565623196065759316483784380767855858606661415400153543649197279531138628582");
      _weight[28] = ct("0.06797092298173053445579386649110409707833752628689484884710968363254660466586108170267586036152601854");
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = ct("0.9961854092532896146028221753356389314404324408686493792874214932610240703762534389970414536663528984");
      _weight[0] = ct("0.00004881538648506998360388173728839473046687594331829239051542362498444876128405787257610641121435982496");
      _points[1] = ct("0.987250587966732915704867341539757607126329624210631340190097603536590860456898711558078237762728568");
      _weight[1] = ct("0.0002920824818819113533365390766918036968638135004181526130531057784590465269274888973274707688805240154");
      _points[2] = ct("0.9733158613935448794453820105491724343356720246202466373654937709136522090881131218997332838292498842");
      _weight[2] = ct("0.0008747452449452054528434345545792328394990878028984125283749635749400441660481138993949777526144453479");
      _points[3] = ct("0.954525315743250196891212405909841651664193121330522964818769451712885974883692851607198562628294405");
      _weight[3] = ct("0.00192432146563680853039780262267058084934464281296702761384700340884737221497115728721168215653477519");
      _points[4] = ct("0.9310719621711364212548285011966173256931864130262399049310424572383352311872885421014229760611693296");
      _weight[4] = ct("0.003544057111846242578449714083482700968747522670541078730791206739367707904169668505907464731859013099");
      _points[5] = ct("0.9031965197235615179874486945867351160142948387890865854781167311755796735993819800971467684400464672");
      _weight[5] = ct("0.005807197046687551242251792528986641465603517512649975600107358331114246119583995371657609253148391519");
      _points[6] = ct("0.001503977326638774096538941045439819204897050842323639110517193282528933882651248791240534017615526382");
      _weight[6] = ct("0.007703907526677142332781611057875534544819793506537816162172648136598926396897833220321164234763843774");
      _points[7] = ct("0.8711850490619494505257748373786477444812674413535150966051762168128661783132891618825618402191055982");
      _weight[7] = ct("0.008752554092761193897920666189535675116315443555815723285447313014922448847745255648780050131576355236");
      _points[8] = ct("0.8353660404570975782088039706260406779943814651902810216421804120682862030815465101588411782330872668");
      _weight[8] = ct("0.01238157096505112882609671713082506468468716145623744445894400365087184337768244738355009213416501403");
      _points[9] = ct("0.7961070500327450999963466408130769909254065823786988072990704501299103077656532538035315934328438486");
      _weight[9] = ct("0.01665700904270025006653225825818748132054069181447553844487836536226341303293367295386176749150289439");
      _points[10] = ct("0.007907415319962090553874910548706797889640929395624179523081760110455578957554042677725283477454649201");
      _weight[10] = ct("0.01774200002910266224241589398107510122653617419432137008802265042177278051968609016670453221518424845");
      _points[11] = ct("0.7538109306754931985292676380937912950273016582300685379467850951928081223373494944028470408186327805");
      _weight[11] = ct("0.02150333048441228769833753851508196766124541500331822808509520438345824079506333418293329410470080059");
      _points[12] = ct("0.7089116992693157344021296505007320277178336913754735555904081981587657489227382458808600070143245976");
      _weight[12] = ct("0.02680876976084624127714802836523064146869361267096646765712817819486360367453807577343673561893162335");
      _points[13] = ct("0.01935870848902583784855403050288221797598668568969896998662158485432325673456693050224134370338878558");
      _weight[13] = ct("0.02734323769023239623194332571355552815906192296906783687662345184113901926590361524395191648538035178");
      _points[14] = ct("0.6618700835772073917491354419849632203892530088735732812563719385176190205613534846026225511037711621");
      _weight[14] = ct("0.03242902027054050043405269502953432501755780381155927730280438058383449132894536615575943817616581525");
      _points[15] = ct("0.03574292537490614361442355505910787775634862347975856384163644336736875759787627385072751815153740946");
      _weight[15] = ct("0.03625397463788723790524483974173847020917492065787212600840108277078063463761026436450175975946083963");
      _points[16] = ct("0.6131687947901146656740818993889533163504756553625524311289854346046812852781127326882590856590079547");
      _weight[16] = ct("0.03819239423170725851575184801695770825061515968304590598855971096584248504449023211886317255778801667");
      _points[17] = ct("0.5633075743824562981501263532733843048016241869169987473593829812419401409863189611028075333329458588");
      _weight[17] = ct("0.04390625227933978568080902602950186417843079234280225955367345367601986305141065089129071180428246366");
      _points[18] = ct("0.05689225853525516679821004110599804301611377083656079546200661056446482284527669656096891945940680971");
      _weight[18] = ct("0.04425731927748618287257948334671876202437120287511051701022472597796561585699259418942874447794983731");
      _points[19] = ct("0.5127980661561916817746887451598282918401125275994180446481874937657033611674660693401318099368063618");
      _weight[19] = ct("0.04936444568948249182271354202432237836841853506199668047436650095508669478549848818479903009284566956");
      _points[20] = ct("0.08258976331894715037611720235316913189397065646611817204648742992390166397107742163078245234741296826");
      _weight[20] = ct("0.05116849259793773961536020333387403840090728696787416722400025316316297583997339266789880587685716188");
      _points[21] = ct("0.4621585661189246886540277907231243106393062489018270745431532167413125006992428964361637064261870771");
      _weight[21] = ct("0.05435547110670841272312359308648180196145265254699122138675635302555438086361230585239049569790033029");
      _points[22] = ct("0.112571774110936611053694579518741087338027646767961081329743508651370777248795257348659213291718789");
      _weight[22] = ct("0.0568401843945930875022309199510318410662194983414264632830750229803768435128288250456115058327183983");
      _points[23] = ct("0.4119087040813242226237090428292506153631763321335100527625422039405211351297361868627226093733969804");
      _weight[23] = ct("0.05867100684562144938879531538437321203226400947228654914597314289823584855733418457124886247351885538");
      _points[24] = ct("0.1465306454397049070797253669507133675863970812842654082165416081846888928125469797956253712673911181");
      _weight[24] = ct("0.06116708587574294585708384600511210723249655869946088776193334346188726348364913454224787676895355881");
      _points[25] = ct("0.3625641115525919243603237735395555249376544784701360196082102632275515462910475713276721125086440228");
      _weight[25] = ct("0.06211448255080993935299302013223286515895217681731822651599307938155060303705561438986736826779035532");
      _points[26] = ct("0.1841179183174382295159362040481778712255751073163280436744486781128841767238309332184203445772649971");
      _weight[26] = ct("0.06408887558478726966987172952929198476290145444949765876320874448844505401660613395137922016487293419");
      _points[27] = ct("0.3146311306484368093477133152707186848865010512147554712673141128875662531347957837834036041944222118");
      _weight[27] = ct("0.06450933095755145680015534470844576452895509725364825086687152102043276408899255479082363409045853491");
      _points[28] = ct("0.2249478990674261230239659038071794671177427343701348684130225163163224666208835088859070269965705134");
      _weight[28] = ct("0.06559148352964400742074101780590288922762063110608826979290732662425384779750749352007854814383952964");
      _points[29] = ct("0.2686016183001323810743018232453001490062411850001232918802978956024515050823666262374429233151227997");
      _weight[29] = ct("0.06570658184089414272443437205941363884723654449948817438625048156296749249405795825047760374282482709");
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = ct("0.9964198154713465863814005035441978010799044283122436703650320561453919687873406872890135672702316458");
      _weight[0] = ct("0.00004300369105210562692826370639121461833320652605667711416578738547360188460016161941716611831833587364");
      _points[1] = ct("0.9880318304951722914880530368106836749146235982824393858168425335568924461010604907917735038470862901");
      _weight[1] = ct("0.0002574514681284442266230751751507317607746199866536766321397160733033418132062271462470548959235436023");
      _points[2] = ct("0.9749437042544240163360031479159922744282696526039622177198702095339328818125350799450505594531097618");
      _weight[2] = ct("0.0007717057396996697641517258768670426827188915944192573597223229681262995542318343942265362056001387414");
      _points[3] = ct("0.9572825118149126493832813913549764982221829460675596349535989927608206332156385580989282616880613246");
      _weight[3] = ct("0.00169969018272393218254041765280551133219705363301035677082391746333472054338783832375495304115262724");
      _points[4] = ct("0.9352185227478344903005635619837840093875008866261301248284230002913241844856789158446614001940347283");
      _weight[4] = ct("0.003135161039546822021790675745981601732773492778297033598408165845484191268636204404626888163907635763");
      _points[5] = ct("0.9089642777365259832428053473898178551206481174446911746120405937208542772309144429777671577360346158");
      _weight[5] = ct("0.005146855981905776970511696158170320994675246401119572219172360040145011608975207596344947769210658964");
      _points[6] = ct("0.001411475965443800134825651358139039341956298466719277973633838444099651944102671436345461185232959835");
      _weight[6] = ct("0.007230975650216755624745604235452245279656002216723509408307916172060648702594299051622707208973025844");
      _points[7] = ct("0.8787726390975521425669806413071461215080266752415391212208380529932518479277636784487635052985135871");
      _weight[7] = ct("0.0077746591068403809703585541633919208182299537947198423202384641651753902336505509239560671215301708");
      _points[8] = ct("0.8449343774921062514064287344919565431900271420193003901458878575147974746179949038330386644409125033");
      _weight[8] = ct("0.0110269395456367302862777382302981553927566333560509275458448854279203254075501907732773782637812124");
      _points[9] = ct("0.8077753782079414862781562853347802220882808558955060482906917367586304344645833319010154104094802443");
      _weight[9] = ct("0.01487917669239610535935110809974107459177779203087820996598630854524461789174475235354270098848842731");
      _points[10] = ct("0.007422051826455695999029982273149380199843648470952244242156277596152147491323816744840604628235024314");
      _weight[10] = ct("0.01666384739763897032812241273494349301940479298727467776618499701123988004490992571717846310005239696");
      _points[11] = ct("0.7676535050807021900513946022822988218884222022947288784940173065942976001602180565188762480511487887");
      _weight[11] = ct("0.01927393500347561210274414657736369528739716154850885294306403397770541527835430503292412077877843752");
      _points[12] = ct("0.724955155054066052909185099237878881084330552561552842546850981707460790693381057457479986132086864");
      _weight[12] = ct("0.024122198648856929845540272680044765145707133412858515109112454837530783184804667781896838708612533");
      _points[13] = ct("0.01817476909526580384371084818030880219026844158254025954136291598091552233243165652620126345900753569");
      _weight[13] = ct("0.02571233502559233962916487514592441336832695124269937897406163393750519114984932164320084145245725209");
      _points[14] = ct("0.680091537418071236704477829714537714512091984669183389020551342806291946956036957137269710642400284");
      _weight[14] = ct("0.02930602312747382029070259723856409204900613580780841178372978455996881359391922812877220700604353425");
      _points[15] = ct("0.03356848869388057760203511836733933006131679408286549627645855414122872018381444995169640476649594173");
      _weight[15] = ct("0.0341509712866015141155229335940271146524226007444312712197754887548547987319766790888766616421082058");
      _points[16] = ct("0.6334947138634949003275653909484439122889862153213787389931455390854347121392448677482017219298371185");
      _weight[16] = ct("0.03468240935401616737828159765451323084923611155594248045105379003407352239380156383657820936225743249");
      _points[17] = ct("0.5856134376099925987278912540897165142616026682924333001806921183223956634540653543769719960785603365");
      _weight[17] = ct("0.04008825767952754596264770738045083066907786976512135760856103031172796742597777430196433932228157271");
      _points[18] = ct("0.05345525785126260801052035243425137799376937217185000461579500643018915955451401268677204289733892771");
      _weight[18] = ct("0.04178617160801825992915658801875977837905592813985782271826046732639763824111240551941946659502975067");
      _points[19] = ct("0.5369088317321095914497342490074296657907384825367613041415625936691425061246625821704741521455568662");
      _weight[19] = ct("0.04534621667933985881749779656727066820681662775058860556728564399850914215218638600268285241138664089");
      _points[20] = ct("0.07764362749241415095123711981229508670423849074450172141610710630224628092431498413286873936044139503");
      _weight[20] = ct("0.04845115329628569641400235641488049317751856187046068419552911791551587187988711064185529431040869095");
      _points[21] = ct("0.4878499483276243221234259221844367644251247402658100645076118919224730288083968168335729128892347285");
      _weight[21] = ct("0.05027120597876520794900410958133807051720717588961402097129758603339362629583444196959462479095184526");
      _points[22] = ct("0.1059006743507898902323150186915157844736889361974601035488644790649877832087183842561556969859190848");
      _weight[22] = ct("0.05401042910942297169606643634238107289080557340412569681213873962182967211009544484175484319162796908");
      _points[23] = ct("0.4389092513075168270421572355375920326554093292760278491838960877415263051727169311927625190648144359");
      _weight[23] = ct("0.05467736526761173539523204053682411291515305478198601616271701663699064504367567004571196515961782481");
      _points[24] = ct("0.1379542774855552447128780719326255863550668361596339433657214819259907437335908860511917486878175547");
      _weight[24] = ct("0.05836375229138350624160086990362615338239160080471286336192335984386192265975526908968401649778295166");
      _points[25] = ct("0.3905580663160595481669443532255889640119739535291665391197508692095761083793683382818158071394605711");
      _weight[25] = ct("0.05838516403304980397938236524245392855998127762199298477601893806562625801132740459692252467239128363");
      _points[26] = ct("0.3432620416022793630998090225239495403051757556793224800045295652949384229369749325747176898568972359");
      _weight[26] = ct("0.06122839910606623016083516397607929712359889718041574971984734730807128531033074166688103903283101319");
      _points[27] = ct("0.1734957478467754419324204886538899820795596100969803016910279626820120007603979994054583834071865742");
      _weight[27] = ct("0.06144885509138399963208906732313442111944660705453147856358092910024558128442404871634707719902707542");
      _points[28] = ct("0.2974766635554075645053147462633574325365810656072451302443779042064099713369581234883434685332375287");
      _weight[28] = ct("0.06306081016811023815063366225055830973064193329943389248977312015799791678018878924264416822426470029");
      _points[29] = ct("0.2121828040888040191351780039348599803712580510768313825900253541385619933886307214449555348905033587");
      _weight[29] = ct("0.06324282395146252460962228399357097064629451333929175881113071479705576514084592429465797579309071398");
      _points[30] = ct("0.2536428700864666432082452431813143747831005223909369486026040434260267599265945644212698451850904382");
      _weight[30] = ct("0.06376205679777034433887185779904126910661659948041441706014396168363015437816563331764831665085087739");
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }


  template<typename ct>
  Jacobi1QuadratureRule<ct,1>::Jacobi1QuadratureRule (int p)
      : QuadratureRule<ct,1>(GeometryTypes::line)
  {
    //! set up quadrature of given order in d dimensions
    std::vector< FieldVector<ct,1> > _points;
    std::vector< ct > _weight;

    int deliveredOrder_;

    Jacobi1QuadratureInitHelper<ct>::init(p, _points, _weight, deliveredOrder_);

    this->delivered_order = deliveredOrder_;
    assert(_points.size() == _weight.size());
    for (size_t i = 0; i < _points.size(); i++)
      this->push_back(QuadraturePoint<ct,1>(_points[i], _weight[i]));
  }

} // namespace Dune

#endif // DUNE_GEOMETRY_QUADRATURE_Jacobi1_HH
