# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTeamMemberResult',
    'AwaitableGetTeamMemberResult',
    'get_team_member',
    'get_team_member_output',
]

@pulumi.output_type
class GetTeamMemberResult:
    """
    A collection of values returned by getTeamMember.
    """
    def __init__(__self__, custom_roles=None, email=None, first_name=None, id=None, last_name=None, role=None):
        if custom_roles and not isinstance(custom_roles, list):
            raise TypeError("Expected argument 'custom_roles' to be a list")
        pulumi.set(__self__, "custom_roles", custom_roles)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="customRoles")
    def custom_roles(self) -> Sequence[str]:
        return pulumi.get(self, "custom_roles")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The team member's given name.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The 24 character alphanumeric ID of the team member.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The team member's family name.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role associated with team member. Possible roles are `owner`, `reader`, `writer`, or `admin`.
        """
        return pulumi.get(self, "role")


class AwaitableGetTeamMemberResult(GetTeamMemberResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamMemberResult(
            custom_roles=self.custom_roles,
            email=self.email,
            first_name=self.first_name,
            id=self.id,
            last_name=self.last_name,
            role=self.role)


def get_team_member(email: Optional[str] = None,
                    id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamMemberResult:
    """
    Provides a LaunchDarkly team member data source.

    This data source allows you to retrieve team member information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_team_member(email="example@example.com")
    ```


    :param str email: The unique email address associated with the team member.
    :param str id: The 24 character alphanumeric ID of the team member.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getTeamMember:getTeamMember', __args__, opts=opts, typ=GetTeamMemberResult).value

    return AwaitableGetTeamMemberResult(
        custom_roles=__ret__.custom_roles,
        email=__ret__.email,
        first_name=__ret__.first_name,
        id=__ret__.id,
        last_name=__ret__.last_name,
        role=__ret__.role)


@_utilities.lift_output_func(get_team_member)
def get_team_member_output(email: Optional[pulumi.Input[str]] = None,
                           id: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTeamMemberResult]:
    """
    Provides a LaunchDarkly team member data source.

    This data source allows you to retrieve team member information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_team_member(email="example@example.com")
    ```


    :param str email: The unique email address associated with the team member.
    :param str id: The 24 character alphanumeric ID of the team member.
    """
    ...
