# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomRoleArgs', 'CustomRole']

@pulumi.input_type
class CustomRoleArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 base_permissions: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]] = None):
        """
        The set of arguments for constructing a CustomRole resource.
        :param pulumi.Input[str] key: The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] base_permissions: The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        :param pulumi.Input[str] description: The description of the custom role.
        :param pulumi.Input[str] name: The human-readable name for the custom role.
        :param pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]] policy_statements: The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        pulumi.set(__self__, "key", key)
        if base_permissions is not None:
            pulumi.set(__self__, "base_permissions", base_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policies is not None:
            warnings.warn("""'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""", DeprecationWarning)
            pulumi.log.warn("""policies is deprecated: 'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""")
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if policy_statements is not None:
            pulumi.set(__self__, "policy_statements", policy_statements)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="basePermissions")
    def base_permissions(self) -> Optional[pulumi.Input[str]]:
        """
        The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        """
        return pulumi.get(self, "base_permissions")

    @base_permissions.setter
    def base_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_permissions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the custom role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name for the custom role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]]:
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]]:
        """
        The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        return pulumi.get(self, "policy_statements")

    @policy_statements.setter
    def policy_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]]):
        pulumi.set(self, "policy_statements", value)


@pulumi.input_type
class _CustomRoleState:
    def __init__(__self__, *,
                 base_permissions: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]] = None):
        """
        Input properties used for looking up and filtering CustomRole resources.
        :param pulumi.Input[str] base_permissions: The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        :param pulumi.Input[str] description: The description of the custom role.
        :param pulumi.Input[str] key: The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-readable name for the custom role.
        :param pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]] policy_statements: The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        if base_permissions is not None:
            pulumi.set(__self__, "base_permissions", base_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policies is not None:
            warnings.warn("""'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""", DeprecationWarning)
            pulumi.log.warn("""policies is deprecated: 'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""")
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if policy_statements is not None:
            pulumi.set(__self__, "policy_statements", policy_statements)

    @property
    @pulumi.getter(name="basePermissions")
    def base_permissions(self) -> Optional[pulumi.Input[str]]:
        """
        The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        """
        return pulumi.get(self, "base_permissions")

    @base_permissions.setter
    def base_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_permissions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the custom role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name for the custom role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]]:
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]]:
        """
        The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        return pulumi.get(self, "policy_statements")

    @policy_statements.setter
    def policy_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRolePolicyStatementArgs']]]]):
        pulumi.set(self, "policy_statements", value)


class CustomRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_permissions: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyArgs']]]]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyStatementArgs']]]]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly custom role resource.

        > **Note:** Custom roles are available to customers on an Enterprise LaunchDarkly plan. To learn more, read about our pricing. To upgrade your plan, [contact LaunchDarkly Sales](https://launchdarkly.com/contact-sales/).

        This resource allows you to create and manage custom roles within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.CustomRole("example",
            description="This is an example role",
            key="example-role-key-1",
            policy_statements=[
                launchdarkly.CustomRolePolicyStatementArgs(
                    actions=["*"],
                    effect="allow",
                    resources=["proj/*:env/production:flag/*"],
                ),
                launchdarkly.CustomRolePolicyStatementArgs(
                    actions=["*"],
                    effect="allow",
                    resources=["proj/*:env/production"],
                ),
            ])
        ```

        ## Import

        You can import LaunchDarkly custom roles by using an existing custom role `key`. For example

        ```sh
         $ pulumi import launchdarkly:index/customRole:CustomRole example example-role-key-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_permissions: The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        :param pulumi.Input[str] description: The description of the custom role.
        :param pulumi.Input[str] key: The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-readable name for the custom role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyStatementArgs']]]] policy_statements: The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly custom role resource.

        > **Note:** Custom roles are available to customers on an Enterprise LaunchDarkly plan. To learn more, read about our pricing. To upgrade your plan, [contact LaunchDarkly Sales](https://launchdarkly.com/contact-sales/).

        This resource allows you to create and manage custom roles within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.CustomRole("example",
            description="This is an example role",
            key="example-role-key-1",
            policy_statements=[
                launchdarkly.CustomRolePolicyStatementArgs(
                    actions=["*"],
                    effect="allow",
                    resources=["proj/*:env/production:flag/*"],
                ),
                launchdarkly.CustomRolePolicyStatementArgs(
                    actions=["*"],
                    effect="allow",
                    resources=["proj/*:env/production"],
                ),
            ])
        ```

        ## Import

        You can import LaunchDarkly custom roles by using an existing custom role `key`. For example

        ```sh
         $ pulumi import launchdarkly:index/customRole:CustomRole example example-role-key-1
        ```

        :param str resource_name: The name of the resource.
        :param CustomRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_permissions: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyArgs']]]]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyStatementArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomRoleArgs.__new__(CustomRoleArgs)

            __props__.__dict__["base_permissions"] = base_permissions
            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            if policies is not None and not opts.urn:
                warnings.warn("""'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""", DeprecationWarning)
                pulumi.log.warn("""policies is deprecated: 'policy' is now deprecated. Please migrate to 'policy_statements' to maintain future compatability.""")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["policy_statements"] = policy_statements
        super(CustomRole, __self__).__init__(
            'launchdarkly:index/customRole:CustomRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_permissions: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyArgs']]]]] = None,
            policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyStatementArgs']]]]] = None) -> 'CustomRole':
        """
        Get an existing CustomRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_permissions: The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        :param pulumi.Input[str] description: The description of the custom role.
        :param pulumi.Input[str] key: The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        :param pulumi.Input[str] name: The human-readable name for the custom role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CustomRolePolicyStatementArgs']]]] policy_statements: The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomRoleState.__new__(_CustomRoleState)

        __props__.__dict__["base_permissions"] = base_permissions
        __props__.__dict__["description"] = description
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["policies"] = policies
        __props__.__dict__["policy_statements"] = policy_statements
        return CustomRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="basePermissions")
    def base_permissions(self) -> pulumi.Output[Optional[str]]:
        """
        The base permission level. Either `reader` or `no_access`. Defaults to `reader` if not set.
        """
        return pulumi.get(self, "base_permissions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the custom role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The unique key that references the custom role. A change in this field will force the destruction of the existing resource and the creation of a new one.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name for the custom role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence['outputs.CustomRolePolicy']]]:
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> pulumi.Output[Optional[Sequence['outputs.CustomRolePolicyStatement']]]:
        """
        The custom role policy block. To learn more, read [Policies in custom roles](https://docs.launchdarkly.com/docs/policies-in-custom-roles).
        """
        return pulumi.get(self, "policy_statements")

