# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pylfg', 'pylfg.TUI', 'pylfg.WebUI', 'pylfg.WebUI.views', 'pylfg.transfer']

package_data = \
{'': ['*'],
 'pylfg.WebUI': ['templates/*'],
 'pylfg.transfer': ['transfer_rules/*']}

install_requires = \
['PlyPlus>=0.7.5,<0.8.0',
 'click>=8.1.3,<9.0.0',
 'fastapi>=0.89.1,<0.90.0',
 'matplotlib>=3.6.3,<4.0.0',
 'networkx>=3.0,<4.0',
 'rich>=13.3.1,<14.0.0',
 'textual-imageview>=0.1.1,<0.2.0',
 'textual>=0.10.1,<0.11.0']

setup_kwargs = {
    'name': 'pylfg',
    'version': '0.1.1a0',
    'description': 'PyLFG is a Python library for working within the Lexical Functional Grammar (LFG) formalism. It provides a set of classes and methods for representing and manipulating LFG structures, including lexical functional structures (f-structures) and c-structures.',
    'long_description': 'PyLFG - A Python package for parsing sentences using Lexical Functional Grammar (LFG)\n=====================================================================================\n\nIntroduction\n------------\n\nPyLFG (Python Library for Lexical Functional Grammar) is a new\nopen-source project that aims to provide a comprehensive set of tools\nfor working within the Lexical Functional Grammar (LFG) formalism. LFG\nis a syntactic theory that represents the structure of natural language\nusing a combination of lexical and functional information. This project\nprovides a set of classes and methods for representing and manipulating\nLFG structures, including lexical functional structures (f-structures)\nand c-structures.\n\nPyLFG’s primary goal is to make LFG research more accessible to a wider\ncommunity by providing a fully modular library that allows researchers\nto easily try new ideas and improve existing ones. The library will not\nonly parse sentences but also generate sentences from f-structures, and\nit will have transfer capabilities to do automated translation.\n\nPyLFG is also designed to be user-friendly, providing both a TUI\n(Terminal User Interface) and a WebUI for easy interaction. The library\nbeing written in Python makes it perfectly suited for linguistics\nstudents who are taught Python in university.\n\nThe lack of open-source LFG parsers is a significant problem in the\nfield of linguistics research. Many academically developed LFG parsers\nhave been abandoned by their authors, making them inaccessible to the\nwider community. This is a major obstacle for researchers who are\ninterested in studying LFG, as they are often forced to rely on\nproprietary software that is difficult to access and modify.\n\nThe open-source nature of PyLFG is crucial in addressing this problem.\nBy providing an open-source LFG parser, PyLFG aims to make LFG research\nmore accessible to a wider community, allowing researchers to easily try\nnew ideas and improve existing ones. The ability to view and modify the\nsource code of the library also allows for greater transparency and\nreproducibility in research, which is essential for the advancement of\nknowledge.\n\nMoreover, PyLFG’s open-source nature allows for collaboration and\ncontributions from the wider community. This can lead to the development\nof new features and improvements in the library, making it a valuable\ntool for linguistics students and professors, language learning\napplications, and documenting under-resourced languages.\n\nOpen science is the best way of spreading and furthering knowledge, and\nPyLFG aims to contribute to this goal by providing a valuable tool that\ncan be used by researchers and practitioners alike. The open-source\nnature of PyLFG will ensure that it is accessible to anyone who is\ninterested in studying LFG, making it an essential tool for advancing\nknowledge in the field of linguistics.\n\nImportant note\n~~~~~~~~~~~~~~\n\nPyLFG is still in early development and has not yet reached a stable\nrelease state.\n\nFeatures\n--------\n\nPyLFG is designed to be a comprehensive tool for working within the\nLexical Functional Grammar (LFG) formalism, providing a range of\nfeatures that make it a valuable tool for researchers and practitioners\nalike.\n\n-  Modularity: PyLFG is fully modular, allowing researchers to easily\n   replace all parts of the LFG parsing pipeline, from tokenizing\n   sentences to the rich visualizations of the x-structures. This allows\n   for flexibility in trying new ideas and improving existing ones,\n   making it a valuable tool for advancing knowledge in the field of\n   linguistics.\n-  Parsing and generation: PyLFG is not only able to parse sentences but\n   also generate sentences from f-structures, which is an essential\n   capability for automated translation and language learning\n   applications.\n-  Transfer capabilities: PyLFG has transfer capabilities which allow it\n   to do automated translation between languages, making it a useful\n   tool for researchers and practitioners working on natural language\n   processing.\n-  User-friendly interface: PyLFG provides both a TUI (Terminal User\n   Interface) and a WebUI for easy interaction, making it accessible to\n   a wide range of users, including students and professors who are\n   taught Python in university.\n-  Open-source: PyLFG is an open-source project, meaning that the source\n   code is freely available for anyone to view and modify. This allows\n   for greater transparency and reproducibility in research, and also\n   enables collaboration and contributions from the wider community.\n-  Suitable for linguistics students and professors: PyLFG is written in\n   Python, which is a widely used programming language in the field of\n   linguistics research. This makes it perfectly suited for linguistics\n   students and professors, as well as python programmers in general.\n-  Valuable tool for documenting under-resourced languages: PyLFG\n   provides a valuable tool for documenting under-resourced languages,\n   which is essential for preserving and studying these languages.\n\nIn summary, PyLFG is a comprehensive and user-friendly open-source tool\nthat provides a range of features that make it valuable for linguistics\nstudents and professors, language learning applications, and documenting\nunder-resourced languages.\n\nUse Cases\n---------\n\nPyLFG can be used in a variety of applications, making it a valuable\ntool for researchers and practitioners working in a range of fields.\nSome of the key use cases include:\n\n-  Linguistics research: PyLFG is a valuable tool for linguistics\n   students and professors who study syntactic theories. It can be used\n   to parse sentences and generate f-structures, which can be used to\n   test hypotheses and advance knowledge in the field.\n-  Language learning applications: PyLFG’s ability to generate sentences\n   from f-structures makes it a useful tool for language learning\n   applications. It can be used to generate grammatically correct\n   sentences for language learners to practice, and its transfer\n   capabilities can also be used to translate between languages.\n-  Documenting under-resourced languages: PyLFG’s ability to parse and\n   generate sentences makes it a valuable tool for documenting\n   under-resourced languages. It can be used to create grammatically\n   correct sentences for use in language dictionaries and phrasebooks,\n   and its transfer capabilities can also be used to translate between\n   languages.\n-  Natural language processing: PyLFG’s transfer capabilities and\n   ability to generate sentences from f-structures make it a valuable\n   tool for researchers and practitioners working on natural language\n   processing. It can be used to automate the translation of sentences\n   between languages, which has a wide range of applications, such as\n   machine translation and language-based search engines.\n-  Language-based search engines: PyLFG can be used to generate\n   f-structures, which can be used to create grammatically correct\n   sentences for use in language-based search engines. This makes it a\n   valuable tool for researchers and practitioners working in this\n   field.\n\nIn summary, PyLFG is a versatile tool that can be used in a wide range\nof applications, making it a valuable tool for researchers and\npractitioners working in linguistics, language learning, natural\nlanguage processing, and language-based search engines.\n\nTechnical Details\n-----------------\n\nPyLFG’s architecture is divided into five main components:\n\n-  Tokenization: PyLFG uses the NLTK library to tokenize sentences. This\n   allows users to tokenize sentences in multiple languages, including\n   English, Spanish, French, and German.\n-  Morphological Analysis: PyLFG uses a morphological analyzer to\n   identify the base forms of words and their grammatical properties.\n   This is an important step in the LFG parsing process, as it provides\n   the necessary information for generating f-structures.\n-  Parsing: PyLFG uses a modified version of the C-Structure Earley\n   parser to parse sentences and generate f-structures. This parser is\n   based on the Earley algorithm, which is a top-down parsing algorithm\n   that is well-suited for parsing context-free grammars.\n-  C-Structure and F-Structure Construction: PyLFG uses the information\n   obtained from tokenization and morphological analysis to construct\n   both C-structures and F-structures. These structures represent the\n   syntactic and functional properties of sentences, respectively.\n-  Visualization: PyLFG uses the Graphviz library to visualize\n   f-structures. This allows users to create rich visualizations of\n   f-structures, making it easy to understand and analyze the structures\n   generated by the parser.\n\nIn addition, PyLFG also provides a TUI (Terminal User Interface) and a\nWebUI (Web User Interface) which makes it easy for users to interact\nwith the library, parse sentences and visualize the f-structures\n\nPyLFG is written in Python, which means users of the library can\nleverage the wide range of libraries and frameworks available in Python,\nsuch as NLTK and Spacy, which makes it a powerful and flexible tool for\nworking with LFG structures.\n\nContributing\n------------\n\nPyLFG is an open-source project and we welcome contributions from the\ncommunity. There are several ways to contribute, including:\n\n-  Reporting bugs: If you find a bug in PyLFG, please report it on the\n   GitHub issue tracker. Be sure to include as much information as\n   possible, such as the version of PyLFG you are using, the steps to\n   reproduce the bug, and any error messages you received.\n-  Suggesting features: If you have an idea for a new feature in PyLFG,\n   please suggest it on the GitHub issue tracker. Be sure to include as\n   much detail as possible about the feature, including any relevant use\n   cases or examples.\n-  Writing code: If you would like to contribute code to PyLFG, please\n   fork the repository on GitHub and submit a pull request. Be sure to\n   follow the existing code style, and include tests and documentation\n   for your changes.\n-  Documentation: If you find any errors or inconsistencies in the\n   documentation, or would like to suggest improvements, please let us\n   know on the GitHub issue tracker.\n-  Examples: If you have examples of using PyLFG in your research or\n   projects, we would love to hear about them and feature them in the\n   documentation.\n\nWe are looking forward to hearing from you and working together to\nimprove PyLFG. Thank you for considering to contribute to this project!\n\nPlease also note that by contributing to this project, you agree to\nabide by our code of conduct.\n\nConclusion\n----------\n\nPyLFG is a powerful open-source Python library for working within the\nLexical Functional Grammar (LFG) formalism. It provides a comprehensive\nset of classes and methods for representing and manipulating LFG\nstructures, including lexical functional structures (f-structures) and\nc-structures. With its modular design, PyLFG allows researchers to\neasily experiment with new ideas and customize their LFG parsing\npipeline.\n\nBy making PyLFG open-source, we aim to contribute to the goal of open\nscience and the spread and advancement of knowledge in the field of\nlinguistics.\n\nWe invite the community to contribute to the development of PyLFG by\nreporting bugs, suggesting new features, writing code, improving\ndocumentation and sharing examples of using PyLFG. We are looking\nforward to working together to improve PyLFG and make it an even more\npowerful tool for researchers in the field of linguistics.\n\nUsage\n-----\n\nThe package provides helper functions for loading grammar rules and\nlexicon from files, and a ``LFGParseTree`` and ``LFGParseTreeNode``\nclass for representing and visualizing parse trees. Here is an example\nof how to use the package:\n\n.. code:: python\n\n   from pylfg import build_parse_trees\n\n\n   sentence = "the cat sits on the mat"\n\n   # load grammar and lexicon\n   grammar = load_grammar("path/to/grammar.txt")\n   lexicon = load_lexicon("path/to/lexicon.txt")\n\n   # parse sentence\n   trees = build_parse_trees(sentence, grammar, lexicon)\n\n   # print the first parse tree\n   print(trees[0])\n\nYou can also use the LFGParseTree.to_f_structure method to export the\nf-structure of the sentence in latex format, as shown in this example\n\n.. code:: python\n\n   f_structure = trees[0].to_f_structure()\n\n   # write f-structure to a latex file\n   with open("f_structure.tex", "w") as f:\n       f.write(f_structure)\n',
    'author': 'SekouDiaoNlp',
    'author_email': 'diao.sekou.nlp@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
