"""
Class object for AIOGitHubAPIRepositoryPullrequest
Documentation: https://docs.github.com/en/rest/reference/pulls#get-a-pull-request

Generated by generate/generate.py - 2020-08-02 10:03:59.857088
"""
from aiogithubapi.objects.base import AIOGitHubAPIBase


class User(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class Labels(AIOGitHubAPIBase):
    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def description(self):
        return self.attributes.get("description", "")

    @property
    def color(self):
        return self.attributes.get("color", "")

    @property
    def default(self):
        return self.attributes.get("default", True)


class MilestoneCreator(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class Milestone(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def labels_url(self):
        return self.attributes.get("labels_url", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def number(self):
        return self.attributes.get("number", None)

    @property
    def state(self):
        return self.attributes.get("state", "")

    @property
    def title(self):
        return self.attributes.get("title", "")

    @property
    def description(self):
        return self.attributes.get("description", "")

    @property
    def creator(self):
        return MilestoneCreator(self.attributes.get("creator", {}))

    @property
    def open_issues(self):
        return self.attributes.get("open_issues", None)

    @property
    def closed_issues(self):
        return self.attributes.get("closed_issues", None)

    @property
    def created_at(self):
        return self.attributes.get("created_at", "")

    @property
    def updated_at(self):
        return self.attributes.get("updated_at", "")

    @property
    def closed_at(self):
        return self.attributes.get("closed_at", "")

    @property
    def due_on(self):
        return self.attributes.get("due_on", "")


class Assignee(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class Assignees(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class RequestedReviewers(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class RequestedTeams(AIOGitHubAPIBase):
    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def slug(self):
        return self.attributes.get("slug", "")

    @property
    def description(self):
        return self.attributes.get("description", "")

    @property
    def privacy(self):
        return self.attributes.get("privacy", "")

    @property
    def permission(self):
        return self.attributes.get("permission", "")

    @property
    def members_url(self):
        return self.attributes.get("members_url", "")

    @property
    def repositories_url(self):
        return self.attributes.get("repositories_url", "")

    @property
    def parent(self):
        return self.attributes.get("parent", None)


class HeadUser(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class HeadRepoOwner(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class HeadRepoPermissions(AIOGitHubAPIBase):
    @property
    def admin(self):
        return self.attributes.get("admin", False)

    @property
    def push(self):
        return self.attributes.get("push", False)

    @property
    def pull(self):
        return self.attributes.get("pull", True)


class HeadRepo(AIOGitHubAPIBase):
    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def full_name(self):
        return self.attributes.get("full_name", "")

    @property
    def owner(self):
        return HeadRepoOwner(self.attributes.get("owner", {}))

    @property
    def private(self):
        return self.attributes.get("private", False)

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def description(self):
        return self.attributes.get("description", "")

    @property
    def fork(self):
        return self.attributes.get("fork", False)

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def archive_url(self):
        return self.attributes.get("archive_url", "")

    @property
    def assignees_url(self):
        return self.attributes.get("assignees_url", "")

    @property
    def blobs_url(self):
        return self.attributes.get("blobs_url", "")

    @property
    def branches_url(self):
        return self.attributes.get("branches_url", "")

    @property
    def collaborators_url(self):
        return self.attributes.get("collaborators_url", "")

    @property
    def comments_url(self):
        return self.attributes.get("comments_url", "")

    @property
    def commits_url(self):
        return self.attributes.get("commits_url", "")

    @property
    def compare_url(self):
        return self.attributes.get("compare_url", "")

    @property
    def contents_url(self):
        return self.attributes.get("contents_url", "")

    @property
    def contributors_url(self):
        return self.attributes.get("contributors_url", "")

    @property
    def deployments_url(self):
        return self.attributes.get("deployments_url", "")

    @property
    def downloads_url(self):
        return self.attributes.get("downloads_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def forks_url(self):
        return self.attributes.get("forks_url", "")

    @property
    def git_commits_url(self):
        return self.attributes.get("git_commits_url", "")

    @property
    def git_refs_url(self):
        return self.attributes.get("git_refs_url", "")

    @property
    def git_tags_url(self):
        return self.attributes.get("git_tags_url", "")

    @property
    def git_url(self):
        return self.attributes.get("git_url", "")

    @property
    def issue_comment_url(self):
        return self.attributes.get("issue_comment_url", "")

    @property
    def issue_events_url(self):
        return self.attributes.get("issue_events_url", "")

    @property
    def issues_url(self):
        return self.attributes.get("issues_url", "")

    @property
    def keys_url(self):
        return self.attributes.get("keys_url", "")

    @property
    def labels_url(self):
        return self.attributes.get("labels_url", "")

    @property
    def languages_url(self):
        return self.attributes.get("languages_url", "")

    @property
    def merges_url(self):
        return self.attributes.get("merges_url", "")

    @property
    def milestones_url(self):
        return self.attributes.get("milestones_url", "")

    @property
    def notifications_url(self):
        return self.attributes.get("notifications_url", "")

    @property
    def pulls_url(self):
        return self.attributes.get("pulls_url", "")

    @property
    def releases_url(self):
        return self.attributes.get("releases_url", "")

    @property
    def ssh_url(self):
        return self.attributes.get("ssh_url", "")

    @property
    def stargazers_url(self):
        return self.attributes.get("stargazers_url", "")

    @property
    def statuses_url(self):
        return self.attributes.get("statuses_url", "")

    @property
    def subscribers_url(self):
        return self.attributes.get("subscribers_url", "")

    @property
    def subscription_url(self):
        return self.attributes.get("subscription_url", "")

    @property
    def tags_url(self):
        return self.attributes.get("tags_url", "")

    @property
    def teams_url(self):
        return self.attributes.get("teams_url", "")

    @property
    def trees_url(self):
        return self.attributes.get("trees_url", "")

    @property
    def clone_url(self):
        return self.attributes.get("clone_url", "")

    @property
    def mirror_url(self):
        return self.attributes.get("mirror_url", "")

    @property
    def hooks_url(self):
        return self.attributes.get("hooks_url", "")

    @property
    def svn_url(self):
        return self.attributes.get("svn_url", "")

    @property
    def homepage(self):
        return self.attributes.get("homepage", "")

    @property
    def language(self):
        return self.attributes.get("language", None)

    @property
    def forks_count(self):
        return self.attributes.get("forks_count", None)

    @property
    def stargazers_count(self):
        return self.attributes.get("stargazers_count", None)

    @property
    def watchers_count(self):
        return self.attributes.get("watchers_count", None)

    @property
    def size(self):
        return self.attributes.get("size", None)

    @property
    def default_branch(self):
        return self.attributes.get("default_branch", "")

    @property
    def open_issues_count(self):
        return self.attributes.get("open_issues_count", None)

    @property
    def is_template(self):
        return self.attributes.get("is_template", True)

    @property
    def topics(self):
        return self.attributes.get("topics", [])

    @property
    def has_issues(self):
        return self.attributes.get("has_issues", True)

    @property
    def has_projects(self):
        return self.attributes.get("has_projects", True)

    @property
    def has_wiki(self):
        return self.attributes.get("has_wiki", True)

    @property
    def has_pages(self):
        return self.attributes.get("has_pages", False)

    @property
    def has_downloads(self):
        return self.attributes.get("has_downloads", True)

    @property
    def archived(self):
        return self.attributes.get("archived", False)

    @property
    def disabled(self):
        return self.attributes.get("disabled", False)

    @property
    def visibility(self):
        return self.attributes.get("visibility", "")

    @property
    def pushed_at(self):
        return self.attributes.get("pushed_at", "")

    @property
    def created_at(self):
        return self.attributes.get("created_at", "")

    @property
    def updated_at(self):
        return self.attributes.get("updated_at", "")

    @property
    def permissions(self):
        return HeadRepoPermissions(self.attributes.get("permissions", {}))

    @property
    def allow_rebase_merge(self):
        return self.attributes.get("allow_rebase_merge", True)

    @property
    def template_repository(self):
        return self.attributes.get("template_repository", None)

    @property
    def temp_clone_token(self):
        return self.attributes.get("temp_clone_token", "")

    @property
    def allow_squash_merge(self):
        return self.attributes.get("allow_squash_merge", True)

    @property
    def delete_branch_on_merge(self):
        return self.attributes.get("delete_branch_on_merge", True)

    @property
    def allow_merge_commit(self):
        return self.attributes.get("allow_merge_commit", True)

    @property
    def subscribers_count(self):
        return self.attributes.get("subscribers_count", None)

    @property
    def network_count(self):
        return self.attributes.get("network_count", None)


class Head(AIOGitHubAPIBase):
    @property
    def label(self):
        return self.attributes.get("label", "")

    @property
    def ref(self):
        return self.attributes.get("ref", "")

    @property
    def sha(self):
        return self.attributes.get("sha", "")

    @property
    def user(self):
        return HeadUser(self.attributes.get("user", {}))

    @property
    def repo(self):
        return HeadRepo(self.attributes.get("repo", {}))


class BaseUser(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class BaseRepoOwner(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class BaseRepoPermissions(AIOGitHubAPIBase):
    @property
    def admin(self):
        return self.attributes.get("admin", False)

    @property
    def push(self):
        return self.attributes.get("push", False)

    @property
    def pull(self):
        return self.attributes.get("pull", True)


class BaseRepo(AIOGitHubAPIBase):
    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def name(self):
        return self.attributes.get("name", "")

    @property
    def full_name(self):
        return self.attributes.get("full_name", "")

    @property
    def owner(self):
        return BaseRepoOwner(self.attributes.get("owner", {}))

    @property
    def private(self):
        return self.attributes.get("private", False)

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def description(self):
        return self.attributes.get("description", "")

    @property
    def fork(self):
        return self.attributes.get("fork", False)

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def archive_url(self):
        return self.attributes.get("archive_url", "")

    @property
    def assignees_url(self):
        return self.attributes.get("assignees_url", "")

    @property
    def blobs_url(self):
        return self.attributes.get("blobs_url", "")

    @property
    def branches_url(self):
        return self.attributes.get("branches_url", "")

    @property
    def collaborators_url(self):
        return self.attributes.get("collaborators_url", "")

    @property
    def comments_url(self):
        return self.attributes.get("comments_url", "")

    @property
    def commits_url(self):
        return self.attributes.get("commits_url", "")

    @property
    def compare_url(self):
        return self.attributes.get("compare_url", "")

    @property
    def contents_url(self):
        return self.attributes.get("contents_url", "")

    @property
    def contributors_url(self):
        return self.attributes.get("contributors_url", "")

    @property
    def deployments_url(self):
        return self.attributes.get("deployments_url", "")

    @property
    def downloads_url(self):
        return self.attributes.get("downloads_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def forks_url(self):
        return self.attributes.get("forks_url", "")

    @property
    def git_commits_url(self):
        return self.attributes.get("git_commits_url", "")

    @property
    def git_refs_url(self):
        return self.attributes.get("git_refs_url", "")

    @property
    def git_tags_url(self):
        return self.attributes.get("git_tags_url", "")

    @property
    def git_url(self):
        return self.attributes.get("git_url", "")

    @property
    def issue_comment_url(self):
        return self.attributes.get("issue_comment_url", "")

    @property
    def issue_events_url(self):
        return self.attributes.get("issue_events_url", "")

    @property
    def issues_url(self):
        return self.attributes.get("issues_url", "")

    @property
    def keys_url(self):
        return self.attributes.get("keys_url", "")

    @property
    def labels_url(self):
        return self.attributes.get("labels_url", "")

    @property
    def languages_url(self):
        return self.attributes.get("languages_url", "")

    @property
    def merges_url(self):
        return self.attributes.get("merges_url", "")

    @property
    def milestones_url(self):
        return self.attributes.get("milestones_url", "")

    @property
    def notifications_url(self):
        return self.attributes.get("notifications_url", "")

    @property
    def pulls_url(self):
        return self.attributes.get("pulls_url", "")

    @property
    def releases_url(self):
        return self.attributes.get("releases_url", "")

    @property
    def ssh_url(self):
        return self.attributes.get("ssh_url", "")

    @property
    def stargazers_url(self):
        return self.attributes.get("stargazers_url", "")

    @property
    def statuses_url(self):
        return self.attributes.get("statuses_url", "")

    @property
    def subscribers_url(self):
        return self.attributes.get("subscribers_url", "")

    @property
    def subscription_url(self):
        return self.attributes.get("subscription_url", "")

    @property
    def tags_url(self):
        return self.attributes.get("tags_url", "")

    @property
    def teams_url(self):
        return self.attributes.get("teams_url", "")

    @property
    def trees_url(self):
        return self.attributes.get("trees_url", "")

    @property
    def clone_url(self):
        return self.attributes.get("clone_url", "")

    @property
    def mirror_url(self):
        return self.attributes.get("mirror_url", "")

    @property
    def hooks_url(self):
        return self.attributes.get("hooks_url", "")

    @property
    def svn_url(self):
        return self.attributes.get("svn_url", "")

    @property
    def homepage(self):
        return self.attributes.get("homepage", "")

    @property
    def language(self):
        return self.attributes.get("language", None)

    @property
    def forks_count(self):
        return self.attributes.get("forks_count", None)

    @property
    def stargazers_count(self):
        return self.attributes.get("stargazers_count", None)

    @property
    def watchers_count(self):
        return self.attributes.get("watchers_count", None)

    @property
    def size(self):
        return self.attributes.get("size", None)

    @property
    def default_branch(self):
        return self.attributes.get("default_branch", "")

    @property
    def open_issues_count(self):
        return self.attributes.get("open_issues_count", None)

    @property
    def is_template(self):
        return self.attributes.get("is_template", True)

    @property
    def topics(self):
        return self.attributes.get("topics", [])

    @property
    def has_issues(self):
        return self.attributes.get("has_issues", True)

    @property
    def has_projects(self):
        return self.attributes.get("has_projects", True)

    @property
    def has_wiki(self):
        return self.attributes.get("has_wiki", True)

    @property
    def has_pages(self):
        return self.attributes.get("has_pages", False)

    @property
    def has_downloads(self):
        return self.attributes.get("has_downloads", True)

    @property
    def archived(self):
        return self.attributes.get("archived", False)

    @property
    def disabled(self):
        return self.attributes.get("disabled", False)

    @property
    def visibility(self):
        return self.attributes.get("visibility", "")

    @property
    def pushed_at(self):
        return self.attributes.get("pushed_at", "")

    @property
    def created_at(self):
        return self.attributes.get("created_at", "")

    @property
    def updated_at(self):
        return self.attributes.get("updated_at", "")

    @property
    def permissions(self):
        return BaseRepoPermissions(self.attributes.get("permissions", {}))

    @property
    def allow_rebase_merge(self):
        return self.attributes.get("allow_rebase_merge", True)

    @property
    def template_repository(self):
        return self.attributes.get("template_repository", None)

    @property
    def temp_clone_token(self):
        return self.attributes.get("temp_clone_token", "")

    @property
    def allow_squash_merge(self):
        return self.attributes.get("allow_squash_merge", True)

    @property
    def delete_branch_on_merge(self):
        return self.attributes.get("delete_branch_on_merge", True)

    @property
    def allow_merge_commit(self):
        return self.attributes.get("allow_merge_commit", True)

    @property
    def subscribers_count(self):
        return self.attributes.get("subscribers_count", None)

    @property
    def network_count(self):
        return self.attributes.get("network_count", None)


class Base(AIOGitHubAPIBase):
    @property
    def label(self):
        return self.attributes.get("label", "")

    @property
    def ref(self):
        return self.attributes.get("ref", "")

    @property
    def sha(self):
        return self.attributes.get("sha", "")

    @property
    def user(self):
        return BaseUser(self.attributes.get("user", {}))

    @property
    def repo(self):
        return BaseRepo(self.attributes.get("repo", {}))


class MergedBy(AIOGitHubAPIBase):
    @property
    def login(self):
        return self.attributes.get("login", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def avatar_url(self):
        return self.attributes.get("avatar_url", "")

    @property
    def gravatar_id(self):
        return self.attributes.get("gravatar_id", "")

    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def followers_url(self):
        return self.attributes.get("followers_url", "")

    @property
    def following_url(self):
        return self.attributes.get("following_url", "")

    @property
    def gists_url(self):
        return self.attributes.get("gists_url", "")

    @property
    def starred_url(self):
        return self.attributes.get("starred_url", "")

    @property
    def subscriptions_url(self):
        return self.attributes.get("subscriptions_url", "")

    @property
    def organizations_url(self):
        return self.attributes.get("organizations_url", "")

    @property
    def repos_url(self):
        return self.attributes.get("repos_url", "")

    @property
    def events_url(self):
        return self.attributes.get("events_url", "")

    @property
    def received_events_url(self):
        return self.attributes.get("received_events_url", "")

    @property
    def type(self):
        return self.attributes.get("type", "")

    @property
    def site_admin(self):
        return self.attributes.get("site_admin", False)


class AIOGitHubAPIRepositoryPullrequest(AIOGitHubAPIBase):
    @property
    def url(self):
        return self.attributes.get("url", "")

    @property
    def id(self):
        return self.attributes.get("id", None)

    @property
    def node_id(self):
        return self.attributes.get("node_id", "")

    @property
    def html_url(self):
        return self.attributes.get("html_url", "")

    @property
    def diff_url(self):
        return self.attributes.get("diff_url", "")

    @property
    def patch_url(self):
        return self.attributes.get("patch_url", "")

    @property
    def issue_url(self):
        return self.attributes.get("issue_url", "")

    @property
    def commits_url(self):
        return self.attributes.get("commits_url", "")

    @property
    def review_comments_url(self):
        return self.attributes.get("review_comments_url", "")

    @property
    def review_comment_url(self):
        return self.attributes.get("review_comment_url", "")

    @property
    def comments_url(self):
        return self.attributes.get("comments_url", "")

    @property
    def statuses_url(self):
        return self.attributes.get("statuses_url", "")

    @property
    def number(self):
        return self.attributes.get("number", None)

    @property
    def state(self):
        return self.attributes.get("state", "")

    @property
    def locked(self):
        return self.attributes.get("locked", True)

    @property
    def title(self):
        return self.attributes.get("title", "")

    @property
    def user(self):
        return User(self.attributes.get("user", {}))

    @property
    def body(self):
        return self.attributes.get("body", "")

    @property
    def labels(self):
        return [Labels(x) for x in self.attributes.get("labels", [])]

    @property
    def milestone(self):
        return Milestone(self.attributes.get("milestone", {}))

    @property
    def active_lock_reason(self):
        return self.attributes.get("active_lock_reason", "")

    @property
    def created_at(self):
        return self.attributes.get("created_at", "")

    @property
    def updated_at(self):
        return self.attributes.get("updated_at", "")

    @property
    def closed_at(self):
        return self.attributes.get("closed_at", "")

    @property
    def merged_at(self):
        return self.attributes.get("merged_at", "")

    @property
    def merge_commit_sha(self):
        return self.attributes.get("merge_commit_sha", "")

    @property
    def assignee(self):
        return Assignee(self.attributes.get("assignee", {}))

    @property
    def assignees(self):
        return [Assignees(x) for x in self.attributes.get("assignees", [])]

    @property
    def requested_reviewers(self):
        return [
            RequestedReviewers(x)
            for x in self.attributes.get("requested_reviewers", [])
        ]

    @property
    def requested_teams(self):
        return [RequestedTeams(x) for x in self.attributes.get("requested_teams", [])]

    @property
    def head(self):
        return Head(self.attributes.get("head", {}))

    @property
    def base(self):
        return Base(self.attributes.get("base", {}))

    @property
    def author_association(self):
        return self.attributes.get("author_association", "")

    @property
    def draft(self):
        return self.attributes.get("draft", False)

    @property
    def merged(self):
        return self.attributes.get("merged", False)

    @property
    def mergeable(self):
        return self.attributes.get("mergeable", True)

    @property
    def rebaseable(self):
        return self.attributes.get("rebaseable", True)

    @property
    def mergeable_state(self):
        return self.attributes.get("mergeable_state", "")

    @property
    def merged_by(self):
        return MergedBy(self.attributes.get("merged_by", {}))

    @property
    def comments(self):
        return self.attributes.get("comments", None)

    @property
    def review_comments(self):
        return self.attributes.get("review_comments", None)

    @property
    def maintainer_can_modify(self):
        return self.attributes.get("maintainer_can_modify", True)

    @property
    def commits(self):
        return self.attributes.get("commits", None)

    @property
    def additions(self):
        return self.attributes.get("additions", None)

    @property
    def deletions(self):
        return self.attributes.get("deletions", None)

    @property
    def changed_files(self):
        return self.attributes.get("changed_files", None)
