# Lamed

[![PyPI](https://img.shields.io/pypi/v/lamed.svg)](https://pypi.python.org/pypi/lamed)

[a Scaleable A/B testing backend in ~100 lines of code (and for free*)](http://blog.gingerlime.com/2016/a-scaleable-ab-testing-backend-in-100-lines-of-code-and-for-free/)

## What is it?

an A/B testing backend using AWS Lambda/API Gateway + Redis.

Lamed is a fork of [Gimel](https://github.com/alephbet/gimel) using different trade-offs. It offers higher accuracy but
requires more memory / storage.

Key Features:

* Highly scalable due to the nature of AWS Lambda
* High performance but with higher memory footprint than Gimel
* Cost Effective
* Easy deployment using `lamed deploy`. No need to twiddle with AWS.

## What does Lamed mean?

Lamed (דמֵל) is the 12th letter of the Hebrew Alphabet. It sounds similar to the greek Lambda
(λ).

## Installation / Quick Start

You will need a live instance of redis accessible online from AWS. Then run:

```bash
$ pip install lamed
$ lamed configure
$ lamed deploy
```

[![asciicast](https://asciinema.org/a/316783.svg)](https://asciinema.org/a/316783?speed=2)

It will automatically configure your AWS Lambda functions, API gateway and produce a JS snippet ready to use
for tracking your experiments.

## Architecture

![](https://s3.amazonaws.com/gingerlime-images/gimel-architecture.png "Architecture")

### Client

I suggest looking at [Alephbet](https://github.com/Alephbet/alephbet) to get more details, but at a high level, the client runs on the end-user browser. It will randomly pick a variant and execute a javascript function to 'activate' it. When a goal is reached -- user performs a certain action, this also include the pseudo-goal of *participating* in the experiment -- then an event is sent to the backend. An event typically looks something like "experiment ABC, variant red, user participated", or "experiment XYZ, variant blue, check out goal reached".

Alephbet might send duplicate events, but each event should include a `uuid` to allow the backend to de-duplicate it. More below

### Data Store - No longer using Redis HyperLogLog

The data store keeps a tally of each event that comes into the system. Being able to count unique events (de-duplication) was important to keep an accurate count. [Gimel](https://github.com/alephbet/gimel) is using [HyperLogLog](https://en.wikipedia.org/wiki/HyperLogLog) to count events. The redis HLL implementation is great, but as your number of events go up (40,000+ roughly), your A/B tests are losing accuracy and become much less reliable.

Lamed uses a different approach, with different trade-offs:

* Each event uuid creates a temporary flag in redis, with an expiry of X seconds.
* When a new event comes in, it is checked against the flag, and if already found, it is ignored as duplicate.
* Non-duplicate events are then counted using redis `INCR` atomic command.
* `uuid` flags are protected with [optimistic locking transactions](https://redis.io/topics/transactions) that redis provides

This mechanism is similar to how [idempotency keys are used at Stripe](https://stripe.com/docs/api/idempotent_requests) for example.

> An idempotency key is a unique value generated by the client which the server uses to recognize subsequent retries of the same request. How you create unique keys is up to you, but we suggest using V4 UUIDs, or another random string with enough entropy to avoid collisions.
>
> Keys are eligible to be removed from the system after they're at least 24 hours old, and a new request is generated if a key is reused after the original has been pruned. The idempotency layer compares incoming parameters to those of the original request and errors unless they're the same to prevent accidental misuse.


### Backend - AWS Lambda / API Gateway

The backend had to take care of a few simple types of requests:

* track an event - receive a (HTTP) request with some json data -- experiment name, variant, goal and uuid, and then push it to redis.
* extract the counters for a specific experiment, or all experiments into some json that can be presented on the dashboard.

### Dashboard

access your dashboard with `lamed dashboard`


## How does tracking work?

Check out [Alephbet](https://github.com/Alephbet/alephbet).

## Command Reference

* `lamed --help` - prints a help screen.
* `lamed configure` - opens your editor so you can edit the config.json file. Use it to update your redis settings.
* `lamed preflight` - runs preflight checks to make sure you have access to AWS, redis etc.
* `lamed deploy` - deploys the code and configs to AWS automatically.

## Advanced

### custom API endpoints

If you want to use different API endpoints, you can add your own `extra_wiring` into the `config.json` file (e.g. using
`lamed configure`).

for example, this will add a `.../prod/my_tracking_endpoint` URL pointing to the `lamed-track` lambda:

```json
{
    "redis": {
       ...
    },
    "extra_wiring": [
        {
            "lambda": {
                "FunctionName": "lamed-track",
                "Handler": "lamed.track",
                "MemorySize": 128,
                "Timeout": 3
            },
            "api_gateway": {
                "pathPart": "my_tracking_endpoint",
                "method": {
                    "httpMethod": "GET",
                    "apiKeyRequired": false,
                    "requestParameters": {
                        "method.request.querystring.namespace": false,
                        "method.request.querystring.experiment": false,
                        "method.request.querystring.variant": false,
                        "method.request.querystring.event": false,
                        "method.request.querystring.uuid": false
                    }
                }
            }
        }
    ]
}
```

see [WIRING](https://github.com/Alephbet/gimel/blob/52830737835119692f3a3c157fe090adabf58150/gimel/deploy.py#L81)

## Privacy, Ad-blockers (GDPR etc)

Lamed provides a backend for A/B test experiment data. This data is aggregated and does *not* contain any personal information at all. It merely stores the total number of actions with a certain variation against another.

As such, Lamed should meet privacy requirements of GDPR and similar privacy regulations.

Nevertheless, important disclaimers:

* I am not a lawyer, and it's entirely up to you if and how you decide to use Lamed. Please check with your local regulations and get legal advice to decide on your own.
* Some ad-blockers are extra vigilent, and would block requests with the `track` keyword in the URL. Therefore, track requests to Lamed might be blocked by default. As the library author, I make no attempts to conceal the fact that a form of tracking is necessary to run A/B tests, even if I believe it to be respecting privacy.
* Users who decide to use Lamed can, if they wish, assign a different endpoint that might get past ad-blockers, but that's entirely up to them. see [custom API endpoints](#custom-api-endpoints) on how this can be achieved.
* As with almost any tool, it can be use for good or evil. Some A/B tests can be seen as manipulative, unfair or otherwise illegitimate. Again, use your own moral compass to decide whether or not it's ok to use A/B testing, or specific A/B tests.

## License

Lamed is distributed under the MIT license. All 3rd party libraries and components are distributed under their
respective license terms.

```
Copyright (C) 2020 Yoav Aner

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```

