"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BundledNodejsFunction = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Lambda Function wrapper that uses pre-bundled JavaScript file from the known folder `lib/lambdas` with some reasonable defaults. The bundled files are put there by projen tasks that use esbuild to bundle TypeScript files from `src/lambdas`. This code is found in `.projenrc.js`.
 */
class BundledNodejsFunction extends aws_cdk_lib_1.aws_lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', id)),
            handler: 'index.handler',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        this.props = props;
    }
}
exports.BundledNodejsFunction = BundledNodejsFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLDZDQUFxRTtBQUdyRTs7R0FFRztBQUNILE1BQWEscUJBQXNCLFNBQVEsd0JBQU0sQ0FBQyxRQUFRO0lBQ3hELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQVcsS0FBNkI7UUFDOUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixHQUFHLEtBQUs7WUFDUixJQUFJLEVBQUUsd0JBQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxFQUFFLENBQUMsQ0FBQztZQUNoRSxPQUFPLEVBQUUsZUFBZTtZQUN4QixPQUFPLEVBQUUsd0JBQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztZQUNuQyxZQUFZLEVBQUUsc0JBQUksQ0FBQyxhQUFhLENBQUMsU0FBUztTQUMzQyxDQUFDLENBQUM7UUFQOEMsVUFBSyxHQUFMLEtBQUssQ0FBd0I7SUFRaEYsQ0FBQztDQUNGO0FBVkQsc0RBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgYXdzX2xhbWJkYSBhcyBsYW1iZGEsIGF3c19sb2dzIGFzIGxvZ3MgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBMYW1iZGEgRnVuY3Rpb24gd3JhcHBlciB0aGF0IHVzZXMgcHJlLWJ1bmRsZWQgSmF2YVNjcmlwdCBmaWxlIGZyb20gdGhlIGtub3duIGZvbGRlciBgbGliL2xhbWJkYXNgIHdpdGggc29tZSByZWFzb25hYmxlIGRlZmF1bHRzLiBUaGUgYnVuZGxlZCBmaWxlcyBhcmUgcHV0IHRoZXJlIGJ5IHByb2plbiB0YXNrcyB0aGF0IHVzZSBlc2J1aWxkIHRvIGJ1bmRsZSBUeXBlU2NyaXB0IGZpbGVzIGZyb20gYHNyYy9sYW1iZGFzYC4gVGhpcyBjb2RlIGlzIGZvdW5kIGluIGAucHJvamVucmMuanNgLlxuICovXG5leHBvcnQgY2xhc3MgQnVuZGxlZE5vZGVqc0Z1bmN0aW9uIGV4dGVuZHMgbGFtYmRhLkZ1bmN0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVhZG9ubHkgcHJvcHM6IGxhbWJkYS5GdW5jdGlvbk9wdGlvbnMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgaWQpKSxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5PREVKU18xNF9YLFxuICAgICAgbG9nUmV0ZW50aW9uOiBsb2dzLlJldGVudGlvbkRheXMuT05FX01PTlRILFxuICAgIH0pO1xuICB9XG59Il19