"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    appId: '',
                    personalAuthToken: '',
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
    }
}
exports.Secrets = Secrets;
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.1.0" };
//# sourceMappingURL=data:application/json;base64,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