"""
This module defines atom radii in Angstrom.

The atom radii used are from Austin Mroz and their STREUSEL method. CITATION.

"""

_atomic_radii = {
    'H': 1.24235230881914,
    'He': 1.05452365003981,
    'Li': 2.056812828,
    'Be': 1.91931241249781,
    'B': 1.75038091053539,
    'C': 1.60775485914852,
    'N': 1.4882656711484,
    'O': 1.4637197,
    'F': 1.36987798765253,
    'Ne': 1.25702711814235,
    'Na': 2.12580224898138,
    'Mg': 2.14838326999501,
    'Al': 2.14312912594923,
    'Si': 2.02657466529572,
    'P': 1.925513788,
    'S': 1.85976282127756,
    'Cl': 1.7470500158822,
    'Ar': 1.68792097147776,
    'K': 2.35285407044264,
    'Ca': 2.48964440125309,
    'Sc': 2.40306396840094,
    'Ti': 2.33990316650787,
    'V': 2.29461553587986,
    'Cr': 2.23708321111811,
    'Mn': 2.03890019054501,
    'Fe': 2.0030514787368,
    'Co': 1.99316521751153,
    'Ni': 1.95,
    'Cu': 2.02004330201429,
    'Zn': 1.97700982061142,
    'Ga': 2.105893901289,
    'Ge': 2.07145574864119,
    'As': 2.00400304727839,
    'Se': 1.96124823474118,
    'Br': 1.88768699742418,
    'Kr': 1.835897951399,
    'Rb': 2.41534821492135,
    'Sr': 2.58762426101894,
    'Y': 2.51747417504651,
    'Zr': 2.46537489040517,
    'Nb': 2.42317971489224,
    'Mo': 2.3389726024143,
    'Tc': 2.29847812587149,
    'Ru': 2.24443708549137,
    'Rh': 2.08881676972219,
    'Pd': 2.04,
    'Ag': 2.01346942794962,
    'Cd': 2.09753480384841,
    'In': 2.23249430959401,
    'Sn': 2.21394729019445,
    'Sb': 2.16562361306837,
    'Te': 2.16072584222943,
    'I': 2.08998338083862,
    'Xe': 2.03306419845194,
    'Cs': 2.53938194179109,
    'Ba': 2.75409874192499,
    'La': 2.6,
    'Ce': 2.57309103672576,
    'Pr': 2.57501268869972,
    'Nd': 2.64836773902291,
    'Pm': 2.63504904841603,
    'Sm': 2.61639680400744,
    'Eu': 2.59671967591172,
    'Gd': 2.50921018914678,
    'Ho': 2.542143214,
    'Er': 2.52548464721466,
    'Tm': 2.5140542362847,
    'Yb': 2.50617313680926,
    'Lu': 2.44722630455372,
    'Hf': 2.417092937,
    'Ta': 2.37585797434754,
    'W': 2.29,
    'Re': 2.25550351628158,
    'Os': 2.190317447,
    'Ir': 2.1675223321386,
    'Pt': 2.13505962021246,
    'Au': 2.07204903400906,
    'Hg': 2.026574665,
    'Tl': 2.21472630056492,
    'Pb': 2.24165336316923,
    'Bi': 2.23121626127852,
    'Po': 2.21990575418137,
    'At': 2.13673417746379,
    'Rn': 2.11047755095882,
    'Fr': 2.55,
    'Ra': 2.74,
    'Ac': 2.69,
    'Pa': 2.58,
    'Np': 2.6,
    'Pu': 2.58,
    'Am': 2.55,
    'Cm': 2.53,
    'Cf': 2.5,
    'Md': 2.26,
    'No': 2.42,
    'Lr': 2.38,
    'Db': 2.35,
}

def get_radius(element_string: str) -> float:
    return _atomic_radii[element_string]
