# Splitres

## Описание
[Splitres.py](https://gitwork.ru/barabass/splitres/-/blob/new/src/splitres.py) - программа обработки данных 
в формате вывода команды messtat -s.(подробнее о [messtat](https://gitwork.ru/ekiselev/messtat/-/blob/master/README.md)), предназначенная  для вычисления минимального, максимального и среднего энергопотребления, 
количества израсходованной энергии для каждого вычислительного устройства.

Результатом выполнения программы будет являться файл, содержащий:    
        :small_red_triangle_down: название исследуемого файла    
        :small_red_triangle_down: минимальное значение энергопотребления;    
        :small_red_triangle_down: максимальное значение энергопотребления;    
        :small_red_triangle_down: среднее значение энергопотребления;    
        :small_red_triangle_down: сумма значений энергопотребления;    

Название файла будет формироваться по принципу `messtat_$HOSTNAME.messtat.splitres`, 
где `$HOSTNAME` - имя вычислительного узла, для которого производилось измерение.

## Указания по запуску программы

На вход программе подаётся либо путь до файла с расширением `.messtat` , либо же дирректория, в которой содержатся необходимые файлы.

Для запуска через конмоль необходимо ввести следующую команду:

```bash
python3.7 src/splitres.py <file_path> <result_path>
```

 `file_path` - путь до файла, либо до необходимой дирректории.

`result_path` - путь до каталога, куда будут помещены результирующие файлы. По умолчанию в текущей директории будет создана папка "Result", куда будут помещены все результирующие файлы.

## Тестирование

Покрытие тестами реализовано следующим образом:

1. Проверяем работоспособность, если на вход подана директория;
2. Проверяем работоспособность, если на вход подан файл;
3. Проверяем, что файл не создаётся и возвращается пустой список при указании пути до несуществующей директории/файла.

Для запуска тестов необходимо ввести следующую команду:

```bash
python3 -m py.test --cov=src --cov-report term-missing  tests/tests.py
```

## Установка пакета

Для установки пакета необходимо прописать в командной строке

```bash
pip install splitres
```