"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateExternalConnections = exports.validateRepoName = exports.validateRepoNameLength = exports.validateDomainNameLength = exports.validateDomainName = void 0;
const exceptions_1 = require("./exceptions");
function validateDomainName(name) {
    const regex = /^[a-z][a-z0-9\-]{0,48}[a-z0-9]{0,2}$/;
    if (!regex.test(name)) {
        throw new exceptions_1.DomainNameInvalid();
    }
    return true;
}
exports.validateDomainName = validateDomainName;
function validateDomainNameLength(name) {
    if (name.length > 50) {
        throw new exceptions_1.DomainNameTooLong();
    }
    return true;
}
exports.validateDomainNameLength = validateDomainNameLength;
function validateRepoNameLength(name) {
    if (name.length > 100) {
        throw new exceptions_1.RepositoryNameTooLong();
    }
    return true;
}
exports.validateRepoNameLength = validateRepoNameLength;
function validateRepoName(name) {
    const regex = /^[a-z][a-z0-9\-]{0,48}[a-z0-9]{0,2}$/;
    if (!regex.test(name)) {
        throw new exceptions_1.RepositoryNameInvalid();
    }
    return true;
}
exports.validateRepoName = validateRepoName;
function validateExternalConnections(connections) {
    if (connections && connections.length > 1) {
        throw new exceptions_1.TooManyExternalConnections();
    }
    return true;
}
exports.validateExternalConnections = validateExternalConnections;
//# sourceMappingURL=data:application/json;base64,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