"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const repository_1 = require("./repository");
const validations = require("./validations");
/**
 * CodeArtifact Domain Construct - enables creation of a domain along with zero or more Repositories.
 *
 * Can be used to create just a domain by passing in no IDomainRepositoryProp elements
 *
 */
class Domain extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        this.domainInstance = new aws_codeartifact_1.CfnDomain(this, props.domainName, props);
        if (props.repositories) {
            let idx = 1;
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repoName = `${repoProps.repositoryName}${idx}`;
                const repo = new repository_1.Repository(this, repoName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domainInstance);
                this.repositories.push(repo);
                idx = idx + 1;
            }
        }
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "cdk-codeartifact.Domain", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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