"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const validations = require("./validations");
/**
 * A Construct that will allow easy setup of an AWS CodeArtifact Repository within a domain
 *
 * @deprecated CodeArtifact class is replaced by Domain and will be removed in future major release 1.1.0
 */
class CodeArtifact extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        this.domainInstance = new aws_codeartifact_1.CfnDomain(scope, props.domainName, props);
        if (props.repositories) {
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repoName = `${repoProps.repositoryName}`;
                const repo = new aws_codeartifact_1.CfnRepository(scope, repoName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domainInstance);
                this.repositories.push(repo);
            }
        }
    }
}
exports.CodeArtifact = CodeArtifact;
_a = JSII_RTTI_SYMBOL_1;
CodeArtifact[_a] = { fqn: "cdk-codeartifact.CodeArtifact", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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