# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['timer_cli']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'globus-sdk>=2.0.1,<3.0.0',
 'importlib-metadata>=3.10.0,<4.0.0',
 'requests>=2.24.0,<3.0.0']

entry_points = \
{'console_scripts': ['globus-timer = timer_cli.main:main']}

setup_kwargs = {
    'name': 'globus-timer-cli',
    'version': '0.2.8',
    'description': 'CLI for interacting with the timer API',
    'long_description': '# Globus Automate Timer CLI\n\nThis is a beta-version CLI for use with the (also in beta) Globus Timer API, to\nuse primarily for scheduling recurring Globus transfers through Globus Automate.\n\nAs the CLI and service are still in beta, please feel free to email support at\nglobus dot org with feedback or to resolve issues.\n\n## What is this Service/CLI for?\n\nThe Globus Timer service can be used to schedule recurring transfer tasks. For\nexample, let\'s say we want to have a transfer automatically run every night to\nback up data. We submit a job to the Timer Service starting tonight, and with an\ninterval of 1 day at which it will be re-run. In that request we provide the\nTimer service the same input we would give to the [Globus Transfer Action\nProvider](https://globus-automate-client.readthedocs.io/en/latest/globus_action_providers.html#globus-transfer-transfer-data);\nthat part of the request contains the information for what Globus endpoints we\ntransfer to and from as well as other options relevant to the transfer.\n\n## Installation\n\nThis CLI requires Python version 3.5 or higher. See the [Globus CLI\ndocs](https://docs.globus.org/cli/installation/prereqs/) for help on how to set\nup Python.\n\nOnce the appropriate version of Python is ready, install with `pip\ninstall globus-timer-cli`. This will create a new command line\nutility, `globus-timer` which can be used for all interactions with\nthe service. Online documentation is always available using the\n`--help` option on any command. So, `globus-timer --help` will provide\ninformation about the options on the command while `globus-timer job\n--help` will provide help text specific to working with jobs. When in\ndoubt, add `--help` to a command for guidance on next steps.\n\n## Getting Started\n\nTo schedule transfers on your behalf, this CLI requires authentication through\nGlobus Auth. Initially, the CLI will prompt you to authorize use via the Globus\nAuth system, with a link to open in a web browser. The page will request that\nyou login to your Globus identity and consent to the service looking up your\nidentity and interacting with the Globus Transfer service on your behalf, and\nthen give you an authorization code to copy and paste back into the CLI. Some\nGlobus endpoints require additional authentication for use; when this is\nnecessary, the CLI will repeat the above process to get consent for using the\nGlobus Transfer service and the specific endpoint(s) for that job.\n\nAuthentication information is thereafter cached in the file\n`~/.globus_timer_tokens.json` (so the authentication process is only needed on\nthe first use of the CLI, or of a given transfer endpoint when required); keep\nthis file secret.\n\nAfter first use, you can determine what Globus Auth identity is being used for\ninteracting with the service by running the command:\n\n```\nglobus-timer session whoami\n```\n\nThis will show the identity which will be used for running the Transfers. Be\nsure that this identity is authorized to work with the endpoints involved in the\nTransfer.\n\nTo remove your stored identity information so that you may re-authenticate, for\nexample to invoke subsequent operations using a different Globus Auth identity,\nuse the command:\n\n```\nglobus-timer session logout\n```\n\nNote that should you wish to both logout, and revoke the Timer service\'s\npermission to run further operations, you may use the command `globus-timer\nsession revoke` however this should be an extreme measure as it is much\npreferred to properly delete jobs as described below.\n\n## Scheduling Periodic Globus Transfer operations\n\nNOTE: To avoid confusion, please read the entirety of this section before using\nthe `job transfer` sub-command.\n\nThe starting point for working with the Timer service is scheduling transfers to\nrun periodically. An example of this command is below:\n\n```\nglobus-timer job transfer \\\n    --name example-job \\\n    --label "Timer Transfer Job" \\\n    --interval 28800 \\\n    --start \'2020-01-01T12:34:56\' \\\n    --source-endpoint ddb59aef-6d04-11e5-ba46-22000b92c6ec \\\n    --dest-endpoint ddb59af0-6d04-11e5-ba46-22000b92c6ec \\\n    --item "/share/godata/file1.txt" "~/new_file1.txt" false \\\n    --item "/share/godata/file2.txt" "~/new_file2.txt" false\n```\n\nThe parameters to the `job transfer` command are as follows (also documented in\nthe CLI help: `globus-timer job transfer --help`):\n\n* `name`: A friendly name you can use to identify the job. However,\n  note that all operations on the job (see below) are based on the job\n  identifier (`job_id`) which is returned in the output of this\n  command.\n\n* `label`: A label string which will be used on the Globus Transfer\n  tasks which will be created to perform the periodic transfer\n  operations. You may use this to help you identify the source of the\n  Globus Transfer task when viewing them in the Globus web\n  application. If no `label` string is provided, the Globus Transfer\n  label will include the `name` of this Timer job.\n\n* `interval`: The time, in seconds, between invocations of the Globus\n  Transfer operation. The Transfer will be invoked after this number\n  of fixed seconds. Note that this easily allows for intervals such as\n  hourly (3600 seconds), daily (86400 seconds) or weekly (604800\n  seconds), but it doesn\'t allow for day of month or provide the\n  ability to compensate for other time related changes like daylight\n  savings time changes. This is presently a limitation of the Timer\n  service. In some cases, the actual time the operation is started in\n  Globus Transfer may be a few seconds longer than the specified\n  interval, but any delay will not impact scheduling of the next\n  operation (i.e. the job will stay on schedule and not "drift" due to\n  delays in any particular execution).\n\n* `start`: A timestamp defining when the job should first be\n  scheduled. Thus, the first invocation of the Globus Transfer\n  operation will occur at the specified time and then again after each\n  `interval` number of seconds. The time may contain just a year,\n  month and date, or may also contain the exact time of day as shown\n  in the example. Unless a timezone is specified, the local timezone\n  will be used.\n\n* `source-endpoint` and `dest-endpoint`: Are the ids for Globus\n  Transfer endpoints for the source and destination of the transfer\n  operation respectively. These values can be retrieved from the\n  Globus web application.\n\n* `item`: Specifies the exact locations on the source and destination\n  endpoints to perform the transfer operation. `item` should be\n  followed by three values: the path on the source endpoint from which\n  to start the transfer, the path on the destination endpoint where\n  the data should be placed, and a true or false value indicating\n  whether the transfer should be performed in a recursive manner. When\n  the value is true, if the source path names a folder, the folder and\n  all of its contained files and other folders will be transferred. If\n  the value is false, the first (source) path should refer to a\n  specific file.\n\nNote that, as shown in the example, a single job creation command can\ncontain multiple specifications of the `item` parameter. This means\nthat a single job can transfer from multiple paths between a single\nsource endpoint and a single destination endpoint.\n\nAs an alternative to specifying the `item` parameter one or more\ntimes, the item values may be stored in a file in which each line has\nthe same format as the `item` parameter. The file may be specified\nwith the `items-file` option which is used *instead of* the `item`\nparameter. An example of the file which would perform the same\noperations as the example above would look like:\n\n```\n# This is my items file\n/share/godata/file1.txt, ~/new_file1.txt, false\n/share/godata/file2.txt, ~/new_file2.txt, false\n```\n\nIf this file was named `transfer_items.csv` it would be specified with the parameter:\n\n```\n--items-file transfer_items.csv\n```\n\nNote that this is a CSV file. The individual parts of the item are separated\nwith commas, and lines starting with a `#` are considered to be comments and are\nnot processed as items for the transfer job.\n\n### Additional Transfer Options\n\nSome optional flags for setting certain Transfer options include:\n\n* `--sync-level`, adjusting how Transfer should behave if files already exist at\n  the destination\n* `--verify-checksum`, causing Transfer to retry if file checksums don\'t match\n* `--encrypt-data`, causing Transfer to encrypt data using TLS\n* `--preserve-timestamp`, causing Transfer to keep file timestamps the same at\n  the destination\n\nYou may also specify a finite number of times or duration after which a job\nshould stop:\n\n* `--stop-after-runs` takes a number, telling Timer to run the job only that\n  many times.\n* `--stop-after-date` takes a date argument, telling Timer to continue running\n  the job only until the given date.\n\nWhen either condition is reached, your job will still exist, and results will\nstill be visible, but Timer will not run any more transfers. If you specify\nboth, the job stops running as soon as one stop condition is met. If you update\nan existing job to modify either of these, Timer will resume running the job\nuntil it hits your new stop condition.\n\nAs always, all of the above options are also documented in `globus-timer job\ntransfer --help`.\n\n## Monitoring and Controlling Submitted jobs\n\nAfter submitting the transfer job, the CLI should return some results containing\na `job_id`, which identifies this job in the Timer service. To check the\nstatus of your jobs, use:\n\n```\nglobus-timer job status <job_id>\n```\n\nThis command defaults to a summarized version of the job\'s information, which\ndoes not include the full details for the corresponding task in Globus Transfer. To\ncheck those, use `-v/--verbose`:\n\n```\nglobus-timer job status --verbose JOB_ID\n```\n\nCommands return date-times in ISO format, in UTC time, so the timezone\nmost likely will not match the local time where you run the\ncommand. No need to worry: the actual start time is still equal to\nyour submission\'s start time, etc.\n\nThe job description will also contain a value for `status` indicating\nthe condition of the job. The `status` may contain one of the\nfollowing values:\n\n* `new`: The job has been received, but it has not yet been scheduled\n  for its first execution (for example the start time has not yet been\n  reached).\n\n* `loaded`: The job has reached its execution mode and is executing\n  repeatedly on the requested interval. This is the "steady-state" for\n  a job when it is executing as expected.\n\n* `updated`: If the job has recently been updated, it will be in this\n  state until the job has transitioned to its new regular\n  operation. This state should rarely be encountered as it is a\n  transient state immediately after a job update.\n\n* `deleted`: Indicates that the job has been deleted. This would not\n  normally be seen, but the `job status` command described above as\n  well as other commands described below provide the option of\n  retrieving jobs marked as deleted using a command line flag\n  `--show-deleted`.\n\nA final important note: `Last Result` in the non-verbose output extends only as\nfar as the Globus Automate system: `SUCCESS` indicates you have successfully submitted\nyour job to the Timer service, which in turn successfully sent the task to the\nGlobus Transfer Action Provider. It\'s possible that the Globus Transfer service will\nsubsequently encounter some error running your transfer. Check the `--verbose`\noutput, which includes the actual response from Transfer, to be certain that\nTransfer has run your job successfully.\n\nTo see all of your jobs which are outstanding, use the command:\n\n```\nglobus-timer job list\n```\n\nThis is particularly helpful if you do not have the `job_id` for a\nparticular job available. It will show all of your jobs in the same\nformat as the `job status` command described above. Similarly, the\n`--verbose/-v` and `--show-deleted` options are supported.\n\nFinally, a job may be removed from operation using the command:\n\n```\nglobus-timer job delete <job_id>\n```\n\nThe job will be removed from operation and no further transfers will\nbe performed. The same information provided via `job status` will be\ndisplayed, showing the final state of the job. As described above, the\n`job status` command may still retrieve the job information by\nproviding the `--show-deleted` flag. This can be helpful to review the\nfinal state of the job, such as the last transfer or error condition,\neven if the output for the `job delete` command is lost.\n',
    'author': 'Rudyard Richter',
    'author_email': 'rudyard@globus.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
