# Diatomic-Py
Python module to calculate the hyperfine energy levels of singlet sigma diatomic molecules. Included are examples from the bialkali series : RbCs, KCs and KRb

The hyperfine structure can be calculated in static electric and magnetic fields and, when provided the polarisability, oscillating electric fields.

Read the full [documentation](https://diatomic-py.readthedocs.io).


# Installation

Installation is available offline using the .whl and .tar.gz files [available here](dist).

Installation is also available via the python package index
` pip install diatomic-py`

# Requirements
- Python 3.7
- numpy 1.19
- sympy 1.4
- scipy 1.1

# License

Diatomic-py is licensed under a BSD 3 clause license. A copy can be found [here](LICENSE).

If you use our work for academic purposes you can cite us using:

J.A.Blackmore *et al.* Diatomic-py: A python module for calculating the rotational and hyperfine structure of <sup>1</sup>Σ molecules, [Arxiv *e-prints* 2205.05686](https://arxiv.org/abs/2205.05686) (2022).
