"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeeringRouterInterfaceConnection = exports.PeeringRouterInterfaceConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "PeeringRouterInterfaceConnectionProperty", { enumerable: true, get: function () { return vpc_generated_1.RosPeeringRouterInterfaceConnection; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::PeeringRouterInterfaceConnection`
 */
class PeeringRouterInterfaceConnection extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::PeeringRouterInterfaceConnection`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPeeringRouterInterfaceConnection = new vpc_generated_1.RosPeeringRouterInterfaceConnection(this, id, {
            oppositeInterfaceId: props.oppositeInterfaceId,
            routerInterfaceId: props.routerInterfaceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPeeringRouterInterfaceConnection;
        this.attrOppositeInterfaceId = rosPeeringRouterInterfaceConnection.attrOppositeInterfaceId;
        this.attrRouterInterfaceId = rosPeeringRouterInterfaceConnection.attrRouterInterfaceId;
    }
}
exports.PeeringRouterInterfaceConnection = PeeringRouterInterfaceConnection;
//# sourceMappingURL=data:application/json;base64,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