"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ipv6Gateway = exports.Ipv6GatewayProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "Ipv6GatewayProperty", { enumerable: true, get: function () { return vpc_generated_1.RosIpv6Gateway; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::Ipv6Gateway`
 */
class Ipv6Gateway extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::Ipv6Gateway`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosIpv6Gateway = new vpc_generated_1.RosIpv6Gateway(this, id, {
            description: props.description,
            vpcId: props.vpcId,
            spec: props.spec,
            tags: props.tags,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosIpv6Gateway;
        this.attrIpv6GatewayId = rosIpv6Gateway.attrIpv6GatewayId;
    }
}
exports.Ipv6Gateway = Ipv6Gateway;
//# sourceMappingURL=data:application/json;base64,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