"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GrantInstanceToCen = exports.GrantInstanceToCenProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "GrantInstanceToCenProperty", { enumerable: true, get: function () { return vpc_generated_1.RosGrantInstanceToCen; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::GrantInstanceToCen`
 */
class GrantInstanceToCen extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::GrantInstanceToCen`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosGrantInstanceToCen = new vpc_generated_1.RosGrantInstanceToCen(this, id, {
            instanceId: props.instanceId,
            cenOwnerId: props.cenOwnerId,
            cenId: props.cenId,
            instanceType: props.instanceType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosGrantInstanceToCen;
        this.attrCenId = rosGrantInstanceToCen.attrCenId;
        this.attrInstanceId = rosGrantInstanceToCen.attrInstanceId;
    }
}
exports.GrantInstanceToCen = GrantInstanceToCen;
//# sourceMappingURL=data:application/json;base64,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