YARP 2.3.66.1 (2016-10-20)                                          {#v2_3_66_1}
==========================

[TOC]

YARP 2.3.66.1 Release Notes
===========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.66.1%22).


Important Changes
-----------------

### YARP_dev

* The `analogServer` device (implemented in `yarp::dev::AnalogWrapper` has
  removed the support for the `deviceId` parameter, that has been
  deprecated since 2014. Invalid configuration files of the form:
~~~
robotName icub
deviceId left_arm
~~~
  can be updated with the valid:
~~~
name /icub/left_arm/analog:o
~~~

* The `controlboardwrapper2` device (implemented in
  `yarp::dev::ControlBoardWrapper` has removed the supported for the
  `threadrate` parameter, that has been deprecated since 2014.
  Invalid configuration files of the form `threadrate 10` can be update with the
  valid form `period 10`.

Bug Fixes
---------

### YARP_OS

* Fixed `PlatformThread` for macOS, no ACE, no c++11.
* Fixed memory leak in `SharedLibrary`.
* Fixed memory leak in `Property::fromArgs`.
* Use reentrant version of `get_host_addr` in `NameConfig` and
  `SocketTwoWayStream` (fixes a few possible race conditions).
* Fixed memory leak in `NameConfig::getHostName` with `SKIP_ACE` enabled.
* Fixed "Conditional jump or move depends on uninitialised value" issues
  reported by `valgrind --memcheck` in `SocketTwoWayStream` with `SKIP_ACE`
  enabled.
* Added implementation of `SystemInfo` for macOS.
* Fixed bug in `yarprun` currently occurring only on macOS, but potentially on
  other platforms (#633)
* `yarp plugin` command now works with `SKIP_ACE` enabled.
* Fixed UDP and MCAST on macOS (#637)
* Fixed SIGPIPE when closing input port before output ports.


### YARP_DEV

* Fixed `yarp::dev::BatteryClient::getBatteryTemperature()`.
* Fixed memory leak in `ImplementTorqueControl`.
* Export some important classes that were erroneously not exported in the ABI.
* Fixed memory leak in `PolyDriver`.
* ControlBoardWrapper: Added checks for testing if joint number is out of bound.


### Modules

* `Rangefinder2DWrapper`: angle_increment is now obtained from the hardware
  device.
* `laserHokuyo`: added parameters max_angle and min_angle.
* `imuBosch_BNO055`: fixed use of char (a signed type) for the byte buffer that
  was corrupting positive measures when converting from 2 bytes to a single 16
  bit value.
* `fakeMotionControl`: Fix memory leak.
* `portaudio`: fix bug in number of samples recorded, changed default values to
  have the device more responsive.


### Tools

* `yarpdatadumperAppGenerator.py` is now installed as
  `yarpdatadumperAppGenerator` on non Windows platforms.


### GUIs

* `yarpview`:
  * Fixed .app bundle on macOS.
  * `QT_DEVICE_PIXEL_RATIO` is now set to "auto" to support 4k displays.
* `yarpscope`:
  * Fixed .app bundle on macOS.
  * Fixed help for --min and --max arguments.
  * Fixed reading minval and maxval from xml.
* `yarpmotorgui`:
  * Max number of joints was fixed to 16. Now memory is dynamically allocated.
  * Fixed issue preventing sequence tab to acquire encoder positions on double
    click, if the control mode of the selected joint is not POSITION.
  * Fixed bug preventing correct copy-and-paste action
  * Fixed issue preventing a GO action from being executed if timing is less
    than zero.
  * Allow copying single lines to clipboard from sequence tab.
  * `QT_DEVICE_PIXEL_RATIO` is now set to "auto" to support 4k displays.
  * Added box to display openloop output.
* `yarpdataplayer`
  * `QT_DEVICE_PIXEL_RATIO` is now set to "auto" to support 4k displays.
  * Fixed error when opening readonly files.
  * Fixed variable sample rate data playing too fast.
* `yarplogger`:
  * The date is now taken into account.
  * Copying to clipboard preserves new lines.
  * New icon-set is displayed in the "filter" section when a log is disabled.
  * Double-clicking on the table to make each line of the logger to adjusts
    the row height to display all of its contents. Added context menu entry.
  * New lines at the end of log messages are now removed.
  * The log is now displayed using a fixed size font.


### IDLs

* The script executed by RosTypeSearch::fetchFromRos now supports the creation
  of .msg files in a non-existing directory.


### Bindings

* Properly define TypedReaderCallbackSound (Fixes TypedReaderCallbackImageMono
  redefinition).


### Build System

* `YarpPlugin.cmake` no longer redefines the `FIND_PACKAGE` CMake command.


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.66..v2.3.66.1`):

```
   155	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    15	Francesco Romano <francesco.romano@iit.it>
    11	Marco Randazzo <marco.randazzo@iit.it>
     9	Silvio Traversaro <silvio.traversaro@iit.it>
     9	Tobias Fischer <t.fischer@imperial.ac.uk>
     7	Matteo Brunettini <matteo.brunettini@iit.it>
     6	Alexandros Paraschos <paraschos@ias.tu-darmstadt.de>
     5	Alberto Cardellino <alberto.cardellino@iit.it>
     2	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     2	Giovanni Saponaro <gsaponaro@isr.ist.utl.pt>
     2	Lorenzo Natale <lorenzo.natale@iit.it>
     2	Ugo Pattacini <ugo.pattacini@iit.it>
     2	Vadim Tikhanoff <vadim.tikhanoff@iit.it>
     1	Claudia Latella <claudia.latella@iit.it>
     1	Claudio Fantacci <claudio.fantacci@iit.it>
     1	Plinio Moreno <plinio@isr.tecnico.ulisboa.pt>
     1	Valentina Gaggero <valentina.gaggero@iit.it>
```
