# Generated by Django 3.1.2 on 2020-10-06 11:29

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('nobinobi_core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='Name')),
                ('short_code', models.SlugField(unique=True, verbose_name='Short code')),
            ],
            options={
                'verbose_name': 'Company',
                'verbose_name_plural': 'Companies',
                'ordering': ('name', 'short_code'),
                'unique_together': {('name', 'short_code')},
            },
        ),
        migrations.CreateModel(
            name='CompanyClosure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('from_date', models.DateField(verbose_name='From date')),
                ('end_date', models.DateField(verbose_name='End date')),
                ('desc', models.CharField(blank=True, max_length=100, null=True, verbose_name='Description')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_core.company', verbose_name='Company')),
            ],
            options={
                'verbose_name': 'Company closure',
                'verbose_name_plural': 'Company closures',
                'ordering': ('from_date', 'end_date'),
            },
        ),
    ]
