# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobResponse(Model):
    """JobResponse.

    :param job_id: System generated.  Ignored at creation. The unique
     identifier of the job.
    :type job_id: str
    :param query_condition: The device query condition.
    :type query_condition: str
    :param created_time: System generated.  Ignored at creation. The creation
     date and time of the job.
    :type created_time: datetime
    :param start_time: The start date and time of the scheduled job in UTC.
    :type start_time: datetime
    :param end_time: System generated.  Ignored at creation. The end date and
     time of the job in UTC.
    :type end_time: datetime
    :param max_execution_time_in_seconds: The maximum execution time in
     secounds.
    :type max_execution_time_in_seconds: long
    :param type: The job type. Possible values include: 'unknown', 'export',
     'import', 'backup', 'readDeviceProperties', 'writeDeviceProperties',
     'updateDeviceConfiguration', 'rebootDevice', 'factoryResetDevice',
     'firmwareUpdate', 'scheduleDeviceMethod', 'scheduleUpdateTwin',
     'restoreFromBackup', 'failoverDataCopy'
    :type type: str or ~protocol.models.enum
    :param cloud_to_device_method: The method type and parameters. This is
     required if job type is cloudToDeviceMethod.
    :type cloud_to_device_method: ~protocol.models.CloudToDeviceMethod
    :param update_twin:
    :type update_twin: ~protocol.models.Twin
    :param status: System generated.  Ignored at creation. The status of the
     job. Possible values include: 'unknown', 'enqueued', 'running',
     'completed', 'failed', 'cancelled', 'scheduled', 'queued'
    :type status: str or ~protocol.models.enum
    :param failure_reason: The reason for the failure, if a failure occurred.
    :type failure_reason: str
    :param status_message: The status message of the job.
    :type status_message: str
    :param device_job_statistics: The details regarding job execution status.
    :type device_job_statistics: ~protocol.models.DeviceJobStatistics
    """

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "query_condition": {"key": "queryCondition", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "max_execution_time_in_seconds": {"key": "maxExecutionTimeInSeconds", "type": "long"},
        "type": {"key": "type", "type": "str"},
        "cloud_to_device_method": {"key": "cloudToDeviceMethod", "type": "CloudToDeviceMethod"},
        "update_twin": {"key": "updateTwin", "type": "Twin"},
        "status": {"key": "status", "type": "str"},
        "failure_reason": {"key": "failureReason", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "device_job_statistics": {"key": "deviceJobStatistics", "type": "DeviceJobStatistics"},
    }

    def __init__(self, **kwargs):
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = kwargs.get("job_id", None)
        self.query_condition = kwargs.get("query_condition", None)
        self.created_time = kwargs.get("created_time", None)
        self.start_time = kwargs.get("start_time", None)
        self.end_time = kwargs.get("end_time", None)
        self.max_execution_time_in_seconds = kwargs.get("max_execution_time_in_seconds", None)
        self.type = kwargs.get("type", None)
        self.cloud_to_device_method = kwargs.get("cloud_to_device_method", None)
        self.update_twin = kwargs.get("update_twin", None)
        self.status = kwargs.get("status", None)
        self.failure_reason = kwargs.get("failure_reason", None)
        self.status_message = kwargs.get("status_message", None)
        self.device_job_statistics = kwargs.get("device_job_statistics", None)
