# 高度機能チュートリアル

このチュートリアルでは、洗練されたAIワークフローを構築するためのRefinireの高度機能について説明します。各セクションでは、コードの詳細ではなく、概念と実装アプローチを重視して解説しています。

## 1. RefinireAgentとのツール統合

### ツール統合の理解

Refinireは、AIエージェントに外部ツールを統合する2つの主要な方法を提供します：直接関数ツールとMCP（Model Context Protocol）サーバーです。ツール統合により、エージェントはテキスト生成以外の操作（データベースアクセス、API呼び出し、計算実行など）を実行できるようになります。

#### モダンなツール統合アプローチ

`@tool`デコレータは、エージェントが自動的に呼び出すことができる関数ツールを作成します。関数を`@tool`でデコレートすると、Refinireは自動発見、パラメータ抽出、実行調整を処理します。エージェントはユーザーリクエストに基づいて、どのツールを使用するかを賢く判断します。

**実装要件：**
- 明確な型ヒントとドキュメント文字列を含む関数を定義する
- Refinireの`@tool`デコレータを使用する
- エージェント作成時に`tools`パラメータにツール関数を渡す
- ツール関数がエラーを適切に処理することを確保する

```python
# 例：天気と計算ツール
@tool
def get_weather(location: str) -> str:
    """指定した場所の現在の天気情報を取得"""
    # 天気API呼び出しロジックを実装
    pass

agent = RefinireAgent(
    name="assistant",
    generation_instructions="利用可能なツールを使ってユーザーを支援する",
    tools=[get_weather],  # ツールが自動的に発見される
    model="gpt-4o-mini"
)
```

#### MCPサーバー統合

MCPサーバーは、外部システムとデータソースへの標準化されたアクセスを提供します。関数ツールとは異なり、MCPサーバーは別のプロセスとして実行され、定義されたプロトコルを介して通信します。このアプローチは、複雑な統合、データベースアクセス、または複数のアプリケーション間でツールを共有する必要がある場合に最適です。

**実装上の考慮事項：**
- `mcp_servers`パラメータでMCPサーバーエンドポイントを設定する
- stdio、HTTP、WebSocketサーバータイプをサポートする
- MCPサーバーは独自のエラー回復と接続管理を処理する
- MCPサーバーからのツールは自動的に発見され統合される

## 2. 高度なFlowアーキテクチャ

### シーケンシャル処理パターン

シーケンシャルフローは、各ステップが前のステップの結果に基づいて構築される複数の段階を通してデータを処理します。このパターンは、複雑な分析タスク、コンテンツ作成ワークフロー、または多段階データ処理に不可欠です。

**設計原則：**
- 各ステップは単一の明確に定義された責任を持つべき
- ステップ間のデータ受け渡しに`Context`オブジェクトを使用する
- ステップを独立してテスト可能に設計する
- 各段階でエラーハンドリングと回復を考慮する

シーケンシャルフローは、ステップ間のデータフローを自動的に管理し、手動の状態管理の必要性を排除します。Flowエンジンは実行順序、エラー伝播、結果集約を処理します。

### 条件付きワークフローロジック

条件付きワークフローは、入力特性、ユーザー設定、または動的条件に基づいて実行をルーティングします。このパターンにより、異なる処理パスが異なるタイプのリクエストを処理する適応的な動作が可能になります。

**実装戦略：**
- ルーティング決定を返す条件関数を作成する
- `ConditionStep`を使用して分岐ロジックを実装する
- 各処理パス用に別々のエージェントを設計する
- すべてのパスが同様の入力タイプを一貫して処理することを確保する

条件関数は現在のコンテキストを受け取り、明確なルーティング決定を返すべきです。条件ロジックは単純に保ち、単一の決定基準に焦点を当てます。

### パフォーマンス向上のための並列処理

並列処理は、独立した操作を同時に実行し、別々の関心事に分解できるタスクのパフォーマンスを劇的に向上させます。このパターンは、分析ワークフロー、データ拡張、または多視点処理に特に効果的です。

**パフォーマンスに関する考慮事項：**
- 並列実行のために真に独立した操作を特定する
- システムリソースに基づいて`max_workers`を設定する
- 共有状態の依存関係を避けるように並列ステップを設計する
- 実行順序に関係なく、結果を一貫して集約する

`{"parallel": [...]}`構文は、非同期調整、ワーカープール管理、結果収集を自動的に処理します。並行性の詳細を管理するのではなく、独立したステップの設計に焦点を当てます。

## 3. 品質保証と評価

### 自動品質管理システム

AIワークフローの品質保証には、体系的な評価と自動改善メカニズムが必要です。Refinireの評価システムにより、品質基準を定義し、閾値を設定し、改善されたプロンプトで失敗した試行を自動的に再試行できます。

**評価設計原則：**
- 明確で測定可能な品質基準を定義する
- アプリケーション要件に基づいて現実的な閾値を設定する
- 実用的なフィードバックを提供する評価指示を設計する
- 品質要件とパフォーマンスの考慮事項のバランスを取る

評価スコアが閾値を下回ると、システムは評価フィードバックを組み込んだ強化プロンプトで自動的に再試行します。これにより、手動介入なしに品質基準を維持する自己改善ループが作成されます。

### カスタムガードレール実装

ガードレールは、AIエージェントの動作に対する安全性とコンプライアンス制御を提供します。入力ガードレールは処理前にリクエストを検証し、出力ガードレールは生成されたコンテンツが基準を満たすことを確保します。

**ガードレール設計戦略：**
- 異なるタイプのコンテンツに対して特定の検証関数を作成する
- 不要な処理を防ぐために早期検証を実装する
- 失敗した検証に対して明確なエラーメッセージを設計する
- 検証ロジックのパフォーマンス影響を考慮する

ガードレールは、ブール値の結果を返す軽量で焦点を絞った関数であるべきです。複雑な検証ロジックは、保守性とテストのためにモジュール化する必要があります。

## 4. 変数埋め込みによる動的プロンプト生成

### 変数埋め込みの概念

変数埋め込みは、コンテキスト認識置換を使用した動的プロンプト構築を可能にします。`{{variable}}`構文により、実行コンテキスト、以前の結果、またはユーザー固有のデータに基づいて適応する柔軟で再利用可能なプロンプトを作成できます。

**変数埋め込み戦略：**
- 目的を明確にする説明的な変数名を使用する
- ワークフロー統合のために予約変数`{{RESULT}}`と`{{EVAL_RESULT}}`を活用する
- ステップ間アクセスのために`Context.shared_state`に動的値を保存する
- 異なる変数値でも一貫性を保つプロンプトを設計する

このアプローチにより、単一のエージェントがコンテキスト変数に基づいて動作を変更することで複数の役割を果たすことができます。また、共通パターンを集約することでプロンプトの保守を促進します。

### 複雑な変数ワークフロー

マルチステップワークフローは、異なるエージェントと処理段階間でコンテキストの連続性を維持することで変数埋め込みの恩恵を受けます。各ステップは共有コンテキストに貢献し、後続のステップが活用できる豊富な情報を構築します。

**ワークフロー設計の考慮事項：**
- 競合を避けるために変数名前空間を計画する
- ワークフローステップ間で一貫した命名規則を使用する
- 意味のある情報を提供するコンテキスト変数を設計する
- 変数のスコープとライフサイクル管理を考慮する

変数埋め込みは評価システムとシームレスに連携し、品質基準とフィードバックがワークフロー段階間を流れることを可能にします。

## 5. コンテキスト管理とメモリ

### インテリジェントコンテキストプロバイダー

コンテキストプロバイダーは、会話履歴、ファイル内容、動的データソースなど、AIエージェントの関連情報を自動的に管理します。このシステムは手動のコンテキスト管理を排除しながら、エージェントが適切な情報にアクセスできることを保証します。

**コンテキストプロバイダー設定：**
- トークンの考慮事項に基づいて会話履歴制限を設定する
- 自動包含のために関連ファイルとディレクトリを指定する
- 開発支援シナリオのためにソースコード分析を設定する
- コンテキストの豊富さと処理効率のバランスを取る

コンテキストプロバイダーは透明に動作し、情報管理ではなくエージェントの動作に焦点を当てることができます。システムは関連性とトークン制限に基づいて自動的にコンテキストをフィルタリングし優先順位を付けます。

### コンテキストベースのエージェントチェーン

共有コンテキストを通じたエージェントチェーンは、複数の専門エージェントが複雑なタスクで協力する洗練されたワークフローを可能にします。各エージェントは専門知識を貢献しながら、以前の作業の上に構築します。

**チェーン設計パターン：**
- 複雑な問題の異なる側面に対して専門エージェントを使用する
- 重要な情報を保持するコンテキストハンドオフパターンを設計する
- 重要な移行ポイントで評価を実装する
- エラー回復とフォールバック戦略を考慮する

共有コンテキストは実行履歴、評価結果、累積状態を維持し、エージェント間の洗練された調整を可能にします。

## 6. 構造化出力とデータ処理

### Pydanticモデル統合

構造化出力は、AI生成コンテンツが特定のデータスキーマに準拠することを保証し、他のシステムとの信頼できる統合を可能にします。Pydanticモデルは、AI出力の型安全性、検証、シリアル化を提供します。

**構造化出力の利点：**
- ダウンストリーム処理のための一貫したデータ形式を保証
- 既存システムとの型安全な統合を可能にする
- AI生成コンテンツの自動検証を提供
- 予測可能なデータ構造でテストとデバッグを促進する

`output_model`を指定すると、Refinireはエージェントのレスポンスが定義されたスキーマに準拠することを保証し、解析と検証を自動的に処理します。

## 7. マルチプロバイダーワークフロー

### プロバイダー固有の最適化

異なるLLMプロバイダーは異なるタイプのタスクに優れています。マルチプロバイダーワークフローは、特定の処理ステップを最適なプロバイダーにルーティングすることで、これらの強みを活用します。

**プロバイダー選択戦略：**
- 適切なタスク（分析、創造性、技術実装）にプロバイダーの強みを使用する
- 異なるプロバイダーのコストとパフォーマンスのトレードオフを考慮する
- プロバイダー固有の動作を適切に処理するワークフローを設計する
- プロバイダーの可用性問題に対するフォールバック戦略を実装する

マルチプロバイダーアプローチには、モデル機能、レスポンス形式、統合パターンの慎重な考慮が必要です。

## 8. パフォーマンス監視と分析

### トレース分析とデバッグ

Refinireのトレースシステムは、詳細な実行情報を自動的にキャプチャし、パフォーマンス分析とデバッグを可能にします。トレースレジストリは、システム動作を理解するための検索と分析機能を提供します。

**監視実装：**
- 開発とデバッグシナリオでトレースを有効にする
- トレース検索機能を使用してパフォーマンスパターンを特定する
- 特定の監視ニーズに対してカスタムトレース分析を実装する
- トレースデータ量とストレージの影響を考慮する

トレースは実行時間、成功率、エラーパターンに関する洞察を提供し、AIワークフローのデータ駆動最適化を可能にします。

## 本番システムのベストプラクティス

### エラーハンドリングと回復力

本番AIシステムには、ユーザーエクスペリエンスを維持しながら障害を適切に管理する堅牢なエラーハンドリング戦略が必要です。ネットワーク問題、プロバイダーの制限、予期しない入力を適切に処理するようにシステムを設計します。

### リソース管理

効果的なリソース管理は、一貫したパフォーマンスとコスト制御を保証します。本番ワークフローを設計する際は、トークン制限、リクエストレート、並行性制限を考慮してください。

### 設定管理

異なるデプロイメントシナリオを管理するために環境ベースの設定を使用します。一貫した動作パターンを維持しながら、開発、ステージング、本番設定を分離します。

これらの高度機能により、複雑な要件に適応しながら信頼性とパフォーマンスを維持する洗練された本番対応AIワークフローが可能になります。