# 要件定義書

## プロジェクトの目的・背景
OpenAI Agents SDKを活用し、生成・評価・ツール連携・ガードレールなどのAIワークフローを簡単に構築・拡張できるPythonライブラリを提供する。

## 利用者と困りごと
| 利用者の種類 | ゴール | 制約 | 困りごと |
|---|---|---|---|
| AI開発者 | LLMを活用した多様なワークフローを素早く構築 | Python, SDK依存 | サンプルや設計例が少ない、ガードレールやツール連携の実装が煩雑 |
| 研究者 | 評価や安全性を担保したAI実験 | 柔軟なカスタマイズ | 評価・安全性の仕組みが不足 |

## 採用する技術スタック
| 技術 | バージョン/備考 |
|---|---|
| Python | 3.10以上 |
| OpenAI Agents SDK | 最新 |
| pydantic | 2.x |

## 機能（ユースケース）一覧
| 困りごと | 機能（ユースケース） | 機能のイメージ |
|---|---|---|
| サンプルや設計例が少ない | AgentPipelineによる生成・評価・ツール連携・ガードレールの統合 | コード例・examples/pipeline_*.py |
| 評価・安全性の仕組みが不足 | 入力ガードレール・自動評価 | ガードレール/評価テンプレートの活用 |

---

## 参考
- 詳細な事例は [docs/pipeline_examples.md](pipeline_examples.md) を参照。 