"""
Package which contains the classes to communicate with HIRO Graph.
"""
import site
from os import path

from hiro_graph_client.appclient import HiroApp
from hiro_graph_client.authclient import HiroAuth
from hiro_graph_client.iamclient import HiroIam
from hiro_graph_client.batchclient import HiroGraphBatch, SessionData, AbstractIOCarrier, BasicFileIOCarrier, \
    SourceValueError, HiroResultCallback
from hiro_graph_client.client import HiroGraph
from hiro_graph_client.clientlib import AbstractTokenApiHandler, AuthenticationTokenError, FixedTokenError, \
    TokenUnauthorizedError, PasswordAuthTokenApiHandler, FixedTokenApiHandler, EnvironmentTokenApiHandler, \
    accept_all_certs, SSLConfig

from hiro_graph_client.version import __version__

this_directory = path.abspath(path.dirname(__file__))

__all__ = [
    'HiroGraph', 'HiroAuth', 'HiroApp', 'HiroIam', 'HiroGraphBatch', 'SessionData',
    'HiroResultCallback', 'AbstractTokenApiHandler', 'PasswordAuthTokenApiHandler', 'FixedTokenApiHandler',
    'EnvironmentTokenApiHandler', 'AuthenticationTokenError', 'FixedTokenError', 'TokenUnauthorizedError',
    'AbstractIOCarrier', 'BasicFileIOCarrier', 'SourceValueError', '__version__', 'accept_all_certs',
    'SSLConfig'
]

site.addsitedir(this_directory)
