/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.DelayAlerter;
import TCGA.URLLauncherDesktop;
import com.croftsoft.core.jnlp.JnlpProxy;
import java.applet.Applet;
import java.applet.AppletContext;
import java.net.URL;
import java.util.Observable;
import javax.swing.JOptionPane;

public class URLLauncher
extends Observable
implements Runnable {
    private URL url;
    private String target;
    private static URL access_url = null;
    private static Applet applet = null;
    private static String DEFAULT_URL_STRING = "https://cgwb.nci.nih.gov/cgi-bin/heatmap";
    private static String DELAY_WARNING = "It seems to be taking a while to launch the web page; this can happen if the remote server is busy.  Please wait, the page should start eventually.";
    private static int DELAY_MS_BEFORE_WARNING = 5000;

    public URLLauncher(URL url, String target) {
        this.url = url;
        this.target = target;
        new Thread(this).start();
    }

    public URLLauncher(String url, String target) {
        try {
            this.url = new URL(url);
            this.target = target;
            new Thread(this).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        long start_time = System.currentTimeMillis();
        System.err.println("attempting to launch URL: " + this.url);
        boolean launched = false;
        this.addObserver(new DelayAlerter(DELAY_MS_BEFORE_WARNING, DELAY_WARNING));
        try {
            Class<?> t = Class.forName("java.awt.Desktop");
            launched = URLLauncherDesktop.launch_url(this.url);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!launched) {
            if (applet != null) {
                System.err.println("launching URL via applet");
                AppletContext ac = applet.getAppletContext();
                ac.showDocument(this.url, this.target);
            } else if (JnlpProxy.showDocument((URL)this.url)) {
                System.err.println("launched via JNLP!");
            } else {
                String msg = "Unable to launch URL on your system.  Please enter the following link into your web browser: " + this.url.toString();
                System.err.println("can't launch URL: " + this.url.toString());
                this.setChanged();
                this.notifyObservers();
                JOptionPane.showMessageDialog(null, msg, "Warning", 2);
            }
        }
        long elapsed = System.currentTimeMillis() - start_time;
        this.setChanged();
        this.notifyObservers();
    }

    public static void launch_url(String url_string, String target) {
        try {
            URL url = new URL(url_string);
            URLLauncher.launch_url(url, target);
        }
        catch (Exception e) {
            System.err.println("ERROR:" + e);
        }
    }

    public static void launch_url(URL url, String target) {
        new URLLauncher(url, target);
    }

    public static void set_applet(Applet ap) {
        applet = ap;
        access_url = applet.getCodeBase();
    }

    public static void set_url(String url) {
        try {
            access_url = new URL(url);
        }
        catch (Exception e) {
            System.err.println("invalid URL:" + e);
            access_url = null;
        }
    }

    public static URL get_url() {
        if (access_url == null) {
            URLLauncher.set_url(DEFAULT_URL_STRING);
        }
        return access_url;
    }

    public static URL get_modified_url(String spec) {
        URL result = null;
        try {
            result = new URL(URLLauncher.get_url(), spec);
        }
        catch (Exception e) {
            System.err.println("ERROR:" + e);
        }
        return result;
    }

    public static void launch_modified_url(String spec, String target) {
        URL url = URLLauncher.get_modified_url(spec);
        if (url != null) {
            URLLauncher.launch_url(url, target);
        }
    }
}

