/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.BooleanComparator;
import TCGA.ByteComparator;
import TCGA.ControlFrame;
import TCGA.ControlFrameListener;
import TCGA.GenomicMeasurement;
import TCGA.Heatmap6;
import TCGA.HeatmapConfiguration;
import TCGA.SampleSubsets;
import TCGA.SubsetCombiner;
import java.awt.BorderLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class SubsetCombinerControl
implements ControlFrameListener {
    private ControlFrame jf;
    private HeatmapConfiguration config;
    private JComboBox jc_sub1;
    private JComboBox jc_logic1;
    private JComboBox jc_value1;
    private JComboBox jc_sub2;
    private JComboBox jc_logic2;
    private JComboBox jc_value2;
    private JComboBox jc_join;
    private JTextField jt_value1;
    private JTextField jt_value2;

    public SubsetCombinerControl(HeatmapConfiguration config) {
        this.config = config;
        this.setup();
    }

    private void setup() {
        this.jf = new ControlFrame(this);
        SampleSubsets ss = this.config.gm.get_sample_subsets();
        if (ss.isEmpty()) {
            System.err.println("ERROR: no samples in subset");
        } else {
            JPanel jp = new JPanel();
            jp.setLayout(new SpringLayout());
            ArrayList<String> subsl = ss.get_subsets_arraylist();
            Collections.sort(subsl);
            Vector<String> subs = new Vector<String>(subsl);
            Vector<String> logic_comp = new Vector<String>();
            logic_comp.add("!=");
            logic_comp.add(">");
            logic_comp.add(">=");
            logic_comp.add("<");
            logic_comp.add("<=");
            logic_comp.add("=");
            Vector<String> logic_op = new Vector<String>();
            logic_op.add("and");
            logic_op.add("or");
            this.jc_sub1 = new JComboBox<String>(subs);
            jp.add(this.jc_sub1);
            this.jc_logic1 = new JComboBox(logic_comp);
            jp.add(this.jc_logic1);
            this.jt_value1 = new JTextField("0");
            jp.add(this.jt_value1);
            jp.add(new JLabel(""));
            this.jc_join = new JComboBox(logic_op);
            jp.add(this.jc_join);
            jp.add(new JLabel(""));
            this.jc_sub2 = new JComboBox<String>(subs);
            jp.add(this.jc_sub2);
            this.jc_logic2 = new JComboBox(logic_comp);
            jp.add(this.jc_logic2);
            this.jt_value2 = new JTextField("0");
            jp.add(this.jt_value2);
            SpringUtilities.makeCompactGrid((Container)jp, (int)3, (int)3, (int)6, (int)6, (int)6, (int)6);
            this.jf.setTitle("Combine data subsets");
            this.jf.setLayout(new BorderLayout());
            this.jf.add("Center", jp);
            this.jf.add("South", this.jf.generate_panel(1));
            this.jf.pack();
            this.jf.setVisible(true);
        }
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            HeatmapConfiguration config = new HeatmapConfiguration();
            config.gm = new GenomicMeasurement("65_binary.gz", false);
            new SubsetCombinerControl(config);
        }
        catch (Exception e) {
            System.err.println("error:" + e);
        }
    }

    public void apply_changes() {
        String subset_1 = (String)this.jc_sub1.getSelectedItem();
        byte value_1 = Byte.parseByte(this.jt_value1.getText());
        String logic_1 = (String)this.jc_logic1.getSelectedItem();
        ByteComparator bc_1 = ByteComparator.get_comparator(logic_1, value_1);
        String subset_2 = (String)this.jc_sub2.getSelectedItem();
        byte value_2 = Byte.parseByte(this.jt_value2.getText());
        String logic_2 = (String)this.jc_logic2.getSelectedItem();
        ByteComparator bc_2 = ByteComparator.get_comparator(logic_2, value_2);
        String join = (String)this.jc_join.getSelectedItem();
        BooleanComparator bc_join = BooleanComparator.get_comparator(join);
        System.err.println(subset_1 + " " + subset_2);
        SubsetCombiner ssc = new SubsetCombiner(this.config.gm, subset_1, bc_1, subset_2, bc_2, bc_join);
        HeatmapConfiguration hc = new HeatmapConfiguration();
        hc.exit_on_close = false;
        hc.show_up_down_histogram = false;
        hc.gs = this.config.gs;
        hc.gm = ssc.get_results();
        hc.parent_gm = this.config.gm;
        hc.parent_subsets = new ArrayList();
        hc.parent_subsets.add(subset_1);
        hc.parent_subsets.add(subset_2);
        try {
            Heatmap6 hm = new Heatmap6(hc);
        }
        catch (Exception ex) {
            System.err.println("error:" + ex);
        }
    }
}

