/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.util.Arrays;

public class Statistics {
    public static void main(String[] argv) {
        byte[] array1 = new byte[]{2, 2, 2};
        byte[] array2 = new byte[]{2, 2, 2};
        try {
            double r = Statistics.pearson_r(array1, array2, true, (byte)-99, false);
            System.err.println("r=" + r);
        }
        catch (Exception e) {
            System.err.println("error:" + e);
        }
    }

    public static double euclidean_distance(byte[] x, byte[] y, boolean invalid_filter, byte invalid_value, byte limiter) throws ArithmeticException {
        int usable = 0;
        int total = 0;
        if (limiter > 0) {
            for (int i = 0; i < x.length; ++i) {
                if (invalid_filter && (x[i] == invalid_value || y[i] == invalid_value)) continue;
                byte xv = x[i];
                byte yv = y[i];
                if (xv > limiter) {
                    xv = limiter;
                } else if (xv < -limiter) {
                    xv = -limiter;
                }
                if (yv > limiter) {
                    yv = limiter;
                } else if (yv < -limiter) {
                    yv = -limiter;
                }
                total = (int)((double)total + Math.pow(xv - yv, 2.0));
                ++usable;
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                if (invalid_filter && (x[i] == invalid_value || y[i] == invalid_value)) continue;
                total = (int)((double)total + Math.pow(x[i] - y[i], 2.0));
                ++usable;
            }
        }
        if (usable == 0) {
            throw new ArithmeticException("no computable values");
        }
        return Math.sqrt(total);
    }

    public static double pearson_r(byte[] x, byte[] y) throws ArithmeticException {
        return Statistics.pearson_r(x, y, false, (byte)0, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double pearson_r(byte[] x, byte[] y, boolean invalid_filter, byte invalid_value, boolean nan_hack) throws ArithmeticException {
        int i;
        if (x.length != y.length) {
            throw new ArithmeticException("pearson_r: array length mismatch");
        }
        double Ex = 0.0;
        double Ey = 0.0;
        double Exy = 0.0;
        double Ex2 = 0.0;
        double Ey2 = 0.0;
        int n = 0;
        for (i = 0; i < x.length; ++i) {
            if (invalid_filter && (x[i] == invalid_value || y[i] == invalid_value)) continue;
            double xv = x[i];
            double yv = y[i];
            Ex += xv;
            Ey += yv;
            Exy += xv * yv;
            Ex2 += xv * xv;
            Ey2 += yv * yv;
            ++n;
        }
        if (n == 0) {
            throw new ArithmeticException("pearson_r: no valid values");
        }
        double r = (Exy - Ex * Ey / (double)n) / Math.sqrt((Ex2 - Ex * Ex / (double)n) * (Ey2 - Ey * Ey / (double)n));
        if (!new Double(r).equals(new Double(Double.NaN))) return r;
        if (!nan_hack) throw new ArithmeticException("pearson_r: NaN result");
        boolean identical = true;
        if (invalid_filter) {
            for (i = 0; i < x.length; ++i) {
                if (invalid_filter && (x[i] == invalid_value || y[i] == invalid_value) || x[i] == y[i]) continue;
                identical = false;
                break;
            }
        } else {
            identical = Arrays.equals(x, y);
        }
        if (!identical) throw new ArithmeticException("pearson_r: NaN result");
        return 1.0;
    }
}

