/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class RubberBandSelection
implements MouseListener,
MouseMotionListener {
    protected Point origin;
    protected Point drag_point;
    protected Component c;
    private static int ACTIVE_BUTTON_MASK = 16;
    private Point start;
    private Point end;
    private String selected_label;

    public RubberBandSelection(Component c) {
        this.c = c;
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
    }

    protected boolean is_usable_event(MouseEvent e) {
        return (e.getModifiers() & ACTIVE_BUTTON_MASK) > 0;
    }

    public void mousePressed(MouseEvent e) {
        if (this.is_usable_event(e)) {
            this.origin = e.getPoint();
            this.drag_point = null;
            this.c.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.is_usable_event(e) && e.getID() == 506) {
            this.drag_point = e.getPoint();
            this.c.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public boolean has_selection() {
        return this.origin != null && this.drag_point != null;
    }

    public void clear_selection() {
        this.drag_point = null;
        this.origin = null;
        this.selected_label = null;
    }

    private void sort_points() {
        this.start = new Point();
        this.end = new Point();
        if (this.drag_point.y < 0) {
            this.drag_point.y = 0;
        }
        if (this.origin.x < this.drag_point.x) {
            this.start.x = this.origin.x;
            this.end.x = this.drag_point.x;
        } else {
            this.start.x = this.drag_point.x;
            this.end.x = this.origin.x;
        }
        if (this.origin.y < this.drag_point.y) {
            this.start.y = this.origin.y;
            this.end.y = this.drag_point.y;
        } else {
            this.start.y = this.drag_point.y;
            this.end.y = this.origin.y;
        }
        if (this.start.x < 0) {
            this.start.x = 0;
        }
    }

    public Point get_start_point() {
        this.sort_points();
        return this.start;
    }

    public Point get_end_point() {
        this.sort_points();
        return this.end;
    }

    public int get_start_x() {
        this.sort_points();
        return this.start.x;
    }

    public int get_end_x() {
        this.sort_points();
        return this.end.x;
    }

    public int get_start_y() {
        this.sort_points();
        return this.start.y;
    }

    public int get_end_y() {
        this.sort_points();
        return this.end.y;
    }

    public Rectangle get_selection() {
        Rectangle result = null;
        if (this.origin != null && this.drag_point != null) {
            this.sort_points();
            result = new Rectangle(this.start.x, this.start.y, this.end.x - this.start.x + 1, this.end.y - this.start.y + 1);
        }
        return result;
    }

    public void set_selection(Rectangle r) {
        this.origin = new Point(r.x, r.y);
        this.drag_point = new Point(r.x + r.width - 1, r.y + r.height - 1);
    }

    public void set_selected_label(String s) {
        this.selected_label = s;
    }

    public String get_selected_label() {
        return this.selected_label;
    }
}

