/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.VisibilityToggle;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressFrame
extends Observable
implements VisibilityToggle {
    private JFrame jf;
    private JProgressBar jpb;
    private String title;
    private String label;
    private int max_value;
    private boolean wants_cancel = false;

    public ProgressFrame(String title, String label, int max_value, boolean wants_cancel) {
        this.title = title;
        this.label = label;
        this.max_value = max_value;
        this.wants_cancel = wants_cancel;
        this.setup();
    }

    private JPanel create_padded_panel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return jp;
    }

    private void setup() {
        this.jf = new JFrame();
        this.jf.setTitle(this.title);
        this.jf.getContentPane().setLayout(new BorderLayout());
        JPanel jp = this.create_padded_panel();
        this.jpb = new JProgressBar(0, this.max_value);
        this.jpb.setValue(0);
        this.jpb.setStringPainted(true);
        jp.setLayout(new BorderLayout());
        jp.add("Center", this.jpb);
        this.jf.getContentPane().add("Center", jp);
        jp = this.create_padded_panel();
        JLabel jl = new JLabel(this.label, 0);
        Dimension dl = jl.getPreferredSize();
        Dimension dp = this.jpb.getPreferredSize();
        int min_w = dl.width * 2;
        if (dp.width < min_w) {
            dp.width = min_w;
            this.jpb.setPreferredSize(dp);
        }
        jp.add(jl);
        this.jf.getContentPane().add("North", jp);
        if (this.wants_cancel) {
            jp = this.create_padded_panel();
            JButton jb = new JButton("Cancel");
            jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProgressFrame.this.setChanged();
                    ProgressFrame.this.notifyObservers();
                }
            });
            jp.add(jb);
            this.jf.getContentPane().add("South", jp);
        }
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        new ProgressFrame("Working...", "progress test", 100, true);
    }

    public void setValue(int n) {
        this.jpb.setValue(n);
    }
}

