/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.GenomicSample;
import TCGA.Statistics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PearsonRCluster
extends Cluster
implements Comparator {
    private static final double DEFAULT_MIN_R_TO_CLUSTER = 0.9;
    public static boolean CLUSTER_EMPTY_SEQUENCES = true;

    @Override
    public String get_method_name() {
        return "Pearson's r";
    }

    @Override
    public boolean are_higher_distance_values_closer() {
        return true;
    }

    @Override
    public double compute_single_distance(byte[] sample1, byte[] sample2) throws ArithmeticException {
        return Statistics.pearson_r(sample1, sample2, true, (byte)-99, false);
    }

    @Override
    public Cluster create_new_cluster() {
        return new PearsonRCluster();
    }

    @Override
    public double get_default_cluster_stop_threshold() {
        return 0.9;
    }

    @Override
    public void precluster(HashSet<Cluster> clusters, ArrayList<GenomicSample> rows) {
        if (CLUSTER_EMPTY_SEQUENCES) {
            ArrayList<Cluster> empty_clusters = new ArrayList<Cluster>();
            for (Cluster c : clusters) {
                int[] ids = c.get_ids();
                boolean all_empty = true;
                for (int i = 0; i < ids.length; ++i) {
                    GenomicSample gs = rows.get(ids[i]);
                    if (gs.all_empty) continue;
                    all_empty = false;
                    break;
                }
                if (!all_empty) continue;
                empty_clusters.add(c);
            }
            if (empty_clusters.size() > 1) {
                Cluster master = (Cluster)empty_clusters.get(0);
                for (int i = 1; i < empty_clusters.size(); ++i) {
                    Cluster sub = (Cluster)empty_clusters.get(i);
                    master.addAll(sub);
                    clusters.remove(sub);
                }
            }
        }
    }

    @Override
    public boolean validate_distance_matrix_cache() {
        return true;
    }
}

