/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.AnnotationFlatfile2;
import TCGA.ErrorReporter;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.Heatmap6;
import TCGA.HeatmapConfiguration;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class HeatmapLocalFileLauncher
extends JFrame
implements ActionListener,
Runnable {
    JFileChooser fc;
    JTextField fn_data;
    JTextField fn_bin;
    JTextField fn_annotations;
    JButton jb_data;
    JButton jb_bin;
    JButton jb_annotations;
    JButton jb_launch;

    public HeatmapLocalFileLauncher() {
        this.setTitle("Heatmap launcher");
        this.setDefaultCloseOperation(3);
        this.fc = new JFileChooser();
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel p = new JPanel(new SpringLayout());
        p.add(new JLabel("Data file:", 11));
        this.fn_data = new JTextField(80);
        p.add(this.fn_data);
        this.jb_data = new JButton("Browse...");
        p.add(this.jb_data);
        p.add(new JLabel("Set/bin file (optional):", 11));
        this.fn_bin = new JTextField(80);
        p.add(this.fn_bin);
        this.jb_bin = new JButton("Browse...");
        p.add(this.jb_bin);
        p.add(new JLabel("Annotation file (optional):", 11));
        this.fn_annotations = new JTextField(80);
        p.add(this.fn_annotations);
        this.jb_annotations = new JButton("Browse...");
        p.add(this.jb_annotations);
        jp_main.add(p);
        SpringUtilities.makeCompactGrid((Container)p, (int)3, (int)3, (int)6, (int)6, (int)6, (int)6);
        p = new JPanel();
        this.jb_launch = new JButton("Start viewer");
        p.add(this.jb_launch);
        jp_main.add(p);
        this.jb_data.addActionListener(this);
        this.jb_bin.addActionListener(this);
        this.jb_annotations.addActionListener(this);
        this.jb_launch.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jp_main);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.jb_data) || src.equals(this.jb_bin) || src.equals(this.jb_annotations)) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                JTextField jtf = null;
                if (src.equals(this.jb_data)) {
                    jtf = this.fn_data;
                } else if (src.equals(this.jb_bin)) {
                    jtf = this.fn_bin;
                } else if (src.equals(this.jb_annotations)) {
                    jtf = this.fn_annotations;
                }
                jtf.setText(file.getAbsolutePath());
            }
        } else if (src.equals(this.jb_launch)) {
            new Thread(this).start();
        }
    }

    public void run() {
        String gm_file = this.fn_data.getText();
        String bin_file = this.fn_bin.getText();
        String annotation_file = this.fn_annotations.getText();
        if (gm_file.length() > 0) {
            try {
                this.setVisible(false);
                GenomicMeasurement gm = new GenomicMeasurement(gm_file);
                AnnotationFlatfile2 af = annotation_file.length() == 0 ? null : new AnnotationFlatfile2(annotation_file);
                GenomicSet gs = bin_file.length() > 0 ? new GenomicSet(bin_file) : null;
                HeatmapConfiguration config = new HeatmapConfiguration(af, gm, gs);
                config.title = Str.basename(gm_file);
                Heatmap6 hm = new Heatmap6(config);
            }
            catch (Exception ex) {
                System.err.println("ERROR:" + ex);
                new ErrorReporter(ex);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Specify a data file to display.", "Error", 0);
        }
    }

    public JFileChooser get_chooser() {
        return this.fc;
    }
}

