/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import Funk.Str;
import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.PearsonRCluster;
import TCGA.SampleSortTools;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CustomSortControl
extends Observable {
    private static final String LABEL_SHOW_ALL = "Show current ID ordering";
    private static final String LABEL_CLEAR = "Clear";
    private static final String LABEL_SORT = "Set sort order";
    private static final String LABEL_CANCEL = "Cancel";
    private JFrame jf;
    private JTextArea jta;
    private GenomicMeasurement gm;
    private static final String CLUSTER_BOUNDARY_MARKER = ">cluster_boundary";

    public CustomSortControl(GenomicMeasurement gm) {
        this.gm = gm;
        this.setup();
    }

    private JButton generate_jbutton(String label, ActionListener al, String tooltip_text) {
        JButton jb = new JButton(label);
        jb.addActionListener(al);
        if (tooltip_text != null) {
            jb.setToolTipText(tooltip_text);
        }
        return jb;
    }

    private void setup() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel sub_p = this.get_buffer_titled_panel(panel, "Specify sample ID ordering:");
        sub_p.setLayout(new BorderLayout());
        this.jta = new JTextArea(20, 40);
        this.show_all_ids();
        JScrollPane jsp_samples = new JScrollPane(this.jta, 20, 30);
        sub_p.add("Center", jsp_samples);
        panel.add(sub_p);
        sub_p = new JPanel();
        panel.add(sub_p);
        sub_p.add(this.generate_jbutton(LABEL_SORT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomSortControl.this.sort_samples();
            }
        }, "Set the sample sort order.  If only a subset of the IDs are specified, they will be moved to the top of the current sort order."));
        sub_p.add(new JLabel("    "));
        sub_p.add(this.generate_jbutton(LABEL_SHOW_ALL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomSortControl.this.show_all_ids();
            }
        }, "Reset list to show the current ordering of sample IDs in the dataset."));
        sub_p.add(this.generate_jbutton(LABEL_CLEAR, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomSortControl.this.jta.setText("");
            }
        }, "Clears the sample ID list."));
        sub_p.add(new JLabel("    "));
        sub_p.add(this.generate_jbutton(LABEL_CANCEL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomSortControl.this.jf.setVisible(false);
            }
        }, null));
        this.jf = new JFrame("Set custom sort order");
        this.jf.add(panel);
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public void setState(int state) {
        this.jf.setState(state);
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            GenomicMeasurement gm = new GenomicMeasurement("p53.txt", false);
            ClusterTool ct = new ClusterTool(gm);
            ct.set_cluster_stop_threshold(0.9f);
            ct.cluster(new PearsonRCluster(), false, false);
            CustomSortControl customSortControl = new CustomSortControl(gm);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        jp_buffer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    private void sort_samples() {
        SampleSortTools sst = new SampleSortTools(this.gm);
        HashMap<String, ArrayList<GenomicSample>> patient2samples = sst.get_patient2samples();
        String[] patients = this.jta.getText().split("\\s+");
        ArrayList<String> unique_patient_ids = this.gm.get_unique_patient_ids();
        HashSet<String> unique = new HashSet<String>(unique_patient_ids);
        HashSet desired_order = new HashSet();
        ArrayList<GenomicSample> rows_new = new ArrayList<GenomicSample>();
        HashSet<String> processed = new HashSet<String>();
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<Cluster> cluster_list = new ArrayList<Cluster>();
        ArrayList<GenomicSample> cluster_queue = new ArrayList<GenomicSample>();
        for (int i = 0; i < patients.length; ++i) {
            String found_id = null;
            if (patients[i].length() == 0) continue;
            if (patients[i].equals(CLUSTER_BOUNDARY_MARKER)) {
                PearsonRCluster cluster = new PearsonRCluster();
                cluster.set_sample_data(cluster_queue);
                cluster_list.add(cluster);
                cluster_queue = new ArrayList();
                continue;
            }
            if (unique.contains(patients[i])) {
                found_id = patients[i];
            } else {
                for (String id : unique_patient_ids) {
                    if (!patients[i].equalsIgnoreCase(id)) continue;
                    found_id = id;
                }
            }
            if (found_id == null) {
                missing.add(patients[i]);
                continue;
            }
            rows_new.addAll((Collection<GenomicSample>)patient2samples.get(found_id));
            cluster_queue.addAll((Collection<GenomicSample>)patient2samples.get(found_id));
            processed.add(found_id);
        }
        for (GenomicSample gs : this.gm.get_rows()) {
            if (processed.contains(gs.patient_id)) continue;
            rows_new.add(gs);
        }
        if (this.gm.get_rows().size() != rows_new.size()) {
            System.err.println("ERROR: size mismatch in custom sort!!");
        }
        if (missing.size() > 0) {
            String msg = "Can't find " + missing.size() + " sample ID" + (missing.size() == 1 ? "" : "s") + ": " + Str.join(", ", missing.iterator());
            JOptionPane.showMessageDialog(this.jf, msg);
        }
        this.gm.set_rows(rows_new, true);
        if (cluster_list.size() > 0) {
            this.gm.get_divider_manager().set_cluster_list(cluster_list);
        }
        this.setVisible(false);
    }

    private void show_all_ids() {
        StringBuilder sb = new StringBuilder();
        HashSet<String> cluster_end = this.gm.get_divider_manager().get_last_patients_in_clusters();
        for (String id : this.gm.get_unique_patient_ids()) {
            sb = sb.append(id + "\n");
            if (!cluster_end.contains(id)) continue;
            sb = sb.append(">cluster_boundary\n");
        }
        this.jta.setText(sb.toString());
    }
}

