/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorScheme;
import TCGA.ColorSchemeModel;
import TCGA.GenomicMeasurement;
import TCGA.HeatmapConfiguration;
import TCGA.Options;
import TCGA.SampleSummaryInfo;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.SpringUtilities;

public class ContrastControlPanel
extends JPanel
implements ActionListener {
    private static final int BORDER_SIZE = 10;
    private static String LABEL_OPTIMIZE = "Optimize";
    private ColorScheme cs;
    private GenomicMeasurement gm;
    private JSlider[] sliders;
    private JSlider js_min_brightness_level;
    private JComboBox jc_schemes;
    private JComboBox jc_background;
    private JComboBox jc_increase;
    private JComboBox jc_decrease;
    private JButton jb_guess;
    private String subset;
    private HeatmapConfiguration config;

    public ContrastControlPanel(ColorScheme cs, String subset, HeatmapConfiguration config) {
        this.config = config;
        this.cs = cs;
        this.gm = config.gm;
        this.subset = subset;
        this.setup();
    }

    private void setup() {
        int i;
        this.setLayout(new BoxLayout(this, 3));
        String gradients_label = "Brightness gradients:";
        this.sliders = new JSlider[Options.SLIDER_COUNT];
        int[] gradients = this.cs == null ? Options.DEFAULT_COPYNUMBER_GRADIENTS : this.cs.get_gradients();
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ContrastControlPanel.this.calculate_minimum_intensity();
            }
        };
        for (i = 0; i < Options.SLIDER_COUNT; ++i) {
            int value;
            int n = value = i < gradients.length ? gradients[i] : 0;
            if (value > Options.MAX_GRADIENTS) {
                value = Options.MAX_GRADIENTS;
            }
            JSlider js = new JSlider(0, Options.MAX_GRADIENTS, value);
            int minor = Options.MAX_GRADIENTS / 20;
            if (minor < 1) {
                minor = 1;
            }
            int major = Options.MAX_GRADIENTS / 4;
            js.setMinorTickSpacing(minor);
            js.setMajorTickSpacing(major);
            js.setSnapToTicks(true);
            js.setPaintTicks(true);
            js.setPaintLabels(true);
            js.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            js.addChangeListener(cl);
            this.sliders[i] = js;
        }
        this.js_min_brightness_level = new JSlider(0, 100, this.cs == null ? 50 : this.cs.get_minimum_intensity_percent());
        this.js_min_brightness_level.setMinorTickSpacing(Options.BRIGHTNESS_MINOR_TICK);
        this.js_min_brightness_level.setMajorTickSpacing(20);
        this.js_min_brightness_level.setSnapToTicks(true);
        this.js_min_brightness_level.setPaintTicks(true);
        this.js_min_brightness_level.setPaintLabels(true);
        this.js_min_brightness_level.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel jp = this.get_buffer_titled_panel(this, "Colors");
        jp.setLayout(new SpringLayout());
        Vector<String> schemes = new Vector<String>();
        schemes.add(ColorScheme.COLOR_SCHEME_RED_GREEN);
        schemes.add(ColorScheme.COLOR_SCHEME_RED_BLUE);
        schemes.add(ColorScheme.COLOR_SCHEME_MAGENTA_CYAN);
        schemes.add(ColorScheme.COLOR_SCHEME_RED_CYAN);
        schemes.add(ColorScheme.COLOR_SCHEME_GREEN_MAGENTA);
        schemes.add(ColorScheme.COLOR_SCHEME_BLUE_YELLOW);
        schemes.add(ColorScheme.COLOR_SCHEME_GREEN_YELLOW);
        schemes.add(ColorScheme.COLOR_SCHEME_ORANGE_WHITE);
        schemes.add(ColorScheme.COLOR_SCHEME_YELLOW_WHITE);
        this.jc_schemes = new JComboBox(schemes);
        this.jc_schemes.setSelectedItem(Options.DEFAULT_COLOR_SCHEME);
        this.jc_schemes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ContrastControlPanel.this.set_colors_from_current_scheme();
            }
        });
        String[] default_colors = Options.DEFAULT_COLOR_SCHEME.split("/");
        Vector<String> bg_colors = new Vector<String>();
        bg_colors.add("White");
        bg_colors.add("Black");
        this.jc_background = new JComboBox(bg_colors);
        this.set_current_values();
        Vector<String> color_names = new Vector<String>(ColorScheme.get_color_names());
        jp.add(new JLabel("Increase:", 11));
        this.jc_increase = new JComboBox<String>(color_names);
        jp.add(this.jc_increase);
        jp.add(new JLabel("Decrease:", 11));
        this.jc_decrease = new JComboBox<String>(color_names);
        jp.add(this.jc_decrease);
        jp.add(new JLabel("Background:", 11));
        jp.add(this.jc_background);
        jp.add(new JLabel(" "));
        jp.add(new JLabel(" "));
        jp.add(new JLabel("Load preset:", 11));
        jp.add(this.jc_schemes);
        this.set_colors_from_current_scheme();
        SpringUtilities.makeCompactGrid((Container)jp, (int)5, (int)2, (int)6, (int)6, (int)6, (int)6);
        jp = this.get_buffer_titled_panel(this, "Baseline brightness level (%)");
        jp.add(this.js_min_brightness_level);
        jp = this.get_buffer_titled_panel(this, gradients_label);
        for (i = 0; i < this.sliders.length; ++i) {
            jp.add(this.sliders[i]);
        }
        JPanel jp_button = new JPanel();
        this.jb_guess = new JButton(LABEL_OPTIMIZE);
        this.jb_guess.addActionListener(this);
        jp_button.add(this.jb_guess);
        jp.add(jp_button);
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        jp_buffer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    public void set_current_values() {
        String color = this.cs.get_colorscheme_model().white_mode ? "White" : "Black";
        this.jc_background.setSelectedItem(color);
    }

    private void set_colors_from_current_scheme() {
        String name = (String)this.jc_schemes.getSelectedItem();
        String[] colors = name.split("/");
        this.jc_increase.setSelectedItem(colors[0]);
        this.jc_decrease.setSelectedItem(colors[1]);
    }

    public void apply_changes() {
        this.apply_changes(true);
    }

    public void apply_changes(boolean notify) {
        ArrayList<Integer> gradients = new ArrayList<Integer>();
        for (int i = 0; i < this.sliders.length; ++i) {
            int v = this.sliders[i].getValue();
            if (v <= 0) continue;
            gradients.add(new Integer(v));
        }
        Collections.sort(gradients);
        int[] g2 = new int[gradients.size()];
        for (int i = 0; i < gradients.size(); ++i) {
            g2[i] = (Integer)gradients.get(i);
        }
        if (this.cs != null) {
            ColorSchemeModel csm = this.cs.get_colorscheme_model();
            csm.up_color = ColorScheme.get_color((String)this.jc_increase.getSelectedItem());
            csm.down_color = ColorScheme.get_color((String)this.jc_decrease.getSelectedItem());
            csm.min_intensity_percent = this.js_min_brightness_level.getValue();
            csm.gradients = g2;
            String bg = (String)this.jc_background.getSelectedItem();
            csm.white_mode = bg.equals("White");
            this.cs.set_colorscheme_model(csm, notify);
        }
    }

    public void actionPerformed(ActionEvent e) {
        SampleSummaryInfo ssi = this.gm.get_sample_summary_info();
        ColorSchemeModel gr = ssi.calculate_gradients(this.subset);
        this.js_min_brightness_level.setValue(gr.min_intensity_percent);
        for (int i = 0; i < this.sliders.length; ++i) {
            this.sliders[i].setValue(i < gr.gradients.length ? gr.gradients[i] : 0);
        }
        this.apply_changes();
    }

    public void set_background_color(String color) {
        this.jc_background.setSelectedItem(color);
    }

    public void set_increase_color(String color) {
        this.jc_increase.setSelectedItem(color);
    }

    public void set_decrease_color(String color) {
        this.jc_decrease.setSelectedItem(color);
    }

    public static int calculate_minimum_intensity(int active_gradient_count) {
        int min_int = 75 - active_gradient_count * 12;
        int mod = min_int % Options.BRIGHTNESS_MINOR_TICK;
        min_int = mod >= Options.BRIGHTNESS_MINOR_TICK / 2 ? (min_int += Options.BRIGHTNESS_MINOR_TICK - mod) : (min_int -= mod);
        return min_int;
    }

    public void calculate_minimum_intensity() {
        int active = 0;
        for (int i = 0; i < this.sliders.length; ++i) {
            int v = this.sliders[i].getValue();
            if (v <= 0) continue;
            ++active;
        }
        this.js_min_brightness_level.setValue(ContrastControlPanel.calculate_minimum_intensity(active));
    }
}

