/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.TableTools;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ClusterReporter {
    private JTable table;
    private ClusterTool ct;
    private GenomicMeasurement gm;

    public ClusterReporter(ClusterTool ct, GenomicMeasurement gm) {
        this.ct = ct;
        this.gm = gm;
        this.setup();
    }

    private void setup() {
        ArrayList<Cluster> cluster_list = this.ct.get_clusters();
        if (cluster_list.size() > 0) {
            JFrame jf = new JFrame("Clustering report");
            jf.getContentPane().setLayout(new BorderLayout());
            Object[] labels = new String[]{"Cluster", "Sample count", "Patient count", "Internal distance", "Members"};
            this.table = new JTable(cluster_list.size() + 7, labels.length);
            this.table.setAutoResizeMode(0);
            DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
            tm.setColumnIdentifiers(labels);
            this.table.getColumnModel().setColumnMargin(5);
            JScrollPane scrollPane = new JScrollPane(this.table);
            boolean cluster_number = false;
            int row_index = 0;
            int samples_clustered = 0;
            for (Cluster c : cluster_list) {
                ArrayList<GenomicSample> samples = c.get_sample_data();
                ArrayList<String> patients = GenomicSample.get_patient_id_list(samples);
                String members = Str.join(", ", patients.iterator());
                int col_index = 0;
                this.table.setValueAt(row_index + 1, row_index, col_index++);
                samples_clustered += c.size();
                this.table.setValueAt(c.size(), row_index, col_index++);
                this.table.setValueAt(patients.size(), row_index, col_index++);
                this.table.setValueAt(c.get_internal_distance(), row_index, col_index++);
                this.table.setValueAt(members, row_index, col_index++);
                ++row_index;
            }
            ArrayList<GenomicSample> leftovers = this.gm.get_unordered_samples();
            ArrayList<String> patients = GenomicSample.get_patient_id_list(leftovers);
            String members = Str.join(", ", patients.iterator());
            int col_index = 0;
            this.table.setValueAt("unclustered", row_index, col_index++);
            this.table.setValueAt(leftovers.size(), row_index, col_index++);
            this.table.setValueAt(patients.size(), row_index, col_index++);
            this.table.setValueAt("n/a", row_index, col_index++);
            this.table.setValueAt(members, row_index, col_index++);
            ++row_index;
            this.table.setValueAt("distance metric:", ++row_index, 0);
            this.table.setValueAt(cluster_list.get(0).get_method_name(), row_index, 1);
            this.table.setValueAt("cluster joining method:", ++row_index, 0);
            this.table.setValueAt(Cluster.describe_distance_method(this.ct.get_distance_method()), row_index, 1);
            this.table.setValueAt("stop threshold:", ++row_index, 0);
            this.table.setValueAt(this.ct.get_cluster_stop_threshold(), row_index, 1);
            int cluster_percent = (int)((double)samples_clustered * 100.0) / (samples_clustered + leftovers.size());
            this.table.setValueAt("percent of samples clustered:", ++row_index, 0);
            this.table.setValueAt(cluster_percent, row_index, 1);
            this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
            TableTools.calcColumnWidths(this.table);
            jf.getContentPane().add("Center", scrollPane);
            jf.pack();
            jf.setVisible(true);
        } else {
            System.err.println("error: no clusters");
        }
    }
}

