/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomicLocation;

public class BinLabel {
    private String bin_label;
    private GenomicLocation genomic_location = null;

    public BinLabel(String s) {
        this.bin_label = s;
        this.parse();
    }

    public boolean is_genomic() {
        return this.genomic_location != null;
    }

    private void parse() {
        String[] start_end;
        String[] chr_pos;
        String lc = this.bin_label.toLowerCase();
        if (lc.indexOf("chr") == 0 && lc.lastIndexOf("mb") == lc.length() - 2 && (chr_pos = lc.split(":")).length == 2 && (start_end = chr_pos[1].split("-")).length == 2) {
            float start = Float.parseFloat(start_end[0]);
            float end = Float.parseFloat(start_end[1].substring(0, start_end[1].length() - 2));
            this.genomic_location = new GenomicLocation(chr_pos[0], (int)(start * 1000000.0f), (int)(end * 1000000.0f));
        }
    }

    public static void main(String[] argv) {
        BinLabel bl = new BinLabel("chr3:215.4-215.6MB");
    }

    public GenomicLocation get_genomic_location() {
        return this.genomic_location;
    }
}

