/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TranscriptLinkOut {
    static final int TYPE_UNKNOWN = 0;
    static final int TYPE_NCBI = 1;
    static final int TYPE_ENSEMBL = 2;
    static final int TYPE_ACEVIEW = 3;
    boolean DEFAULT_NCBI = true;
    String id;
    int accession_type = 0;

    public boolean identify(String id) {
        Pattern sp;
        Matcher sm;
        this.id = id;
        this.accession_type = 1;
        boolean ok = true;
        if (id.indexOf("ENST") == 0) {
            this.accession_type = 2;
        }
        if ((sm = (sp = Pattern.compile("\\.[a-z]+[A-Z]")).matcher(id)).find()) {
            this.accession_type = 3;
        }
        if (this.accession_type == 0) {
            if (this.DEFAULT_NCBI) {
                this.accession_type = 1;
            } else {
                System.err.println("ERROR: unknown accession type for " + id);
                ok = false;
            }
        }
        return ok;
    }

    public String get_label() {
        String result = null;
        if (this.accession_type == 1) {
            result = "NCBI";
        } else if (this.accession_type == 2) {
            result = "Ensembl";
        } else if (this.accession_type == 3) {
            result = "AceView";
        }
        return result;
    }

    public URL get_url() {
        URL result = null;
        try {
            if (this.accession_type == 2) {
                result = new URL("http://useast.ensembl.org/Homo_sapiens/Transcript/Summary?t=" + this.id);
            } else if (this.accession_type == 1) {
                result = new URL("http://www.ncbi.nlm.nih.gov/nuccore/" + this.id);
            } else if (this.accession_type == 3) {
                result = new URL("http://www.ncbi.nlm.nih.gov/IEB/Research/Acembly/av.cgi?db=human&q=" + this.id + "&c=mrna");
            } else {
                System.err.println("ERROR: unhandled URL type for " + this.accession_type);
            }
        }
        catch (MalformedURLException e) {
            System.err.println("bad URL format");
        }
        return result;
    }

    public static void main(String[] argv) {
        TranscriptLinkOut tlo = new TranscriptLinkOut();
        String id = "RPL10andSNORA70.veAug10";
        if (tlo.identify(id)) {
            URL url = tlo.get_url();
            System.err.println("url=" + url);
        }
    }
}

