/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.IsoViewConfig;
import IsoView.JDBCQuery;
import IsoView.RegionParser;
import IsoView.Transcript;
import IsoView.TranscriptExon;
import IsoView.TranscriptLoader;
import IsoView.UCSCTools;

public class ManualJunctionTranscriptLoader
extends TranscriptLoader {
    IsoViewConfig config;
    int exon_counter;

    public ManualJunctionTranscriptLoader(IsoViewConfig config) {
        this.config = config;
        this.exon_counter = 0;
    }

    public void add_junction(String junction) {
        RegionParser rp = new RegionParser();
        if (rp.parse(junction)) {
            String tid = junction;
            Transcript t = new Transcript();
            t.sample_name = junction;
            t.transcript_id = new String(tid);
            t.strand = "+";
            this.id2transcript.put(tid, t);
            this.all_transcripts.add(t);
            String gene = null;
            if (gene == null) {
                UCSCTools ut = new UCSCTools(JDBCQuery.get_stjude_hg19());
                System.err.print("detecting gene name...");
                gene = ut.get_gene_from_region(rp.reference, rp.start, rp.end);
                if (gene == null) {
                    gene = this.config.NULL_GENE_SYMBOL_OVERRIDE == null ? "unknown_or_span" : this.config.NULL_GENE_SYMBOL_OVERRIDE;
                }
                System.err.println(gene);
            }
            TranscriptExon te = new TranscriptExon();
            te.transcript = t;
            te.reference = new String(rp.reference);
            te.gene_name = new String(gene);
            ++this.exon_counter;
            te.feature_number = this.exon_counter++;
            te.start = rp.start - this.config.FLANKING_NT_TO_GENERATE;
            te.end = rp.start;
            t.exons.add(te);
            te = new TranscriptExon();
            te.transcript = t;
            te.reference = new String(rp.reference);
            te.gene_name = new String(gene);
            te.feature_number = this.exon_counter;
            te.start = rp.end;
            te.end = rp.end + this.config.FLANKING_NT_TO_GENERATE;
            t.exons.add(te);
        } else {
            System.err.println("ERROR parsing " + junction + ", must be chrX:start-end OR chrX:start:+,chrX:end:+");
        }
        this.transcript_setup();
    }
}

