/*
 * Decompiled with CFR 0.152.
 */
package Funk;

import Funk.Gr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMultiScrollPanel
extends JPanel
implements ComponentListener,
AdjustmentListener,
MouseWheelListener {
    private Vector<Component> components = new Vector();
    private JPanel component_holder;
    private JScrollBar scrollbar;
    private boolean ENABLE_SNAP = false;
    private static int PREFERRED_HEIGHT_PERCENT = 100;

    public JMultiScrollPanel() {
        this.setup();
    }

    public static void set_window_height_percent(int h) {
        PREFERRED_HEIGHT_PERCENT = h;
    }

    public static int get_window_height_percent() {
        return PREFERRED_HEIGHT_PERCENT;
    }

    public void set_preferred_width_percent(int percent) {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension pref = this.component_holder.getSize();
        pref.width = ss.width * percent / 100;
    }

    public synchronized Component add(Component c) {
        this.component_holder.add(c);
        this.components.add(c);
        return c;
    }

    public void removeAll() {
        this.component_holder.removeAll();
        this.components.removeAllElements();
    }

    public void validate() {
        this.handle_resize();
        super.validate();
    }

    private void setup() {
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.component_holder = new JPanel();
        this.component_holder.setLayout(new BoxLayout(this.component_holder, 1));
        this.setLayout(new BorderLayout());
        this.add("Center", this.component_holder);
        this.scrollbar = new JScrollBar(1, 0, 0, 0, 0);
        this.scrollbar.addAdjustmentListener(this);
        this.add("East", this.scrollbar);
    }

    public synchronized void handle_resize() {
        int total_components = this.components.size();
        int panel_heights = 0;
        int panel_height = 0;
        for (Component c : this.components) {
            Dimension d = c.getSize();
            panel_heights += d.height;
            panel_height = d.height;
        }
        if (panel_heights == 0) {
            return;
        }
        int holder_height = this.component_holder.getSize().height;
        int visible = holder_height * total_components / panel_heights;
        int value = this.scrollbar.getValue();
        int minimum = 0;
        int maximum = total_components;
        if (value > maximum) {
            value = maximum;
        }
        this.scrollbar.setValues(value, visible, minimum, maximum);
        this.scrollbar.setBlockIncrement(visible);
        this.lay_out_components();
        if (this.ENABLE_SNAP) {
            this.snap(false);
        }
    }

    public void snap(boolean resize_to_max) {
        int leftover;
        int total_components = this.components.size();
        int holder_height = this.component_holder.getSize().height;
        int panel_height = this.components.elementAt((int)0).getSize().height;
        int fit = holder_height / panel_height;
        if (resize_to_max) {
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            JFrame toplevel = Gr.getJFrame(this.component_holder);
            int overhead = ss.height - ss.height * PREFERRED_HEIGHT_PERCENT / 100;
            if (toplevel != null) {
                int toplevel_height = toplevel.getSize().height;
                overhead += toplevel_height - holder_height;
            }
            fit = (ss.height - overhead) / panel_height;
        }
        if (fit < 1) {
            fit = 1;
        }
        if (fit > total_components) {
            fit = total_components;
        }
        if ((leftover = holder_height % panel_height) != 0 || resize_to_max) {
            JFrame f = Gr.getJFrame(this);
            int new_h = fit * panel_height;
            Dimension new_pref = new Dimension(this.component_holder.getWidth(), new_h);
            this.component_holder.setPreferredSize(new_pref);
            f.pack();
        }
    }

    public void componentResized(ComponentEvent e) {
        Dimension d = this.getSize();
        this.handle_resize();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    private synchronized void lay_out_components() {
        int start_visible = this.scrollbar.getValue();
        int end_visible = start_visible + this.scrollbar.getVisibleAmount();
        int i = 0;
        this.component_holder.removeAll();
        for (Component c : this.components) {
            if (i >= start_visible && i <= end_visible) {
                this.component_holder.add(c);
            }
            ++i;
        }
        this.component_holder.validate();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.lay_out_components();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean everything_visible;
        int rotation = e.getWheelRotation();
        int current_value = this.scrollbar.getValue();
        int new_value = this.scrollbar.getValue() + rotation;
        int min = this.scrollbar.getMinimum();
        int max = this.scrollbar.getMaximum();
        int vis = this.scrollbar.getVisibleAmount();
        int block = this.scrollbar.getBlockIncrement();
        boolean bl = everything_visible = current_value == min && current_value + vis >= max;
        if (new_value < min) {
            new_value = min;
        }
        if (new_value > max) {
            new_value = max;
        }
        if (new_value != current_value && !everything_visible) {
            this.scrollbar.setValue(new_value);
            this.lay_out_components();
        }
    }
}

