/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.EndianReader;
import Ace2.TwoBitBlock;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoBitSequence {
    private ArrayList<TwoBitBlock> n_blocks;
    private ArrayList<TwoBitBlock> mask_blocks;
    private int sequence_length;
    private EndianReader er;
    private long packed_dna_offset;
    private static final int BASES_PACKED_PER_BYTE = 4;
    private static final boolean VERBOSE = false;
    private boolean parse_error = false;

    public TwoBitSequence(EndianReader er, int offset, boolean read_fully) {
        this.er = er;
        this.setup(offset, read_fully);
    }

    public void set_randomaccessfile(RandomAccessFile raf) {
        this.er.set_randomaccessfile(raf);
    }

    private void setup(int offset, boolean read_fully) {
        try {
            this.er.seek(offset);
            this.sequence_length = this.er.readInt();
            if (!read_fully) {
                return;
            }
            this.n_blocks = this.read_block_set();
            this.mask_blocks = this.read_block_set();
            int reserved = this.er.readInt();
            if (reserved != 0) {
                System.err.println("WARNING: nonzero reserved value");
            }
            this.packed_dna_offset = this.er.getFilePointer();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public byte[] get_region(int start_base, int region_size) throws IOException {
        byte[] result = this.read_sequence(start_base, region_size);
        if (this.n_blocks != null) {
            for (TwoBitBlock nb : this.n_blocks) {
                nb.set_n(result, start_base, region_size);
            }
        } else {
            System.err.println("no N blocks in .2bit file");
        }
        if (this.mask_blocks != null) {
            for (TwoBitBlock mb : this.mask_blocks) {
                mb.mask(result, start_base, region_size);
            }
        } else {
            System.err.println("no mask blocks in .2bit file");
        }
        return result;
    }

    private byte[] read_sequence(int start_base, int bases_needed) throws IOException {
        byte[] sequence_buf = new byte[bases_needed];
        RandomAccessFile raf = this.er.get_randomaccessfile();
        long seek_start = this.packed_dna_offset + (long)((start_base - 1) / 4);
        raf.seek(seek_start);
        int start_block_base = (start_base - 1) % 4;
        int seq_ptr = 0;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(raf.getFD()));
        boolean first_block = true;
        this.parse_error = false;
        while (bases_needed > 0) {
            int shift;
            int bases_wanted_in_block;
            int block = bis.read();
            if (block == -1) {
                System.err.println("ERROR: still need " + bases_needed + " bases, but EOF!");
                this.parse_error = true;
                break;
            }
            if (first_block) {
                bases_wanted_in_block = 4 - start_block_base;
                shift = (bases_wanted_in_block - 1) * 2;
            } else {
                bases_wanted_in_block = 4;
                shift = 6;
            }
            if (bases_wanted_in_block > bases_needed) {
                bases_wanted_in_block = bases_needed;
            }
            while (bases_wanted_in_block > 0) {
                int base;
                switch (block >> shift & 3) {
                    case 0: {
                        base = 84;
                        break;
                    }
                    case 1: {
                        base = 67;
                        break;
                    }
                    case 2: {
                        base = 65;
                        break;
                    }
                    case 3: {
                        base = 71;
                        break;
                    }
                    default: {
                        base = 33;
                    }
                }
                sequence_buf[seq_ptr++] = base;
                --bases_wanted_in_block;
                shift -= 2;
                --bases_needed;
            }
            first_block = false;
        }
        return this.parse_error ? null : sequence_buf;
    }

    public byte[] get_full_sequence() throws IOException {
        byte[] full_sequence = this.read_sequence(1, this.sequence_length);
        if (this.n_blocks != null) {
            for (TwoBitBlock nb : this.n_blocks) {
                nb.set_n(full_sequence);
            }
        } else {
            System.err.println("no N blocks in .2bit file");
        }
        if (this.mask_blocks != null) {
            for (TwoBitBlock mb : this.mask_blocks) {
                mb.mask(full_sequence);
            }
        } else {
            System.err.println("no mask blocks in .2bit file");
        }
        return full_sequence;
    }

    private ArrayList<TwoBitBlock> read_block_set() throws IOException {
        int block_count = this.er.readInt();
        int[] starts = this.read_int_set(block_count);
        int[] sizes = this.read_int_set(block_count);
        ArrayList<TwoBitBlock> set = new ArrayList<TwoBitBlock>();
        for (int i = 0; i < block_count; ++i) {
            TwoBitBlock block = new TwoBitBlock(starts[i], sizes[i]);
            set.add(block);
        }
        return set;
    }

    private int[] read_int_set(int count) throws IOException {
        int[] set = new int[count];
        for (int i = 0; i < count; ++i) {
            set[i] = this.er.readInt();
        }
        return set;
    }

    public int get_length() {
        return this.sequence_length;
    }
}

