/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SNPConfig;
import Ace2.SampleMatchInfo;
import Ace2.SampleNamingConventionPattern;
import Ace2.TumorNormal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleNamingConvention {
    String convention_name;
    String global_pattern;
    ArrayList<SampleNamingConventionPattern> type_matches;
    SampleMatchInfo match_info;
    private static boolean VERBOSE = false;
    private static ArrayList<SampleNamingConvention> known_conventions = null;

    public SampleNamingConvention(String convention_name) {
        this.convention_name = convention_name;
        this.type_matches = new ArrayList();
    }

    public void add_pattern(SampleNamingConventionPattern sncp) {
        this.type_matches.add(sncp);
    }

    public boolean matches(String s) {
        Pattern sp = Pattern.compile(this.global_pattern, 2);
        Matcher sm = sp.matcher(s);
        this.match_info = null;
        if (sm.find()) {
            if (VERBOSE) {
                new Exception().printStackTrace();
                System.err.println("checking " + s);
                System.err.println("global match for " + this.global_pattern + " => " + sm.group(1) + " " + sm.group(2));
            }
            String type_string = sm.group(2);
            for (SampleNamingConventionPattern sncp : this.type_matches) {
                if (!sncp.type_string.equalsIgnoreCase(type_string)) continue;
                this.match_info = new SampleMatchInfo();
                this.match_info.sample_name = sm.group(1);
                this.match_info.description = sncp.description;
                this.match_info.tumor_normal = sncp.tumor_normal;
                this.match_info.is_recurrent = sncp.is_recurrent;
                break;
            }
        } else if (VERBOSE) {
            System.err.println("no match for " + this.global_pattern);
        }
        return this.match_info != null;
    }

    public SampleMatchInfo get_match_info() {
        return this.match_info;
    }

    public static ArrayList<SampleNamingConvention> get_known_conventions() {
        TumorNormal CELL_LINE_TN_HACK = TumorNormal.TUMOR;
        if (known_conventions == null) {
            known_conventions = new ArrayList();
            SampleNamingConvention snc = new SampleNamingConvention("st_jude");
            known_conventions.add(snc);
            snc.global_pattern = "^(\\w+)_([DG])\\-";
            snc.add_pattern(new SampleNamingConventionPattern("G", TumorNormal.NORMAL, "germline (normal)"));
            snc.add_pattern(new SampleNamingConventionPattern("D", TumorNormal.TUMOR, "diagnosis (tumor)"));
            if (SNPConfig.TCGA_SAMPLE_FIELD_COUNT == 3) {
                snc = new SampleNamingConvention("tcga_donor");
                known_conventions.add(snc);
                snc.global_pattern = "^(TCGA\\-\\w\\w\\-\\w\\w\\w\\w)\\-(\\w\\w)";
            } else if (SNPConfig.TCGA_SAMPLE_FIELD_COUNT == 4) {
                snc = new SampleNamingConvention("tcga_sample");
                known_conventions.add(snc);
                snc.global_pattern = "^(TCGA\\-\\w\\w\\-\\w\\w\\w\\w\\-(\\w\\w))";
            }
            snc.add_pattern(new SampleNamingConventionPattern("01", TumorNormal.TUMOR, "primary solid tumor"));
            snc.add_pattern(new SampleNamingConventionPattern("02", TumorNormal.TUMOR, "recurrent solid tumor"));
            snc.add_pattern(new SampleNamingConventionPattern("03", TumorNormal.TUMOR, "primary blood-derived cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("04", TumorNormal.TUMOR, "recurrent blood-derived cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("05", TumorNormal.TUMOR, "additional - new primary cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("06", TumorNormal.TUMOR, "metastatic"));
            snc.add_pattern(new SampleNamingConventionPattern("07", TumorNormal.TUMOR, "additional metastatic"));
            snc.add_pattern(new SampleNamingConventionPattern("10", TumorNormal.NORMAL, "blood-derived normal"));
            snc.add_pattern(new SampleNamingConventionPattern("11", TumorNormal.NORMAL, "solid tissue normal"));
            snc.add_pattern(new SampleNamingConventionPattern("12", TumorNormal.NORMAL, "buccal cell normal"));
            snc.add_pattern(new SampleNamingConventionPattern("13", TumorNormal.NORMAL, "EBV immortalized normal"));
            snc.add_pattern(new SampleNamingConventionPattern("14", TumorNormal.NORMAL, "bone marrow normal"));
            snc.add_pattern(new SampleNamingConventionPattern("20", CELL_LINE_TN_HACK, "cell line control"));
            snc = new SampleNamingConvention("target_sample");
            known_conventions.add(snc);
            snc.global_pattern = "^(TARGET\\-\\w\\w\\-\\w{6}\\-(\\w\\w))";
            snc.add_pattern(new SampleNamingConventionPattern("01", TumorNormal.TUMOR, "primary tumor"));
            snc.add_pattern(new SampleNamingConventionPattern("02", TumorNormal.TUMOR, "recurrent tumor"));
            snc.add_pattern(new SampleNamingConventionPattern("03", TumorNormal.TUMOR, "primary blood cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("04", TumorNormal.TUMOR, "recurrent blood cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("05", TumorNormal.TUMOR, "additional new primary cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("06", TumorNormal.TUMOR, "metastatic cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("07", TumorNormal.TUMOR, "additional metastatic cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("08", TumorNormal.TUMOR, "human tumor additional cells"));
            snc.add_pattern(new SampleNamingConventionPattern("09", TumorNormal.TUMOR, "primary blood cancer: bone marrow"));
            snc.add_pattern(new SampleNamingConventionPattern("10", TumorNormal.NORMAL, "blood derived normal"));
            snc.add_pattern(new SampleNamingConventionPattern("11", TumorNormal.NORMAL, "solid tissue normal"));
            snc.add_pattern(new SampleNamingConventionPattern("12", TumorNormal.NORMAL, "buccal cell normal"));
            snc.add_pattern(new SampleNamingConventionPattern("13", TumorNormal.NORMAL, "EBV normal"));
            snc.add_pattern(new SampleNamingConventionPattern("14", TumorNormal.NORMAL, "bone mrrow normal"));
            snc.add_pattern(new SampleNamingConventionPattern("20", CELL_LINE_TN_HACK, "cell line control"));
            snc.add_pattern(new SampleNamingConventionPattern("40", TumorNormal.TUMOR, "recurrent blood cancer"));
            snc.add_pattern(new SampleNamingConventionPattern("50", TumorNormal.TUMOR, "cancer cell line"));
            snc.add_pattern(new SampleNamingConventionPattern("60", TumorNormal.TUMOR, "xenograft, primary"));
            snc.add_pattern(new SampleNamingConventionPattern("70", TumorNormal.TUMOR, "xenograft, cell-line derived"));
        }
        return known_conventions;
    }

    public static void import_convention(String s) {
        String[] chunks = s.split(",");
        int ptr = 0;
        if (chunks.length >= 5 && (chunks.length - 2) % 3 == 0) {
            SampleNamingConvention snc = new SampleNamingConvention(chunks[ptr++]);
            System.err.println("importing new convention: " + snc.convention_name);
            SampleNamingConvention.get_known_conventions().add(snc);
            snc.global_pattern = chunks[ptr++];
            int left = chunks.length - 2;
            if (left > 0 && left % 3 == 0) {
                int count = left / 3;
                for (int j = 0; j < count; ++j) {
                    String desc;
                    String type_string = chunks[ptr++];
                    TumorNormal tn = TumorNormal.valueOfString(chunks[ptr++]);
                    if ((desc = chunks[ptr++]) != null && desc.equalsIgnoreCase("null")) {
                        desc = null;
                    }
                    snc.add_pattern(new SampleNamingConventionPattern(type_string, tn, desc));
                }
            } else {
                System.err.println("naming convention spec error");
            }
        } else {
            System.err.println("naming convention spec error: specify convention_name,regexp,tn_string,[TN],desc[,tn_string,[TN],desc...]");
        }
    }

    public static void main(String[] argv) {
        if (argv.length > 0) {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-convention")) {
                    SampleNamingConvention.import_convention(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-v")) {
                    VERBOSE = true;
                    continue;
                }
                String thing = argv[i];
                ArrayList<SampleNamingConvention> conventions = SampleNamingConvention.get_known_conventions();
                System.err.println("conventions: " + conventions.size());
                for (SampleNamingConvention snc : conventions) {
                    if (!snc.matches(thing)) continue;
                    System.err.println("matches naming convention: " + snc.convention_name);
                    SampleMatchInfo info = snc.get_match_info();
                    System.err.println("sample_name: " + info.sample_name);
                    System.err.println("desc: " + info.description);
                    System.err.println("tn: " + (Object)((Object)info.tumor_normal));
                    System.err.println("");
                }
            }
        } else {
            System.err.println("specify test file name");
        }
    }
}

