/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Range;
import Ace2.SAMReadQuery;
import Ace2.SEUConfig;
import Ace2.SEUInteresting;
import Ace2.SEUWriter;
import Ace2.SortedJobQueue;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;

public class SEUMateQuery {
    private SEUConfig config;
    private SEUInteresting interesting;
    private SEUWriter seuw;
    private SortedJobQueue<SAMReadQuery> queue;
    private SamReader reader;
    private String reference_name;
    private int reference_index;
    private long processing_time = 0L;
    public static boolean VERBOSE = false;

    public SEUMateQuery(SEUConfig config, SEUInteresting interesting, SEUWriter seuw) {
        this.config = config;
        this.interesting = interesting;
        this.seuw = seuw;
        this.setup();
    }

    public SEUMateQuery(SEUConfig config, SEUWriter seuw) {
        this.config = config;
        this.seuw = seuw;
        this.interesting = null;
        this.setup();
    }

    public String get_reference_name() {
        return this.reference_name;
    }

    private void setup() {
        this.reference_name = null;
        this.reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.config.bam_file);
        this.queue = new SortedJobQueue();
    }

    public void add_mate(SAMRecord sr) throws IOException {
        this.queue.add(new SAMReadQuery(sr, true), sr.getMateAlignmentStart());
        if (this.reference_name == null) {
            this.reference_name = sr.getMateReferenceName();
            this.reference_index = sr.getMateReferenceIndex();
        }
        if (this.queue.get_job_count() >= this.config.MATE_QUERY_GROUP_QUEUE_LIMIT) {
            this.flush();
        }
    }

    public int get_job_count() {
        return this.queue.get_job_count();
    }

    public void flush() throws IOException {
        long start_time = System.currentTimeMillis();
        TreeMap<Integer, ArrayList<SAMReadQuery>> jobs = this.queue.get_queue();
        ArrayList<Range> queries = new ArrayList<Range>();
        Range r = null;
        for (Integer pos : jobs.keySet()) {
            if (r != null && pos - r.start > this.config.MATE_QUERY_GROUP_MAX_ALIGN_DISTANCE) {
                r = null;
            }
            if (r == null) {
                r = new Range(pos, pos);
                queries.add(r);
            }
            r.end = pos;
        }
        int scan_count = 0;
        int query_count = 0;
        for (Range query : queries) {
            if (VERBOSE) {
                System.err.println("query: " + query.start + "-" + query.end);
            }
            ++query_count;
            ArrayList<SAMReadQuery> targets = null;
            int last_start = -1;
            SAMRecordIterator iterator = query.start == query.end ? this.reader.queryAlignmentStart(this.reference_name, query.start) : this.reader.queryOverlapping(this.reference_name, query.start, query.end);
            block2: while (iterator.hasNext()) {
                int as;
                SAMRecord sr = (SAMRecord)iterator.next();
                ++scan_count;
                if (sr.getReadUnmappedFlag() || (as = sr.getAlignmentStart()) < query.start) continue;
                if (as > query.end) break;
                if (as != last_start) {
                    last_start = as;
                    targets = jobs.get(last_start);
                    if (VERBOSE && targets != null) {
                        System.err.println("targets at " + last_start + ":");
                        for (SAMReadQuery target : targets) {
                            System.err.println("  " + target.readName + " " + target.alignmentStart + " " + (target.negativeStrandFlag ? "-" : "+"));
                        }
                    }
                }
                if (targets == null) continue;
                for (SAMReadQuery target : targets) {
                    if (!target.matches(sr)) continue;
                    if (target.hit == null) {
                        target.hit = sr;
                        continue block2;
                    }
                    System.err.println("WTF: multiple hits for target!");
                    continue block2;
                }
            }
            iterator.close();
        }
        int total = 0;
        int found = 0;
        for (Integer pos : jobs.keySet()) {
            for (SAMReadQuery q : jobs.get(pos)) {
                ++total;
                if (q.hit == null) continue;
                ++found;
            }
        }
        this.processing_time += System.currentTimeMillis() - start_time;
        SEUInteresting seui = this.interesting;
        if (seui == null) {
            System.err.println("creating temporary SEUI for RI " + this.reference_index + " name=" + this.reference_name);
            seui = new SEUInteresting(this.config, this.reference_index);
        }
        for (Integer pos : jobs.keySet()) {
            for (SAMReadQuery q : jobs.get(pos)) {
                if (q.hit == null) continue;
                seui.interesting_check(q.hit);
                this.seuw.addAlignment(q.hit, seui);
            }
        }
        this.queue.reset();
        System.err.println("SEUMateQuery summary: scan_count " + scan_count + " in " + query_count + " queries, found " + found + "/" + total + " in " + this.processing_time + " ms");
    }
}

