/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewerConfig;
import Ace2.Chromosome;
import Ace2.SAMConsensusGenerator;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Funk.Str;
import Funk.Timer;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMUtils {
    private static final boolean DEBUG_RESTRICT_LOAD = false;

    public static SAMRecord[] load_sams(SamReader reader) throws IOException {
        Timer timer = new Timer("sam load");
        ArrayList<SAMRecord> sams = new ArrayList<SAMRecord>();
        int unmapped_reads = 0;
        HashSet wanted = new HashSet();
        for (SAMRecord samRecord : reader) {
            if (samRecord.getReadUnmappedFlag()) {
                ++unmapped_reads;
                continue;
            }
            sams.add(samRecord);
        }
        reader.close();
        timer.finish();
        System.err.println("loaded " + sams.size() + " reads");
        if (unmapped_reads > 0) {
            System.err.println("unmapped reads: " + unmapped_reads);
        }
        SAMRecord[] sa = new SAMRecord[sams.size()];
        int i = 0;
        for (SAMRecord sr : sams) {
            sa[i++] = sr;
        }
        return sa;
    }

    public static SAMRecord[] load_sams(File f) {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(f);
        return SAMUtils.load_sams(f);
    }

    public static SAMRecord[] load_sams(URL url) throws IOException {
        System.err.println("SAM load via URL " + url);
        System.err.println("ERROR: URL load not implemented");
        System.exit(1);
        return null;
    }

    public static String cigar_to_string(Cigar c) {
        StringBuffer sb = new StringBuffer();
        for (CigarElement ce : c.getCigarElements()) {
            CigarOperator co = ce.getOperator();
            sb.append(co);
            sb.append(ce.getLength());
        }
        return sb.toString();
    }

    public static void write_fastq(PrintStream ps, SAMRecord sr, String info) {
        byte[] bases = sr.getReadBases();
        String qual = sr.getBaseQualityString();
        String error = null;
        if (bases.length == 0) {
            error = "0-length bases";
        } else if (qual.length() == 0) {
            error = "0-length quality";
        } else if (bases.length != qual.length()) {
            error = "sequence/quality length mismatch";
        }
        if (error != null) {
            System.err.println("ERROR: not writing FASTQ, " + error + " for " + sr.getReadName());
        } else {
            ps.println("@" + info);
            ps.println(new String(bases));
            ps.println("+");
            ps.println(qual);
        }
    }

    public static void write_fastq(PrintStream ps, SAMRecord sr, String info, ArrayList<String> tags) {
        SAMUtils.write_fastq(ps, sr, info + " " + Str.join(",", tags));
    }

    public static String bucket_reference_name(String ref_name, boolean bucket_non_chr) {
        Chromosome c;
        if (ref_name == null || ref_name.length() == 0) {
            ref_name = "unknown";
        } else if (ref_name.indexOf("chr") == 0) {
            ref_name = ref_name.substring(3);
        }
        if (bucket_non_chr && (c = Chromosome.valueOfString(ref_name)) == null) {
            ref_name = "other";
        }
        return ref_name;
    }

    public static boolean flanking_quality_check(byte[] quals, int read_i, int site_size, int min_qual, int window_size, boolean illumina_q2_mode) {
        boolean result = true;
        if (site_size == 0) {
            int start = read_i - window_size;
            int end = read_i + site_size + window_size;
            if (start < 0) {
                start = 0;
            }
            if (end > quals.length) {
                end = quals.length;
            }
            for (int i = start; i < end; ++i) {
                if (quals[i] >= min_qual || illumina_q2_mode && quals[i] == 2) continue;
                result = false;
                break;
            }
        } else {
            int i;
            int start = read_i - window_size;
            int end = read_i;
            if (start < 0) {
                start = 0;
            }
            if (end > quals.length) {
                end = quals.length;
            }
            for (i = start; i < end; ++i) {
                if (quals[i] >= min_qual || illumina_q2_mode && quals[i] == 2) continue;
                result = false;
                break;
            }
            start = read_i + site_size;
            end = start + window_size;
            if (start < 0) {
                start = 0;
            }
            if (end > quals.length) {
                end = quals.length;
            }
            for (i = start; i < end; ++i) {
                if (quals[i] >= min_qual || illumina_q2_mode && quals[i] == 2) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static Exception sam_config_setup(AceViewerConfig avc, SAMRegion region) throws IOException, FileNotFoundException {
        Exception exception = null;
        if (region.isValid()) {
            ArrayList<String> files = new ArrayList<String>();
            for (SAMResource sre : avc.sams) {
                sre.set_region(region);
                if (avc.CENTER_BASE_QUERY_ONLY) {
                    sre.set_query_overlap_base(avc.center);
                }
                if (sre.file == null) continue;
                files.add(sre.file.getName());
            }
            String title = "";
            if (files.size() > 0) {
                title = Str.join(", ", files);
            }
            if (title.length() > 0) {
                title = title + ": ";
            }
            avc.title = title = title + region.toString();
            avc.ruler_start = region.range.start - 1;
            Chromosome c = Chromosome.valueOfString(region.tname);
            avc.CONSENSUS_TAG = c == null ? region.tname : c.toString();
            if (avc.GENERATE_CONSENSUS) {
                avc.CONSENSUS_TAG = avc.CONSENSUS_TAG.concat("_SAM_consensus");
                SAMConsensusGenerator scg = new SAMConsensusGenerator(avc);
                avc.target_sequence = scg.generate_consensus();
            } else if (avc.reference_sequence != null) {
                System.err.println("loading reference from " + avc.reference_sequence);
                avc.target_sequence = avc.reference_sequence.get_region(region.tname, region.range.start, region.get_length());
                if (avc.target_sequence == null) {
                    JOptionPane.showMessageDialog(null, "Can't retrieve reference sequence for \"" + region.tname + "\"; please check reference and/or BAM data.  Using generated reference sequence.", "Error", 0);
                    SAMConsensusGenerator scg = new SAMConsensusGenerator(avc);
                    avc.target_sequence = scg.generate_consensus();
                }
            } else if (avc.target_sequence == null) {
                System.err.println("ERROR: no ReferenceSequence accessor available");
            }
        }
        return exception;
    }

    public static String get_printable_read_name(SAMRecord sr) {
        return sr.getReadName() + "." + (sr.getReadNegativeStrandFlag() ? "R" : "F");
    }

    public static String get_standardized_refname(String s) {
        if (s.toLowerCase().indexOf("chr") == 0) {
            return s.substring(3);
        }
        return s;
    }

    public static ArrayList<String> get_refname_alternates(String s) {
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> saw = new HashSet<String>();
        SAMUtils.conditional_add(results, saw, s);
        String std = SAMUtils.get_standardized_refname(s);
        SAMUtils.conditional_add(results, saw, std);
        SAMUtils.conditional_add(results, saw, "chr" + std);
        if (std.toUpperCase().equals("M")) {
            SAMUtils.conditional_add(results, saw, "MT");
            SAMUtils.conditional_add(results, saw, "chrMT");
        } else if (std.toUpperCase().equals("MT")) {
            SAMUtils.conditional_add(results, saw, "M");
            SAMUtils.conditional_add(results, saw, "chrM");
        }
        return results;
    }

    public static void main(String[] argv) {
        for (String s : SAMUtils.get_refname_alternates("MT")) {
            System.err.println("alt=" + s);
        }
    }

    private static void conditional_add(ArrayList<String> list, HashSet<String> saw, String s) {
        if (!saw.contains(s)) {
            list.add(s);
            saw.add(s);
        }
    }

    public static boolean is_bam_indexed(File f) {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(f);
        return reader.hasIndex();
    }

    public static void bam_index(File bam) {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam);
        BAMIndexer ix = new BAMIndexer(new File(bam.getName() + ".bai"), reader.getFileHeader());
        for (SAMRecord sr : reader) {
            ix.processAlignment(sr);
        }
        ix.finish();
    }
}

