/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.GeneInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class GeneList
implements Runnable {
    private static HashMap<String, GeneInfo> genes;
    private static boolean load_started;
    private static boolean is_loaded;

    public GeneList() {
        if (!load_started) {
            new Thread(this).start();
            load_started = true;
        }
    }

    public void run() {
        ClassLoader cl = this.getClass().getClassLoader();
        String resource = "Ace2/gene_list.tab.gz";
        URL load_url = cl == null ? ClassLoader.getSystemResource(resource) : cl.getResource(resource);
        genes = new HashMap();
        if (load_url != null) {
            try {
                String line;
                URLConnection urlc = load_url.openConnection();
                InputStream is = urlc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(is)));
                while ((line = br.readLine()) != null) {
                    String[] things = line.split("\t");
                    GeneInfo gi = new GeneInfo();
                    gi.name = new String(things[0]);
                    gi.chr = Chromosome.valueOfString(things[1]);
                    gi.start = Integer.valueOf(things[2]);
                    gi.end = Integer.valueOf(things[3]);
                    genes.put(gi.name.toUpperCase(), gi);
                }
                is_loaded = true;
            }
            catch (Exception e) {
                System.err.println("ERROR:" + e);
            }
        }
    }

    public GeneInfo get_gene(String name) {
        return genes.get(name.toUpperCase());
    }

    public boolean is_loaded() {
        return is_loaded;
    }

    public void sleep_until_ready() {
        while (!is_loaded) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    static {
        load_started = false;
        is_loaded = false;
    }
}

