/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class ArrowPainter {
    protected int total_width;
    int left_margin = 0;
    private int buffer;
    private int width;
    private int height;
    private int x;
    private int baseline;
    private int y_modifier;
    private int[] arrow_x = new int[3];
    private int[] arrow_y = new int[3];
    private Color arrow_color;

    public ArrowPainter(int font_width, int line_height, int font_ascent, int font_descent, Color arrow_color) {
        this.arrow_color = arrow_color;
        this.buffer = (int)((double)font_width * 0.4);
        this.width = font_width * 2;
        this.height = (int)((double)line_height * 0.6 / 2.0);
        this.y_modifier = 0 - font_ascent + (font_ascent + font_descent) / 2;
        this.total_width = this.width + this.buffer * 4;
    }

    public void draw(Graphics gr, boolean rc, int y, boolean cancel_mode) {
        Graphics2D g = (Graphics2D)gr;
        Color old_color = g.getColor();
        Stroke old_stroke = g.getStroke();
        Object last_hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.arrow_color);
        this.x = this.left_margin + this.buffer;
        this.baseline = y + this.y_modifier;
        if (rc) {
            this.arrow_x[0] = this.x + this.width;
            this.arrow_y[0] = this.baseline - this.height;
            this.arrow_x[1] = this.x + this.width;
            this.arrow_y[1] = this.baseline + this.height;
            this.arrow_x[2] = this.x;
            this.arrow_y[2] = this.baseline;
        } else {
            this.arrow_x[0] = this.x;
            this.arrow_y[0] = this.baseline - this.height;
            this.arrow_x[1] = this.x;
            this.arrow_y[1] = this.baseline + this.height;
            this.arrow_x[2] = this.x + this.width;
            this.arrow_y[2] = this.baseline;
        }
        g.setStroke(new BasicStroke(1.25f));
        if (cancel_mode) {
            g.drawPolygon(this.arrow_x, this.arrow_y, 3);
        } else {
            g.fillPolygon(this.arrow_x, this.arrow_y, 3);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, last_hint);
        g.setColor(old_color);
        g.setStroke(old_stroke);
    }

    public int get_total_width() {
        return this.total_width;
    }
}

