/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceSequence;
import Ace2.Contig;
import Ace2.SNPList;
import Ace2.getID;
import Funk.Notifier;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observer;
import java.util.StringTokenizer;

public class Ace
extends Notifier
implements Runnable {
    String filename;
    public Contig current_contig;
    Hashtable contigs;
    String[] member_id_list;
    private boolean loaded;
    private boolean status;
    private Notifier notifier = new Notifier();
    private int bytes_loaded;
    private boolean is_empty = false;
    private DataInputStream input_stream = null;

    public Ace(String filename) {
        this.filename = filename;
        this.load();
    }

    public Ace(String filename, Observer o) {
        this.filename = filename;
        this.addObserver(o);
        Thread thread = new Thread(this);
        thread.start();
    }

    public Ace(DataInputStream input_stream, Observer o) {
        this.input_stream = input_stream;
        this.addObserver(o);
        Thread thread = new Thread(this);
        thread.start();
    }

    public Ace(DataInputStream input_stream) {
        this.input_stream = input_stream;
        this.load();
    }

    public boolean is_empty() {
        return this.is_empty;
    }

    public boolean loaded() {
        return this.loaded;
    }

    public boolean error() {
        return !this.status;
    }

    public int count() {
        return this.member_id_list.length;
    }

    public int bytes_loaded() {
        return this.bytes_loaded;
    }

    public void run() {
        this.load();
        this.setChanged();
        this.notifyObservers(new Boolean(this.status));
    }

    public void load() {
        this.status = false;
        this.loaded = false;
        this.contigs = new Hashtable();
        try {
            DataInputStream d = this.input_stream;
            long before = System.currentTimeMillis();
            this.parse(new BufferedReader(new InputStreamReader(d)));
            long after = System.currentTimeMillis();
            System.err.println("took:" + (after - before) + " ms to load/parse");
        }
        catch (IOException e) {
            System.out.println("load: " + e);
        }
        this.loaded = true;
    }

    Enumeration get_contig_list() {
        return this.contigs.keys();
    }

    String get_contig_id() {
        return this.current_contig == null ? "null" : this.current_contig.name;
    }

    int get_contig_length() {
        return this.current_contig == null ? 0 : this.current_contig.consensus.sequence.length();
    }

    private void parse_new(BufferedReader d) throws IOException {
        String line;
        AceSequence seq = null;
        while ((line = d.readLine()) != null) {
            if (line.length() <= 0) continue;
            StringTokenizer st = new StringTokenizer(line);
            String key = st.nextToken();
            if (key.equals("CO")) {
                String id = st.nextToken();
                int len = Integer.parseInt(st.nextToken());
                int max = len + len / 50;
                Contig c = new Contig(id);
                this.contigs.put(id, c);
                this.current_contig = c;
                this.grab_sequence(d, c.consensus);
                continue;
            }
            if (key.equals("AF")) {
                seq = this.current_contig.create_member(st.nextToken());
                seq.complemented = st.nextToken().equals("C");
                seq.asm_start_padded = Integer.parseInt(st.nextToken());
                continue;
            }
            if (key.equals("RD")) {
                seq = this.current_contig.get_member(st.nextToken());
                int len = Integer.parseInt(st.nextToken());
                int max = len + len / 50;
                this.grab_sequence(d, seq);
                seq.asm_end_padded = seq.asm_start_padded + seq.sequence.length() - 1;
                continue;
            }
            if (key.equals("QA")) {
                st.nextToken();
                st.nextToken();
                seq.clip_start_padded = Integer.parseInt(st.nextToken());
                seq.clip_end_padded = Integer.parseInt(st.nextToken());
                if (seq.clip_start_padded != -1 || seq.clip_end_padded != -1) continue;
                seq.clip_start_padded = 1;
                seq.clip_end_padded = seq.sequence.length();
                continue;
            }
            if (key.equals("DS")) {
                seq.description = line.substring(2);
                continue;
            }
            if (key.equals("BQ")) {
                StringBuffer sb = this.grab_until_whitespace(d);
                StringTokenizer st2 = new StringTokenizer(sb.toString());
                while (st2.hasMoreTokens()) {
                    this.current_contig.quality.addElement(st2.nextToken());
                }
                continue;
            }
            if (key.equals("BS")) {
                StringBuffer sb = this.grab_until_whitespace(d);
                continue;
            }
            if (key.substring(0, 2).equals("RT") || key.substring(0, 2).equals("WA") || key.substring(0, 2).equals("WR")) {
                while ((line = d.readLine()) != null && !line.substring(0, 1).equals("}")) {
                }
                continue;
            }
            System.out.println("unhandled acefile tag: " + key + " line:" + line);
            System.exit(1);
        }
    }

    private void parse(BufferedReader d) throws IOException {
        Contig c;
        String line;
        System.err.println("loading .ace file");
        boolean contig_seq_mode = false;
        boolean seq_mode = false;
        boolean ignore_mode = false;
        boolean bq_mode = false;
        AceSequence current_seq = null;
        this.bytes_loaded = 0;
        boolean first = true;
        while ((line = d.readLine()) != null) {
            String id;
            getID g;
            if (first) {
                if (line.length() >= 2 && line.substring(0, 2).equals("AS")) {
                    StringTokenizer nst = new StringTokenizer(line);
                    nst.nextToken();
                    if (nst.nextToken().equals("0") && nst.nextToken().equals("0")) {
                        this.is_empty = true;
                    }
                    this.parse_new(d);
                    break;
                }
                first = false;
            }
            int line_len = line.length();
            this.bytes_loaded += line_len;
            this.notify_check(this.bytes_loaded);
            if (line_len == 0) {
                seq_mode = false;
                contig_seq_mode = false;
                ignore_mode = false;
                bq_mode = false;
                continue;
            }
            if (ignore_mode) continue;
            if (bq_mode) {
                StringTokenizer st2 = new StringTokenizer(line);
                while (st2.hasMoreTokens()) {
                    this.current_contig.quality.addElement(st2.nextToken());
                }
                continue;
            }
            StringTokenizer st = new StringTokenizer(line);
            String key = st.nextToken();
            if (contig_seq_mode) {
                AceSequence s;
                if (key.equals("Assembled_from")) {
                    g = new getID(st.nextToken());
                    id = g.id;
                    s = this.current_contig.create_member(id);
                    continue;
                }
                if (!key.equals("Assembled_from*")) continue;
                g = new getID(st.nextToken());
                id = g.id;
                s = this.get_member(id);
                s.asm_start_padded = Integer.parseInt(st.nextToken());
                s.asm_end_padded = Integer.parseInt(st.nextToken());
                continue;
            }
            if (seq_mode) {
                if (key.equals("Clipping")) continue;
                if (key.equals("Clipping*")) {
                    current_seq.clip_start_padded = Integer.parseInt(st.nextToken());
                    current_seq.clip_end_padded = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (key.equals("Description")) {
                    current_seq.description = line.substring(12);
                    continue;
                }
                System.out.println("unknown key " + key);
                continue;
            }
            if (key.equals("DNA")) {
                g = new getID(st.nextToken());
                id = g.id;
                if (g.contig) {
                    c = new Contig(id);
                    this.contigs.put(id, c);
                    this.current_contig = c;
                    current_seq = c.consensus;
                } else {
                    current_seq = this.get_member(id);
                }
                current_seq.complemented = g.complemented;
                this.grab_sequence(d, current_seq);
                continue;
            }
            if (key.equals("Sequence")) {
                g = new getID(st.nextToken());
                id = g.id;
                if (g.contig) {
                    contig_seq_mode = true;
                    current_seq = this.current_contig.consensus;
                    continue;
                }
                seq_mode = true;
                current_seq = this.get_member(id);
                continue;
            }
            if (key.equals("BaseQuality")) {
                bq_mode = true;
                continue;
            }
            System.out.println("ace: unknown block " + key + ", line=" + line);
        }
        Enumeration e = this.contigs.elements();
        while (e.hasMoreElements()) {
            c = (Contig)e.nextElement();
            c.find_bounds();
        }
        this.status = true;
    }

    public void set_snps(SNPList snps) {
        this.current_contig.snps = snps;
    }

    public SNPList get_snps() {
        return this.current_contig.snps;
    }

    public void set_current_contig(String id) {
        this.current_contig = this.get_contig(id);
        Enumeration e = this.current_contig.members.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            ++count;
            e.nextElement();
        }
        this.member_id_list = new String[count];
        e = this.current_contig.members.keys();
        count = 0;
        while (e.hasMoreElements()) {
            this.member_id_list[count++] = (String)e.nextElement();
        }
    }

    Contig get_contig(String id) {
        return (Contig)this.contigs.get(id);
    }

    public AceSequence get_member(String id) {
        return this.current_contig.get_member(id);
    }

    public String get_biggest_contig() {
        String id = null;
        int biggest = 0;
        Enumeration e = this.contigs.elements();
        while (e.hasMoreElements()) {
            Contig c = (Contig)e.nextElement();
            if (c.get_size() <= biggest) continue;
            id = c.name;
            biggest = c.get_size();
        }
        return id;
    }

    AceSequence consensus() {
        return this.current_contig.consensus;
    }

    public String[] member_id_list() {
        return this.member_id_list;
    }

    public String consensus_sequence() {
        return this.current_contig.consensus.sequence.toString();
    }

    public char consensus_nucleotide(int offset) {
        return this.current_contig.consensus.sequence.charAt(offset - 1);
    }

    private StringBuffer grab_until_whitespace(BufferedReader d) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = d.readLine()) != null && line.length() != 0) {
            sb.append(line);
        }
        return sb;
    }

    private void grab_sequence(BufferedReader d, AceSequence as) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = d.readLine()) != null && line.length() != 0) {
            sb.append(line);
        }
        as.sequence = sb.toString();
    }
}

