# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class Workspace(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collection_count': 'int',
        'created_at': 'str',
        'created_by': 'str',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'collection_count': 'collection_count',
        'created_at': 'created_at',
        'created_by': 'created_by',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, collection_count=None, created_at=None, created_by=None, description=None, name=None, local_vars_configuration=None):  # noqa: E501
        """Workspace - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._collection_count = None
        self._created_at = None
        self._created_by = None
        self._description = None
        self._name = None
        self.discriminator = None

        if collection_count is not None:
            self.collection_count = collection_count
        if created_at is not None:
            self.created_at = created_at
        if created_by is not None:
            self.created_by = created_by
        if description is not None:
            self.description = description
        if name is not None:
            self.name = name

    @property
    def collection_count(self):
        """Gets the collection_count of this Workspace.  # noqa: E501

        number of collections that are immediate children of workspace  # noqa: E501

        :return: The collection_count of this Workspace.  # noqa: E501
        :rtype: int
        """
        return self._collection_count

    @collection_count.setter
    def collection_count(self, collection_count):
        """Sets the collection_count of this Workspace.

        number of collections that are immediate children of workspace  # noqa: E501

        :param collection_count: The collection_count of this Workspace.  # noqa: E501
        :type collection_count: int
        """

        self._collection_count = collection_count

    @property
    def created_at(self):
        """Gets the created_at of this Workspace.  # noqa: E501

        ISO-8601 date of when workspace was created  # noqa: E501

        :return: The created_at of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Workspace.

        ISO-8601 date of when workspace was created  # noqa: E501

        :param created_at: The created_at of this Workspace.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this Workspace.  # noqa: E501

        email of user who created the workspace  # noqa: E501

        :return: The created_by of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Workspace.

        email of user who created the workspace  # noqa: E501

        :param created_by: The created_by of this Workspace.  # noqa: E501
        :type created_by: str
        """

        self._created_by = created_by

    @property
    def description(self):
        """Gets the description of this Workspace.  # noqa: E501

        longer explanation for the workspace  # noqa: E501

        :return: The description of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Workspace.

        longer explanation for the workspace  # noqa: E501

        :param description: The description of this Workspace.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this Workspace.  # noqa: E501

        descriptive label and unique identifier  # noqa: E501

        :return: The name of this Workspace.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Workspace.

        descriptive label and unique identifier  # noqa: E501

        :param name: The name of this Workspace.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Workspace):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Workspace):
            return True

        return self.to_dict() != other.to_dict()
