# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class SourceS3(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access_key': 'str',
        'bucket': 'str',
        'format': 'str',
        'mappings': 'list[FieldMask]',
        'object_bytes_total': 'int',
        'object_count_downloaded': 'int',
        'object_count_total': 'int',
        'pattern': 'str',
        'prefix': 'str',
        'prefixes': 'list[str]',
        'region': 'str',
        'secret_access': 'str'
    }

    attribute_map = {
        'access_key': 'access_key',
        'bucket': 'bucket',
        'format': 'format',
        'mappings': 'mappings',
        'object_bytes_total': 'object_bytes_total',
        'object_count_downloaded': 'object_count_downloaded',
        'object_count_total': 'object_count_total',
        'pattern': 'pattern',
        'prefix': 'prefix',
        'prefixes': 'prefixes',
        'region': 'region',
        'secret_access': 'secret_access'
    }

    def __init__(self, access_key=None, bucket=None, format=None, mappings=None, object_bytes_total=None, object_count_downloaded=None, object_count_total=None, pattern=None, prefix=None, prefixes=None, region=None, secret_access=None, local_vars_configuration=None):  # noqa: E501
        """SourceS3 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._access_key = None
        self._bucket = None
        self._format = None
        self._mappings = None
        self._object_bytes_total = None
        self._object_count_downloaded = None
        self._object_count_total = None
        self._pattern = None
        self._prefix = None
        self._prefixes = None
        self._region = None
        self._secret_access = None
        self.discriminator = None

        if access_key is not None:
            self.access_key = access_key
        self.bucket = bucket
        if format is not None:
            self.format = format
        if mappings is not None:
            self.mappings = mappings
        if object_bytes_total is not None:
            self.object_bytes_total = object_bytes_total
        if object_count_downloaded is not None:
            self.object_count_downloaded = object_count_downloaded
        if object_count_total is not None:
            self.object_count_total = object_count_total
        if pattern is not None:
            self.pattern = pattern
        if prefix is not None:
            self.prefix = prefix
        self.prefixes = prefixes
        if region is not None:
            self.region = region
        if secret_access is not None:
            self.secret_access = secret_access

    @property
    def access_key(self):
        """Gets the access_key of this SourceS3.  # noqa: E501

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :return: The access_key of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._access_key

    @access_key.setter
    def access_key(self, access_key):
        """Sets the access_key of this SourceS3.

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :param access_key: The access_key of this SourceS3.  # noqa: E501
        :type access_key: str
        """

        self._access_key = access_key

    @property
    def bucket(self):
        """Gets the bucket of this SourceS3.  # noqa: E501

        address of S3 bucket containing data  # noqa: E501

        :return: The bucket of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """Sets the bucket of this SourceS3.

        address of S3 bucket containing data  # noqa: E501

        :param bucket: The bucket of this SourceS3.  # noqa: E501
        :type bucket: str
        """
        if self.local_vars_configuration.client_side_validation and bucket is None:  # noqa: E501
            raise ValueError("Invalid value for `bucket`, must not be `None`")  # noqa: E501

        self._bucket = bucket

    @property
    def format(self):
        """Gets the format of this SourceS3.  # noqa: E501

        do not use  # noqa: E501

        :return: The format of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this SourceS3.

        do not use  # noqa: E501

        :param format: The format of this SourceS3.  # noqa: E501
        :type format: str
        """
        allowed_values = ["JSON"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and format not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `format` ({0}), must be one of {1}"  # noqa: E501
                .format(format, allowed_values)
            )

        self._format = format

    @property
    def mappings(self):
        """Gets the mappings of this SourceS3.  # noqa: E501

        custom transformation on data field  # noqa: E501

        :return: The mappings of this SourceS3.  # noqa: E501
        :rtype: list[FieldMask]
        """
        return self._mappings

    @mappings.setter
    def mappings(self, mappings):
        """Sets the mappings of this SourceS3.

        custom transformation on data field  # noqa: E501

        :param mappings: The mappings of this SourceS3.  # noqa: E501
        :type mappings: list[FieldMask]
        """

        self._mappings = mappings

    @property
    def object_bytes_total(self):
        """Gets the object_bytes_total of this SourceS3.  # noqa: E501


        :return: The object_bytes_total of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_bytes_total

    @object_bytes_total.setter
    def object_bytes_total(self, object_bytes_total):
        """Sets the object_bytes_total of this SourceS3.


        :param object_bytes_total: The object_bytes_total of this SourceS3.  # noqa: E501
        :type object_bytes_total: int
        """

        self._object_bytes_total = object_bytes_total

    @property
    def object_count_downloaded(self):
        """Gets the object_count_downloaded of this SourceS3.  # noqa: E501


        :return: The object_count_downloaded of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_count_downloaded

    @object_count_downloaded.setter
    def object_count_downloaded(self, object_count_downloaded):
        """Sets the object_count_downloaded of this SourceS3.


        :param object_count_downloaded: The object_count_downloaded of this SourceS3.  # noqa: E501
        :type object_count_downloaded: int
        """

        self._object_count_downloaded = object_count_downloaded

    @property
    def object_count_total(self):
        """Gets the object_count_total of this SourceS3.  # noqa: E501


        :return: The object_count_total of this SourceS3.  # noqa: E501
        :rtype: int
        """
        return self._object_count_total

    @object_count_total.setter
    def object_count_total(self, object_count_total):
        """Sets the object_count_total of this SourceS3.


        :param object_count_total: The object_count_total of this SourceS3.  # noqa: E501
        :type object_count_total: int
        """

        self._object_count_total = object_count_total

    @property
    def pattern(self):
        """Gets the pattern of this SourceS3.  # noqa: E501

        Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.  # noqa: E501

        :return: The pattern of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this SourceS3.

        Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.  # noqa: E501

        :param pattern: The pattern of this SourceS3.  # noqa: E501
        :type pattern: str
        """

        self._pattern = pattern

    @property
    def prefix(self):
        """Gets the prefix of this SourceS3.  # noqa: E501

        Prefix that selects keys to ingest.  # noqa: E501

        :return: The prefix of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this SourceS3.

        Prefix that selects keys to ingest.  # noqa: E501

        :param prefix: The prefix of this SourceS3.  # noqa: E501
        :type prefix: str
        """

        self._prefix = prefix

    @property
    def prefixes(self):
        """Gets the prefixes of this SourceS3.  # noqa: E501

        list of prefixes to paths from which data should be ingested  # noqa: E501

        :return: The prefixes of this SourceS3.  # noqa: E501
        :rtype: list[str]
        """
        return self._prefixes

    @prefixes.setter
    def prefixes(self, prefixes):
        """Sets the prefixes of this SourceS3.

        list of prefixes to paths from which data should be ingested  # noqa: E501

        :param prefixes: The prefixes of this SourceS3.  # noqa: E501
        :type prefixes: list[str]
        """
        if self.local_vars_configuration.client_side_validation and prefixes is None:  # noqa: E501
            raise ValueError("Invalid value for `prefixes`, must not be `None`")  # noqa: E501

        self._prefixes = prefixes

    @property
    def region(self):
        """Gets the region of this SourceS3.  # noqa: E501

        AWS region containing source bucket  # noqa: E501

        :return: The region of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this SourceS3.

        AWS region containing source bucket  # noqa: E501

        :param region: The region of this SourceS3.  # noqa: E501
        :type region: str
        """

        self._region = region

    @property
    def secret_access(self):
        """Gets the secret_access of this SourceS3.  # noqa: E501

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :return: The secret_access of this SourceS3.  # noqa: E501
        :rtype: str
        """
        return self._secret_access

    @secret_access.setter
    def secret_access(self, secret_access):
        """Sets the secret_access of this SourceS3.

        AWS credential with ListObjects and GetObject access  # noqa: E501

        :param secret_access: The secret_access of this SourceS3.  # noqa: E501
        :type secret_access: str
        """

        self._secret_access = secret_access

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceS3):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceS3):
            return True

        return self.to_dict() != other.to_dict()
